/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iant.types;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.AS400Text;
import com.ibm.as400.access.ProgramCall;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.SystemValue;
import com.ibm.etools.iseries.comm.ISeriesAbstractHostAPIProcessor;
import com.ibm.etools.iseries.comm.ISeriesAbstractListProcessor;
import com.ibm.etools.iseries.comm.ISeriesElapsedTimer;
import com.ibm.etools.iseries.comm.filters.ISeriesAbstractFilterString;
import com.ibm.etools.iseries.comm.filters.ISeriesObjectFilterString;
import com.ibm.etools.iseries.comm.interfaces.IISeriesHostListBaseFactory;
import com.ibm.etools.iseries.comm.interfaces.IISeriesHostListObjectFactory;
import com.ibm.etools.iseries.comm.interfaces.IISeriesHostListStatusCallback;
import com.ibm.etools.iseries.comm.interfaces.IISeriesHostObjectBrief;
import com.ibm.etools.iseries.comm.interfaces.IISeriesHostObjectFactory;
import com.ibm.etools.iseries.comm.interfaces.ISeriesHostListObjectBasicFactory;
import java.util.ArrayList;
import java.util.List;

public class IListDBRelations
extends ISeriesAbstractHostAPIProcessor {
    public static final String Copyright = "(C) Copyright IBM Corp. 2002, 2003.  All Rights Reserved.";
    protected static final int GENERIC_HEADER_SIZE = 192;
    private static final String TYPE_FILE = "*FILE";
    private static final String ATTR_ALL = "*ALL";
    private static final String NONE_OBJECT = "*NONE";
    public static final int LIST_NAMES = 0;
    public static final int LIST_BASIC = 1;
    private static final String HOST_API = "QDBLDBR";
    private static final String LOG_PREFIX = "QDBLDBR: ";
    private static final IISeriesHostListObjectFactory DEFAULT_LISTOBJECT_FACTORY_BRIEF = new ISeriesHostListObjectBasicFactory();
    private boolean initCalled = false;
    private final int listType = 1;
    private IISeriesHostListObjectFactory returnListFieldFactory;
    private ISeriesAbstractFilterString filterStringObject;
    private static final String listFormatRequest = "DBRL0100";
    private static final int NBR_PARMS = 6;
    private final ProgramParameter[] parmList = new ProgramParameter[6];
    private List<IISeriesHostObjectBrief> theObjectList;
    private AS400Text text8;
    private AS400Text text10;
    private AS400Text text20;
    private byte[] returnData;

    public IListDBRelations() {
        this.setTracing(true, LOG_PREFIX);
    }

    public IListDBRelations(AS400 system) {
        super(system);
        this.setTracing(true, LOG_PREFIX);
        this.init();
    }

    public List<IISeriesHostObjectBrief> getList(ISeriesAbstractFilterString fsObj) throws Exception {
        return this.getObjectList(fsObj);
    }

    public List<IISeriesHostObjectBrief> getList(ISeriesAbstractFilterString fsObj, IISeriesHostListBaseFactory listFactory) throws Exception {
        return this.getObjectList(fsObj, (IISeriesHostListObjectFactory)listFactory);
    }

    public List<IISeriesHostObjectBrief> getObjectList(ISeriesAbstractFilterString fsObj) throws Exception {
        return this.getObjectList(fsObj, DEFAULT_LISTOBJECT_FACTORY_BRIEF);
    }

    public List<IISeriesHostObjectBrief> getObjectList(ISeriesAbstractFilterString fsObj, IISeriesHostListObjectFactory listObjectFactory) throws Exception {
        return this.getObjectList(fsObj, listObjectFactory, null);
    }

    public List<IISeriesHostObjectBrief> getObjectList(ISeriesAbstractFilterString fsObj, IISeriesHostListObjectFactory listObjectFactory, IISeriesHostListStatusCallback callback) throws Exception {
        this.filterStringObject = fsObj;
        if (!this.initCalled) {
            this.init();
        }
        ISeriesElapsedTimer timer = null;
        if (this.isTraceOn()) {
            timer = new ISeriesElapsedTimer();
        }
        this.setListObjectFactory(listObjectFactory);
        this.initList();
        this.registerCancelQuerier(callback);
        if (callback != null) {
            callback.startingFilterProcessing(fsObj);
        }
        this.internalGetList(fsObj, listObjectFactory);
        if (this.isTraceOn()) {
            timer.setEndTime();
            int count = this.theObjectList == null ? 0 : this.theObjectList.size();
            timer.writeElapsedTime(this.getLogFileStream(), "Time to retrieve " + count + " fields  for request " + this.getFilterString());
            this.logMessage("FIELDS RETURNED:");
            this.logMessage("-----------------");
            int idx = 0;
            while (idx < this.theObjectList.size()) {
                this.logMessage("Record " + idx + ": " + this.theObjectList.get(idx).getName());
                ++idx;
            }
            this.logMessage(" ");
        }
        return this.theObjectList;
    }

    private void internalGetList(ISeriesAbstractFilterString fsObj, IISeriesHostListObjectFactory listObjectFactory) throws Exception {
        Exception errorExc;
        block6: {
            errorExc = null;
            this.createUserSpaceOnHost();
            try {
                try {
                    this.getListFromAS400(this.getFilterString());
                }
                catch (Exception exc) {
                    errorExc = exc;
                    this.closeUserSpace();
                    break block6;
                }
            }
            catch (Throwable throwable) {
                this.closeUserSpace();
                throw throwable;
            }
            this.closeUserSpace();
        }
        if (errorExc != null) {
            this.logException(errorExc);
            throw errorExc;
        }
    }

    private void init() {
        this.initCalled = true;
        AS400 system = this.getSystem();
        this.parmList[5] = this.getErrorCodeStructure().getInputProgramParameter();
        this.text8 = new AS400Text(8, this.getClientCCSID(), system);
        this.text10 = new AS400Text(10, this.getClientCCSID(), system);
        this.text20 = new AS400Text(20, this.getClientCCSID(), system);
    }

    private void initList() {
        this.clearWarnings();
        this.theObjectList = new ArrayList<IISeriesHostObjectBrief>();
        this.cancel = false;
        ISeriesObjectFilterString ffsObj = (ISeriesObjectFilterString)this.getFilterStringObject();
        this.setLibrary(ffsObj.getLibrary());
        this.setObjectName(ffsObj.getObject());
        this.setObjectType(ffsObj.getObjectType());
        this.parmList[0] = new ProgramParameter(this.getUserSpaceAPIName());
        this.parmList[1] = new ProgramParameter(this.text8.toBytes((Object)listFormatRequest));
        String objectname = String.valueOf(IListDBRelations.padString((String)this.getObjectName(), (int)10)) + IListDBRelations.padString((String)this.getLibrary(), (int)10);
        this.parmList[2] = new ProgramParameter(this.text20.toBytes((Object)objectname));
        this.parmList[3] = new ProgramParameter(this.text10.toBytes((Object)IListDBRelations.padString((String)ATTR_ALL, (int)10)));
        this.parmList[4] = new ProgramParameter(this.text10.toBytes((Object)IListDBRelations.padString((String)ATTR_ALL, (int)10)));
    }

    protected void getListFromAS400(String filterString) throws Exception {
        AS400 system = this.getSystem();
        boolean rungood = false;
        QSYSObjectPathName pgmName = new QSYSObjectPathName("QSYS", HOST_API, "PGM");
        ProgramCall as400_Pgmcall = new ProgramCall(system);
        as400_Pgmcall.setProgram(pgmName.getPath(), this.parmList);
        rungood = as400_Pgmcall.run();
        if (!rungood) {
            String firstMsgId;
            AS400Message[] msgList = as400_Pgmcall.getMessageList();
            if (msgList != null && msgList.length > 1 && (firstMsgId = msgList[0].getID()) != "CPF3C23") {
                String firstMsg = this.logHostMessages(as400_Pgmcall, HOST_API);
                if (firstMsg != null) {
                    throw new Exception(firstMsg);
                }
                throw new Exception("Error running host API QDBLDBR");
            }
        } else {
            String errorText = this.getErrorCodeStructure().getReturnedError();
            if (errorText != null) {
                this.logMessage("host API has returned an error: " + errorText);
                throw new Exception(errorText);
            }
        }
        if (this.isCancelled()) {
            return;
        }
        this.returnData = new byte[192];
        try {
            this.readUserSpace(this.returnData, 0);
        }
        catch (Exception eeU) {
            this.logMessage("AS/400 field list host error: " + eeU.getMessage());
            throw eeU;
        }
        ISeriesAbstractListProcessor.HostAPIGenericListHeader genericHeader = new ISeriesAbstractListProcessor.HostAPIGenericListHeader(system);
        genericHeader.setInput(this.returnData);
        int userSpaceSize = genericHeader.getUserSpaceSize();
        int listStartingPosition = genericHeader.getListStartingPosition();
        int numListBytesReturned = genericHeader.getListSize();
        int numItemsAvailableOnHost = genericHeader.getNbrListItems();
        int sizePerItem = genericHeader.getSizePerItem();
        if (this.isTraceOn()) {
            genericHeader.logHeaderInfo(this.getLogFileStream(), LOG_PREFIX);
        }
        this.returnData = new byte[userSpaceSize];
        try {
            this.readUserSpace(this.returnData, 0);
        }
        catch (Exception eeU) {
            this.logMessage("AS/400 field list host error: " + eeU.getMessage());
            throw eeU;
        }
        if (numItemsAvailableOnHost > 0) {
            this.buildList(numItemsAvailableOnHost, listStartingPosition, sizePerItem);
        }
    }

    protected void buildList(int nbrRows, int listStartingPosition, int sizePerRow) throws Exception {
        Boolean longxlate = (Boolean)dbcsConvert.get(this.getSystem());
        if (longxlate == null) {
            SystemValue sysval = new SystemValue(this.getSystem(), "QIGC");
            String QIGC = (String)sysval.getValue();
            longxlate = QIGC.equals("1") ? Boolean.TRUE : Boolean.FALSE;
            dbcsConvert.put(this.getSystem(), longxlate);
        }
        AS400Text textConvert10 = new AS400Text(10, this.getHostCCSID(), this.getSystem());
        int offset = listStartingPosition;
        int loop = 0;
        while (loop < nbrRows) {
            String dependentFileName = (String)textConvert10.toObject(this.returnData, offset + 20);
            dependentFileName = dependentFileName.trim();
            String dependentLibraryname = (String)textConvert10.toObject(this.returnData, offset + 30);
            dependentLibraryname = dependentLibraryname.trim();
            if (!dependentFileName.equalsIgnoreCase(NONE_OBJECT) || dependentLibraryname.trim().length() != 0) {
                IISeriesHostObjectBrief basicObj = (IISeriesHostObjectBrief)this.getObjectFactory().createObject(TYPE_FILE, ATTR_ALL);
                basicObj.setName(dependentFileName);
                basicObj.setLibrary(dependentLibraryname);
                basicObj.setType(TYPE_FILE);
                basicObj.setSubType(ATTR_ALL);
                this.theObjectList.add(basicObj);
                offset += sizePerRow;
            }
            ++loop;
        }
    }

    protected void setListObjectFactory(IISeriesHostListObjectFactory factory) {
        this.returnListFieldFactory = factory;
    }

    protected IISeriesHostListObjectFactory getListFieldFactory() {
        if (this.returnListFieldFactory != null) {
            return this.returnListFieldFactory;
        }
        return DEFAULT_LISTOBJECT_FACTORY_BRIEF;
    }

    protected ISeriesAbstractFilterString getFilterStringObject() {
        return this.filterStringObject;
    }

    protected String getFilterString() {
        return this.filterStringObject.toString();
    }

    protected IISeriesHostObjectFactory getObjectFactory() {
        if (this.returnObjectFactory != null) {
            return this.returnObjectFactory;
        }
        return this.getDefaultObjectFactory();
    }

    protected IISeriesHostObjectFactory getDefaultObjectFactory() {
        return DEFAULT_OBJECT_FACTORY_BRIEF;
    }
}

