/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iant.types;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.IFSFile;
import com.ibm.iant.taskdefs.IAntTaskUtils;
import java.io.IOException;
import java.util.Vector;

public class IBMIResourceDependencies {
    private Vector<Object> objects = new Vector();
    private Vector<Member> members = new Vector();
    private Vector<Path> paths = new Vector();

    public Object createObject() {
        Object d = new Object();
        this.objects.add(d);
        return d;
    }

    public Member createMember() {
        Member d = new Member();
        this.members.add(d);
        return d;
    }

    public Path createPath() {
        Path d = new Path();
        this.paths.add(d);
        return d;
    }

    public int size() {
        return this.members.size() + this.paths.size() + this.objects.size();
    }

    public boolean allExist(AS400 conn) {
        boolean exist = true;
        if (exist) {
            for (Member m : this.members) {
                if (m.exists(conn)) continue;
                exist = false;
                break;
            }
        }
        if (exist) {
            for (Path p : this.paths) {
                if (p.exists(conn)) continue;
                exist = false;
                break;
            }
        }
        if (exist) {
            for (Object o : this.objects) {
                if (o.exists(conn)) continue;
                exist = false;
                break;
            }
        }
        return exist;
    }

    public boolean noneExist(AS400 conn) {
        boolean none = true;
        for (Object o : this.objects) {
            if (!o.exists(conn)) continue;
            none = false;
            break;
        }
        if (none) {
            for (Member m : this.members) {
                if (!m.exists(conn)) continue;
                none = false;
                break;
            }
        }
        if (none) {
            for (Path p : this.paths) {
                if (!p.exists(conn)) continue;
                none = false;
                break;
            }
        }
        return none;
    }

    public class Member {
        String library;
        String file;
        String name;
        String type;

        public void setLibrary(String library) {
            this.library = library;
        }

        public void setFile(String file) {
            this.file = file;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setType(String type) {
            this.type = type;
        }

        public boolean exists(AS400 conn) {
            return IAntTaskUtils.doesMemberExist(conn, this.library, this.file, this.name, this.type);
        }
    }

    public class Object {
        String library;
        String name;
        String type;
        String attribute;

        public void setLibrary(String library) {
            this.library = library;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setType(String type) {
            this.type = type;
        }

        public void setAttribute(String attribute) {
            this.attribute = attribute;
        }

        public boolean exists(AS400 conn) {
            return IAntTaskUtils.doesObjectExist(conn, this.library, this.name, this.type, this.attribute);
        }
    }

    public class Path {
        String path;

        public void setPath(String path) {
            this.path = path;
        }

        public boolean exists(AS400 conn) {
            boolean ret = false;
            try {
                ret = new IFSFile(conn, this.path).exists();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return ret;
        }
    }
}

