/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iant.types;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.CommandCall;
import com.ibm.as400.access.User;
import com.ibm.etools.iseries.comm.interfaces.IISeriesHostObjectBrief;
import com.ibm.etools.iseries.util.AS400Factory;
import com.ibm.iant.taskdefs.IAntTaskUtils;
import java.beans.PropertyVetoException;
import java.util.Arrays;
import java.util.HashMap;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.DataType;

public class AS400Type
extends DataType {
    private final AS400 _as400 = AS400Factory.getInstance().getAS400();
    private final HashMap<String, IISeriesHostObjectBrief> relationsTable = new HashMap();
    private static final String PROPERTY_PREFIX = "${";
    private boolean shouldSetCCSIDJob = false;
    private boolean setCCSIDJob = false;
    private static final String CCSID_JOB_PROPERTY = "teamp.build.jobCCSID";
    private boolean usesASP;
    private String aspName;
    public String IASPGroup = "";
    private boolean isASPGroupInitialized = false;

    public void setSystemname(String systemname) throws PropertyVetoException {
        if (systemname == null || systemname.trim().length() == 0 || systemname.trim().startsWith(PROPERTY_PREFIX)) {
            return;
        }
        this._as400.setSystemName(systemname);
        this.getProject().log("[AS400Type] systemname --> " + systemname, 4);
    }

    public void setUserid(String userid) throws PropertyVetoException {
        if (userid == null || userid.trim().length() == 0 || userid.trim().startsWith(PROPERTY_PREFIX)) {
            return;
        }
        this._as400.setUserId(userid);
    }

    public void setUserpassword(String userpw) {
        if (userpw == null || userpw.trim().length() == 0 || userpw.trim().startsWith(PROPERTY_PREFIX)) {
            return;
        }
        this._as400.setPassword(userpw);
    }

    public AS400 getAS400() {
        Project project = this.getProject();
        String ccsidJob = project.getProperty(CCSID_JOB_PROPERTY);
        if (ccsidJob != null && !ccsidJob.equals("")) {
            this.shouldSetCCSIDJob = true;
        }
        if (this.shouldSetCCSIDJob && !this.setCCSIDJob) {
            block15: {
                CommandCall command = new CommandCall(this._as400);
                String changeJobCommandString = "CHGJOB CCSID(" + ccsidJob + ")";
                project.log("Running Command: " + changeJobCommandString);
                try {
                    boolean ok = command.run(changeJobCommandString);
                    if (ok) break block15;
                    AS400Message[] messageList = command.getMessageList();
                    if (messageList.length > 0) {
                        int i = 0;
                        while (i < messageList.length) {
                            AS400Message m = messageList[i];
                            this.log(m.getText(), 0);
                            ++i;
                        }
                    }
                    return null;
                }
                catch (Exception e) {
                    return null;
                }
            }
            this.setCCSIDJob = true;
        }
        if (!this.isASPGroupInitialized) {
            this.aspName = project.getProperty("team.enterprise.ibmi.toolkit.ASPName");
            this.usesASP = Boolean.valueOf(project.getProperty("team.enterprise.ibmi.toolkit.setASP"));
            this.isASPGroupInitialized = true;
            project.log("[AS400Type] property \"team.enterprise.ibmi.toolkit.setASP\" --> [" + this.usesASP + "]", 3);
            project.log("[AS400Type] property \"team.enterprise.ibmi.toolkit.ASPName\" --> [" + this.aspName + "]", 3);
            if (this.usesASP) {
                if (this.aspName != null && !this.aspName.trim().isEmpty()) {
                    this.IASPGroup = this.aspName;
                    this.setIASPGroup(this.aspName);
                    project.log("[AS400Type] aspGroupName --> " + this.aspName, 3);
                } else if (this.aspName != null && this.aspName.trim().isEmpty()) {
                    Object[] userIASPs = null;
                    String iasp = "";
                    try {
                        userIASPs = new User(this._as400, this._as400.getUserId()).getIASPNames();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    if (userIASPs != null && userIASPs.length > 0) {
                        iasp = userIASPs[0];
                        this.setIASPGroup(iasp);
                        this.IASPGroup = iasp;
                    }
                    project.log("[AS400Type] User.getIASPNames() --> " + Arrays.toString(userIASPs) + ", iasp => " + iasp, 3);
                }
            }
        }
        return this._as400;
    }

    public HashMap<String, IISeriesHostObjectBrief> getRelationsTable() {
        return this.relationsTable;
    }

    private void setIASPGroup(String aspGroupName) {
        String command = "SETASPGRP ASPGRP(" + this.aspName + ")";
        IAntTaskUtils.runCommand(command, this.getAS400(), this.getProject(), true);
    }
}

