/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iant.taskdefs.build;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Bin4;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.AS400Text;
import com.ibm.as400.access.ObjectDescription;
import com.ibm.as400.access.ProgramCall;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.etools.iseries.comm.interfaces.IISeriesHostObjectBasic;
import com.ibm.iant.taskdefs.AbstractIBMiCommandTask;
import com.ibm.iant.taskdefs.IAntTaskUtils;
import java.io.IOException;
import java.security.SecureRandom;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class IBMITagTask
extends AbstractIBMiCommandTask {
    private static final int TAG_DURING = 0;
    private static final int TAG_AFTER = 1;
    private static final int TAG_BOTH = 2;
    private static Vector<String> libraries = new Vector();
    private static Date baseDateStamp = null;
    private static String buildID = "";
    private static int tagType = 0;
    private static Vector<IISeriesHostObjectBasic> taggedObjects = new Vector();
    private static boolean lock = false;
    private boolean tag = false;

    public void setLibrary(String l) {
        if (!l.trim().startsWith("${")) {
            String[] libs;
            String[] stringArray = libs = l.split("[:\\s]");
            int n = libs.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                libraries.add(s);
                ++n2;
            }
        }
    }

    public void setBuildID(String s) {
        SecureRandom random = new SecureRandom();
        int number = random.nextInt(999999999);
        buildID = String.valueOf(number);
        if (buildID.length() > 10) {
            buildID = buildID.substring(0, 10);
        }
    }

    public void setTag(boolean tag) {
        this.tag = tag;
    }

    public void setLock(boolean tag) {
        lock = tag;
    }

    @Override
    public void execute() throws BuildException {
        String devBuild = this.getProject().getProperty("com.ibm.iant.devBuild");
        if (devBuild == null) {
            if (!this.tag) {
                if (baseDateStamp == null) {
                    taggedObjects = new Vector();
                }
                try {
                    baseDateStamp = this.getAS400().getSignonDate().getTime();
                    this.log("Base IBM i time stamp for server [" + this.getAS400().getSystemName() + "] is: " + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(baseDateStamp), 3);
                }
                catch (AS400SecurityException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                switch (tagType) {
                    case 0: 
                    case 2: {
                        if (buildID.length() > 0) {
                            this.log(String.valueOf(taggedObjects.size()) + " Objects were tagged with \"" + buildID + "\" during execution of this script:", 3);
                            for (IISeriesHostObjectBasic o : taggedObjects) {
                                this.log("  " + o.toString(), 3);
                            }
                            break;
                        }
                        this.log("Build ID is a required parameter and was not provided.  Unable to tag objects.");
                        break;
                    }
                    case 1: {
                        if (libraries.size() > 0 && buildID.length() > 0) {
                            for (String l : libraries) {
                                List objects = IAntTaskUtils.getObjectListForFilterString(String.valueOf(l) + "/*all ", this.getAS400());
                                this.log("Searching " + objects.size() + " objects in library " + l + " for objects touched after " + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(baseDateStamp), 3);
                                int count = 0;
                                for (IISeriesHostObjectBasic o : objects) {
                                    Date d = o.getDateModified();
                                    if (d == null || d.compareTo(baseDateStamp) <= 0) continue;
                                    ++count;
                                    IBMITagTask.tagOne(o, this, this.getAS400());
                                }
                                if (count != 0) continue;
                                this.log("  No new objects found.", 3);
                            }
                            break;
                        }
                        if (libraries.size() == 0) {
                            this.log("Output libraries were not defined; no objects were tagged with build identifier.");
                            break;
                        }
                        this.log("Build ID is a required parameter and was not provided.  Unable to tag objects.");
                        break;
                    }
                }
                baseDateStamp = null;
            }
        }
    }

    private static byte[] convert2to1(byte[][] data2) {
        int size = 0;
        byte[][] byArray = data2;
        int n = data2.length;
        int n2 = 0;
        while (n2 < n) {
            byte[] e = byArray[n2];
            size += e.length;
            ++n2;
        }
        byte[] data1 = new byte[size];
        int i = 0;
        byte[][] byArray2 = data2;
        int n3 = data2.length;
        int n4 = 0;
        while (n4 < n3) {
            byte[] e;
            byte[] byArray3 = e = byArray2[n4];
            int n5 = e.length;
            int n6 = 0;
            while (n6 < n5) {
                byte eb = byArray3[n6];
                data1[i++] = eb;
                ++n6;
            }
            ++n4;
        }
        return data1;
    }

    public static boolean tagOneIfNew(IISeriesHostObjectBasic o, Task t, AS400 conn) {
        Date d = o.getDateModified();
        boolean success = true;
        if (baseDateStamp == null) {
            t.log("Base time stamp has not been established.  Unable to tag objects.", 3);
        } else if (tagType != 1 && d.compareTo(baseDateStamp) > 0) {
            if (buildID.length() > 0) {
                success = IBMITagTask.tagOne(o, t, conn);
                if (success) {
                    taggedObjects.add(o);
                }
            } else {
                t.log("Build ID is a required parameter and was not provided.  Unable to tag objects.", 3);
            }
        }
        return success;
    }

    public static boolean tagOneAlways(IISeriesHostObjectBasic o, Task t, AS400 conn) {
        boolean success = true;
        if (tagType != 1) {
            if (buildID.length() > 0) {
                if (!taggedObjects.contains(o) && (success = IBMITagTask.tagOne(o, t, conn))) {
                    taggedObjects.add(o);
                }
            } else {
                t.log("Build ID is a required parameter and was not provided.  Unable to tag objects.", 3);
            }
        }
        return success;
    }

    private static boolean tagOne(IISeriesHostObjectBasic o, Task t, AS400 conn) {
        Boolean success = true;
        AS400Bin4 ib = new AS400Bin4();
        byte[][] data2 = new byte[][]{ib.toBytes(2), ib.toBytes(9), ib.toBytes(10), new AS400Text(10).toBytes((Object)buildID), ib.toBytes(8), ib.toBytes(1), new AS400Text(1).toBytes((Object)(lock ? "0" : "1"))};
        ProgramParameter[] parameterList = new ProgramParameter[5];
        parameterList[0] = new ProgramParameter(new AS400Text(10).toBytes((Object)""));
        parameterList[3] = new ProgramParameter(IBMITagTask.convert2to1(data2));
        parameterList[4] = new ProgramParameter(new byte[32], 0);
        try {
            t.log("Tagging: " + o.toString() + "; old tag=\"" + new ObjectDescription(conn, o.getLibrary(), o.getName(), o.getType().substring(1)).getValueAsString(204) + "\"", 3);
            parameterList[1] = new ProgramParameter(new AS400Text(20).toBytes((Object)String.format("%-10s%-10s", o.getName(), o.getLibrary())));
            parameterList[2] = new ProgramParameter(new AS400Text(10).toBytes((Object)o.getType()));
            ProgramCall pgm = new ProgramCall(conn);
            success = pgm.run("QSYS.LIB/QSYS.LIB/QLICOBJD.PGM", parameterList);
            if (!success.booleanValue()) {
                AS400Message[] msgList = pgm.getMessageList();
                t.log("Unable to tag object: " + o.toString(), 0);
                t.log("  Possible causes if tagging lock is on: Object was only modified (not created) by build, or library included multiple times.", 0);
                int i1 = 0;
                while (i1 < msgList.length) {
                    t.log("  <<" + msgList[i1].getText(), 0);
                    ++i1;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return success;
    }

    public static void setTagType(int tagType) {
        IBMITagTask.tagType = tagType < 0 || tagType > 2 ? 0 : tagType;
    }
}

