/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iant.taskdefs.build;

import com.ibm.etools.iseries.comm.interfaces.IISeriesHostMemberBrief;
import com.ibm.etools.iseries.comm.interfaces.IISeriesHostObjectBrief;
import com.ibm.iant.taskdefs.build.IBMIBuildTaskUtils;
import com.ibm.iant.types.IAbstractObjectEntry;
import com.ibm.iant.types.ILibraryNameEntry;
import com.ibm.iant.types.ILibraryPatternSet;
import com.ibm.iant.types.ILibrarySet;
import com.ibm.iant.types.IMemberNameEntry;
import com.ibm.iant.types.IMemberPatternSet;
import com.ibm.iant.types.IMemberSet;
import com.ibm.iant.types.INameEntry;
import com.ibm.iant.types.IObjectNameEntry;
import com.ibm.iant.types.IObjectPatternSet;
import com.ibm.iant.types.IObjectSet;
import com.ibm.iant.types.Members;
import com.ibm.iant.types.Objects;
import com.ibm.iant.types.build.IBMIExclude;
import com.ibm.iant.types.build.IBMIInclude;
import com.ibm.iant.types.build.IBMIInput;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;

public class IBMIInputResolver {
    public static String copyright = "(c) Copyright IBM Corp 2010.";
    private final HashMap<IBMIInput, Set<Object>> resolvedResource;
    private final Project project;
    private final String systemref;

    public IBMIInputResolver(Project project, String systemref) {
        this.project = project;
        this.systemref = systemref;
        this.resolvedResource = new HashMap();
    }

    public Set<Object> resolve(IBMIInput ibmIInput, HashMap<String, String> resolvedVariableMap) throws Exception {
        if (ibmIInput == null) {
            return Collections.EMPTY_SET;
        }
        LinkedHashSet<Object> results = new LinkedHashSet<Object>();
        if (this.resolvedResource.containsKey(ibmIInput)) {
            return this.resolvedResource.get(ibmIInput);
        }
        Iterator<IBMIInclude> includeIterator = ibmIInput.getIncludeIterator();
        Iterator<IBMIExclude> excludeIterator = ibmIInput.getExcludeIterator();
        Vector<Object> includedResourceList = new Vector<Object>();
        Vector<Object> excludedResourceList = new Vector<Object>();
        this.resolvedInputResources(includeIterator, true, includedResourceList, resolvedVariableMap);
        this.resolvedInputResources(excludeIterator, false, excludedResourceList, resolvedVariableMap);
        results.addAll(includedResourceList);
        results.removeAll(excludedResourceList);
        this.resolvedResource.put(ibmIInput, results);
        return results;
    }

    protected void resolvedInputResources(Iterator<?> resourceIterator, boolean isInclude, Vector<Object> resolvedResourceList, HashMap<String, String> map) throws Exception {
        try {
            Iterator<Members> membersIterator = null;
            Iterator<Objects> objectsIterator = null;
            while (resourceIterator != null && resourceIterator.hasNext()) {
                if (isInclude) {
                    IBMIInclude thisInclude = (IBMIInclude)resourceIterator.next();
                    membersIterator = thisInclude.membersIterator();
                    objectsIterator = thisInclude.objectsIterator();
                } else {
                    IBMIExclude thisExclude = (IBMIExclude)resourceIterator.next();
                    membersIterator = thisExclude.membersIterator();
                    objectsIterator = thisExclude.objectsIterator();
                }
                HashMap<String, String> memberMapping = new HashMap<String, String>();
                while (membersIterator != null && membersIterator.hasNext()) {
                    Members thisMembers = membersIterator.next();
                    IMemberSet thisMemberSet = new IMemberSet();
                    thisMemberSet.setProject(this.project);
                    thisMemberSet.setSystemref(this.systemref);
                    thisMemberSet.setLibrary(this.substituteVars(thisMembers.getLibrary().toUpperCase(), map, this.project).toUpperCase());
                    thisMemberSet.setFileName(thisMembers.getFile());
                    IMemberPatternSet thisMemberPatternSet = thisMemberSet.createIMemberPatternSet();
                    thisMemberPatternSet.setProject(this.project);
                    IMemberNameEntry filter1 = (IMemberNameEntry)thisMemberPatternSet.createInclude();
                    filter1.setName(thisMembers.getName());
                    filter1.setType(thisMembers.getType());
                    Iterator thisMembersIterator = thisMemberSet.iterator();
                    while (thisMembersIterator != null && thisMembersIterator.hasNext()) {
                        IISeriesHostMemberBrief thisResult = (IISeriesHostMemberBrief)thisMembersIterator.next();
                        String key = String.valueOf(thisResult.getFile()) + thisResult.getName();
                        if (memberMapping.containsKey(key)) continue;
                        resolvedResourceList.add(thisResult);
                        memberMapping.put(key, key);
                    }
                }
                HashMap<String, String> objectMapping = new HashMap<String, String>();
                while (objectsIterator != null && objectsIterator.hasNext()) {
                    String key;
                    IISeriesHostObjectBrief thisResult;
                    Iterator thisObjectsIterator;
                    INameEntry filter1;
                    Objects thisObjects = objectsIterator.next();
                    if (!IBMIBuildTaskUtils.isLibraryType(thisObjects)) {
                        IObjectSet thisObjectSet = new IObjectSet();
                        thisObjectSet.setProject(this.project);
                        thisObjectSet.setSystemref(this.systemref);
                        thisObjectSet.setLibrary(this.substituteVars(thisObjects.getLibrary().toUpperCase(), map, this.project).toUpperCase());
                        IObjectPatternSet thisObjectPatternSet = thisObjectSet.createIObjectPatternSet();
                        thisObjectPatternSet.setProject(this.project);
                        filter1 = (IObjectNameEntry)thisObjectPatternSet.createInclude();
                        ((IAbstractObjectEntry)filter1).setName(thisObjects.getName());
                        ((IObjectNameEntry)filter1).setType(thisObjects.getType());
                        ((IAbstractObjectEntry)filter1).setObjectAttribute(thisObjects.getAttribute());
                        thisObjectsIterator = thisObjectSet.iterator();
                        while (thisObjectsIterator != null && thisObjectsIterator.hasNext()) {
                            thisResult = (IISeriesHostObjectBrief)thisObjectsIterator.next();
                            key = String.valueOf(thisResult.getLibrary()) + thisResult.getName() + thisResult.getType() + thisResult.getSubType();
                            if (objectMapping.containsKey(key)) continue;
                            resolvedResourceList.add(thisResult);
                            objectMapping.put(key, key);
                        }
                        continue;
                    }
                    ILibrarySet thisLibSet = new ILibrarySet();
                    thisLibSet.setProject(this.project);
                    thisLibSet.setSystemref(this.systemref);
                    ILibraryPatternSet thisLibraryPatternSet = thisLibSet.createILibraryPatternSet();
                    thisLibraryPatternSet.setProject(this.project);
                    filter1 = (ILibraryNameEntry)thisLibraryPatternSet.createInclude();
                    ((ILibraryNameEntry)filter1).setName(this.substituteVars(thisObjects.getName().toUpperCase(), map, this.project).toUpperCase());
                    thisObjectsIterator = thisLibSet.iterator();
                    while (thisObjectsIterator != null && thisObjectsIterator.hasNext()) {
                        thisResult = (IISeriesHostObjectBrief)thisObjectsIterator.next();
                        key = String.valueOf(thisResult.getLibrary()) + thisResult.getName() + thisResult.getType() + thisResult.getSubType();
                        if (objectMapping.containsKey(key)) continue;
                        resolvedResourceList.add(thisResult);
                        objectMapping.put(key, key);
                    }
                }
            }
        }
        catch (Exception e) {
            String iteratorType = isInclude ? "include" : "exclude";
            String msg = "ERROR: error encountered when resolving resource list from " + iteratorType + " for an input. ";
            if (e.getMessage() != null) {
                msg = new StringBuffer(msg).append(e.getMessage()).toString();
            }
            throw new Exception(msg, e);
        }
    }

    private String substituteVars(String str, HashMap<String, String> map, Project project) {
        String result = str;
        Set<String> keys = map.keySet();
        Iterator<String> iterator = keys.iterator();
        while (iterator != null && iterator.hasNext()) {
            String currentKey = iterator.next();
            String currentValue = map.get(currentKey);
            Pattern p = Pattern.compile(currentKey, 66);
            Matcher m = p.matcher(result);
            StringBuffer sb = new StringBuffer();
            boolean isAntProperty = false;
            while (m.find()) {
                char followOnChar;
                int last = m.end();
                if (last < result.length() && IBMIBuildTaskUtils.isValidNameChar(followOnChar = result.charAt(last))) continue;
                if (IBMIBuildTaskUtils.isAntProperty(currentValue)) {
                    String antPropertyValue = project.getProperty(IBMIBuildTaskUtils.extractAntPropertyName(currentValue));
                    if (antPropertyValue != null) {
                        result = m.replaceAll(Matcher.quoteReplacement(antPropertyValue));
                        break;
                    }
                    result = m.replaceAll(Matcher.quoteReplacement(""));
                    isAntProperty = true;
                    throw new BuildException("Ant property not set: " + currentValue);
                }
                m.appendReplacement(sb, Matcher.quoteReplacement(currentValue));
            }
            if (isAntProperty) continue;
            m.appendTail(sb);
            result = sb.toString();
        }
        return result;
    }

    public Set<Object> getResolvedResource(IBMIInput ibmIInput) {
        Set<Object> results = this.resolvedResource.get(ibmIInput);
        if (results == null) {
            return Collections.EMPTY_SET;
        }
        return results;
    }

    public void cleanup() {
        this.resolvedResource.clear();
    }

    public void cleanup(IBMIInput ibmIInput) {
        this.resolvedResource.remove(ibmIInput);
    }
}

