/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iant.taskdefs.build;

import com.ibm.etools.iseries.comm.interfaces.IISeriesHostMemberNameOnly;
import com.ibm.etools.iseries.comm.interfaces.IISeriesHostObjectBasic;
import com.ibm.etools.iseries.comm.interfaces.IISeriesHostObjectBrief;
import com.ibm.iant.taskdefs.AbstractIBMiCommandTask;
import com.ibm.iant.taskdefs.IAntTaskUtils;
import com.ibm.iant.taskdefs.IUpToDate;
import com.ibm.iant.taskdefs.build.IBMIBuildTaskUtils;
import com.ibm.iant.taskdefs.build.IBMIInputResolver;
import com.ibm.iant.taskdefs.build.IBMITagTask;
import com.ibm.iant.types.ICommand;
import com.ibm.iant.types.IMemberNameEntry;
import com.ibm.iant.types.IMemberPatternSet;
import com.ibm.iant.types.IMemberSet;
import com.ibm.iant.types.IObjectNameEntry;
import com.ibm.iant.types.IObjectPatternSet;
import com.ibm.iant.types.IObjectSet;
import com.ibm.iant.types.ISource;
import com.ibm.iant.types.ITarget;
import com.ibm.iant.types.Objects;
import com.ibm.iant.types.build.IBMIInput;
import com.ibm.iant.types.build.IBMIProcess;
import com.ibm.iant.types.build.IBMIVariable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;

public class IBMIGenericBuildTask2
extends AbstractIBMiCommandTask {
    public static final String copyright = "(C) Copyright IBM Corporation 2009.";
    private boolean checkObject = true;
    private final ArrayList<IBMIProcess> processes = new ArrayList();
    private final ArrayList<IBMIProcess> absentProcessBucket = new ArrayList();
    private final ArrayList<IBMIProcess> outofDateProcessBucket = new ArrayList();
    private Object currentIterativeResource;
    private List<IBMIInput> aggregatedInputs;
    private List<IBMIInput> dependencyInputs;
    private IBMIInputResolver inputResolver;
    private String buildSpecTargetName = "";
    private Objects specifiedOutputObject = null;
    private Iterator<IBMIVariable> taskVariablesIterator = null;
    private HashMap<String, String> gtVariableSubstitutionMap = new HashMap();
    private final HashMap<String, String> variableSubstitutionMap = new HashMap();
    private Date baseDateStamp = null;
    private boolean needCleanup = true;
    private String expectedOutputObjectBuildLibrary = "*CURLIB";

    public IBMIGenericBuildTask2() {
        this.log("[IBMIGenericBuildTask] constructor", 3);
    }

    public void setCheckobject(boolean checkObject) {
        this.checkObject = checkObject;
    }

    public IBMIProcess createProcess() {
        IBMIProcess bMIProcess = new IBMIProcess();
        this.processes.add(bMIProcess);
        return bMIProcess;
    }

    @Override
    public void execute() throws BuildException {
        this.log("[IBMIGenericBuildTask] execute()", 3);
        this.cleanUp();
        this.queryBaseTimeStamp();
        this.expectedOutputObjectBuildLibrary = IAntTaskUtils.getCurrentLibName(this.getAS400());
        this.categorizeProcesses();
        this.resolveTaskLevelVariables(this.gtVariableSubstitutionMap);
        if (!this.checkObject) {
            this.log("A general command set is specified. Run command set without object checking", 3);
            this.runProcessesWithoutChecking(this.processes, this.expectedOutputObjectBuildLibrary, this.inputResolver);
        } else {
            this.log("A conditional command set is specified. Run command set with object checking", 3);
            this.runProcessesWithChecking(this.expectedOutputObjectBuildLibrary);
        }
    }

    private void queryBaseTimeStamp() {
        if (this.baseDateStamp == null) {
            try {
                this.baseDateStamp = this.getAS400().getSignonDate().getTime();
            }
            catch (Exception e) {
                this.log("Error: Failed to get base IBM i time stamp for server [" + this.getAS400().getSystemName() + "]", 0);
            }
        }
    }

    protected void cleanUp() {
        if (this.absentProcessBucket != null) {
            this.absentProcessBucket.clear();
        }
        if (this.outofDateProcessBucket != null) {
            this.outofDateProcessBucket.clear();
        }
        if (this.variableSubstitutionMap != null) {
            this.variableSubstitutionMap.clear();
        }
    }

    protected void categorizeProcesses() {
        IBMIProcess outofdateProcess = null;
        boolean hasAbsentProcess = false;
        boolean hasInheritsAbsentProcess = false;
        for (IBMIProcess process : this.processes) {
            if (process.getState().equals("*OUTOFDATE")) {
                this.outofDateProcessBucket.add(process);
                outofdateProcess = process;
                continue;
            }
            if (!process.getState().equals("*ABSENT")) continue;
            hasAbsentProcess = true;
            if (!process.isInherits()) {
                this.absentProcessBucket.add(process);
                continue;
            }
            hasInheritsAbsentProcess = true;
        }
        if (!hasAbsentProcess || hasInheritsAbsentProcess) {
            if (outofdateProcess != null) {
                this.absentProcessBucket.add(outofdateProcess);
                if (!hasAbsentProcess) {
                    this.log("No command set specified if output object does not exist. By default, the command set specified for out-of-date object will be used.", 3);
                }
                if (hasInheritsAbsentProcess) {
                    this.log("The command set for non-exist output object inherits the command set for out-of-date object. The command set specified for out-of-date object will be used.", 3);
                }
            } else if (this.checkObject) {
                this.log("ERROR: Invalid command set specified. Command set for non-exist output object specified but no command set specified for out-of-date object.", 0);
                return;
            }
        }
    }

    protected void runProcessesWithoutChecking(Collection<IBMIProcess> processes, String expectedOutputObjectBuildLibrary, IBMIInputResolver resolver) {
        if (this.isEmptyProcessBucket(processes)) {
            this.log("Warning: command set does not contain any command.", 1);
            return;
        }
        if (this.getCurrentIterativeResource() == null) {
            Objects substitutedOutputObject;
            ArrayList<Object> inputs = new ArrayList<Object>();
            Set<Object> aggregatedInputResources = this.getAggregatedResources();
            if (aggregatedInputResources != null && !aggregatedInputResources.isEmpty()) {
                inputs.addAll(aggregatedInputResources);
            }
            if ((substitutedOutputObject = this.computeSubstitutedOutputObject(this.specifiedOutputObject, this.variableSubstitutionMap)) != null) {
                this.log("\nThe specified output object after variable substitution: " + this.createSubsitutedObjectName(substitutedOutputObject.getLibrary(), substitutedOutputObject.getName(), substitutedOutputObject.getType(), substitutedOutputObject.getAttribute()), 2);
            }
            Objects expectedOutputObject = this.computeExpectedOutputObject(substitutedOutputObject, expectedOutputObjectBuildLibrary);
            this.fireOutputEvent(expectedOutputObject, inputs, "NEED_BUILD");
            this.runProcessCommands(processes, this.variableSubstitutionMap);
            this.checkAndGenerateRelations(expectedOutputObject);
            this.postProcessRun(expectedOutputObject);
        } else {
            try {
                Object currentResource = this.getCurrentIterativeResource();
                this.resolveInternalVariables(currentResource, this.variableSubstitutionMap);
                Objects substitutedOutputObject = this.computeSubstitutedOutputObject(this.specifiedOutputObject, this.variableSubstitutionMap);
                if (substitutedOutputObject != null) {
                    this.log("\nThe specified output object after variable substitution: " + this.createSubsitutedObjectName(substitutedOutputObject.getLibrary(), substitutedOutputObject.getName(), substitutedOutputObject.getType(), substitutedOutputObject.getAttribute()), 2);
                }
                ArrayList<Object> inputs = new ArrayList<Object>();
                inputs.add(currentResource);
                Objects expectedOutputObject = this.computeExpectedOutputObject(substitutedOutputObject, expectedOutputObjectBuildLibrary);
                this.fireOutputEvent(expectedOutputObject, inputs, "NEED_BUILD");
                this.runProcessCommands(processes, this.variableSubstitutionMap);
                this.checkAndGenerateRelations(expectedOutputObject);
                this.postProcessRun(expectedOutputObject);
                this.cleanupInternalVariables(this.variableSubstitutionMap);
            }
            catch (Exception e) {
                this.log("ERROR:" + e.toString(), 0);
                return;
            }
        }
    }

    private Set<Object> getAggregatedResources() {
        HashSet<Object> aggregatedInputResources = new HashSet<Object>();
        if (this.getAggregatedInputs() != null) {
            for (IBMIInput input : this.getAggregatedInputs()) {
                aggregatedInputResources.add(this.inputResolver.getResolvedResource(input));
            }
        }
        return aggregatedInputResources;
    }

    protected Objects computeSubstitutedOutputObject(Objects specifiedOutputObject, HashMap<String, String> variableSubstitutionMap) {
        String msg;
        if (specifiedOutputObject == null) {
            return null;
        }
        Objects outputObjectWithSubstitution = new Objects();
        String libraryNames = specifiedOutputObject.getLibrary().trim();
        if (libraryNames == null) {
            libraryNames = "";
        }
        if (IBMIBuildTaskUtils.isVariable(libraryNames)) {
            String libraryNameObject = variableSubstitutionMap.get(libraryNames.toUpperCase());
            if (libraryNameObject != null) {
                libraryNames = libraryNameObject;
            } else {
                String msg2 = "ERROR: Variable for the output object library: " + libraryNames + " is not resolved.";
                this.log(msg2, 0);
                return null;
            }
        }
        if (IBMIBuildTaskUtils.isAntProperty(libraryNames)) {
            String msg3 = "ERROR: Ant property not set: " + libraryNames;
            this.log(msg3, 0);
            return null;
        }
        String objectNames = specifiedOutputObject.getName().trim();
        if (objectNames == null) {
            objectNames = "";
        }
        if (IBMIBuildTaskUtils.isVariable(objectNames)) {
            String objectNameObject = variableSubstitutionMap.get(objectNames);
            if (objectNameObject != null) {
                objectNames = objectNameObject;
            } else {
                String msg4 = "ERROR: Variable for the output object name: " + objectNames + " is not resolved.";
                this.log(msg4, 0);
                return null;
            }
        }
        if (IBMIBuildTaskUtils.isAntProperty(objectNames)) {
            msg = "ERROR: Ant property not set: " + objectNames;
            this.log(msg, 0);
            return null;
        }
        if (objectNames.trim().length() == 0) {
            msg = "ERROR: The output object name is empty.";
            this.log(msg, 0);
            return null;
        }
        outputObjectWithSubstitution.setLibrary(libraryNames);
        outputObjectWithSubstitution.setName(objectNames);
        outputObjectWithSubstitution.setType(specifiedOutputObject.getType().trim());
        outputObjectWithSubstitution.setAttribute(specifiedOutputObject.getAttribute().trim());
        outputObjectWithSubstitution.setDeployable(specifiedOutputObject.isDeployable());
        return outputObjectWithSubstitution;
    }

    protected Objects computeExpectedOutputObject(Objects substitutedOutputObject, String intendedOutputObjectLibrary) {
        if (substitutedOutputObject == null) {
            return null;
        }
        Objects expected = new Objects();
        expected.setLibrary(intendedOutputObjectLibrary);
        expected.setName(substitutedOutputObject.getName());
        expected.setType(substitutedOutputObject.getType());
        expected.setAttribute(substitutedOutputObject.getAttribute());
        expected.setDeployable(substitutedOutputObject.isDeployable());
        return expected;
    }

    protected void fireOutputEvent(Objects reportedObject, Collection<Object> inputs, String buildDecision) {
        if (reportedObject == null) {
            return;
        }
        IAntTaskUtils.fireOutputResolveBuildEvent(this.getProject(), this.getBuildSpecTargetName(), reportedObject.getLibrary(), reportedObject.getName(), reportedObject.getType(), reportedObject.getAttribute(), inputs, buildDecision);
    }

    protected void postProcessRun(Objects reportedObject) {
        if (reportedObject == null) {
            return;
        }
        List<IISeriesHostObjectBasic> objects = this.queryObjects(reportedObject);
        if (objects != null && objects.size() > 0) {
            IBMITagTask.tagOneIfNew(objects.get(0), this, this.getAS400());
            if (objects.size() == 1) {
                IISeriesHostObjectBasic object = objects.get(0);
                if (object != null) {
                    if (IAntTaskUtils.isNewlyBuild(object, this.baseDateStamp)) {
                        IAntTaskUtils.fireOutputBuildStatusEvent(this.getProject(), this.getBuildSpecTargetName(), object.getLibrary(), object.getName(), object.getType(), object.getSubType(), "BUILD_SUCCESS");
                    } else {
                        IAntTaskUtils.fireOutputBuildStatusEvent(this.getProject(), this.getBuildSpecTargetName(), object.getLibrary(), object.getName(), object.getType(), object.getSubType(), "BUILD_FAILED");
                    }
                }
            } else {
                String intendedOutputObjectLibrary = IAntTaskUtils.getCurrentLibName(this.getAS400());
                IAntTaskUtils.fireOutputBuildStatusEvent(this.getProject(), this.getBuildSpecTargetName(), intendedOutputObjectLibrary, reportedObject.getName(), reportedObject.getType(), reportedObject.getAttribute(), "BUILD_OUTPUT_NOT_FOUND");
            }
        }
    }

    private List<IISeriesHostObjectBasic> queryObjects(Objects expectedObject) {
        String filterString = new StringBuffer(expectedObject.getLibrary()).append("/").append(expectedObject.getName()).append(" OBJTYPE(").append(expectedObject.getType()).append(":").append(expectedObject.getAttribute()).append(")").toString();
        return IAntTaskUtils.getObjectListForFilterString(filterString, this.getAS400());
    }

    protected void runProcessesWithChecking(String expectedOutputObjectBuildLibrary) {
        if (this.isEmptyProcessBucket(this.processes)) {
            this.log("Warning: command set does not contain any command.", 1);
            return;
        }
        if (this.specifiedOutputObject == null) {
            String msg = "ERROR: Command set needs to check output object state but the output object is not specified in the builder.";
            this.log(msg, 0);
            return;
        }
        Set<Object> aggregatedInputResources = this.getAggregatedResources();
        if (this.getCurrentIterativeResource() == null) {
            Objects resolvedOutputObject;
            Objects substitutedOutputObject;
            ArrayList<Object> inputs = new ArrayList<Object>();
            if (aggregatedInputResources != null && !aggregatedInputResources.isEmpty()) {
                inputs.addAll(aggregatedInputResources);
            }
            if ((substitutedOutputObject = this.computeSubstitutedOutputObject(this.specifiedOutputObject, this.variableSubstitutionMap)) != null) {
                this.log("\nThe specified output object after variable substitution: " + this.createSubsitutedObjectName(substitutedOutputObject.getLibrary(), substitutedOutputObject.getName(), substitutedOutputObject.getType(), substitutedOutputObject.getAttribute()), 2);
            }
            if ((resolvedOutputObject = this.resolveOutputObject(substitutedOutputObject)) == null) {
                this.log("No existing output object found in the system.");
                Objects expectedOutputObject = this.computeExpectedOutputObject(substitutedOutputObject, expectedOutputObjectBuildLibrary);
                this.fireOutputEvent(expectedOutputObject, inputs, "NEED_BUILD");
                this.runProcessCommands(this.absentProcessBucket, this.variableSubstitutionMap);
                this.checkAndGenerateRelations(expectedOutputObject);
                this.postProcessRun(expectedOutputObject);
            } else {
                String key;
                this.log("Found the existing output object in the system: " + this.createQSYSObjectName(resolvedOutputObject.getLibrary(), resolvedOutputObject.getName(), resolvedOutputObject.getType(), resolvedOutputObject.getAttribute()), 2);
                IISeriesHostObjectBrief resultSearchInRelationTable = null;
                boolean isUpToDate = true;
                HashMap<String, IISeriesHostObjectBrief> relationsTable = this.getRelationsTable();
                if (relationsTable != null && (resultSearchInRelationTable = relationsTable.get(key = String.valueOf(resolvedOutputObject.getLibrary()) + resolvedOutputObject.getName())) != null) {
                    isUpToDate = false;
                    relationsTable.remove(key);
                }
                if (isUpToDate) {
                    isUpToDate = this.computeUpToDateAgainstAggregateInput(resolvedOutputObject, aggregatedInputResources);
                }
                if (isUpToDate) {
                    isUpToDate = this.computeUpToDateAgainstDependencies(resolvedOutputObject, this.dependencyInputs, this.variableSubstitutionMap);
                }
                if (!isUpToDate) {
                    this.log("The existing output object is out-of-date. Need to build.", 2);
                    Objects expectedOutputObject = this.computeExpectedOutputObject(resolvedOutputObject, expectedOutputObjectBuildLibrary);
                    this.fireOutputEvent(expectedOutputObject, inputs, "NEED_BUILD");
                    if (this.isInCurLib(resolvedOutputObject, expectedOutputObjectBuildLibrary)) {
                        this.runProcessCommands(this.outofDateProcessBucket, this.variableSubstitutionMap);
                    } else {
                        this.runProcessCommands(this.absentProcessBucket, this.variableSubstitutionMap);
                    }
                    this.checkAndGenerateRelations(expectedOutputObject);
                    this.postProcessRun(expectedOutputObject);
                } else {
                    this.log("The existing output object is up-to-date. No need to build.", 2);
                }
            }
        } else {
            try {
                Objects resolvedOutputObject;
                Object currentResource = this.getCurrentIterativeResource();
                this.resolveInternalVariables(currentResource, this.variableSubstitutionMap);
                Objects substitutedOutputObject = this.computeSubstitutedOutputObject(this.specifiedOutputObject, this.variableSubstitutionMap);
                if (substitutedOutputObject != null) {
                    this.log("\nThe specified output object after variable substitution: " + this.createSubsitutedObjectName(substitutedOutputObject.getLibrary(), substitutedOutputObject.getName(), substitutedOutputObject.getType(), substitutedOutputObject.getAttribute()), 2);
                }
                if ((resolvedOutputObject = this.resolveOutputObject(substitutedOutputObject)) == null) {
                    this.log("No existing output object found in the system. Need to build", 2);
                    ArrayList<Object> inputs = new ArrayList<Object>();
                    inputs.add(currentResource);
                    Objects expectedOutputObject = this.computeExpectedOutputObject(substitutedOutputObject, expectedOutputObjectBuildLibrary);
                    this.fireOutputEvent(expectedOutputObject, inputs, "NEED_BUILD");
                    this.runProcessCommands(this.absentProcessBucket, this.variableSubstitutionMap);
                    this.checkAndGenerateRelations(expectedOutputObject);
                    this.postProcessRun(expectedOutputObject);
                } else {
                    String key;
                    IISeriesHostObjectBrief resultSearchInRelationTable;
                    this.log("Found the existing output object in the system: " + this.createQSYSObjectName(resolvedOutputObject.getLibrary(), resolvedOutputObject.getName(), resolvedOutputObject.getType(), resolvedOutputObject.getAttribute()), 2);
                    boolean isUpToDate = true;
                    HashMap<String, IISeriesHostObjectBrief> relationsTable = this.getRelationsTable();
                    if (relationsTable != null && (resultSearchInRelationTable = relationsTable.get(key = String.valueOf(resolvedOutputObject.getLibrary()) + resolvedOutputObject.getName() + resolvedOutputObject.getType())) != null) {
                        isUpToDate = false;
                        relationsTable.remove(key);
                    }
                    if (isUpToDate) {
                        isUpToDate = this.computeUpToDateAgainstAggregateInput(resolvedOutputObject, aggregatedInputResources);
                    }
                    if (isUpToDate && (isUpToDate = this.computeUpToDateAgainstResource(resolvedOutputObject, currentResource))) {
                        isUpToDate = this.computeUpToDateAgainstDependencies(resolvedOutputObject, this.dependencyInputs, this.variableSubstitutionMap);
                    }
                    if (!isUpToDate) {
                        this.log("The existing output object is out-of-date. Need to build.", 2);
                        ArrayList<Object> inputs = new ArrayList<Object>();
                        inputs.add(currentResource);
                        Objects expectedOutputObject = this.computeExpectedOutputObject(resolvedOutputObject, expectedOutputObjectBuildLibrary);
                        this.fireOutputEvent(expectedOutputObject, inputs, "NEED_BUILD");
                        if (this.isInCurLib(resolvedOutputObject, expectedOutputObjectBuildLibrary)) {
                            this.runProcessCommands(this.outofDateProcessBucket, this.variableSubstitutionMap);
                        } else {
                            this.runProcessCommands(this.absentProcessBucket, this.variableSubstitutionMap);
                        }
                        this.checkAndGenerateRelations(expectedOutputObject);
                        this.postProcessRun(expectedOutputObject);
                    } else {
                        this.log("The existing output object is up-to-date. No need to build.", 2);
                    }
                }
                this.cleanupInternalVariables(this.variableSubstitutionMap);
            }
            catch (Exception e) {
                this.log("ERROR: " + e.toString(), 0);
                return;
            }
        }
    }

    protected boolean computeUpToDateAgainstAggregateInput(Objects resolvedOutputObject, Set<Object> aggregatedInputEntries) {
        if (aggregatedInputEntries == null) {
            return true;
        }
        boolean isUpToDate = true;
        for (Object currentResource : aggregatedInputEntries) {
            isUpToDate = this.computeUpToDateAgainstResource(resolvedOutputObject, currentResource);
            if (!isUpToDate) break;
        }
        String msg = isUpToDate ? "The existing output object is up-to-date against aggregated input." : "The existing output object is out-of-date against aggregated input.";
        this.log(msg, 3);
        return isUpToDate;
    }

    protected boolean computeUpToDateAgainstResource(Objects resolvedOutputObject, Object currentResource) {
        boolean isUpToDate = true;
        String resourceName = "";
        if (currentResource instanceof IISeriesHostMemberNameOnly) {
            IISeriesHostMemberNameOnly currentMember = (IISeriesHostMemberNameOnly)currentResource;
            isUpToDate = this.checkUpToDateForMemberSource(resolvedOutputObject, currentMember.getLibrary(), currentMember.getFile(), currentMember.getName());
            resourceName = this.createQSYSMemberName(currentMember.getLibrary(), currentMember.getFile(), currentMember.getName());
        } else if (currentResource instanceof IISeriesHostObjectBrief) {
            IISeriesHostObjectBrief currentObject = (IISeriesHostObjectBrief)currentResource;
            isUpToDate = this.checkUpToDateForObjectResource(resolvedOutputObject, currentObject.getLibrary(), currentObject.getName(), currentObject.getType());
            resourceName = this.createQSYSObjectName(currentObject.getLibrary(), currentObject.getName(), currentObject.getType(), currentObject.getSubType());
        }
        String msg = isUpToDate ? "The existing output object is up-to-date against resource: " + resourceName : "The existing output object is out-of-date against resource: " + resourceName;
        this.log(msg, 3);
        return isUpToDate;
    }

    private String createQSYSObjectName(String libName, String objName, String type, String subType) {
        StringBuffer nameBuffer = new StringBuffer(libName).append("/").append(objName).append(" OBJTYPE(").append(type);
        if (subType != null && subType.trim().length() > 0) {
            nameBuffer = nameBuffer.append(":").append(subType);
        }
        nameBuffer = nameBuffer.append(")");
        return nameBuffer.toString();
    }

    private String createQSYSMemberName(String libName, String fileName, String objName) {
        StringBuffer nameBuffer = new StringBuffer(libName).append("/").append(fileName).append("(").append(objName).append(")");
        return nameBuffer.toString();
    }

    private String createSubsitutedObjectName(String libNames, String objName, String type, String subType) {
        StringBuffer nameBuffer = new StringBuffer("Name:").append(objName).append(" Type:").append(type);
        if (subType != null && subType.trim().length() > 0) {
            nameBuffer = nameBuffer.append(" Attribute:").append(subType);
        }
        nameBuffer.append(" in libraries: ").append(libNames);
        return nameBuffer.toString();
    }

    protected boolean computeUpToDateAgainstDependencies(Objects resolvedOutputObject, List<IBMIInput> dependencyInputs, HashMap<String, String> variableSubstitutionMap) {
        if (dependencyInputs == null) {
            return true;
        }
        boolean isUpToDate = true;
        int i = 0;
        while (i < dependencyInputs.size()) {
            IBMIInput thisInput = dependencyInputs.get(i);
            Collection<Object> sourceResourceSet = this.resolveDependencyInputResources(thisInput, variableSubstitutionMap, this.inputResolver);
            Iterator<Object> iter = sourceResourceSet.iterator();
            while (isUpToDate && iter != null && iter.hasNext()) {
                Object thisDependentResource = iter.next();
                isUpToDate = this.computeUpToDateAgainstResource(resolvedOutputObject, thisDependentResource);
                if (!isUpToDate) break;
            }
            ++i;
        }
        String msg = isUpToDate ? "The existing output object is up-to-date against dependencies." : "The existing output object is out-of-date against dependencies.";
        this.log(msg, 3);
        return isUpToDate;
    }

    protected Collection<Object> resolveDependencyInputResources(IBMIInput dependencyInput, HashMap<String, String> variableSubstitutionMap, IBMIInputResolver inputResolver) {
        try {
            return inputResolver.resolve(dependencyInput, variableSubstitutionMap);
        }
        catch (Exception e) {
            this.log("Error occured when resolving " + dependencyInput.getId() + ": " + e.toString(), 1);
            return Collections.EMPTY_LIST;
        }
    }

    protected boolean checkUpToDateForMemberSource(Objects resolvedOutputObject, String sourceMemberLibrary, String sourceMemberFile, String sourceMemberName) {
        IUpToDate upToDateTask = new IUpToDate();
        Project myProject = this.getProject();
        upToDateTask.setProject(myProject);
        upToDateTask.setProperty("uptodated");
        this.setupTargetForUpToDateTask(upToDateTask, resolvedOutputObject);
        this.setupMemberSetForUpToDateTask(upToDateTask, sourceMemberLibrary, sourceMemberFile, sourceMemberName);
        upToDateTask.execute();
        return upToDateTask.isUpdateToDate();
    }

    protected boolean checkUpToDateForObjectResource(Objects resolvedOutputObject, String sourceObjectLibrary, String sourceObjectName, String sourceObjectType) {
        IUpToDate upToDateTask = new IUpToDate();
        Project myProject = this.getProject();
        upToDateTask.setProject(myProject);
        upToDateTask.setProperty("uptodated");
        this.setupTargetForUpToDateTask(upToDateTask, resolvedOutputObject);
        this.setupObjectSetForUpToDateTask(upToDateTask, sourceObjectLibrary, sourceObjectName, sourceObjectType);
        upToDateTask.execute();
        return upToDateTask.isUpdateToDate();
    }

    private void setupTargetForUpToDateTask(IUpToDate upToDateTask, Objects resolvedOutputObject) {
        ITarget target = upToDateTask.createITarget();
        IObjectSet targetObjectSet = target.createIObjectSet();
        targetObjectSet.setProject(upToDateTask.getProject());
        targetObjectSet.setSystemref(this._systemref);
        String libraryName = resolvedOutputObject.getLibrary();
        String objectName = resolvedOutputObject.getName();
        targetObjectSet.setLibrary(libraryName);
        IObjectPatternSet objectPatternSet = targetObjectSet.createIObjectPatternSet();
        objectPatternSet.setProject(upToDateTask.getProject());
        IObjectNameEntry filter1 = (IObjectNameEntry)objectPatternSet.createInclude();
        filter1.setName(objectName);
        filter1.setType(resolvedOutputObject.getType());
    }

    private void setupObjectSetForUpToDateTask(IUpToDate upToDateTask, String sourceObjectLibrary, String sourceObjectName, String sourceObjectType) {
        ISource source = upToDateTask.createISource();
        IObjectSet sourceObject = source.createIObjectSet();
        sourceObject.setProject(upToDateTask.getProject());
        sourceObject.setSystemref(this._systemref);
        sourceObject.setLibrary(sourceObjectLibrary);
        IObjectPatternSet sourceObjectPatternSet = sourceObject.createIObjectPatternSet();
        sourceObjectPatternSet.setProject(upToDateTask.getProject());
        IObjectNameEntry filter2 = (IObjectNameEntry)sourceObjectPatternSet.createInclude();
        filter2.setName(sourceObjectName);
        filter2.setType(sourceObjectType);
    }

    private void setupMemberSetForUpToDateTask(IUpToDate upToDateTask, String sourceMemberLibrary, String sourceMemberFile, String sourceMemberName) {
        ISource source = upToDateTask.createISource();
        IMemberSet sourceMemberSet = source.createIMemberSet();
        sourceMemberSet.setProject(upToDateTask.getProject());
        sourceMemberSet.setSystemref(this._systemref);
        sourceMemberSet.setLibrary(sourceMemberLibrary);
        sourceMemberSet.setFileName(sourceMemberFile);
        IMemberPatternSet mbrPatternSet = sourceMemberSet.createIMemberPatternSet();
        mbrPatternSet.setProject(upToDateTask.getProject());
        IMemberNameEntry memberFilter = (IMemberNameEntry)mbrPatternSet.createInclude();
        memberFilter.setName(sourceMemberName);
    }

    private boolean isInCurLib(Objects resolvedOutputObject, String curlib) {
        String lib = resolvedOutputObject.getLibrary();
        if (lib.equalsIgnoreCase("*CURLIB")) {
            return true;
        }
        return lib.equalsIgnoreCase(curlib);
    }

    protected Objects resolveOutputObject(Objects substitutedOutputObject) {
        if (substitutedOutputObject == null) {
            return null;
        }
        Objects reslovedOutputObject = null;
        IObjectSet thisObjectSet = (IObjectSet)this.createIResourceCollection(new IObjectSet());
        thisObjectSet.setProject(this.getProject());
        thisObjectSet.setSystemref(this._systemref);
        thisObjectSet.setLibrary(substitutedOutputObject.getLibrary());
        IObjectPatternSet thisObjectPatternSet = thisObjectSet.createIObjectPatternSet();
        thisObjectPatternSet.setProject(this.getProject());
        IObjectNameEntry filter1 = (IObjectNameEntry)thisObjectPatternSet.createInclude();
        filter1.setName(substitutedOutputObject.getName());
        filter1.setType(substitutedOutputObject.getType());
        filter1.setObjectAttribute(substitutedOutputObject.getAttribute());
        try {
            StringBuffer libWithDupObj = new StringBuffer();
            if (!this.isValidMultipleOccurance(thisObjectSet)) {
                String msg = new StringBuffer("ERROR: Multiple matches found in library ").append(libWithDupObj).append(" for specified output: ").append(this.createSubsitutedObjectName(substitutedOutputObject.getLibrary(), substitutedOutputObject.getName(), substitutedOutputObject.getType(), substitutedOutputObject.getAttribute())).toString();
                this.log(msg, 0);
                throw new BuildException(msg);
            }
            Iterator thisObjectsIterator = thisObjectSet.iterator();
            if (thisObjectsIterator.hasNext()) {
                Object thisObject = thisObjectsIterator.next();
                IISeriesHostObjectBrief curObject = (IISeriesHostObjectBrief)thisObject;
                reslovedOutputObject = new Objects();
                reslovedOutputObject.setLibrary(curObject.getLibrary());
                reslovedOutputObject.setName(curObject.getName());
                reslovedOutputObject.setType(curObject.getType());
            }
        }
        catch (Exception e) {
            this.log("Error: error occurred when looking up output object: " + e.toString(), 0);
        }
        return reslovedOutputObject;
    }

    private boolean isValidMultipleOccurance(IObjectSet thisObjectSet) {
        try {
            HashMap resolvedObjects = new HashMap();
            Iterator thisObjectsIterator = thisObjectSet.iterator();
            Object thisObject = null;
            IISeriesHostObjectBrief curObject = null;
            String firstMatchLibName = null;
            String objName = null;
            Set nameSet = null;
            if (thisObjectsIterator.hasNext()) {
                thisObject = thisObjectsIterator.next();
                curObject = thisObject;
                firstMatchLibName = curObject.getLibrary().trim();
                objName = curObject.getName();
                nameSet = new HashSet<String>();
                nameSet.add(objName);
                resolvedObjects.put(firstMatchLibName, nameSet);
            }
            boolean isValid = true;
            while (thisObjectsIterator.hasNext()) {
                thisObject = thisObjectsIterator.next();
                curObject = thisObject;
                String libName = curObject.getLibrary();
                if (!libName.trim().equalsIgnoreCase(firstMatchLibName)) continue;
                objName = curObject.getName();
                nameSet = (Set)resolvedObjects.get(firstMatchLibName);
                if (nameSet == null || !nameSet.contains(objName)) continue;
                isValid = false;
                break;
            }
            return isValid;
        }
        catch (Exception e) {
            this.log("Error: " + e.toString(), 0);
            return true;
        }
    }

    protected void resolveTaskLevelVariables(HashMap<String, String> variableSubstitutionMap) {
        while (this.taskVariablesIterator != null && this.taskVariablesIterator.hasNext()) {
            IBMIVariable thisVariable = this.taskVariablesIterator.next();
            String variableName = thisVariable.getName();
            if (variableName == null) continue;
            variableName = variableName.toUpperCase();
            String variableValue = thisVariable.getValue();
            String variableType = thisVariable.getType().trim();
            if (variableType.equalsIgnoreCase("*STRING")) {
                String valueFoundInMap;
                if (variableValue != null && variableValue.startsWith("&") && (valueFoundInMap = variableSubstitutionMap.get(variableValue.toUpperCase())) != null) {
                    variableValue = valueFoundInMap;
                }
                variableSubstitutionMap.put(variableName, variableValue);
                continue;
            }
            if (!variableType.equalsIgnoreCase("*INPUT")) continue;
            String variableFormat = thisVariable.getFormat();
            if (!(variableValue = "&" + variableValue + "." + variableFormat).endsWith(".*QUALIFIED_NAME") && !variableValue.endsWith(".*NAME")) continue;
            String resolvedInputVariableValue = variableSubstitutionMap.get(variableValue.toUpperCase());
            variableSubstitutionMap.put(variableName, resolvedInputVariableValue);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void mergeVariables(HashMap<String, String> parametersMap, HashMap<String, String> inputTypeVariablesMap, HashMap<String, String> variableSubstitutionMap) {
        keySet = parametersMap.keySet();
        keyIterator = keySet.iterator();
        if (keyIterator != null) ** GOTO lbl12
        return;
lbl-1000:
        // 1 sources

        {
            paramName = keyIterator.next().toUpperCase();
            paramValue = parametersMap.get(paramName);
            if (paramValue != null && inputTypeVariablesMap != null && (paramValue.startsWith("&") || paramValue.endsWith(".*QUALIFIED_NAME") || paramValue.endsWith(".*NAME")) && (mappedParamValue = inputTypeVariablesMap.get(paramValue)) != null) {
                paramValue = mappedParamValue;
            }
            if (paramName == null || paramValue == null) continue;
            variableSubstitutionMap.put(paramName, paramValue);
lbl12:
            // 3 sources

            ** while (keyIterator.hasNext())
        }
lbl13:
        // 1 sources

    }

    protected void resolveInternalVariables(Object currentResource, HashMap<String, String> variableSubstitutionMap) {
        if (currentResource instanceof IISeriesHostMemberNameOnly) {
            IISeriesHostMemberNameOnly currentObject = (IISeriesHostMemberNameOnly)currentResource;
            variableSubstitutionMap.put("&N", currentObject.getName());
            variableSubstitutionMap.put("&F", currentObject.getFile());
            variableSubstitutionMap.put("&L", currentObject.getLibrary());
        } else if (currentResource instanceof IISeriesHostObjectBrief) {
            IISeriesHostObjectBrief currentObject = (IISeriesHostObjectBrief)currentResource;
            variableSubstitutionMap.put("&N", currentObject.getName());
            variableSubstitutionMap.put("&L", currentObject.getLibrary());
        }
    }

    protected void cleanupInternalVariables(HashMap<String, String> variableSubstitutionMap) {
        if (variableSubstitutionMap.get("&N") != null) {
            variableSubstitutionMap.remove("&N");
        }
        if (variableSubstitutionMap.get("&F") != null) {
            variableSubstitutionMap.remove("&F");
        }
        if (variableSubstitutionMap.get("&L") != null) {
            variableSubstitutionMap.remove("&L");
        }
    }

    private void populateParametersMap(HashMap<String, String> parametersMap) {
        while (this.taskVariablesIterator != null && this.taskVariablesIterator.hasNext()) {
            IBMIVariable thisVariable = this.taskVariablesIterator.next();
            String variableName = thisVariable.getName();
            if (variableName == null) continue;
            variableName = variableName.toUpperCase();
            String variableValue = thisVariable.getValue();
            String variableType = thisVariable.getType().trim();
            if (variableType.equalsIgnoreCase("*STRING")) {
                String valueFoundInMap;
                if (variableValue != null && variableValue.startsWith("&") && (valueFoundInMap = parametersMap.get(variableValue.toUpperCase())) != null) {
                    variableValue = valueFoundInMap;
                }
                parametersMap.put(variableName, variableValue);
                continue;
            }
            if (!variableType.equalsIgnoreCase("*INPUT")) continue;
            String variableFormat = thisVariable.getFormat();
            variableValue = "&" + variableValue + "." + variableFormat;
            parametersMap.put(variableName, variableValue.toUpperCase());
        }
    }

    protected void runProcessCommands(Collection<IBMIProcess> processes, HashMap<String, String> variableSubstitutionMap) {
        for (IBMIProcess process : processes) {
            Vector<ICommand> commands = process.getCommands();
            int i = 0;
            while (i < commands.size()) {
                ICommand thisCommand = (ICommand)((Object)commands.get(i));
                String command = thisCommand.getCommandString();
                command = this.substituteVars(command, variableSubstitutionMap);
                this.runCommand(command);
                ++i;
            }
        }
    }

    public void setGlobalAndTargetVariables(HashMap<String, String> gtVariableSubstitutionMap) {
        this.gtVariableSubstitutionMap = gtVariableSubstitutionMap;
        this.variableSubstitutionMap.clear();
        this.variableSubstitutionMap.putAll(gtVariableSubstitutionMap);
    }

    public void setTaskLocalVariables(Iterator<IBMIVariable> iterator) {
        this.taskVariablesIterator = iterator;
    }

    public void setCurrentIterativeResource(Object currentIterativeResource) {
        this.currentIterativeResource = currentIterativeResource;
    }

    public void setAggregatedInputs(List<IBMIInput> aggregatedInputs) {
        this.aggregatedInputs = aggregatedInputs;
    }

    public void setDependencyInputs(List<IBMIInput> dependencyInputs) {
        this.dependencyInputs = dependencyInputs;
    }

    public void setInputResolver(IBMIInputResolver inputResolver) {
        this.inputResolver = inputResolver;
    }

    public Object getCurrentIterativeResource() {
        return this.currentIterativeResource;
    }

    public List<IBMIInput> getAggregatedInputs() {
        return this.aggregatedInputs;
    }

    public List<IBMIInput> getDependencyInputs() {
        return this.dependencyInputs;
    }

    public IBMIInputResolver getInputResolver() {
        return this.inputResolver;
    }

    private String substituteVars(String str, HashMap<String, String> map) {
        String result = str;
        Set<String> keys = map.keySet();
        Iterator<String> iterator = keys.iterator();
        while (iterator != null && iterator.hasNext()) {
            String currentKey = iterator.next();
            String currentValue = map.get(currentKey);
            Pattern p = Pattern.compile(currentKey, 66);
            Matcher m = p.matcher(result);
            if (!m.find()) continue;
            if (IBMIBuildTaskUtils.isAntProperty(currentValue)) {
                this.log("ERROR: Ant property not set: " + currentValue, 0);
                result = m.replaceAll(Matcher.quoteReplacement(""));
            }
            result = m.replaceAll(Matcher.quoteReplacement(currentValue));
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    private boolean isEmptyProcessBucket(Collection<IBMIProcess> processes) {
        iter = processes.iterator();
        if (iter.hasNext()) ** GOTO lbl7
        return true;
lbl-1000:
        // 1 sources

        {
            process = iter.next();
            if (process.getCommands().size() <= 0) continue;
            return false;
lbl7:
            // 2 sources

            ** while (iter.hasNext())
        }
lbl8:
        // 1 sources

        return true;
    }

    private void checkAndGenerateRelations(Objects expectedOutputObject) {
        if (expectedOutputObject == null) {
            return;
        }
        String library = expectedOutputObject.getLibrary();
        String name = expectedOutputObject.getName();
        String type = expectedOutputObject.getType();
        String attribute = expectedOutputObject.getAttribute();
        List<IISeriesHostObjectBrief> list = null;
        if (type.trim().equalsIgnoreCase("*FILE") && attribute.equalsIgnoreCase("PF") || attribute.equalsIgnoreCase("*ALL") || attribute.equalsIgnoreCase("*")) {
            list = IAntTaskUtils.getRelationsForPF(library, name, type, this.getAS400());
        }
        if (list == null) {
            return;
        }
        HashMap<String, IISeriesHostObjectBrief> relationsTable = this.getRelationsTable();
        for (IISeriesHostObjectBrief o : list) {
            String key = String.valueOf(o.getLibrary()) + o.getName() + o.getType();
            relationsTable.put(key, o);
        }
    }

    public void setBuildSpecTargetName(String buildSpecTargetName) {
        this.buildSpecTargetName = buildSpecTargetName;
    }

    public String getBuildSpecTargetName() {
        return this.buildSpecTargetName;
    }

    public void setOutputObject(Objects outputObject) {
        this.specifiedOutputObject = outputObject;
    }

    public HashMap<String, String> getSubstitutionMap() {
        return this.variableSubstitutionMap;
    }

    public void setCleanupFlag(boolean needCleanup) {
        this.needCleanup = needCleanup;
    }
}

