/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iant.taskdefs.build;

import com.ibm.etools.iseries.comm.interfaces.IISeriesHostObjectBrief;
import com.ibm.iant.types.Objects;
import com.ibm.team.build.internal.PasswordHelper;
import com.ibm.team.repository.common.util.ObfuscationHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;

public class IBMIBuildTaskUtils {
    public static String copyright = "(c) Copyright IBM Corp 2010.";

    public static boolean isLibraryType(IISeriesHostObjectBrief hostObject) {
        String type = hostObject.getType();
        if (type == null) {
            return false;
        }
        return type.trim().equalsIgnoreCase("*LIB");
    }

    public static boolean isLibraryType(Objects objects) {
        return objects.getType().trim().equalsIgnoreCase("*LIB");
    }

    public static boolean isAntProperty(String name) {
        return name.startsWith("${") && name.endsWith("}");
    }

    public static String extractAntPropertyName(String name) {
        if (!IBMIBuildTaskUtils.isAntProperty(name)) {
            return name;
        }
        if (name.trim().equals("${}")) {
            return "";
        }
        return name.substring(2, name.trim().length() - 1);
    }

    public static boolean isVariable(String name) {
        return name.startsWith("&");
    }

    public static boolean isValidNameChar(char c) {
        return 'A' <= c && c <= 'Z' || 'a' <= c && c <= 'z' || Character.isDigit(c) || '_' == c;
    }

    public static String getProvidedPassword(String filePath) {
        File passwordFile = new File(filePath);
        try {
            return IBMIBuildTaskUtils.decryptPassword(passwordFile);
        }
        catch (Exception exception) {
            throw null;
        }
    }

    public static String decryptPassword(File passwordFile) throws GeneralSecurityException, IOException {
        return PasswordHelper.getPassword((File)passwordFile);
    }

    public static String getPassword(File passwordFile) throws GeneralSecurityException, IOException {
        StringBuffer fileContent = new StringBuffer();
        FileInputStream inputStream = new FileInputStream(passwordFile);
        byte[] buffer = new byte[256];
        int bytesRead = inputStream.read(buffer);
        while (bytesRead != -1) {
            fileContent.append(new String(buffer, 0, bytesRead));
            bytesRead = inputStream.read(buffer);
        }
        inputStream.close();
        return new String(ObfuscationHelper.decrypt((byte[])fileContent.toString().getBytes()));
    }
}

