/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iant.taskdefs.build;

import com.ibm.etools.iseries.comm.interfaces.IISeriesHostMemberNameOnly;
import com.ibm.etools.iseries.comm.interfaces.IISeriesHostObjectBrief;
import com.ibm.iant.taskdefs.AbstractIBMiCommandTask;
import com.ibm.iant.taskdefs.build.IBMIBuildTaskUtils;
import com.ibm.iant.taskdefs.build.IBMIGenericBuildTask2;
import com.ibm.iant.taskdefs.build.IBMIInputResolver;
import com.ibm.iant.types.Objects;
import com.ibm.iant.types.Variables;
import com.ibm.iant.types.build.IBMIInput;
import com.ibm.iant.types.build.IBMIVariable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.apache.tools.ant.BuildException;

public class IBMIBuildTask2
extends AbstractIBMiCommandTask {
    private Objects outputObject = null;
    private Inputs inputs;
    private TaskRefs taskrefs;
    private Variables globalvariables;
    private Variables targetvariables;
    public static final String SEARCH_PATH_VARIABLE_NAME = "&SP";
    public static final String SRC_LIB_VARIABLE_NAME = "&SRCLIB";
    public static final String OBJ_LIB_VARIABLE_NAME = "&OBJLIB";
    public static final String FIXLIBL_ANT_NAME = "ibuild.fixlibl";
    public static final String BASELIBL_ANT_NAME = "ibuild.baselibl";
    public static final String SRCLIB_ANT_NAME = "ibuild.sourceLibrary";
    public static final String OBJLIB_ANT_NAME = "ibuild.targetLibrary";
    private Iterator<IBMIInput> iBMIInputs;
    private IBMIInput iterateInput;
    private List<IBMIInput> aggregateInputs;
    private List<IBMIInput> dependencyInputs;
    private String buildSpecTargetName = "";

    public Inputs createInputs() {
        this.inputs = new Inputs();
        return this.inputs;
    }

    public Objects createOutput() {
        this.outputObject = new Objects();
        return this.outputObject;
    }

    public TaskRefs createTaskRefs() {
        this.taskrefs = new TaskRefs();
        return this.taskrefs;
    }

    public Variables createGlobalvariables() {
        this.globalvariables = new Variables();
        return this.globalvariables;
    }

    public Variables createVariables() {
        this.targetvariables = new Variables();
        return this.targetvariables;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void execute() throws BuildException {
        this.setBuildSpecTargetName(this.target.getName());
        if (this.taskrefs == null) {
            this.log("No command set is specified for the builder " + this.getBuildSpecTargetName(), 2);
            return;
        }
        this.categorizeInputs();
        HashMap<String, String> variableSubstitutionMap = new HashMap<String, String>();
        this.populateGlobalAntTargetVariables(variableSubstitutionMap);
        IBMIInputResolver resolver = new IBMIInputResolver(this.getProject(), this._systemref);
        if (this.hasIterateInput()) {
            try {
                resolver.resolve(this.iterateInput, variableSubstitutionMap);
            }
            catch (Exception e) {
                String msg;
                BuildException exception;
                if (e instanceof BuildException) {
                    exception = (BuildException)((Object)e);
                    msg = e.getMessage();
                } else {
                    msg = e.getMessage();
                    exception = new BuildException(e.getMessage(), this.getLocation());
                }
                String location = exception.getLocation().toString();
                this.log(String.valueOf(msg) + location, 0);
                return;
            }
        }
        if (this.aggregateInputs != null) {
            for (IBMIInput input : this.aggregateInputs) {
                try {
                    resolver.resolve(input, variableSubstitutionMap);
                }
                catch (Exception e) {
                    String msg;
                    BuildException exception;
                    if (e instanceof BuildException) {
                        exception = (BuildException)((Object)e);
                        msg = e.getMessage();
                    } else {
                        msg = e.getMessage();
                        exception = new BuildException(e.getMessage(), this.getLocation());
                    }
                    String location = exception.getLocation().toString();
                    this.log(String.valueOf(msg) + location, 0);
                }
            }
            HashMap<String, String> inputTypeVariableSubstitutionMap = new HashMap<String, String>();
            this.resolveAggregateInputVariables(this.aggregateInputs, resolver, inputTypeVariableSubstitutionMap);
            this.mergeVariables(inputTypeVariableSubstitutionMap, variableSubstitutionMap);
        }
        if (!this.hasIterateInput()) {
            this.executeCommandSets(this.taskrefs, this.aggregateInputs, this.dependencyInputs, variableSubstitutionMap, resolver);
            return;
        }
        Set<Object> iterativeSourceResourceSet = resolver.getResolvedResource(this.iterateInput);
        try {
            Iterator iter = iterativeSourceResourceSet.iterator();
            if (!iter.hasNext()) {
                this.log("Warning: No input members matching the filters were found. The command sets will not be run.", 1);
                return;
            }
            while (true) {
                if (!iter.hasNext()) {
                    return;
                }
                Object currentResource = iter.next();
                this.executeCommandSets(this.taskrefs, currentResource, this.aggregateInputs, this.dependencyInputs, variableSubstitutionMap, resolver);
            }
        }
        catch (Exception e) {
            this.log("ERROR:" + e.toString(), 0);
        }
    }

    private boolean isEmptyOutput(Objects output) {
        if (output == null) {
            return true;
        }
        return output.getLibrary().trim().length() == 0 || output.getName().trim().length() == 0;
    }

    /*
     * Unable to fully structure code
     */
    protected void categorizeInputs() {
        if (this.iBMIInputs != null) ** GOTO lbl26
        this.log("No input is specified for the builder " + this.getBuildSpecTargetName(), 2);
        return;
lbl-1000:
        // 1 sources

        {
            currentInput = this.iBMIInputs.next();
            type = currentInput.getType().trim();
            if (type.equalsIgnoreCase("*ITERATE")) {
                if (this.iterateInput == null) {
                    this.iterateInput = currentInput;
                    this.log("Iterated input " + currentInput.getId() + " specified for the builder " + this.getBuildSpecTargetName(), 2);
                    continue;
                }
                this.log("ERROR: More than one iterate input specified for the builder " + this.getBuildSpecTargetName(), 0);
                throw new BuildException("More than one iterate input passed in.");
            }
            if (type.equalsIgnoreCase("*AGGREGATE")) {
                if (this.aggregateInputs == null) {
                    this.aggregateInputs = new Vector<IBMIInput>();
                }
                this.aggregateInputs.add(currentInput);
                this.log("Aggregated input " + currentInput.getId() + " specified for the builder " + this.getBuildSpecTargetName(), 2);
                continue;
            }
            if (!type.equalsIgnoreCase("*DEPENDENCY")) continue;
            if (this.dependencyInputs == null) {
                this.dependencyInputs = new Vector<IBMIInput>();
            }
            this.dependencyInputs.add(currentInput);
            this.log("Resource dependency input " + currentInput.getId() + " specified for the builder " + this.getBuildSpecTargetName(), 2);
lbl26:
            // 5 sources

            ** while (this.iBMIInputs.hasNext())
        }
lbl27:
        // 1 sources

    }

    protected void executeCommandSets(TaskRefs taskrefs, List<IBMIInput> aggregateInputs, List<IBMIInput> dependencyInputs, HashMap<String, String> variableSubstitutionMap, IBMIInputResolver resolver) {
        this.executeCommandSets(taskrefs, null, aggregateInputs, dependencyInputs, variableSubstitutionMap, resolver);
    }

    protected void executeCommandSets(TaskRefs taskrefs, Object currentIterativeResource, List<IBMIInput> aggregateInputs, List<IBMIInput> dependencyInputs, HashMap<String, String> variableSubstitutionMap, IBMIInputResolver resolver) {
        Iterator<TaskRef> iter = taskrefs.iterator();
        while (iter.hasNext()) {
            TaskRef taskref = iter.next();
            String taskId = taskref.getTaskId();
            if (taskId == null) {
                String msg = "Error: No command set was found. The refid parameter was not specified for the <taskref> element.";
                this.log(msg, 0);
                return;
            }
            Object obj = this.getProject().getReference(taskId);
            if (obj == null) {
                String msg = "Error: No command set was found with an ID matching the refid attribute specified in the <taskref> element. refid attribute specified: " + taskId;
                this.log(msg, 0);
                return;
            }
            if (!(obj instanceof IBMIGenericBuildTask2)) continue;
            IBMIGenericBuildTask2 bMIGenericBuildTask = (IBMIGenericBuildTask2)((Object)obj);
            bMIGenericBuildTask.setCurrentIterativeResource(currentIterativeResource);
            bMIGenericBuildTask.setAggregatedInputs(aggregateInputs);
            bMIGenericBuildTask.setDependencyInputs(dependencyInputs);
            if (!this.isEmptyOutput(this.outputObject)) {
                bMIGenericBuildTask.setOutputObject(this.outputObject);
            }
            bMIGenericBuildTask.setGlobalAndTargetVariables(variableSubstitutionMap);
            Variables localVariables = taskref.getVariables();
            if (localVariables != null) {
                bMIGenericBuildTask.setTaskLocalVariables(localVariables.iterator());
            }
            bMIGenericBuildTask.setInputResolver(resolver);
            bMIGenericBuildTask.setSystemref(this._systemref);
            bMIGenericBuildTask.perform();
        }
    }

    private void populateGlobalAntTargetVariables(HashMap<String, String> parametersMap) {
        String baseLiblValue = this.getProject().getProperty(BASELIBL_ANT_NAME);
        String fixLiblValue = this.getProject().getProperty(FIXLIBL_ANT_NAME);
        String spValue = "";
        if (fixLiblValue != null && fixLiblValue.trim().length() > 0) {
            if (baseLiblValue != null) {
                spValue = String.valueOf(spValue) + fixLiblValue + " " + baseLiblValue.trim();
            }
        } else if (baseLiblValue != null) {
            spValue = baseLiblValue.trim();
        }
        parametersMap.put(SEARCH_PATH_VARIABLE_NAME, spValue);
        String srcLibValue = this.getProject().getProperty(SRCLIB_ANT_NAME);
        String objLibValue = this.getProject().getProperty(OBJLIB_ANT_NAME);
        if (srcLibValue == null) {
            srcLibValue = "";
        }
        if (objLibValue == null) {
            objLibValue = "";
        }
        parametersMap.put(SRC_LIB_VARIABLE_NAME, srcLibValue);
        parametersMap.put(OBJ_LIB_VARIABLE_NAME, objLibValue);
        Iterator<IBMIVariable> gVIt = this.globalvariables.iterator();
        while (gVIt != null && gVIt.hasNext()) {
            IBMIVariable thisVariable = gVIt.next();
            String variableName = thisVariable.getName();
            if (variableName == null) continue;
            variableName = variableName.toUpperCase();
            String variableValue = thisVariable.getValue();
            String variableType = thisVariable.getType().trim();
            if (variableType == null || !variableType.equalsIgnoreCase("*STRING")) continue;
            parametersMap.put(variableName, variableValue);
        }
        Iterator<IBMIVariable> tVIt = this.targetvariables.iterator();
        while (tVIt != null && tVIt.hasNext()) {
            IBMIVariable thisVariable = tVIt.next();
            String variableName = thisVariable.getName();
            String variableValue = thisVariable.getValue();
            if (variableName == null) continue;
            variableName = variableName.toUpperCase();
            String variableType = thisVariable.getType().trim();
            if (variableType.equalsIgnoreCase("*STRING")) {
                String valueFoundInMap;
                if (variableValue != null && variableValue.startsWith("&") && (valueFoundInMap = parametersMap.get(variableValue.toUpperCase())) != null) {
                    variableValue = valueFoundInMap;
                }
                parametersMap.put(variableName, variableValue);
                continue;
            }
            if (!variableType.equalsIgnoreCase("*INPUT")) continue;
            String variableFormat = thisVariable.getFormat();
            variableValue = "&" + variableValue + "." + variableFormat;
            parametersMap.put(variableName, variableValue.toUpperCase());
        }
    }

    protected void resolveAggregateInputVariables(List<IBMIInput> aggregateInputs, IBMIInputResolver resolver, HashMap<String, String> inputTypeVariablesMap) {
        int i = 0;
        while (i < aggregateInputs.size()) {
            IBMIInput thisInput = aggregateInputs.get(i);
            String inputId = thisInput.getId();
            String variableKeyQualifiedName = "&" + inputId + ".*QUALIFIED_NAME";
            String concatenatedValueForQualifiedName = "";
            String variableKeyBaseName = "&" + inputId + ".*NAME";
            String concatenatedValueForBaseName = "";
            try {
                Set<Object> sourceResourceSet = resolver.getResolvedResource(thisInput);
                for (Object e : sourceResourceSet) {
                    if (e instanceof IISeriesHostMemberNameOnly) {
                        IISeriesHostMemberNameOnly currentMember = (IISeriesHostMemberNameOnly)e;
                        String memberName = currentMember.getName();
                        String memberFileName = currentMember.getFile();
                        String memberLibraryName = currentMember.getLibrary();
                        String memberQualifiedName = String.valueOf(memberLibraryName) + "/" + memberFileName + "(" + memberName + ")";
                        concatenatedValueForQualifiedName = concatenatedValueForQualifiedName.trim().length() <= 0 ? memberQualifiedName : String.valueOf(concatenatedValueForQualifiedName) + " " + memberQualifiedName;
                        if (concatenatedValueForBaseName.trim().length() <= 0) {
                            concatenatedValueForBaseName = memberName;
                            continue;
                        }
                        concatenatedValueForBaseName = String.valueOf(concatenatedValueForBaseName) + " " + memberName;
                        continue;
                    }
                    if (!(e instanceof IISeriesHostObjectBrief)) continue;
                    IISeriesHostObjectBrief currentObject = (IISeriesHostObjectBrief)e;
                    String objectName = currentObject.getName();
                    String objectLibraryName = currentObject.getLibrary();
                    String objectQualifiedName = "";
                    objectQualifiedName = IBMIBuildTaskUtils.isLibraryType(currentObject) ? objectName : String.valueOf(objectLibraryName) + "/" + objectName;
                    concatenatedValueForQualifiedName = concatenatedValueForQualifiedName.trim().length() <= 0 ? objectQualifiedName : String.valueOf(concatenatedValueForQualifiedName) + " " + objectQualifiedName;
                    concatenatedValueForBaseName = concatenatedValueForBaseName.trim().length() <= 0 ? objectName : String.valueOf(concatenatedValueForBaseName) + " " + objectName;
                }
                inputTypeVariablesMap.put(variableKeyQualifiedName.toUpperCase(), concatenatedValueForQualifiedName);
                inputTypeVariablesMap.put(variableKeyBaseName.toUpperCase(), concatenatedValueForBaseName);
            }
            catch (Exception e) {
                BuildException exception = new BuildException("property attribute is required.", this.getLocation());
                String string = exception.getLocation().toString();
                this.log("ERROR: error encountered when resolving aggregate input variables" + string, 0);
                throw exception;
            }
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void mergeVariables(HashMap<String, String> inputTypeVariablesMap, HashMap<String, String> variableSubstitutionMap) {
        keySet = variableSubstitutionMap.keySet();
        keyIterator = keySet.iterator();
        if (keyIterator != null) ** GOTO lbl12
        return;
lbl-1000:
        // 1 sources

        {
            paramName = keyIterator.next().toUpperCase();
            paramValue = variableSubstitutionMap.get(paramName);
            if (paramValue != null && inputTypeVariablesMap != null && (paramValue.startsWith("&") || paramValue.endsWith(".*QUALIFIED_NAME") || paramValue.endsWith(".*NAME")) && (mappedParamValue = inputTypeVariablesMap.get(paramValue)) != null) {
                paramValue = mappedParamValue;
            }
            if (paramName == null || paramValue == null) continue;
            variableSubstitutionMap.put(paramName, paramValue);
lbl12:
            // 3 sources

            ** while (keyIterator.hasNext())
        }
lbl13:
        // 1 sources

    }

    private boolean hasIterateInput() {
        return this.iterateInput != null;
    }

    protected void setBuildSpecTargetName(String buildSpecTargetName) {
        this.buildSpecTargetName = buildSpecTargetName;
    }

    protected String getBuildSpecTargetName() {
        return this.buildSpecTargetName;
    }

    protected void cleanUp() {
        this.iterateInput = null;
        if (this.aggregateInputs != null) {
            this.aggregateInputs.clear();
        }
        if (this.dependencyInputs != null) {
            this.dependencyInputs.clear();
        }
    }

    public class Inputs {
        public Vector<IBMIInput> iBMIInputs = new Vector();

        public IBMIInput createInput() {
            IBMIInput iBMIInput = new IBMIInput();
            this.iBMIInputs.add(iBMIInput);
            return iBMIInput;
        }

        public Iterator<IBMIInput> iterator() {
            return this.iBMIInputs.iterator();
        }
    }

    public class TaskRef {
        private String taskId;
        private Variables variables;

        public void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        public String getTaskId() {
            return this.taskId;
        }

        public Variables createVariables() {
            this.variables = new Variables();
            return this.variables;
        }

        public Variables getVariables() {
            return this.variables;
        }
    }

    public class TaskRefs {
        private final Vector<TaskRef> taskrefs = new Vector();

        public TaskRef createTaskRef() {
            TaskRef taskref = new TaskRef();
            this.taskrefs.add(taskref);
            return taskref;
        }

        public Iterator<TaskRef> iterator() {
            return this.taskrefs.iterator();
        }
    }
}

