/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iant.taskdefs.build;

import com.ibm.etools.iseries.comm.ISeriesListObjects;
import com.ibm.etools.iseries.comm.filters.ISeriesAbstractFilterString;
import com.ibm.etools.iseries.comm.filters.ISeriesObjectFilterString;
import com.ibm.etools.iseries.comm.interfaces.IISeriesHostMemberBrief;
import com.ibm.etools.iseries.comm.interfaces.IISeriesHostMemberNameOnly;
import com.ibm.etools.iseries.comm.interfaces.IISeriesHostObjectBasic;
import com.ibm.etools.iseries.comm.interfaces.IISeriesHostObjectBrief;
import com.ibm.iant.taskdefs.AbstractIBMiCommandTask;
import com.ibm.iant.taskdefs.build.IBMIBuildTaskUtils;
import com.ibm.iant.taskdefs.build.IBMIGenericBuildTask;
import com.ibm.iant.taskdefs.build.IBMIInputResolver;
import com.ibm.iant.taskdefs.build.IBMITagTask;
import com.ibm.iant.types.Objects;
import com.ibm.iant.types.Variables;
import com.ibm.iant.types.build.IBMIInput;
import com.ibm.iant.types.build.IBMIVariable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.apache.tools.ant.BuildException;

public class IBMIBuildTask
extends AbstractIBMiCommandTask {
    private Objects outputObject = null;
    private Inputs inputs;
    private TaskRefs taskrefs;
    private Variables globalvariables;
    private Variables targetvariables;
    public static final String SEARCH_PATH_VARIABLE_NAME = "&SP";
    public static final String SRC_LIB_VARIABLE_NAME = "&SRCLIB";
    public static final String OBJ_LIB_VARIABLE_NAME = "&OBJLIB";
    public static final String FIXLIBL_ANT_NAME = "ibuild.fixlibl";
    public static final String BASELIBL_ANT_NAME = "ibuild.baselibl";
    public static final String SRCLIB_ANT_NAME = "ibuild.sourceLibrary";
    public static final String OBJLIB_ANT_NAME = "ibuild.targetLibrary";
    private Iterator<IBMIInput> iBMIInputs;
    private IBMIInput iterateInput;
    private List<IBMIInput> aggregateInputs;
    private List<IBMIInput> dependencyInputs;
    private String buildSpecTargetName = "";

    public Inputs createInputs() {
        this.inputs = new Inputs();
        return this.inputs;
    }

    public Objects createOutput() {
        this.outputObject = new Objects();
        return this.outputObject;
    }

    public TaskRefs createTaskRefs() {
        this.taskrefs = new TaskRefs();
        return this.taskrefs;
    }

    public Variables createGlobalvariables() {
        this.globalvariables = new Variables();
        return this.globalvariables;
    }

    public Variables createVariables() {
        this.targetvariables = new Variables();
        return this.targetvariables;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void execute() throws BuildException {
        try {
            this.setBuildSpecTargetName(this.target.getName());
        }
        catch (Exception e) {
            this.setBuildSpecTargetName("UNKNOWN");
            this.log("Not able to retrieve build spec target name", 2);
        }
        if (this.taskrefs == null) {
            this.log("No command set is specified for the builder " + this.getBuildSpecTargetName(), 2);
            return;
        }
        HashMap<String, String> inputTypeVariableSubstitutionMap = new HashMap<String, String>();
        this.categorizeInputs();
        HashMap<String, String> variableSubstitutionMap = new HashMap<String, String>();
        if (this.globalvariables == null) {
            this.globalvariables = new Variables();
        }
        if (this.targetvariables == null) {
            this.targetvariables = new Variables();
        }
        this.populateGlobalAntTargetVariables(variableSubstitutionMap, this.globalvariables, this.targetvariables);
        IBMIInputResolver resolver = new IBMIInputResolver(this.getProject(), this._systemref);
        if (this.hasIterateInput()) {
            try {
                resolver.resolve(this.iterateInput, variableSubstitutionMap);
            }
            catch (Exception e) {
                String msg;
                BuildException exception;
                if (e instanceof BuildException) {
                    exception = (BuildException)((Object)e);
                    msg = e.getMessage();
                } else {
                    msg = e.getMessage();
                    exception = new BuildException(e.getMessage(), this.getLocation());
                }
                String location = exception.getLocation().toString();
                this.log(String.valueOf(msg) + location, 0);
                return;
            }
        }
        if (this.aggregateInputs != null) {
            for (IBMIInput input : this.aggregateInputs) {
                try {
                    resolver.resolve(input, variableSubstitutionMap);
                }
                catch (Exception e) {
                    String msg;
                    BuildException exception;
                    if (e instanceof BuildException) {
                        exception = (BuildException)((Object)e);
                        msg = e.getMessage();
                    } else {
                        msg = e.getMessage();
                        exception = new BuildException(e.getMessage(), this.getLocation());
                    }
                    String location = exception.getLocation().toString();
                    this.log(String.valueOf(msg) + location, 0);
                }
            }
            this.resolveAggregateInputVariables(this.aggregateInputs, resolver, inputTypeVariableSubstitutionMap);
            this.mergeVariables(inputTypeVariableSubstitutionMap, variableSubstitutionMap);
        }
        if (this.hasIterateInput()) {
            this.log("The following iterative inputs in this builder may be queried for auto dependencies:", 3);
            Set<Object> s = resolver.getResolvedResource(this.iterateInput);
            for (Object o : s) {
                this.log("    [" + o + "]", 3);
            }
        }
        if (!this.hasIterateInput()) {
            this.executeCommandSets(this.taskrefs, this.aggregateInputs, this.dependencyInputs, variableSubstitutionMap, inputTypeVariableSubstitutionMap, resolver);
            return;
        }
        Set<Object> iterativeSourceResourceSet = resolver.getResolvedResource(this.iterateInput);
        try {
            Iterator iter = iterativeSourceResourceSet.iterator();
            if (!iter.hasNext()) {
                this.log("Warning: No input members matching the filters were found. The command sets will not be run.", 1);
                return;
            }
            while (true) {
                if (!iter.hasNext()) {
                    return;
                }
                Object currentResource = iter.next();
                this.executeCommandSets(this.taskrefs, currentResource, this.aggregateInputs, this.dependencyInputs, variableSubstitutionMap, inputTypeVariableSubstitutionMap, resolver);
            }
        }
        catch (BuildException e) {
            throw e;
        }
        catch (Exception e) {
            this.log("ERROR:" + e.toString(), 0);
        }
    }

    private boolean isEmptyOutput(Objects output) {
        if (output == null) {
            return true;
        }
        return output.getLibrary().trim().length() == 0 || output.getName().trim().length() == 0;
    }

    /*
     * Unable to fully structure code
     */
    protected void categorizeInputs() {
        this.iBMIInputs = this.inputs == null ? null : this.inputs.iterator();
        if (this.iBMIInputs != null) ** GOTO lbl27
        this.log("No input is specified for the builder " + this.getBuildSpecTargetName(), 2);
        return;
lbl-1000:
        // 1 sources

        {
            currentInput = this.iBMIInputs.next();
            type = currentInput.getType().trim();
            if (type.equalsIgnoreCase("*ITERATE")) {
                if (this.iterateInput == null) {
                    this.iterateInput = currentInput;
                    this.log("Iterated input " + currentInput.getId() + " specified for the builder " + this.getBuildSpecTargetName(), 2);
                    continue;
                }
                this.log("ERROR: More than one iterate input specified for the builder " + this.getBuildSpecTargetName(), 0);
                throw new BuildException("More than one iterate input passed in.");
            }
            if (type.equalsIgnoreCase("*AGGREGATE")) {
                if (this.aggregateInputs == null) {
                    this.aggregateInputs = new Vector<IBMIInput>();
                }
                this.aggregateInputs.add(currentInput);
                this.log("Aggregated input " + currentInput.getId() + " specified for the builder " + this.getBuildSpecTargetName(), 2);
                continue;
            }
            if (!type.equalsIgnoreCase("*DEPENDENCY")) continue;
            if (this.dependencyInputs == null) {
                this.dependencyInputs = new Vector<IBMIInput>();
            }
            this.dependencyInputs.add(currentInput);
            this.log("Resource dependency input " + currentInput.getId() + " specified for the builder " + this.getBuildSpecTargetName(), 2);
lbl27:
            // 5 sources

            ** while (this.iBMIInputs.hasNext())
        }
lbl28:
        // 1 sources

    }

    protected void executeCommandSets(TaskRefs taskrefs, List<IBMIInput> aggregateInputs, List<IBMIInput> dependencyInputs, HashMap<String, String> variableSubstitutionMap, HashMap<String, String> inputTypeVariableSubstitutionMap, IBMIInputResolver resolver) {
        this.executeCommandSets(taskrefs, null, aggregateInputs, dependencyInputs, variableSubstitutionMap, inputTypeVariableSubstitutionMap, resolver);
    }

    protected void executeCommandSets(TaskRefs taskrefs, Object currentIterativeResource, List<IBMIInput> aggregateInputs, List<IBMIInput> dependencyInputs, HashMap<String, String> variableSubstitutionMap, HashMap<String, String> inputTypeVariableSubstitutionMap, IBMIInputResolver resolver) {
        if (taskrefs == null) {
            return;
        }
        Iterator<TaskRef> iter = taskrefs.iterator();
        boolean hasTaskRef = false;
        while (iter.hasNext()) {
            TaskRef taskref = iter.next();
            String taskId = taskref.getTaskId();
            if (taskId == null) {
                String msg = "Error: No command set was found. The refid parameter was not specified for the <taskref> element.";
                this.log(msg, 0);
                continue;
            }
            Object obj = this.getProject().getReference(taskId);
            if (obj == null) {
                String msg = "Error: No command set was found with an ID matching the refid attribute specified in the <taskref> element. refid attribute specified: " + taskId;
                this.log(msg, 0);
                continue;
            }
            hasTaskRef = true;
            if (!(obj instanceof IBMIGenericBuildTask)) continue;
            IBMIGenericBuildTask bMIGenericBuildTask = (IBMIGenericBuildTask)((Object)obj);
            bMIGenericBuildTask.setCurrentIterativeResource(currentIterativeResource);
            if (aggregateInputs == null) {
                aggregateInputs = new Vector<IBMIInput>();
            }
            bMIGenericBuildTask.setAggregatedInputs(aggregateInputs);
            if (dependencyInputs == null) {
                dependencyInputs = new Vector<IBMIInput>();
            }
            bMIGenericBuildTask.setDependencyInputs(dependencyInputs);
            if (!this.isEmptyOutput(this.outputObject)) {
                bMIGenericBuildTask.setOutputObject(this.outputObject);
            }
            Variables localVariables = taskref.getVariables();
            HashMap<String, String> finalResolvedVariables = this.resolveTaskLevelVariables(localVariables, variableSubstitutionMap, inputTypeVariableSubstitutionMap);
            bMIGenericBuildTask.setResolvedVariablesMap(finalResolvedVariables);
            bMIGenericBuildTask.setInputResolver(resolver);
            bMIGenericBuildTask.setSystemref(this._systemref);
            bMIGenericBuildTask.perform();
        }
        try {
            this.tagSourceAndEventFiles(resolver);
        }
        catch (Exception e) {
            this.log("Warning: Exception occurs when taging source file and EVFEVENT " + e.toString(), 1);
        }
    }

    protected void tagSourceAndEventFiles(IBMIInputResolver resolver) {
        String srcLib = this.getProject().getProperty(SRCLIB_ANT_NAME);
        Set<IISeriesHostObjectBasic> srcPFs = this.collectSourcePFs(resolver, srcLib);
        Iterator<IISeriesHostObjectBasic> iter = srcPFs.iterator();
        while (iter.hasNext()) {
            IBMITagTask.tagOneAlways(iter.next(), this, this.getAS400());
        }
        String objLib = this.getProject().getProperty(OBJLIB_ANT_NAME);
        IISeriesHostObjectBasic eventFile = this.resolveEventFile(objLib);
        if (eventFile != null) {
            IBMITagTask.tagOneAlways(eventFile, this, this.getAS400());
        }
    }

    private Set<IISeriesHostObjectBasic> collectSourcePFs(IBMIInputResolver resolver, String srcLib) {
        HashSet<String> srcFileNames = new HashSet<String>();
        Iterator<IBMIInput> iter = this.inputs.iterator();
        while (iter.hasNext()) {
            IBMIInput input = iter.next();
            Set<Object> resolvedResources = resolver.getResolvedResource(input);
            for (Object obj : resolvedResources) {
                String file;
                String lib;
                if (!(obj instanceof IISeriesHostMemberBrief) || !(lib = ((IISeriesHostMemberBrief)obj).getLibrary()).trim().equalsIgnoreCase(srcLib) || srcFileNames.contains(file = ((IISeriesHostMemberBrief)obj).getFile())) continue;
                srcFileNames.add(file);
            }
        }
        if (!srcFileNames.isEmpty()) {
            HashSet<IISeriesHostObjectBasic> srcFileObjects = new HashSet<IISeriesHostObjectBasic>(srcFileNames.size());
            ISeriesListObjects listObjects = new ISeriesListObjects(this.getAS400());
            Iterator iter3 = srcFileNames.iterator();
            block4: while (iter3.hasNext()) {
                ISeriesObjectFilterString filterString = new ISeriesObjectFilterString();
                filterString.setLibrary(srcLib);
                filterString.setObject((String)iter3.next());
                filterString.setObjectType("*FILE");
                try {
                    List srcFileObjs = listObjects.getList((ISeriesAbstractFilterString)filterString);
                    for (Object obj : srcFileObjs) {
                        if (!(obj instanceof IISeriesHostObjectBasic)) continue;
                        srcFileObjects.add((IISeriesHostObjectBasic)obj);
                        continue block4;
                    }
                }
                catch (Exception e) {
                    this.log("Warning: fail to retrieve source file object in " + srcLib + " for tagging: " + e.toString(), 1);
                }
            }
            return srcFileObjects;
        }
        return Collections.EMPTY_SET;
    }

    private IISeriesHostObjectBasic resolveEventFile(String objectLib) {
        ISeriesListObjects listObjects = new ISeriesListObjects(this.getAS400());
        ISeriesObjectFilterString filterString = new ISeriesObjectFilterString();
        filterString.setLibrary(objectLib);
        filterString.setObject("EVFEVENT");
        filterString.setObjectType("*FILE");
        try {
            List srcFileObjs = listObjects.getList((ISeriesAbstractFilterString)filterString);
            for (Object obj : srcFileObjs) {
                if (!(obj instanceof IISeriesHostObjectBasic)) continue;
                return (IISeriesHostObjectBasic)obj;
            }
        }
        catch (Exception e) {
            this.log("Warning: fail to retrieve " + objectLib + "/EVFEVENT for tagging: " + e.toString(), 1);
        }
        return null;
    }

    public void populateGlobalAntTargetVariables(HashMap<String, String> parametersMap, Variables globalVariables, Variables targetVariables) {
        String variableType;
        String variableValue;
        String variableName;
        IBMIVariable thisVariable;
        String baseLiblValue = this.getProject().getProperty(BASELIBL_ANT_NAME);
        String fixLiblValue = this.getProject().getProperty(FIXLIBL_ANT_NAME);
        String spValue = "";
        if (fixLiblValue != null && fixLiblValue.trim().length() > 0) {
            if (baseLiblValue != null) {
                spValue = String.valueOf(spValue) + fixLiblValue + " " + baseLiblValue.trim();
            }
        } else if (baseLiblValue != null) {
            spValue = baseLiblValue.trim();
        }
        parametersMap.put(SEARCH_PATH_VARIABLE_NAME, spValue);
        String srcLibValue = this.getProject().getProperty(SRCLIB_ANT_NAME);
        String objLibValue = this.getProject().getProperty(OBJLIB_ANT_NAME);
        if (srcLibValue == null) {
            srcLibValue = "";
        }
        if (objLibValue == null) {
            objLibValue = "";
        }
        parametersMap.put(SRC_LIB_VARIABLE_NAME, srcLibValue);
        parametersMap.put(OBJ_LIB_VARIABLE_NAME, objLibValue);
        if (globalVariables != null) {
            Iterator<IBMIVariable> gVIt = globalVariables.iterator();
            while (gVIt != null && gVIt.hasNext()) {
                thisVariable = gVIt.next();
                variableName = thisVariable.getName();
                if (variableName == null) continue;
                variableName = variableName.toUpperCase();
                variableValue = thisVariable.getValue();
                variableType = thisVariable.getType().trim();
                if (variableType == null || !variableType.equalsIgnoreCase("*STRING")) continue;
                parametersMap.put(variableName, variableValue);
            }
        }
        if (targetVariables != null) {
            Iterator<IBMIVariable> tVIt = targetVariables.iterator();
            while (tVIt != null && tVIt.hasNext()) {
                thisVariable = tVIt.next();
                variableName = thisVariable.getName();
                variableValue = thisVariable.getValue();
                if (variableName == null) continue;
                variableName = variableName.toUpperCase();
                variableType = thisVariable.getType().trim();
                if (variableType.equalsIgnoreCase("*STRING")) {
                    String valueFoundInMap;
                    if (variableValue != null && variableValue.startsWith("&") && (valueFoundInMap = parametersMap.get(variableValue.toUpperCase())) != null) {
                        variableValue = valueFoundInMap;
                    }
                    parametersMap.put(variableName, variableValue);
                    continue;
                }
                if (!variableType.equalsIgnoreCase("*INPUT")) continue;
                String variableFormat = thisVariable.getFormat();
                variableValue = "&" + variableValue + "." + variableFormat;
                parametersMap.put(variableName, variableValue.toUpperCase());
            }
        }
    }

    public void resolveAggregateInputVariables(List<IBMIInput> aggregateInputs, IBMIInputResolver resolver, HashMap<String, String> inputTypeVariablesMap) {
        int i = 0;
        while (i < aggregateInputs.size()) {
            IBMIInput thisInput = aggregateInputs.get(i);
            String inputId = thisInput.getId();
            String variableKeyQualifiedName = "&" + inputId + ".*QUALIFIED_NAME";
            String concatenatedValueForQualifiedName = "";
            String variableKeyBaseName = "&" + inputId + ".*NAME";
            String concatenatedValueForBaseName = "";
            try {
                Set<Object> sourceResourceSet = resolver.getResolvedResource(thisInput);
                for (Object e : sourceResourceSet) {
                    if (e instanceof IISeriesHostMemberNameOnly) {
                        IISeriesHostMemberNameOnly currentMember = (IISeriesHostMemberNameOnly)e;
                        String memberName = currentMember.getName();
                        String memberFileName = currentMember.getFile();
                        String memberLibraryName = currentMember.getLibrary();
                        String memberQualifiedName = String.valueOf(memberLibraryName) + "/" + memberFileName + "(" + memberName + ")";
                        concatenatedValueForQualifiedName = concatenatedValueForQualifiedName.trim().length() <= 0 ? memberQualifiedName : String.valueOf(concatenatedValueForQualifiedName) + " " + memberQualifiedName;
                        if (concatenatedValueForBaseName.trim().length() <= 0) {
                            concatenatedValueForBaseName = memberName;
                            continue;
                        }
                        concatenatedValueForBaseName = String.valueOf(concatenatedValueForBaseName) + " " + memberName;
                        continue;
                    }
                    if (!(e instanceof IISeriesHostObjectBrief)) continue;
                    IISeriesHostObjectBrief currentObject = (IISeriesHostObjectBrief)e;
                    String objectName = currentObject.getName();
                    String objectLibraryName = currentObject.getLibrary();
                    String objectQualifiedName = "";
                    objectQualifiedName = IBMIBuildTaskUtils.isLibraryType(currentObject) ? objectName : String.valueOf(objectLibraryName) + "/" + objectName;
                    concatenatedValueForQualifiedName = concatenatedValueForQualifiedName.trim().length() <= 0 ? objectQualifiedName : String.valueOf(concatenatedValueForQualifiedName) + " " + objectQualifiedName;
                    concatenatedValueForBaseName = concatenatedValueForBaseName.trim().length() <= 0 ? objectName : String.valueOf(concatenatedValueForBaseName) + " " + objectName;
                }
                inputTypeVariablesMap.put(variableKeyQualifiedName.toUpperCase(), concatenatedValueForQualifiedName);
                inputTypeVariablesMap.put(variableKeyBaseName.toUpperCase(), concatenatedValueForBaseName);
            }
            catch (Exception e) {
                BuildException exception = new BuildException("property attribute is required.", this.getLocation());
                String string = exception.getLocation().toString();
                this.log("ERROR: error encountered when resolving aggregate input variables" + string, 0);
                throw exception;
            }
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     */
    public void mergeVariables(HashMap<String, String> inputTypeVariablesMap, HashMap<String, String> variableSubstitutionMap) {
        keySet = variableSubstitutionMap.keySet();
        keyIterator = keySet.iterator();
        if (keyIterator != null) ** GOTO lbl12
        return;
lbl-1000:
        // 1 sources

        {
            paramName = keyIterator.next().toUpperCase();
            paramValue = variableSubstitutionMap.get(paramName);
            if (paramValue != null && inputTypeVariablesMap != null && (paramValue.startsWith("&") || paramValue.endsWith(".*QUALIFIED_NAME") || paramValue.endsWith(".*NAME")) && (mappedParamValue = inputTypeVariablesMap.get(paramValue)) != null) {
                paramValue = mappedParamValue;
            }
            if (paramName == null || paramValue == null) continue;
            variableSubstitutionMap.put(paramName, paramValue);
lbl12:
            // 3 sources

            ** while (keyIterator.hasNext())
        }
lbl13:
        // 1 sources

    }

    public HashMap<String, String> resolveTaskLevelVariables(Variables taskLevelVariables, HashMap<String, String> variableSubstitutionMap, HashMap<String, String> inputTypeVariableSubstitutionMap) {
        HashMap<String, String> finalVariables = new HashMap<String, String>();
        finalVariables.putAll(variableSubstitutionMap);
        if (taskLevelVariables == null) {
            return finalVariables;
        }
        Iterator<IBMIVariable> taskVariablesIterator = taskLevelVariables.iterator();
        while (taskVariablesIterator != null && taskVariablesIterator.hasNext()) {
            String resolvedInputVariableValue;
            IBMIVariable thisVariable = taskVariablesIterator.next();
            String variableName = thisVariable.getName();
            if (variableName == null) continue;
            variableName = variableName.toUpperCase();
            String variableValue = thisVariable.getValue();
            String variableType = thisVariable.getType().trim();
            if (variableType.equalsIgnoreCase("*STRING")) {
                String valueFoundInMap;
                if (variableValue != null && variableValue.startsWith("&") && (valueFoundInMap = variableSubstitutionMap.get(variableValue.toUpperCase())) != null) {
                    variableValue = valueFoundInMap;
                }
                finalVariables.put(variableName, variableValue);
                continue;
            }
            if (!variableType.equalsIgnoreCase("*INPUT")) continue;
            String variableFormat = thisVariable.getFormat();
            if (!(variableValue = "&" + variableValue + "." + variableFormat).endsWith(".*QUALIFIED_NAME") && !variableValue.endsWith(".*NAME") || (resolvedInputVariableValue = inputTypeVariableSubstitutionMap.get(variableValue.toUpperCase())) == null) continue;
            finalVariables.put(variableName, resolvedInputVariableValue);
        }
        return finalVariables;
    }

    private boolean hasIterateInput() {
        return this.iterateInput != null;
    }

    protected void setBuildSpecTargetName(String buildSpecTargetName) {
        this.buildSpecTargetName = buildSpecTargetName;
    }

    protected String getBuildSpecTargetName() {
        return this.buildSpecTargetName;
    }

    protected void cleanUp() {
        this.iterateInput = null;
        if (this.aggregateInputs != null) {
            this.aggregateInputs.clear();
        }
        if (this.dependencyInputs != null) {
            this.dependencyInputs.clear();
        }
    }

    public class Inputs {
        public Vector<IBMIInput> iBMIInputs = new Vector();

        public IBMIInput createInput() {
            IBMIInput iBMIInput = new IBMIInput();
            this.iBMIInputs.add(iBMIInput);
            return iBMIInput;
        }

        public Iterator<IBMIInput> iterator() {
            return this.iBMIInputs.iterator();
        }
    }

    public class TaskRef {
        private String taskId;
        private Variables variables;

        public void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        public String getTaskId() {
            return this.taskId;
        }

        public Variables createVariables() {
            this.variables = new Variables();
            return this.variables;
        }

        public Variables getVariables() {
            return this.variables;
        }
    }

    public class TaskRefs {
        private final Vector<TaskRef> taskrefs = new Vector();

        public TaskRef createTaskRef() {
            TaskRef taskref = new TaskRef();
            this.taskrefs.add(taskref);
            return taskref;
        }

        public Iterator<TaskRef> iterator() {
            return this.taskrefs.iterator();
        }
    }
}

