/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iant.taskdefs.build;

import com.ibm.etools.iseries.comm.ISeriesListLibraries;
import com.ibm.etools.iseries.comm.filters.ISeriesAbstractFilterString;
import com.ibm.etools.iseries.comm.interfaces.IISeriesHostListBaseFactory;
import com.ibm.etools.iseries.comm.interfaces.IISeriesHostObjectBrief;
import com.ibm.etools.iseries.comm.interfaces.ISeriesHostListObjectBriefFactory;
import com.ibm.iant.taskdefs.AbstractIBMiCommandTask;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.BuildException;

public class IBMIBuildSetupTask
extends AbstractIBMiCommandTask {
    private static final String CHGCURLIB_COMMAND_FIRSTPART = "CHGCURLIB CURLIB(";
    private static final String COMMAND_SECONDPART = ")";
    private static final String PREBUILD_USR_LIBRARY_LIST_PROPERTY = "preBuildUsrLibraryList";
    private static final String PREBUILD_CURRENT_LIBRARY_PROPERTY = "preBuildCurLib";
    private static final String ADDLIBLE_COMMAND_FIRSTPART = "ADDLIBLE LIB(";
    private static final String ADDLIBLE_COMMAND_SECONDPART = ") POSITION(*FIRST)";
    private static final String RMVLIBLE_COMMAND_FIRSTPART = "RMVLIBLE LIB(";
    private static final String RMVLIBLE_COMMAND_SECONDPART = ")";
    private String curlib = null;

    @Override
    public void execute() throws BuildException {
        this.log("Setting up build for Project " + this.getProject().getProperty("projectName"), 2);
        String devBuild = this.getProject().getProperty("com.ibm.iant.devBuild");
        if (devBuild != null) {
            String devliblString = this.getProject().getProperty("com.ibm.iant.liblist");
            String[] devlibl = devliblString.split(" ");
            int i = devlibl.length - 1;
            while (i >= 0) {
                String commandString = ADDLIBLE_COMMAND_FIRSTPART + devlibl[i] + ADDLIBLE_COMMAND_SECONDPART;
                this.runCommandWithNoFailure(commandString);
                --i;
            }
        }
        String preBuildUsrLibraryList = this.getUserLibraryList();
        String preBuildCurLib = this.getCurLib();
        this.getProject().setNewProperty(PREBUILD_USR_LIBRARY_LIST_PROPERTY, preBuildUsrLibraryList);
        this.log("*LIBL instance in preBuild stage= " + this.getLibraryList(), 4);
        this.log("*USRLIBL instance in preBuild stage= " + preBuildUsrLibraryList, 4);
        this.getProject().setNewProperty(PREBUILD_CURRENT_LIBRARY_PROPERTY, preBuildCurLib);
        this.log("*CURLIB instance in preBuild stage= " + preBuildCurLib, 4);
        String fixLibl = this.getProject().getProperty("ibuild.fixlibl");
        this.log("Fix Pack Libraries = " + fixLibl, 2);
        String baseLibl = this.getProject().getProperty("ibuild.baselibl");
        this.log("Referenced Libraries = " + baseLibl, 2);
        String appLibl = fixLibl.concat(" " + baseLibl);
        this.log("Search Path (SP) = Fix Pack Libraries + Referenced Libraries = " + appLibl, 2);
        String[] appLibraries = appLibl.split(" ");
        int i = appLibraries.length - 1;
        while (i >= 0) {
            String[] preBuildLibraryListLibraries = preBuildUsrLibraryList.split(" ");
            int j = 0;
            while (j < preBuildLibraryListLibraries.length) {
                if (preBuildLibraryListLibraries[j].equalsIgnoreCase(appLibraries[i])) {
                    String commandString = RMVLIBLE_COMMAND_FIRSTPART + preBuildLibraryListLibraries[j] + ")";
                    this.runCommandWithNoFailure(commandString);
                }
                ++j;
            }
            String commandString = ADDLIBLE_COMMAND_FIRSTPART + appLibraries[i] + ADDLIBLE_COMMAND_SECONDPART;
            this.runCommandWithNoFailure(commandString);
            --i;
        }
        this.log("*LIBL has now been set to : " + this.getLibraryList(), 2);
        if (this.curlib != null) {
            String commandString = CHGCURLIB_COMMAND_FIRSTPART + this.curlib + ")";
            this.runCommand(commandString);
        }
        this.log("CURLIB has now been set to : " + this.getCurLib(), 2);
    }

    private String getLibraryList() {
        ISeriesAbstractFilterString filter = ISeriesAbstractFilterString.createFilterStringObject((String)"*LIBL");
        ISeriesListLibraries api = new ISeriesListLibraries(this.getAS400());
        List results = new ArrayList();
        String LibraryList = "";
        try {
            api.setInfoLevel(1);
            results = api.getList(filter, (IISeriesHostListBaseFactory)new ISeriesHostListObjectBriefFactory());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        int i = 0;
        while (i < results.size()) {
            LibraryList = LibraryList.concat(String.valueOf(((IISeriesHostObjectBrief)results.get(i)).getName()) + " ");
            ++i;
        }
        return LibraryList;
    }

    private String getUserLibraryList() {
        ISeriesAbstractFilterString filter = ISeriesAbstractFilterString.createFilterStringObject((String)"*USRLIBL");
        ISeriesListLibraries api = new ISeriesListLibraries(this.getAS400());
        List results = new ArrayList();
        String LibraryList = "";
        try {
            api.setInfoLevel(1);
            results = api.getList(filter, (IISeriesHostListBaseFactory)new ISeriesHostListObjectBriefFactory());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        int i = 0;
        while (i < results.size()) {
            LibraryList = LibraryList.concat(String.valueOf(((IISeriesHostObjectBrief)results.get(i)).getName()) + " ");
            ++i;
        }
        return LibraryList;
    }

    private String getCurLib() {
        ISeriesAbstractFilterString filter = ISeriesAbstractFilterString.createFilterStringObject((String)"*CURLIB");
        ISeriesListLibraries api = new ISeriesListLibraries(this.getAS400());
        String preBuildCurLib = "";
        try {
            api.setInfoLevel(1);
            List results = api.getList(filter, (IISeriesHostListBaseFactory)new ISeriesHostListObjectBriefFactory());
            if (results.size() == 1) {
                preBuildCurLib = ((IISeriesHostObjectBrief)results.get(0)).getName();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return preBuildCurLib;
    }

    public void setCurlib(String curlib) {
        this.curlib = curlib;
        this.log("curlib --> " + curlib, 4);
    }
}

