/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iant.taskdefs.build;

import com.ibm.etools.iseries.comm.ISeriesListLibraries;
import com.ibm.etools.iseries.comm.filters.ISeriesAbstractFilterString;
import com.ibm.etools.iseries.comm.interfaces.IISeriesHostListBaseFactory;
import com.ibm.etools.iseries.comm.interfaces.IISeriesHostObjectBrief;
import com.ibm.etools.iseries.comm.interfaces.ISeriesHostListObjectBriefFactory;
import com.ibm.iant.taskdefs.AbstractIBMiCommandTask;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.BuildException;

public class IBMIBuildCompleteTask
extends AbstractIBMiCommandTask {
    private static final String CHGCURLIB_COMMAND_FIRSTPART = "CHGCURLIB CURLIB(";
    private static final String COMMAND_SECONDPART = ")";
    private static final String PREBUILD_USR_LIBRARY_LIST_PROPERTY = "preBuildUsrLibraryList";
    private static final String PREBUILD_CURRENT_LIBRARY_PROPERTY = "preBuildCurLib";
    private static final String ADDLIBLE_COMMAND_FIRSTPART = "ADDLIBLE LIB(";
    private static final String ADDLIBLE_COMMAND_SECONDPART = ") POSITION(*FIRST)";
    private static final String RMVLIBLE_COMMAND_FIRSTPART = "RMVLIBLE LIB(";
    private static final String RMVLIBLE_COMMAND_SECONDPART = ")";

    @Override
    public void execute() throws BuildException {
        String preTearDownLibraryList = this.getLibraryList();
        this.log("*LIBL instance in preTearDown stage= " + preTearDownLibraryList, 4);
        try {
            String commandString;
            String preTearDownUserLibraryList = this.getUserLibraryList();
            String[] preTearDownUserLibraryListEntries = preTearDownUserLibraryList.split(" ");
            int i = 0;
            while (i < preTearDownUserLibraryListEntries.length) {
                if (!preTearDownUserLibraryListEntries[i].equalsIgnoreCase("QGPL") && !preTearDownUserLibraryListEntries[i].equalsIgnoreCase("QTEMP")) {
                    String commandString2 = RMVLIBLE_COMMAND_FIRSTPART + preTearDownUserLibraryListEntries[i] + ")";
                    this.runCommandWithNoFailure(commandString2);
                }
                ++i;
            }
            String[] preBuildLibraryListEntries = this.getProject().getProperty(PREBUILD_USR_LIBRARY_LIST_PROPERTY).split(" ");
            int i2 = preBuildLibraryListEntries.length - 1;
            while (i2 >= 0) {
                if (!preBuildLibraryListEntries[i2].equalsIgnoreCase("QGPL") && !preBuildLibraryListEntries[i2].equalsIgnoreCase("QTEMP")) {
                    commandString = ADDLIBLE_COMMAND_FIRSTPART + preBuildLibraryListEntries[i2] + ADDLIBLE_COMMAND_SECONDPART;
                    this.runCommandWithNoFailure(commandString);
                }
                --i2;
            }
            this.log("*CURLIB before TearDown  : " + this.getCurLib(), 4);
            String preBuildCurLib = this.getProject().getProperty(PREBUILD_CURRENT_LIBRARY_PROPERTY);
            commandString = CHGCURLIB_COMMAND_FIRSTPART + preBuildCurLib + ")";
            this.runCommand(commandString);
            this.log("*CURLIB after TearDown  : " + preBuildCurLib, 2);
            this.log("*LIBL has now been set to after TearDown  : " + this.getLibraryList(), 2);
        }
        catch (Exception e) {
            this.log(e, 0);
        }
    }

    private String getLibraryList() {
        ISeriesAbstractFilterString filter = ISeriesAbstractFilterString.createFilterStringObject((String)"*LIBL");
        ISeriesListLibraries api = new ISeriesListLibraries(this.getAS400());
        List results = new ArrayList();
        String LibraryList = "";
        try {
            api.setInfoLevel(1);
            results = api.getList(filter, (IISeriesHostListBaseFactory)new ISeriesHostListObjectBriefFactory());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.log(e, 0);
        }
        int i = 0;
        while (i < results.size()) {
            LibraryList = LibraryList.concat(String.valueOf(((IISeriesHostObjectBrief)results.get(i)).getName()) + " ");
            ++i;
        }
        return LibraryList;
    }

    private String getUserLibraryList() {
        ISeriesAbstractFilterString filter = ISeriesAbstractFilterString.createFilterStringObject((String)"*USRLIBL");
        ISeriesListLibraries api = new ISeriesListLibraries(this.getAS400());
        List results = new ArrayList();
        String LibraryList = "";
        try {
            api.setInfoLevel(1);
            results = api.getList(filter, (IISeriesHostListBaseFactory)new ISeriesHostListObjectBriefFactory());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.log(e, 0);
        }
        int i = 0;
        while (i < results.size()) {
            LibraryList = LibraryList.concat(String.valueOf(((IISeriesHostObjectBrief)results.get(i)).getName()) + " ");
            ++i;
        }
        return LibraryList;
    }

    private String getCurLib() {
        ISeriesAbstractFilterString filter = ISeriesAbstractFilterString.createFilterStringObject((String)"*CURLIB");
        ISeriesListLibraries api = new ISeriesListLibraries(this.getAS400());
        String preBuildCurLib = "";
        try {
            api.setInfoLevel(1);
            List results = api.getList(filter, (IISeriesHostListBaseFactory)new ISeriesHostListObjectBriefFactory());
            if (results.size() == 1) {
                preBuildCurLib = ((IISeriesHostObjectBrief)results.get(0)).getName();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.log(e, 0);
        }
        return preBuildCurLib;
    }
}

