/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iant.taskdefs;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.IFSFile;
import com.ibm.as400.access.IFSFileInputStream;
import com.ibm.as400.access.IFSFileOutputStream;
import com.ibm.iant.taskdefs.AbstractIBMiCommandTask;
import com.ibm.iant.taskdefs.IAntTaskUtils;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.tools.ant.BuildException;

public class ZipPDFSpoolTask
extends AbstractIBMiCommandTask {
    private String property;
    private boolean deletespooldir = false;

    public void setProperty(String property) {
        this.property = property;
        IAntTaskUtils.logParam(this.getProject(), "property --> " + property);
    }

    public void setDeletespooldir(String flag) {
        this.deletespooldir = flag.equalsIgnoreCase("true");
        IAntTaskUtils.logParam(this.getProject(), "deletespooldir --> " + flag);
    }

    @Override
    public void execute() throws BuildException {
        if (this.property == null) {
            BuildException noProperty = new BuildException("property attribute is required.", this.getLocation());
            String location = noProperty.getLocation().toString();
            this.log("property attribute is required." + location, 0);
            throw noProperty;
        }
        String value = this.getProject().getProperty(this.property);
        if (value == null || value.trim().length() == 0) {
            BuildException propertyValueNotSet = new BuildException("property value is not set.", this.getLocation());
            String location = propertyValueNotSet.getLocation().toString();
            this.log("property value is not set." + location, 0);
            throw propertyValueNotSet;
        }
        AS400 as400 = this.getAS400();
        IFSFile spoolFileDir = new IFSFile(as400, value);
        try {
            if (!spoolFileDir.exists() || !spoolFileDir.isDirectory()) {
                BuildException noSpoolFileDir = new BuildException("the specified spool file directory does not exist", this.getLocation());
                String location = noSpoolFileDir.getLocation().toString();
                this.log("the specified spool file directory does not exist" + location, 0);
                throw noSpoolFileDir;
            }
            String zipFileName = String.valueOf(spoolFileDir.getName()) + ".zip";
            String parentDirPath = spoolFileDir.getParent();
            String zipFileFullName = String.valueOf(parentDirPath) + "/" + zipFileName;
            IFSFile zipFile = new IFSFile(as400, zipFileFullName);
            IFSFile[] directoryFiles = spoolFileDir.listFiles();
            ZipOutputStream out = new ZipOutputStream((OutputStream)new IFSFileOutputStream(zipFile));
            byte[] buf = new byte[1024];
            int i = 0;
            while (i < directoryFiles.length) {
                int len;
                IFSFileInputStream in = new IFSFileInputStream(directoryFiles[i]);
                out.putNextEntry(new ZipEntry(directoryFiles[i].getName()));
                while ((len = in.read(buf)) > 0) {
                    out.write(buf, 0, len);
                }
                out.closeEntry();
                in.close();
                ++i;
            }
            out.close();
            if (this.deletespooldir) {
                this.deleteDir(spoolFileDir);
            }
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            String stackTrace = sw.toString();
            this.log(stackTrace, 0);
            e.printStackTrace();
        }
    }

    private boolean deleteDir(IFSFile fileObj) throws Exception {
        boolean result = true;
        try {
            IFSFile[] list = fileObj.listFiles();
            int i = 0;
            while (i < list.length && result) {
                if (list[i].isFile()) {
                    result = list[i].delete();
                } else {
                    result = this.deleteDir(list[i]);
                    if (!result) break;
                }
                ++i;
            }
            fileObj.delete();
        }
        catch (Exception e) {
            this.log(e, 0);
            throw e;
        }
        return result;
    }
}

