/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iant.taskdefs;

import com.ibm.iant.taskdefs.AbstractIBMiCommandTask;
import com.ibm.iant.taskdefs.IAntTaskUtils;
import org.apache.tools.ant.BuildException;

public class SAVLIBTask
extends AbstractIBMiCommandTask {
    private static final String CMD_NAME = "SAVLIB ";
    private static final String DEFAULT_DEVICE = "*SAVF";
    private String _savflib;
    private String _savfname;
    private String _libParm = "";
    private String _devParm = "";
    private String _savfParm = "";
    private String _targetreleaseParm = "";
    private String _otheroptionParms = "";
    private boolean _overwriteSavefile = true;

    @Override
    public void execute() throws BuildException {
        if (this._savflib == null) {
            this.log("The required 'savefilelibrary' parameter was not provided.", 0);
            throw new BuildException("The required 'savefilelibrary' parameter was not provided.");
        }
        if (this._savfname == null) {
            this.log("The required 'savefilename' parameter was not provided.", 0);
            throw new BuildException("The required 'savefilename' parameter was not provided.");
        }
        if (this._libParm.equals("")) {
            this.log("The required 'library' parameter was not provided.", 0);
            throw new BuildException("The required 'library' parameter was not provided.");
        }
        String clearParm = "";
        this._devParm = "DEV(*SAVF) ";
        this._savfParm = "SAVF(" + this._savflib + "/" + this._savfname + ") ";
        boolean savfExists = IAntTaskUtils.doesObjectExist(this.getAS400(), this._savflib, this._savfname, "*FILE", "SAVF");
        if (savfExists) {
            if (!this._overwriteSavefile) {
                this.log("SAVLIB command was not run because parameter overwritesavefile was set to false and the savefile " + this._savflib + "/" + this._savfname + " exists on the host.", 0);
                return;
            }
            clearParm = "CLEAR(*ALL) ";
        } else {
            IAntTaskUtils.runCommand("CRTSAVF FILE(" + this._savflib + "/" + this._savfname + ") ", this.getAS400(), this.getProject());
            if (!IAntTaskUtils.doesObjectExist(this.getAS400(), this._savflib, this._savfname, "*FILE", "SAVF")) {
                this.log("SAVLIB command was not run because savefile " + this._savflib + "/" + this._savfname + " could not be created on the host.", 0);
                return;
            }
        }
        String compileString = CMD_NAME + this._libParm + this._devParm + this._savfParm + clearParm + this._targetreleaseParm + this._otheroptionParms;
        this.runCommand(compileString);
    }

    public void setLibrary(String library) {
        this._libParm = "LIB(" + library + ") ";
        IAntTaskUtils.logParam(this.getProject(), "library --> " + library);
    }

    public void setSavefilelibrary(String savflib) {
        this._savflib = savflib;
        IAntTaskUtils.logParam(this.getProject(), "savefilelibrary --> " + savflib);
    }

    public void setSavefilename(String savfname) {
        this._savfname = savfname;
        IAntTaskUtils.logParam(this.getProject(), "savefilename --> " + savfname);
    }

    public void setTargetrelease(String targetrelease) {
        this._targetreleaseParm = "TGTRLS(" + targetrelease + ") ";
        IAntTaskUtils.logParam(this.getProject(), "targetrelease --> " + targetrelease);
    }

    public void setOtheroptions(String otheroptions) {
        this._otheroptionParms = otheroptions;
        IAntTaskUtils.logParam(this.getProject(), "otheroptions --> " + otheroptions);
    }

    public void setOverwritesavefile(String overwriteSavefile) {
        this._overwriteSavefile = !overwriteSavefile.equalsIgnoreCase("no") && !overwriteSavefile.equalsIgnoreCase("false");
        IAntTaskUtils.logParam(this.getProject(), "overwritesavefile --> " + overwriteSavefile);
    }
}

