/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iant.taskdefs;

import com.ibm.iant.taskdefs.AbstractIBMiCommandTask;
import com.ibm.iant.taskdefs.IAntTaskUtils;
import org.apache.tools.ant.BuildException;

public class RSTLIBTask
extends AbstractIBMiCommandTask {
    private static final String CMD_NAME = "RSTLIB ";
    private static final String DEFAULT_DEVICE = "*SAVF";
    private String _savflib;
    private String _savfname;
    private String _savlibParm = "";
    private String _devParm = "";
    private String _savfParm = "";
    private String _rstlibParm = "";
    private String _otheroptionParms = "";

    @Override
    public void execute() throws BuildException {
        if (this._savflib == null) {
            this.log("The required 'savefilelibrary' parameter was not provided.", 0);
            throw new BuildException("The required 'savefilelibrary' parameter was not provided.");
        }
        if (this._savfname == null) {
            this.log("The required 'savefilename' parameter was not provided.", 0);
            throw new BuildException("The required 'savefilename' parameter was not provided.");
        }
        if (this._savlibParm.equals("")) {
            this.log("The required 'library' parameter was not provided.", 0);
            throw new BuildException("The required 'library' parameter was not provided.");
        }
        this._devParm = "DEV(*SAVF) ";
        this._savfParm = "SAVF(" + this._savflib + "/" + this._savfname + ") ";
        boolean savfExists = IAntTaskUtils.doesObjectExist(this.getAS400(), this._savflib, this._savfname, "*FILE", "SAVF");
        if (!savfExists) {
            this.log("RSTLIB command was not run because savefile " + this._savflib + "/" + this._savfname + " could not be found on the host.", 0);
            return;
        }
        String compileString = CMD_NAME + this._savlibParm + this._devParm + this._savfParm + this._rstlibParm + this._otheroptionParms;
        this.runCommand(compileString);
    }

    public void setSavedlibrary(String savlib) {
        this._savlibParm = "SAVLIB(" + savlib + ") ";
        IAntTaskUtils.logParam(this.getProject(), "savedlibrary --> " + savlib);
    }

    public void setSavefilelibrary(String savflib) {
        this._savflib = savflib;
        IAntTaskUtils.logParam(this.getProject(), "savefilelibrary --> " + savflib);
    }

    public void setSavefilename(String savfname) {
        this._savfname = savfname;
        IAntTaskUtils.logParam(this.getProject(), "savefilename --> " + savfname);
    }

    public void setRestoretolibrary(String rstlib) {
        this._rstlibParm = "RSTLIB(" + rstlib + ") ";
        IAntTaskUtils.logParam(this.getProject(), "restoretolibrary --> " + rstlib);
    }

    public void setOtheroptions(String otheroptions) {
        this._otheroptionParms = otheroptions;
        IAntTaskUtils.logParam(this.getProject(), "otheroptions --> " + otheroptions);
    }
}

