/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iant.taskdefs;

import com.ibm.etools.iseries.comm.interfaces.ISeriesHostObjectBrief;
import com.ibm.iant.taskdefs.AbstractIBMiCommandTask;
import com.ibm.iant.taskdefs.IAntTaskUtils;
import com.ibm.iant.types.IObjectSet;
import com.ibm.iant.types.IResourceCollection;
import java.util.Iterator;
import org.apache.tools.ant.BuildException;

public class MOVOBJTask
extends AbstractIBMiCommandTask {
    private static final String DEFAULT_FROM_LIB = "*LIBL";
    private static final String MOVOBJ_CMD = "MOVOBJ ";
    private String lib = "*LIBL";
    private String obj = null;
    private String objtype = null;
    private String tolib = null;
    private String otheroptions = "";
    private String _objParm = "";
    private String _objTypeParm = "";
    private String _toLibParm = "";

    @Override
    public void execute() throws BuildException {
        IResourceCollection resourceCollection = this.getResourceCollection();
        if (resourceCollection == null) {
            if (this.obj == null || this.obj.trim().length() == 0) {
                this.log("No object name provided.", 0);
                throw new BuildException("No object name provided.");
            }
            if (this.objtype == null || this.objtype.trim().length() == 0) {
                this.log("No object type provided.", 0);
                throw new BuildException("No object type provided.");
            }
            if (this.tolib == null || this.tolib.trim().length() == 0) {
                this.log("No destination library provided.", 0);
                throw new BuildException("No destination library provided.");
            }
            this._objParm = "OBJ(" + this.lib + "/" + this.obj + ") ";
            this._objTypeParm = "OBJTYPE(" + this.objtype + ") ";
            this._toLibParm = "TOLIB(" + this.tolib + ") ";
            String copyCommandString = MOVOBJ_CMD + this._objParm + this._objTypeParm + this._toLibParm + this.otheroptions;
            this.runCommand(copyCommandString);
        } else {
            if (this.tolib == null || this.tolib.trim().length() == 0) {
                this.log("Did not specify TOLIB parameter", 0);
                throw new BuildException("Did not specify TOLIB parameter");
            }
            try {
                Iterator iter = resourceCollection.iterator();
                while (iter.hasNext()) {
                    Object curRes = iter.next();
                    if (!(curRes instanceof ISeriesHostObjectBrief)) {
                        this.log("Unexpected resource type in resource set.", 0);
                        throw new BuildException("Unexpected resource type in resource set.");
                    }
                    ISeriesHostObjectBrief curObject = (ISeriesHostObjectBrief)curRes;
                    this._objParm = "OBJ(" + curObject.getLibrary() + "/" + curObject.getName() + ") ";
                    this._objTypeParm = "OBJTYPE(" + curObject.getType() + ") ";
                    this._toLibParm = "TOLIB(" + this.tolib + ") ";
                    String copyCommandString = MOVOBJ_CMD + this._objParm + this._objTypeParm + this._toLibParm + this.otheroptions;
                    this.runCommand(copyCommandString);
                }
            }
            catch (Exception e) {
                this.log(e, 0);
                throw new BuildException((Throwable)e);
            }
        }
    }

    public void setLibrary(String lib) {
        this.lib = lib;
        IAntTaskUtils.logParam(this.getProject(), "library --> " + lib);
    }

    public void setObject(String obj) {
        this.obj = obj;
        IAntTaskUtils.logParam(this.getProject(), "object --> " + obj);
    }

    public void setObjecttype(String objType) {
        this.objtype = objType;
        IAntTaskUtils.logParam(this.getProject(), "objecttype --> " + objType);
    }

    public void setTolibrary(String toLib) {
        this.tolib = toLib;
        IAntTaskUtils.logParam(this.getProject(), "tolibrary --> " + toLib);
    }

    public void setOtheroptions(String option) {
        this.otheroptions = option;
        IAntTaskUtils.logParam(this.getProject(), "otheroptions --> " + option);
    }

    public IObjectSet createIObjectSet() {
        return (IObjectSet)super.createIResourceCollection(new IObjectSet());
    }
}

