/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iant.taskdefs;

import com.ibm.etools.iseries.comm.interfaces.ISeriesHostMemberBasic;
import com.ibm.etools.iseries.comm.interfaces.ISeriesHostObjectBasic;
import com.ibm.iant.types.AbstractIResourceSet;
import com.ibm.iant.types.ILibrarySet;
import com.ibm.iant.types.IMemberSet;
import com.ibm.iant.types.IObjectSet;
import java.util.Iterator;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.CallTarget;
import org.apache.tools.ant.taskdefs.Property;

public class IterateTask
extends Task {
    public static final String SOURCE_MEMBER_NAME = "source-member.name";
    public static final String SOURCE_MEMBER_FILE_NAME = "source-member.file-name";
    public static final String SOURCE_MEMBER_LIBRARY_NAME = "source-member.library-name";
    public static final String SOURCE_MEMBER_TYPE = "source-member.type";
    public static final String SOURCE_MEMBER_FULL_NAME = "source-member.fullname";
    public static final String OBJECT_NAME = "object.name";
    public static final String OBJECT_LIBRARY_NAME = "object.library-name";
    public static final String OBJECT_TYPE = "object.type";
    public static final String OBJECT_SUBTYPE = "object.subtype";
    public static final String OBJECT_FULL_NAME = "object.fullname";
    public static final String LIBRARY_NAME = "library.name";
    public static final String LIBRARY_FULL_NAME = "library.fullname";
    private AbstractIResourceSet resourceSet;
    private CallTarget callTarget;

    public IMemberSet createIMemberSet() {
        this.resourceSet = new IMemberSet();
        return (IMemberSet)this.resourceSet;
    }

    public IObjectSet createIObjectSet() {
        this.resourceSet = new IObjectSet();
        return (IObjectSet)this.resourceSet;
    }

    public ILibrarySet createILibrarySet() {
        this.resourceSet = new ILibrarySet();
        return (ILibrarySet)this.resourceSet;
    }

    public CallTarget createAntCall() {
        this.callTarget = new CallTarget();
        return this.callTarget;
    }

    public void execute() throws BuildException {
        try {
            Iterator iterator = this.resourceSet.iterator();
            while (iterator.hasNext()) {
                Property fullnameProperty;
                Property typeProperty;
                Property libraryProperty;
                Property nameProperty;
                ISeriesHostMemberBasic item;
                this.callTarget.init();
                if (this.resourceSet instanceof IMemberSet) {
                    item = (ISeriesHostMemberBasic)iterator.next();
                    nameProperty = this.callTarget.createParam();
                    nameProperty.setName(SOURCE_MEMBER_NAME);
                    nameProperty.setValue(item.getName());
                    Property fileProperty = this.callTarget.createParam();
                    fileProperty.setName(SOURCE_MEMBER_FILE_NAME);
                    fileProperty.setValue(item.getFile());
                    libraryProperty = this.callTarget.createParam();
                    libraryProperty.setName(SOURCE_MEMBER_LIBRARY_NAME);
                    libraryProperty.setValue(item.getLibrary());
                    typeProperty = this.callTarget.createParam();
                    typeProperty.setName(SOURCE_MEMBER_TYPE);
                    typeProperty.setValue(item.getType());
                    fullnameProperty = this.callTarget.createParam();
                    fullnameProperty.setName(SOURCE_MEMBER_FULL_NAME);
                    fullnameProperty.setValue(item.getFullName());
                } else if (this.resourceSet instanceof IObjectSet) {
                    item = (ISeriesHostObjectBasic)iterator.next();
                    nameProperty = this.callTarget.createParam();
                    nameProperty.setName(OBJECT_NAME);
                    nameProperty.setValue(item.getName());
                    libraryProperty = this.callTarget.createParam();
                    libraryProperty.setName(OBJECT_LIBRARY_NAME);
                    libraryProperty.setValue(item.getLibrary());
                    typeProperty = this.callTarget.createParam();
                    typeProperty.setName(OBJECT_TYPE);
                    typeProperty.setValue(item.getType());
                    Property subtypeProperty = this.callTarget.createParam();
                    subtypeProperty.setName(OBJECT_SUBTYPE);
                    subtypeProperty.setValue(item.getSubType());
                    fullnameProperty = this.callTarget.createParam();
                    fullnameProperty.setName(OBJECT_FULL_NAME);
                    fullnameProperty.setValue(item.getFullName());
                } else if (this.resourceSet instanceof ILibrarySet) {
                    item = (ISeriesHostObjectBasic)iterator.next();
                    nameProperty = this.callTarget.createParam();
                    nameProperty.setName(LIBRARY_NAME);
                    nameProperty.setValue(item.getName());
                    fullnameProperty = this.callTarget.createParam();
                    fullnameProperty.setName(OBJECT_FULL_NAME);
                    fullnameProperty.setValue(item.getFullName());
                }
                this.callTarget.execute();
            }
        }
        catch (Exception e) {
            this.log("[IterateTask] " + e.toString(), 0);
            throw new BuildException((Throwable)e);
        }
    }
}

