/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iant.taskdefs;

import com.ibm.etools.iseries.comm.interfaces.IISeriesHostObjectBasic;
import com.ibm.iant.taskdefs.IAntTaskUtils;
import com.ibm.iant.types.AbstractIResourceSet;
import com.ibm.iant.types.ISource;
import com.ibm.iant.types.ITarget;
import java.util.Date;
import java.util.Iterator;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.condition.Condition;

public class IUpToDate
extends Task
implements Condition {
    private String property;
    private String value;
    private ITarget target;
    private ISource source;
    private boolean isUpdateToDate = false;

    public IUpToDate() {
        this.log("[IUpToDate] constructor", 3);
    }

    public void setProperty(String property) {
        this.property = property;
        IAntTaskUtils.logParam(this.getProject(), "[IUpToDate] property --> " + property);
        this.log("[IUpToDate] Property set", 4);
    }

    public void setValue(String value) {
        this.value = value;
        IAntTaskUtils.logParam(this.getProject(), "[IUpToDate] value --> " + value);
        this.log("[IUpToDate] value --> " + value, 2);
    }

    private String getValue() {
        return this.value != null ? this.value : "true";
    }

    public ITarget createITarget() {
        this.target = new ITarget();
        return this.target;
    }

    public ISource createISource() {
        this.source = new ISource();
        return this.source;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean eval() throws BuildException {
        this.log("eval()", 3);
        AbstractIResourceSet targetResourceSet = this.target.getAbstractResourceSet();
        AbstractIResourceSet sourceResourceSet = this.source.getAbstractResourceSet();
        try {
            Date sourceDate;
            Iterator targetIter = targetResourceSet.iterator();
            if (!targetIter.hasNext()) {
                return false;
            }
            IISeriesHostObjectBasic target = (IISeriesHostObjectBasic)targetIter.next();
            Date targetDate = target.getDateModified();
            this.log("Output Object (" + target.getName() + ") Date: " + targetDate.getTime(), 3);
            Iterator sourceIter = sourceResourceSet.iterator();
            do {
                if (!sourceIter.hasNext()) {
                    return true;
                }
                IISeriesHostObjectBasic source = (IISeriesHostObjectBasic)sourceIter.next();
                sourceDate = source.getDateModified();
                this.log(String.valueOf(source.getName()) + " Date: " + sourceDate.getTime(), 3);
            } while (targetDate.compareTo(sourceDate) >= 0);
            this.log("Found out of date input", 3);
            return false;
        }
        catch (Exception e) {
            this.log("[IUpToDate] " + e.toString(), 0);
            throw new BuildException((Throwable)e);
        }
    }

    public void execute() throws BuildException {
        this.log("[IUpToDate] execute()", 3);
        if (this.property == null) {
            BuildException noPropertyAttribute = new BuildException("property attribute is required.", this.getLocation());
            String location = noPropertyAttribute.getLocation().toString();
            this.log("[IUpToDate] property attribute is required." + location, 0);
            throw noPropertyAttribute;
        }
        boolean upToDate = this.eval();
        if (upToDate) {
            this.getProject().setNewProperty(this.property, this.getValue());
            this.isUpdateToDate = true;
        }
    }

    public boolean isUpdateToDate() {
        return this.isUpdateToDate;
    }
}

