/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iant.taskdefs;

import com.ibm.as400.access.AS400;
import com.ibm.etools.iseries.comm.ISeriesListLibraries;
import com.ibm.etools.iseries.comm.ISeriesListMembers;
import com.ibm.etools.iseries.comm.ISeriesListObjects;
import com.ibm.etools.iseries.comm.filters.ISeriesAbstractFilterString;
import com.ibm.etools.iseries.comm.filters.ISeriesLibraryFilterString;
import com.ibm.etools.iseries.comm.filters.ISeriesMemberFilterString;
import com.ibm.etools.iseries.comm.filters.ISeriesObjectFilterString;
import com.ibm.etools.iseries.comm.filters.ISeriesObjectTypeAttr;
import com.ibm.etools.iseries.comm.filters.ISeriesObjectTypeAttrList;
import com.ibm.iant.taskdefs.AbstractIBMiCommandTask;
import com.ibm.iant.taskdefs.IAntTaskUtils;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.condition.Condition;

public class IAvailableTask
extends AbstractIBMiCommandTask
implements Condition {
    private static final String MBR_TYPE = "*MBR";
    private static final String LIB_TYPE = "*LIB";
    private static final String CURLIB = "*CURLIB";
    private String property;
    private String value;
    private String name;
    private String path;
    private String type;
    private String subtype;
    private boolean isAvailable = false;

    public IAvailableTask() {
        this.log("[IAvailableTask] constructor", 4);
    }

    public void setProperty(String property) {
        this.property = property;
        IAntTaskUtils.logParam(this.getProject(), "[IAvailableTask] Property set");
    }

    public void setValue(String value) {
        this.value = value;
        IAntTaskUtils.logParam(this.getProject(), "[IAvailableTask] value --> " + value);
    }

    private String getValue() {
        return this.value != null ? this.value : "true";
    }

    public void setName(String value) {
        this.name = value;
        IAntTaskUtils.logParam(this.getProject(), "[IAvailableTask] name --> " + value);
    }

    public void setPath(String value) {
        this.path = value;
        IAntTaskUtils.logParam(this.getProject(), "[IAvailableTask] path --> " + value);
    }

    public void setType(String value) {
        this.type = value;
        IAntTaskUtils.logParam(this.getProject(), "[IAvailableTask] type --> " + value);
    }

    public void setSubtype(String value) {
        this.subtype = value;
        IAntTaskUtils.logParam(this.getProject(), "[IAvailableTask] subtype --> " + value);
    }

    public boolean eval() throws BuildException {
        AS400 as400 = this.getAS400();
        if (this.type.equalsIgnoreCase(LIB_TYPE)) {
            return this.evalLib(as400);
        }
        if (this.type.equalsIgnoreCase(MBR_TYPE)) {
            return this.evalMbr(as400);
        }
        return this.evalObj(as400);
    }

    @Override
    public void execute() throws BuildException {
        if (this.property == null) {
            BuildException noPropertyAttribute = new BuildException("property attribute is required.", this.getLocation());
            String location = noPropertyAttribute.getLocation().toString();
            this.log("[IAvailableTask] property attribute is required." + location, 0);
            throw noPropertyAttribute;
        }
        if (this.type == null) {
            this.type = "*ALL";
        }
        if (this.name == null) {
            BuildException noNameAttribute = new BuildException("name attribute is required.", this.getLocation());
            String location = noNameAttribute.getLocation().toString();
            this.log("[IAvailableTask] name attribute is required." + location, 0);
            this.isAvailable = false;
            return;
        }
        boolean available = this.eval();
        if (available) {
            this.getProject().setNewProperty(this.property, this.getValue());
            this.isAvailable = true;
        }
    }

    public boolean isAvailable() {
        return this.isAvailable;
    }

    private boolean evalLib(AS400 as400) {
        if (-1 != this.name.indexOf(42) && !this.name.equalsIgnoreCase(CURLIB)) {
            BuildException invalidNameInput = new BuildException("invalid name input", this.getLocation());
            String location = invalidNameInput.getLocation().toString();
            this.log("[IAvailableTask] invalid name entered" + location, 0);
            return false;
        }
        ISeriesLibraryFilterString filterString = new ISeriesLibraryFilterString(this.name);
        ISeriesListLibraries listLibraries = new ISeriesListLibraries(as400);
        try {
            List filterResults = listLibraries.getList((ISeriesAbstractFilterString)filterString);
            return filterResults != null && !filterResults.isEmpty();
        }
        catch (Exception e) {
            this.log("Exception during get library thrugh filtering: ", 3);
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            String stackTrace = sw.toString();
            this.log("[IAvailableTask] " + stackTrace, 0);
            e.printStackTrace();
            return false;
        }
    }

    private boolean evalMbr(AS400 as400) {
        int slashIndex;
        String libraryName = null;
        String fileName = null;
        String memberName = null;
        if (this.path != null && this.path.trim().length() > 0) {
            slashIndex = this.path.indexOf(47);
            if (slashIndex == -1) {
                BuildException invalidPathInput = new BuildException("invalid path input", this.getLocation());
                String location = invalidPathInput.getLocation().toString();
                this.log("[IAvailableTask] invalid path entered" + location, 0);
                return false;
            }
            libraryName = this.path.substring(0, slashIndex);
            fileName = this.path.substring(slashIndex + 1);
            if (-1 != libraryName.indexOf(42) && !libraryName.equalsIgnoreCase(CURLIB)) {
                BuildException invalidPathInput = new BuildException("invalid path input", this.getLocation());
                String location = invalidPathInput.getLocation().toString();
                this.log("[IAvailableTask] invalid path entered" + location, 0);
                return false;
            }
            if (-1 != fileName.indexOf("*")) {
                BuildException invalidPathInput = new BuildException("invalid path input", this.getLocation());
                String location = invalidPathInput.getLocation().toString();
                this.log("[IAvailableTask] invalid path entered" + location, 0);
                return false;
            }
            if (-1 != this.name.indexOf("*")) {
                BuildException invalidNameInput = new BuildException("invalid name input", this.getLocation());
                String location = invalidNameInput.getLocation().toString();
                this.log("[IAvailableTask] invalid name entered" + location, 0);
                return false;
            }
            memberName = this.name;
        } else {
            slashIndex = this.name.indexOf(47);
            int leftBracketIndex = this.name.indexOf(40);
            int rightBracketIndex = this.name.indexOf(41);
            if (slashIndex == -1 || leftBracketIndex == -1 || rightBracketIndex == -1) {
                BuildException invalidNameInput = new BuildException("invalid name input", this.getLocation());
                String location = invalidNameInput.getLocation().toString();
                this.log("[IAvailableTask] invalid name entered" + location, 0);
                return false;
            }
            libraryName = this.name.substring(0, slashIndex);
            fileName = this.name.substring(slashIndex + 1, leftBracketIndex);
            memberName = this.name.substring(leftBracketIndex + 1, rightBracketIndex);
            if (-1 != libraryName.indexOf(42) && !libraryName.equalsIgnoreCase(CURLIB)) {
                BuildException invalidNameInput = new BuildException("invalid name input", this.getLocation());
                String location = invalidNameInput.getLocation().toString();
                this.log("[IAvailableTask] invalid name entered" + location, 0);
                return false;
            }
            if (-1 != fileName.indexOf("*")) {
                BuildException invalidNameInput = new BuildException("invalid name input", this.getLocation());
                String location = invalidNameInput.getLocation().toString();
                this.log("[IAvailableTask] invalid name entered" + location, 0);
                return false;
            }
            if (-1 != memberName.indexOf("*")) {
                BuildException invalidNameInput = new BuildException("invalid name input", this.getLocation());
                String location = invalidNameInput.getLocation().toString();
                this.log("[IAvailableTask] invalid name entered" + location, 0);
                return false;
            }
        }
        ISeriesMemberFilterString filterString = new ISeriesMemberFilterString();
        filterString.setLibrary(libraryName);
        filterString.setFile(fileName);
        filterString.setMember(memberName);
        ISeriesListMembers listMembers = new ISeriesListMembers(as400);
        try {
            List filterResults = listMembers.getList((ISeriesAbstractFilterString)filterString);
            return filterResults != null && !filterResults.isEmpty();
        }
        catch (Exception e) {
            this.log("[IAvailableTask] Exception during get member through filtering: ", 3);
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            String stackTrace = sw.toString();
            this.log("[IAvailableTask] " + stackTrace, 0);
            e.printStackTrace();
            return false;
        }
    }

    private boolean evalObj(AS400 as400) {
        String libraryName = null;
        String objName = null;
        if (this.path != null && this.path.trim().length() > 0) {
            libraryName = this.path;
            if (-1 != libraryName.indexOf(42) && !libraryName.equalsIgnoreCase(CURLIB)) {
                BuildException invalidPathInput = new BuildException("invalid path input", this.getLocation());
                String location = invalidPathInput.getLocation().toString();
                this.log("[IAvailableTask] invalid path entered" + location, 0);
                return false;
            }
            if (-1 != this.name.indexOf("*")) {
                this.isAvailable = false;
                return false;
            }
            objName = this.name;
        } else {
            int slashIndex = this.name.indexOf(47);
            if (slashIndex == -1) {
                BuildException invalidNameInput = new BuildException("invalid name input", this.getLocation());
                String location = invalidNameInput.getLocation().toString();
                this.log("[IAvailableTask] invalid name entered" + location, 0);
                return false;
            }
            libraryName = this.name.substring(0, slashIndex);
            objName = this.name.substring(slashIndex + 1);
            if (-1 != libraryName.indexOf(42) && !libraryName.equalsIgnoreCase(CURLIB)) {
                BuildException invalidNameInput = new BuildException("invalid name input", this.getLocation());
                String location = invalidNameInput.getLocation().toString();
                this.log("[IAvailableTask] invalid name entered" + location, 0);
                return false;
            }
            if (-1 != objName.indexOf("*")) {
                BuildException invalidNameInput = new BuildException("invalid name input", this.getLocation());
                String location = invalidNameInput.getLocation().toString();
                this.log("[IAvailableTask] invalid name entered" + location, 0);
                return false;
            }
        }
        ISeriesObjectFilterString filterString = new ISeriesObjectFilterString();
        filterString.setLibrary(libraryName);
        filterString.setObject(objName);
        filterString.setObjectType(this.type);
        ISeriesObjectTypeAttr typeAttr = new ISeriesObjectTypeAttr();
        typeAttr.setObjectType(this.type);
        typeAttr.setObjectAttr(this.subtype);
        ISeriesObjectTypeAttrList typeAttrList = new ISeriesObjectTypeAttrList(typeAttr.toString());
        filterString.setObjectTypeAttrList(typeAttrList);
        ISeriesListObjects listObjects = new ISeriesListObjects(as400);
        try {
            List filterResults = listObjects.getList((ISeriesAbstractFilterString)filterString);
            return filterResults != null && !filterResults.isEmpty();
        }
        catch (Exception e) {
            this.log("[IAvailableTask] Exception during get member through filtering: ", 3);
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            String stackTrace = sw.toString();
            this.log("[IAvailableTask] " + stackTrace, 0);
            e.printStackTrace();
            return false;
        }
    }
}

