/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iant.taskdefs;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.CommandCall;
import com.ibm.etools.iseries.comm.ISeriesListLibraries;
import com.ibm.etools.iseries.comm.ISeriesListMembers;
import com.ibm.etools.iseries.comm.ISeriesListObjects;
import com.ibm.etools.iseries.comm.filters.ISeriesAbstractFilterString;
import com.ibm.etools.iseries.comm.filters.ISeriesLibraryFilterString;
import com.ibm.etools.iseries.comm.filters.ISeriesMemberFilterString;
import com.ibm.etools.iseries.comm.filters.ISeriesObjectFilterString;
import com.ibm.etools.iseries.comm.interfaces.IISeriesHostObjectBasic;
import com.ibm.etools.iseries.comm.interfaces.IISeriesHostObjectBrief;
import com.ibm.etools.iseries.comm.interfaces.IISeriesHostObjectNameOnly;
import com.ibm.etools.iseries.util.ISeriesCodepageConverter;
import com.ibm.iant.IBMIBuildEvent;
import com.ibm.iant.IBMiBuildOutputBuildStatusEvent;
import com.ibm.iant.IBMiBuildOutputResolveEvent;
import com.ibm.iant.IIBMICommandListener;
import com.ibm.iant.types.IListDBRelations;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;

public class IAntTaskUtils {
    public static final String AS400TYPE_INSTANCE_ID_PROPERTY_NAME = "default.system.id";
    private static final String SLASH = "/";

    public static void runCommand(String cmd, AS400 system, Project thisProject) throws BuildException {
        IAntTaskUtils.runCommand(cmd, system, thisProject, false);
    }

    public static void runCommand(String cmd, AS400 system, Project thisProject, boolean failOnError) throws BuildException {
        Vector vector = thisProject.getBuildListeners();
        Iterator iter = vector.iterator();
        Vector<IIBMICommandListener> commandListeners = new Vector<IIBMICommandListener>();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (!(obj instanceof IIBMICommandListener)) continue;
            commandListeners.add((IIBMICommandListener)obj);
        }
        Iterator commandListenersIterator = commandListeners.iterator();
        while (commandListenersIterator != null && commandListenersIterator.hasNext()) {
            IIBMICommandListener commandListener = (IIBMICommandListener)commandListenersIterator.next();
            commandListener.beforeCommandRun(new IBMIBuildEvent(thisProject, cmd, system));
        }
        CommandCall cmdCall = new CommandCall();
        thisProject.log("[IAntTaskUtils] Command to run: " + cmd);
        try {
            cmdCall.setCommand(cmd);
            cmdCall.setSystem(system);
            cmdCall.setMessageOption(2);
            boolean result = cmdCall.run(cmd);
            if (!result) {
                thisProject.log("[IAntTaskUtils] AbstractIBMiCommandTask#runCommand: command.run( cmd ) != true");
            }
            AS400Message[] messagelist = cmdCall.getMessageList();
            AS400Message highestSevMessage = null;
            int i = 0;
            while (i < messagelist.length) {
                AS400Message as400Message = messagelist[i];
                IAntTaskUtils.displayAS400Message(as400Message, system, true, thisProject);
                if (highestSevMessage == null || as400Message.getSeverity() > highestSevMessage.getSeverity()) {
                    highestSevMessage = messagelist[i];
                }
                ++i;
            }
            if (!result) {
                if (!failOnError) {
                    thisProject.log("Failed to run command: " + cmd, 0);
                } else {
                    throw new BuildException("Failed to run command: " + cmd);
                }
            }
            commandListenersIterator = commandListeners.iterator();
            while (commandListenersIterator != null && commandListenersIterator.hasNext()) {
                IIBMICommandListener commandListener = (IIBMICommandListener)commandListenersIterator.next();
                commandListener.afterCommandRun(new IBMIBuildEvent(thisProject, cmd, system));
            }
            if (!result && highestSevMessage != null) {
                IAntTaskUtils.checkIBMiCmdFailOnError(thisProject, highestSevMessage);
            }
        }
        catch (BuildException e) {
            thisProject.log("[IAntTaskUtils] " + e.toString(), 0);
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            String stackTrace = sw.toString();
            thisProject.log(stackTrace, 0);
            thisProject.log("[IAntTaskUtils] " + e.toString(), 0);
            throw new BuildException((Throwable)e);
        }
    }

    public static void checkIBMiCmdFailOnError(Project thisProject, AS400Message highestSevMessage) throws BuildException {
        boolean failOnError = false;
        int failOnErrorThreshold = 40;
        String propertyString = thisProject.getProperty("com.ibm.teami.build.ant.icmd.failOnError");
        if (propertyString == null) {
            return;
        }
        failOnError = Boolean.valueOf(propertyString);
        propertyString = thisProject.getProperty("com.ibm.teami.build.ant.icmd.failOnError.level");
        if (propertyString != null) {
            failOnErrorThreshold = Integer.valueOf(propertyString);
        }
        if (failOnError && highestSevMessage.getSeverity() >= failOnErrorThreshold) {
            throw new BuildException("[IBMiCommand.SeverityThresholdHit]: " + highestSevMessage.toString());
        }
    }

    public static void runCommandWithNoFailure(String cmd, AS400 system, Project thisProject) {
        CommandCall cmdCall = new CommandCall();
        try {
            cmdCall.setCommand(cmd);
            cmdCall.setSystem(system);
            cmdCall.setMessageOption(2);
            cmdCall.run(cmd);
        }
        catch (Exception e) {
            thisProject.log("[IAntTaskUtils] " + e.toString(), 0);
        }
    }

    public static void displayAS400Message(AS400Message as400Message, AS400 as400, boolean withHelp, Project thisProject) {
        try {
            as400Message.load();
        }
        catch (Exception e) {
            thisProject.log("[IAntTaskUtils] Error when loading AS400Message. " + e.toString(), 0);
            throw new BuildException("Error when loading AS400Message. ", (Throwable)e);
        }
        String msgId = as400Message.getID();
        String msgText = as400Message.getText();
        byte[] subData = as400Message.getSubstitutionData();
        int severity = as400Message.getSeverity();
        String help = "";
        if (msgText.length() == 0 && msgId.trim().length() == 0 && subData != null && subData.length > 0) {
            ISeriesCodepageConverter converter = new ISeriesCodepageConverter(as400);
            try {
                msgText = converter.convHostBytesToClientString(as400.getCcsid(), subData);
            }
            catch (UnsupportedEncodingException e) {
                thisProject.log("[IAntTaskUtils] " + e.toString(), 1);
            }
            msgId = "";
        }
        if (msgText.length() == 0 && msgId.trim().length() == 0) {
            thisProject.log("[IAntTaskUtils] getSystemMessage: Message returned is empty", 0);
        } else {
            if (withHelp) {
                int indexOfProblemChar;
                help = as400Message.getHelp();
                if (msgId != null && msgId.equalsIgnoreCase("CPFAC11") && (indexOfProblemChar = help.indexOf(0)) > -1) {
                    help = String.valueOf(help.substring(0, indexOfProblemChar)) + ' ' + help.substring(indexOfProblemChar + 1);
                }
            }
            String messageOutput = "Host: " + msgId + ": " + msgText;
            if (severity > 30) {
                thisProject.log("[IAntTaskUtils] " + messageOutput, 0);
                if (withHelp) {
                    thisProject.log("[IAntTaskUtils] " + help, 0);
                }
            } else if (!msgId.equals("CPD4090")) {
                thisProject.log("[IAntTaskUtils] " + messageOutput, 4);
                if (withHelp) {
                    thisProject.log("[IAntTaskUtils] " + help, 4);
                }
            }
        }
    }

    public static boolean doesObjectExist(AS400 system, String objectLibrary, String objectName, String objectType, String objectAttribute) {
        List list = IAntTaskUtils.getObjectListForFilterString(String.valueOf(objectLibrary) + SLASH + objectName + " OBJTYPE(" + objectType + ":" + objectAttribute + ")", system);
        return IAntTaskUtils.checkListForObjectName(list, objectName);
    }

    public static boolean doesMemberExist(AS400 system, String memberLibrary, String memberSourceFile, String memberName, String memberType) {
        List list = IAntTaskUtils.getMemberListForFilterString(String.valueOf(memberLibrary) + SLASH + memberSourceFile + "(" + memberName + ")" + " MBRTYPE(" + memberType + ")", system);
        return IAntTaskUtils.checkListForObjectName(list, memberName);
    }

    public static boolean doesLibraryExist(AS400 system, String libraryName) {
        List list = IAntTaskUtils.getLibraryListForFilterString(libraryName, system);
        return IAntTaskUtils.checkListForObjectName(list, libraryName);
    }

    public static boolean checkListForObjectName(List list, String objName) {
        if (list == null) {
            return false;
        }
        boolean hasObject = false;
        Iterator it = list.iterator();
        while (it.hasNext() && !hasObject) {
            Object curObj = it.next();
            if (!(curObj instanceof IISeriesHostObjectNameOnly) || !((IISeriesHostObjectNameOnly)curObj).getName().equalsIgnoreCase(objName)) continue;
            hasObject = true;
        }
        return hasObject;
    }

    public static boolean checkListForObjectSubType(List list, String objName, String objSubType) {
        if (list == null) {
            return false;
        }
        boolean hasObjectWithSubType = false;
        Iterator it = list.iterator();
        while (it.hasNext() && !hasObjectWithSubType) {
            Object curObj = it.next();
            if (!(curObj instanceof IISeriesHostObjectBrief) || !((IISeriesHostObjectBrief)curObj).getName().equalsIgnoreCase(objName) || !((IISeriesHostObjectBrief)curObj).getSubType().equalsIgnoreCase(objSubType)) continue;
            hasObjectWithSubType = true;
        }
        return hasObjectWithSubType;
    }

    public static Date checkListForObjectModifiedDate(List list, String objName) {
        if (list == null) {
            return null;
        }
        Date date = null;
        Iterator it = list.iterator();
        while (it.hasNext() && date == null) {
            Object curObj = it.next();
            if (!(curObj instanceof IISeriesHostObjectBasic) || !((IISeriesHostObjectBasic)curObj).getName().equalsIgnoreCase(objName)) continue;
            date = ((IISeriesHostObjectBasic)curObj).getDateModified();
        }
        return date;
    }

    public static List getObjectListForFilterString(String filter, AS400 system) {
        ISeriesObjectFilterString filterString = new ISeriesObjectFilterString(filter);
        ISeriesListObjects listObjects = new ISeriesListObjects();
        listObjects.setSystem(system);
        List list = null;
        try {
            list = listObjects.getList((ISeriesAbstractFilterString)filterString);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public static List getMemberListForFilterString(String filter, AS400 system) {
        ISeriesMemberFilterString filterString = new ISeriesMemberFilterString(filter);
        ISeriesListMembers listMembers = new ISeriesListMembers();
        listMembers.setSystem(system);
        List list = null;
        try {
            list = listMembers.getList((ISeriesAbstractFilterString)filterString);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public static List getLibraryListForFilterString(String filter, AS400 system) {
        ISeriesLibraryFilterString filterString = new ISeriesLibraryFilterString(filter);
        ISeriesListLibraries listLibraries = new ISeriesListLibraries();
        listLibraries.setSystem(system);
        List list = null;
        try {
            list = listLibraries.getList((ISeriesAbstractFilterString)filterString);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public static List<IISeriesHostObjectBrief> getRelationsForPF(String library, String name, String type, AS400 system) {
        boolean exists = IAntTaskUtils.doesObjectExist(system, library, name, type, "*ALL");
        if (!exists) {
            return null;
        }
        ISeriesObjectFilterString filterString = new ISeriesObjectFilterString();
        filterString.setLibrary(library);
        filterString.setObject(name);
        filterString.setObjectType(type);
        IListDBRelations listRelations = new IListDBRelations();
        listRelations.setSystem(system);
        List<IISeriesHostObjectBrief> list = null;
        try {
            list = listRelations.getList((ISeriesAbstractFilterString)filterString);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public static void logParam(Project project, String msg) {
        if (project != null) {
            project.log(msg, 4);
        }
    }

    public static void fireOutputResolveBuildEvent(Project thisProject, String buildSpecTargetName, String outputObjectLib, String outputObjectName, String outputObjectType, String outputObjectAttribute, Collection inputs, String decision) {
        Iterator<IIBMICommandListener> commandListenersIterator = IAntTaskUtils.getIBMICommandListener(thisProject);
        while (commandListenersIterator != null && commandListenersIterator.hasNext()) {
            IIBMICommandListener commandListener = commandListenersIterator.next();
            commandListener.beforeCommandRun(new IBMiBuildOutputResolveEvent(thisProject, buildSpecTargetName, outputObjectLib, outputObjectName, outputObjectType, outputObjectAttribute, inputs, decision));
        }
    }

    public static void fireOutputBuildStatusEvent(Project thisProject, String buildSpecTargetName, String outputObjectLib, String outputObjectName, String outputObjectType, String outputObjectAttribute, String buildStatus) {
        Iterator<IIBMICommandListener> commandListenersIterator = IAntTaskUtils.getIBMICommandListener(thisProject);
        while (commandListenersIterator != null && commandListenersIterator.hasNext()) {
            IIBMICommandListener commandListener = commandListenersIterator.next();
            commandListener.afterCommandRun(new IBMiBuildOutputBuildStatusEvent(thisProject, buildSpecTargetName, outputObjectLib, outputObjectName, outputObjectType, outputObjectAttribute, buildStatus));
        }
    }

    protected static Iterator<IIBMICommandListener> getIBMICommandListener(Project thisProject) {
        Vector vector = thisProject.getBuildListeners();
        Iterator iter = vector.iterator();
        Vector<IIBMICommandListener> commandListeners = new Vector<IIBMICommandListener>();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (!(obj instanceof IIBMICommandListener)) continue;
            commandListeners.add((IIBMICommandListener)obj);
        }
        return commandListeners.iterator();
    }

    public static String getCurrentLibName(AS400 system) {
        Object curObj;
        List libList = IAntTaskUtils.getLibraryListForFilterString("*CURLIB", system);
        if (!libList.isEmpty() && (curObj = libList.get(0)) instanceof IISeriesHostObjectNameOnly) {
            return ((IISeriesHostObjectNameOnly)curObj).getName();
        }
        return "";
    }

    public static boolean isNewlyBuild(IISeriesHostObjectBasic reportedObject, Date baseDateStamp) {
        Date objectDate;
        return reportedObject != null && reportedObject instanceof IISeriesHostObjectBasic && (objectDate = reportedObject.getDateModified()) != null && objectDate.compareTo(baseDateStamp) >= 0;
    }

    public static String getBaseIFSPath(String iasp, String libraryName) {
        String qsys = "/QSYS.LIB/";
        if (libraryName != null && libraryName.compareToIgnoreCase("QTEMP") != 0 && !iasp.isEmpty()) {
            qsys = SLASH + iasp + SLASH + "QSYS.LIB" + SLASH;
        }
        return qsys;
    }

    public static String getCRTLIBASPArguments(String iasp) {
        String aspArguments = "";
        if (iasp != null && !iasp.trim().isEmpty()) {
            aspArguments = " ASP(*ASPDEV) ASPDEV(" + iasp + ")";
        }
        return aspArguments;
    }
}

