/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iant.taskdefs;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.IFSFile;
import com.ibm.as400.access.Job;
import com.ibm.iant.taskdefs.AbstractIBMiCommandTask;
import com.ibm.iant.taskdefs.IAntTaskUtils;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.tools.ant.BuildException;

public class GeneratePDFSpoolTask
extends AbstractIBMiCommandTask {
    private static final String TMP_DIR = "/home/tmp";
    private static final String SPOOL_LOCATION_NAME_PREFIX = "SPOOL_LOCATION";
    private static final String COMMAND_FIRSTPART = "OVRPRTF FILE(QSYSPRT) DEVTYPE(*AFPDS) TOSTMF('";
    private static final String COMMAND_SECONDPART = "') WSCST(*PDF) OVRSCOPE(*JOB)";
    private String property;
    private String value;

    public void setProperty(String property) {
        this.property = property;
        IAntTaskUtils.logParam(this.getProject(), "property--> " + property);
    }

    public void setValue(String value) {
        this.value = value;
        IAntTaskUtils.logParam(this.getProject(), "value--> " + value);
    }

    private String getValue() {
        return this.value != null ? this.value : ".";
    }

    @Override
    public void execute() throws BuildException {
        if (this.property == null) {
            BuildException noProperty = new BuildException("property attribute is required.", this.getLocation());
            String location = noProperty.getLocation().toString();
            this.log("property attribute is required." + location, 0);
            throw noProperty;
        }
        IFSFile parentDirectory = null;
        String spoolFileLocationFullName = null;
        AS400 as400 = this.getAS400();
        try {
            if (this.value == null || this.value.trim().length() == 0) {
                IFSFile tmpDirectory = new IFSFile(as400, TMP_DIR);
                if (!tmpDirectory.exists()) {
                    tmpDirectory.mkdir();
                }
                if (!tmpDirectory.exists()) {
                    BuildException wrongTmpDir = new BuildException("Cannot create temparory directory for the sp", this.getLocation());
                    String location = wrongTmpDir.getLocation().toString();
                    this.log("Cannot create temparory directory for the sp" + location, 0);
                    throw wrongTmpDir;
                }
                parentDirectory = tmpDirectory;
            } else {
                IFSFile specifiedDirectory = new IFSFile(as400, this.value);
                if (!specifiedDirectory.exists()) {
                    specifiedDirectory.mkdir();
                } else if (!specifiedDirectory.isDirectory()) {
                    BuildException wrongSpoolFileDir = new BuildException("specified spool file directory value is actually a file", this.getLocation());
                    String location = wrongSpoolFileDir.getLocation().toString();
                    this.log("specified spool file directory value is actually a file" + location, 0);
                    throw wrongSpoolFileDir;
                }
                parentDirectory = specifiedDirectory;
            }
            as400.connectService(2);
            Job[] commandServerJobs = as400.getJobs(2);
            Job thisJob = commandServerJobs[0];
            String jobNumber = thisJob.getNumber();
            String spoolFileLocationName = SPOOL_LOCATION_NAME_PREFIX + jobNumber;
            spoolFileLocationFullName = String.valueOf(parentDirectory.getAbsolutePath()) + "/" + spoolFileLocationName;
            IFSFile spoolFileDirectory = new IFSFile(as400, spoolFileLocationFullName);
            spoolFileDirectory.mkdir();
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            String stackTrace = sw.toString();
            this.log(stackTrace, 0);
            e.printStackTrace();
            BuildException spoolFileCreation = new BuildException("Exception when creating directory to hold spool file.", this.getLocation());
            String location = spoolFileCreation.getLocation().toString();
            this.log("Exception when creating directory to hold spool file." + location, 0);
            throw spoolFileCreation;
        }
        String command = COMMAND_FIRSTPART + spoolFileLocationFullName + COMMAND_SECONDPART;
        this.runCommand(command);
        this.getProject().setNewProperty(this.property, spoolFileLocationFullName);
    }
}

