/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iant.taskdefs;

import com.ibm.etools.iseries.comm.interfaces.ISeriesHostObjectBrief;
import com.ibm.iant.taskdefs.AbstractIBMiCommandTask;
import com.ibm.iant.taskdefs.IAntTaskUtils;
import com.ibm.iant.types.IObjectSet;
import com.ibm.iant.types.IResourceCollection;
import java.util.Iterator;
import org.apache.tools.ant.BuildException;

public class DLTOBJTask
extends AbstractIBMiCommandTask {
    private static final String DEFAULT_LIB = "*LIBL";
    private String lib = "*LIBL";
    private String obj = null;
    private String objtype = null;
    private String otheroptions = "";

    @Override
    public void execute() throws BuildException {
        IResourceCollection resourceCollection = this.getResourceCollection();
        if (resourceCollection == null) {
            if (this.obj == null) {
                this.log("No object name provided.", 0);
                throw new BuildException("No object name provided.");
            }
            if (this.objtype == null) {
                this.log("No object type provided.", 0);
                throw new BuildException("No object type provided.");
            }
            String commandString = this.getDeleteObjectCommand(this.lib, this.obj, this.objtype);
            commandString = String.valueOf(commandString) + " " + this.otheroptions;
            this.runCommand(commandString);
        } else {
            try {
                Iterator iter = resourceCollection.iterator();
                while (iter.hasNext()) {
                    Object curRes = iter.next();
                    if (!(curRes instanceof ISeriesHostObjectBrief)) {
                        this.log("Unexpected resource type in resource set.", 0);
                        throw new BuildException("Unexpected resource type in resource set.");
                    }
                    ISeriesHostObjectBrief curObject = (ISeriesHostObjectBrief)curRes;
                    String commandString = this.getDeleteObjectCommand(curObject.getLibrary(), curObject.getName(), curObject.getType());
                    commandString = String.valueOf(commandString) + " " + this.otheroptions;
                    this.runCommand(commandString);
                }
            }
            catch (Exception e) {
                this.log(e, 0);
                throw new BuildException((Throwable)e);
            }
        }
    }

    public void setLibrary(String lib) {
        this.lib = lib;
        IAntTaskUtils.logParam(this.getProject(), "library --> " + lib);
    }

    public void setObject(String obj) {
        this.obj = obj;
        IAntTaskUtils.logParam(this.getProject(), "object --> " + obj);
    }

    public void setObjecttype(String objType) {
        this.objtype = objType;
        IAntTaskUtils.logParam(this.getProject(), "objecttype --> " + objType);
    }

    public void setOtheroptions(String option) {
        this.otheroptions = option;
        IAntTaskUtils.logParam(this.getProject(), "otheroptions --> " + option);
    }

    public IObjectSet createIObjectSet() {
        return (IObjectSet)super.createIResourceCollection(new IObjectSet());
    }

    private String getDeleteObjectCommand(String libraryName, String objectName, String objectType) {
        String type = objectType;
        if (type.startsWith("*")) {
            type = type.substring(1);
        }
        String deleteCommand = "DLT" + type;
        if ("*FILE".equals(objectType)) {
            deleteCommand = "DLTF";
        } else if ("*MODULE".equals(objectType)) {
            deleteCommand = "DLTMOD";
        } else if ("*MENU".equals(objectType)) {
            deleteCommand = "DLTMNU";
        }
        deleteCommand = String.valueOf(deleteCommand) + "  " + libraryName + "/" + objectName;
        return deleteCommand;
    }
}

