/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iant.taskdefs;

import com.ibm.etools.iseries.comm.interfaces.ISeriesHostMemberBrief;
import com.ibm.iant.taskdefs.AbstractIBMiCommandTask;
import com.ibm.iant.taskdefs.IAntTaskUtils;
import com.ibm.iant.types.IMemberSet;
import com.ibm.iant.types.IResourceCollection;
import java.util.Iterator;
import org.apache.tools.ant.BuildException;

public class DLTMBRTask
extends AbstractIBMiCommandTask {
    private static final String DEFAULT_LIB = "*LIBL";
    private static final String RMVM_CMD = "RMVM ";
    private String lib = "*LIBL";
    private String srcf = null;
    private String mbr = null;
    private String otheroptions = "";
    private String _fileParm = "";
    private String _mbrParm = "";

    @Override
    public void execute() throws BuildException {
        IResourceCollection resourceCollection = this.getResourceCollection();
        if (resourceCollection == null) {
            if (this.srcf == null || this.srcf.trim().length() == 0) {
                this.log("No source file name provided.", 0);
                throw new BuildException("No source file name provided.");
            }
            if (this.mbr == null || this.mbr.trim().length() == 0) {
                this.log("No member name provided.", 0);
                throw new BuildException("No member name provided.");
            }
            this._fileParm = "FILE(" + this.lib + "/" + this.srcf + ") ";
            this._mbrParm = "MBR(" + this.mbr + ") ";
            String commandString = RMVM_CMD + this._fileParm + this._mbrParm + this.otheroptions;
            this.runCommand(commandString);
        } else {
            try {
                Iterator iter = resourceCollection.iterator();
                while (iter.hasNext()) {
                    Object curRes = iter.next();
                    if (!(curRes instanceof ISeriesHostMemberBrief)) {
                        this.log("Unexpected resource type in resource set.", 0);
                        throw new BuildException("Unexpected resource type in resource set.");
                    }
                    ISeriesHostMemberBrief curMember = (ISeriesHostMemberBrief)curRes;
                    this._fileParm = "FILE(" + curMember.getLibrary() + "/" + curMember.getFile() + ") ";
                    this._mbrParm = "MBR(" + curMember.getName() + ") ";
                    String commandString = RMVM_CMD + this._fileParm + this._mbrParm + this.otheroptions;
                    commandString = String.valueOf(commandString) + " " + this.otheroptions;
                    this.runCommand(commandString);
                }
            }
            catch (Exception e) {
                this.log(e, 0);
                throw new BuildException((Throwable)e);
            }
        }
    }

    public void setLibrary(String lib) {
        this.lib = lib;
        IAntTaskUtils.logParam(this.getProject(), "library --> " + lib);
    }

    public void setSourcefile(String srcf) {
        this.srcf = srcf;
        IAntTaskUtils.logParam(this.getProject(), "sourcefile --> " + srcf);
    }

    public void setMember(String mbr) {
        this.mbr = mbr;
        IAntTaskUtils.logParam(this.getProject(), "member --> " + mbr);
    }

    public void setOtheroptions(String option) {
        this.otheroptions = option;
        IAntTaskUtils.logParam(this.getProject(), "otheroptions --> " + option);
    }

    public IMemberSet createIMemberSet() {
        return (IMemberSet)super.createIResourceCollection(new IMemberSet());
    }
}

