/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iant.taskdefs;

import com.ibm.etools.iseries.comm.interfaces.IISeriesHostObjectNameOnly;
import com.ibm.iant.taskdefs.AbstractIBMiCommandTask;
import com.ibm.iant.taskdefs.IAntTaskUtils;
import com.ibm.iant.types.ILibrarySet;
import com.ibm.iant.types.IResourceCollection;
import java.util.Iterator;
import org.apache.tools.ant.BuildException;

public class DLTLIBTask
extends AbstractIBMiCommandTask {
    private static final String DLT_CMD = "DLTLIB ";
    private String lib = null;
    private String otheroptions = "";
    private String _libParm = "";

    @Override
    public void execute() throws BuildException {
        IResourceCollection resourceCollection = this.getResourceCollection();
        if (resourceCollection == null) {
            if (this.lib == null || this.lib.trim().length() == 0) {
                this.log("No library name provided.", 0);
                throw new BuildException("No library name provided.");
            }
            this._libParm = "LIB(" + this.lib + ") ";
            String commandString = DLT_CMD + this._libParm + this.otheroptions;
            this.runCommand(commandString);
        } else {
            try {
                Iterator iter = resourceCollection.iterator();
                while (iter.hasNext()) {
                    Object curRes = iter.next();
                    if (!(curRes instanceof IISeriesHostObjectNameOnly)) {
                        this.log("Unexpected resource type in resource set.", 0);
                        throw new BuildException("Unexpected resource type in resource set.");
                    }
                    IISeriesHostObjectNameOnly curObject = (IISeriesHostObjectNameOnly)curRes;
                    this._libParm = "LIB(" + curObject.getName() + ") ";
                    String commandString = DLT_CMD + this._libParm + this.otheroptions;
                    this.runCommand(commandString);
                }
            }
            catch (Exception e) {
                this.log(e, 0);
                throw new BuildException((Throwable)e);
            }
        }
    }

    public void setLibrary(String lib) {
        this.lib = lib;
        IAntTaskUtils.logParam(this.getProject(), "library--> " + lib);
    }

    public void setOtheroptions(String option) {
        this.otheroptions = option;
        IAntTaskUtils.logParam(this.getProject(), "otheroptions --> " + option);
    }

    public ILibrarySet createILibrarySet() {
        return (ILibrarySet)super.createIResourceCollection(new ILibrarySet());
    }
}

