/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iant.taskdefs;

import com.ibm.etools.iseries.comm.interfaces.IISeriesHostObjectBrief;
import com.ibm.iant.taskdefs.AbstractIBMiCommandTask;
import com.ibm.iant.taskdefs.IAntTaskUtils;
import com.ibm.iant.types.IObjectSet;
import com.ibm.iant.types.IResourceCollection;
import java.util.Iterator;
import org.apache.tools.ant.BuildException;

public class CPYOBJTask
extends AbstractIBMiCommandTask {
    private static final String DEFAULT_TO_LIB = "*FROMLIB";
    private static final String DEFAULT_NEW_OBJ = "*OBJ";
    private static final String CRTDUPOBJ_CMD = "CRTDUPOBJ ";
    private String fromlib = null;
    private String obj = null;
    private String objtype = null;
    private String tolib = "*FROMLIB";
    private String newobj = "*OBJ";
    private String otheroptions = "";
    private String _objParm = "";
    private String _fromLibParm = "";
    private String _objTypeParm = "";
    private String _toLibParm = "";
    private String _newObjParm = "";

    @Override
    public void execute() throws BuildException {
        IResourceCollection resourceCollection = this.getResourceCollection();
        if (resourceCollection == null) {
            if (this.fromlib == null) {
                this.log("The required 'fromlibrary' parameter was not provided.", 0);
                throw new BuildException("The required 'fromlibrary' parameter was not provided.");
            }
            if (this.obj == null) {
                this.log("The required 'fromobject' parameter was not provided.", 0);
                throw new BuildException("The required 'fromobject' parameter was not provided.");
            }
            if (this.objtype == null) {
                this.log("The required 'fromobjecttype' parameter was not provided.", 0);
                throw new BuildException("The required 'fromobjecttype' parameter was not provided.");
            }
            if ((this.tolib == null || this.tolib.trim().length() == 0 || this.tolib.equalsIgnoreCase(DEFAULT_TO_LIB) || this.tolib.equalsIgnoreCase(this.fromlib)) && (this.newobj == null || this.newobj.trim().length() == 0 || this.newobj.equalsIgnoreCase(DEFAULT_NEW_OBJ) || this.newobj.equalsIgnoreCase(this.obj))) {
                this.log("Cannot copy object to itself.", 0);
                throw new BuildException("Cannot copy object to itself.");
            }
            this._objParm = "OBJ(" + this.obj + ") ";
            this._fromLibParm = "FROMLIB(" + this.fromlib + ") ";
            this._objTypeParm = "OBJTYPE(" + this.objtype + ") ";
            this._toLibParm = "TOLIB(" + this.tolib + ") ";
            this._newObjParm = "NEWOBJ(" + this.newobj + ") ";
            String copyCommandString = CRTDUPOBJ_CMD + this._objParm + this._fromLibParm + this._objTypeParm + this._toLibParm + this._newObjParm + this.otheroptions;
            this.runCommand(copyCommandString);
        } else {
            if (this.tolib == null || this.tolib.trim().length() == 0 || this.tolib.equalsIgnoreCase(DEFAULT_TO_LIB)) {
                this.log("Did not specify TOLIB parameter", 0);
                throw new BuildException("Did not specify TOLIB parameter");
            }
            try {
                Iterator iter = resourceCollection.iterator();
                while (iter.hasNext()) {
                    Object curRes = iter.next();
                    if (!(curRes instanceof IISeriesHostObjectBrief)) {
                        this.log("Unexpected resource type in resource set.", 0);
                        throw new BuildException("Unexpected resource type in resource set.");
                    }
                    IISeriesHostObjectBrief curObject = (IISeriesHostObjectBrief)curRes;
                    this._objParm = "OBJ(" + curObject.getName() + ") ";
                    this._fromLibParm = "FROMLIB(" + curObject.getLibrary() + ") ";
                    this._objTypeParm = "OBJTYPE(" + curObject.getType() + ") ";
                    this._toLibParm = "TOLIB(" + this.tolib + ") ";
                    this._newObjParm = "NEWOBJ(" + this.newobj + ") ";
                    String copyCommandString = CRTDUPOBJ_CMD + this._objParm + this._fromLibParm + this._objTypeParm + this._toLibParm + this._newObjParm + this.otheroptions;
                    this.runCommand(copyCommandString);
                }
            }
            catch (Exception e) {
                this.log(e, 0);
                throw new BuildException((Throwable)e);
            }
        }
    }

    public void setFromlibrary(String fromLib) {
        this.fromlib = fromLib;
        IAntTaskUtils.logParam(this.getProject(), "fromlibrary --> " + fromLib);
    }

    public void setFromobject(String obj) {
        this.obj = obj;
        IAntTaskUtils.logParam(this.getProject(), "fromobject --> " + obj);
    }

    public void setFromobjecttype(String objType) {
        this.objtype = objType;
        IAntTaskUtils.logParam(this.getProject(), "fromobjecttype --> " + this.objtype);
    }

    public void setTolibrary(String toLib) {
        this.tolib = toLib;
        IAntTaskUtils.logParam(this.getProject(), "tolibrary --> " + toLib);
    }

    public void setNewobject(String newObj) {
        this.newobj = newObj;
        IAntTaskUtils.logParam(this.getProject(), "newobject --> " + newObj);
    }

    public void setOtheroptions(String option) {
        this.otheroptions = option;
        IAntTaskUtils.logParam(this.getProject(), "otheroptions --> " + option);
    }

    public IObjectSet createIObjectSet() {
        return (IObjectSet)super.createIResourceCollection(new IObjectSet());
    }
}

