/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iant.taskdefs;

import com.ibm.etools.iseries.comm.interfaces.ISeriesHostObjectBrief;
import com.ibm.iant.taskdefs.AbstractIBMiCommandTask;
import com.ibm.iant.taskdefs.IAntTaskUtils;
import com.ibm.iant.types.IObjectSet;
import com.ibm.iant.types.IResourceCollection;
import java.util.Iterator;
import org.apache.tools.ant.BuildException;

public class CHGOWNERTask
extends AbstractIBMiCommandTask {
    private static final String DEFAULT_RVKOLDAUT = "*YES";
    private static final String CHGOWN_COMMAND = "CHGOWN ";
    private String lib = null;
    private String obj = null;
    private String objtype = null;
    private String newowner = null;
    private final String rvkoldaut = "*YES";
    private String otheroptions = "";
    private String _objParm = "";
    private String _newOwnerParm = "";
    private String _rvkoldautParm = "";

    @Override
    public void execute() throws BuildException {
        if (this.newowner == null || this.newowner.trim().length() == 0) {
            this.log("No new owner provided.", 0);
            throw new BuildException("No new owner provided.");
        }
        IResourceCollection resourceCollection = this.getResourceCollection();
        if (resourceCollection == null) {
            if (this.lib == null || this.lib.trim().length() == 0) {
                this.log("No object library name provided.", 0);
                throw new BuildException("No object library name provided.");
            }
            if (this.obj == null || this.obj.trim().length() == 0) {
                this.log("No object name provided.", 0);
                throw new BuildException("No object name provided.");
            }
            if (this.objtype == null || this.objtype.trim().length() == 0) {
                this.log("No object type provided.", 0);
                throw new BuildException("No object type provided.");
            }
            String objectPath = this.getObjectPath(this.lib, this.obj, this.objtype);
            this._objParm = "OBJ('" + objectPath + "') ";
            this._newOwnerParm = "NEWOWN(" + this.newowner + ") ";
            this._rvkoldautParm = "RVKOLDAUT(*YES) ";
            String commandString = CHGOWN_COMMAND + this._objParm + this._newOwnerParm + this._rvkoldautParm + this.otheroptions;
            this.runCommand(commandString);
        } else {
            try {
                Iterator iter = resourceCollection.iterator();
                while (iter.hasNext()) {
                    Object curRes = iter.next();
                    if (!(curRes instanceof ISeriesHostObjectBrief)) {
                        this.log("Unexpected resource type in resource set.", 0);
                        throw new BuildException("Unexpected resource type in resource set.");
                    }
                    ISeriesHostObjectBrief curObject = (ISeriesHostObjectBrief)curRes;
                    String objectPath = this.getObjectPath(curObject.getLibrary(), curObject.getName(), curObject.getType());
                    this._objParm = "OBJ('" + objectPath + "') ";
                    this._newOwnerParm = "NEWOWN(" + this.newowner + ") ";
                    this._rvkoldautParm = "RVKOLDAUT(*YES) ";
                    String commandString = CHGOWN_COMMAND + this._objParm + this._newOwnerParm + this._rvkoldautParm + this.otheroptions;
                    this.runCommand(commandString);
                }
            }
            catch (Exception e) {
                this.log(e, 0);
                throw new BuildException((Throwable)e);
            }
        }
    }

    public void setObjectlibrary(String lib) {
        this.lib = lib;
        IAntTaskUtils.logParam(this.getProject(), "objectlibrary --> " + lib);
    }

    public void setObjectname(String obj) {
        this.obj = obj;
        IAntTaskUtils.logParam(this.getProject(), "objectname --> " + obj);
    }

    public void setObjecttype(String objType) {
        this.objtype = objType;
        IAntTaskUtils.logParam(this.getProject(), "objecttype --> " + this.objtype);
    }

    public void setNewowner(String newowner) {
        this.newowner = newowner;
        IAntTaskUtils.logParam(this.getProject(), "newowner --> " + newowner);
    }

    public void setOtheroptions(String option) {
        this.otheroptions = option;
        IAntTaskUtils.logParam(this.getProject(), "otheroptions --> " + option);
    }

    public IObjectSet createIObjectSet() {
        return (IObjectSet)super.createIResourceCollection(new IObjectSet());
    }

    private String getObjectPath(String libraryName, String objectName, String objectType) {
        String objectExtension = objectType;
        if (objectExtension.startsWith("*")) {
            objectExtension = objectExtension.substring(1);
        }
        String objectPath = null;
        objectPath = "*LIB".equals(objectType) ? "/QSYS.LIB/" + objectName + ".LIB" : "/QSYS.LIB/" + libraryName + ".LIB" + "/" + objectName + "." + objectExtension;
        return objectPath;
    }
}

