/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iant.taskdefs;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.CommandCall;
import com.ibm.iant.types.IBMIResourceDependencies;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class BuildDefinitionTask
extends Task {
    private String hostCredentials = "";
    private final Vector<RemoteCommand> cmds = new Vector();
    private IBMIResourceDependencies resourceDependenciesNew = null;
    private static AS400 connection = null;

    public void execute() {
        if (connection != null && connection.isConnected()) {
            if (this.resourceDependenciesNew != null) {
                this.log(String.valueOf(this.resourceDependenciesNew.size()) + " resource dependencies, resolve to " + this.resourceDependenciesNew.allExist(connection));
            } else {
                this.log("No resource dependencies to resolve");
            }
            for (RemoteCommand c : this.cmds) {
                String remoteCmd = c.getCommand();
                try {
                    if (remoteCmd.length() > 0) {
                        CommandCall cmd = new CommandCall(connection);
                        this.log(">>" + remoteCmd);
                        boolean success = cmd.run(remoteCmd);
                        AS400Message[] messageList = cmd.getMessageList();
                        if (messageList.length <= 0) continue;
                        AS400Message[] aS400MessageArray = messageList;
                        int n = messageList.length;
                        int n2 = 0;
                        while (n2 < n) {
                            AS400Message m = aS400MessageArray[n2];
                            this.log("  <<" + m.getID() + ": " + m.getText(), success ? 2 : 0);
                            ++n2;
                        }
                        continue;
                    }
                    this.log("Nothing to execute!", 0);
                }
                catch (Exception e) {
                    this.log(e.toString());
                }
            }
        } else {
            this.log("No AS400 connection");
        }
    }

    public Object createResourceDependencies() {
        this.resourceDependenciesNew = new IBMIResourceDependencies();
        return this.resourceDependenciesNew;
    }

    public RemoteCommand createIcmd() {
        RemoteCommand c = new RemoteCommand();
        this.cmds.add(c);
        return c;
    }

    protected String getHostName() {
        return this.hostCredentials;
    }

    public void setHostCredentials(String hc) {
        this.hostCredentials = hc;
        boolean fail = true;
        String host = "";
        String id = "";
        String pwd = "";
        String[] credentials = this.hostCredentials.split("[:\\s]");
        if (credentials.length == 3) {
            host = credentials[0];
            id = credentials[1];
            pwd = credentials[2];
            try {
                connection = new AS400(host, id, pwd);
                connection.setGuiAvailable(false);
                connection.connectService(2);
                fail = false;
            }
            catch (AS400SecurityException aS400SecurityException) {
            }
            catch (IOException iOException) {
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
        if (fail) {
            throw new BuildException("Failed to create AS400 object (server:" + host + ",id:" + id + ",pwd:" + pwd.replaceAll("[\\w\\W]", "*") + ").  Abort Ant script ...");
        }
    }

    protected AS400 getConnection() {
        return connection;
    }

    public class RemoteCommand {
        private String command = "";

        public String getCommand() {
            return this.command;
        }

        public void setCommand(String c) {
            this.command = c;
        }
    }
}

