/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iant.taskdefs;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.IFSFile;
import com.ibm.as400.access.Job;
import com.ibm.iant.taskdefs.AbstractIBMiCommandTask;
import com.ibm.iant.taskdefs.IAntTaskUtils;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.tools.ant.BuildException;

public class AggregateEventFileTask
extends AbstractIBMiCommandTask {
    private static final String EVENT_FILE_NAME = "EVFEVENT";
    private static final String EVENT_FILE_IFSNAME = "EVFEVENT.evf";
    private static final String TEMP_LIBRARY_NAME = "QTEMP";
    private static final String TMP_DIR = "/home/tmp";
    private static final String EVENTFILE_LOCATION_NAME_PREFIX = "EVENTFILE_LOCATION";
    private static final String TEMP_EVENTFILE_IFS_PATH = "/QSYS.LIB/QTEMP.LIB/EVFEVENT.FILE/EVFEVENT.MBR";
    private static final String CPYF_COMMAND_FIRSTPART = "CPYF FROMFILE(";
    private static final String CPYF_COMMAND_SECONDPART = ") TOFILE(";
    private static final String CPYF_COMMAND_THIRDPART = ") FROMMBR(*ALL) MBROPT( *ADD) CRTFILE(*YES) FMTOPT(*MAP)";
    private static final String COPY_COMMAND_FIRSTPART = "COPY OBJ('";
    private static final String COPY_COMMAND_SECONDPART = "') TOOBJ('";
    private static final String COPY_COMMAND_THIRDPART = "') DTAFMT(*TEXT) REPLACE(*YES)";
    private String library = null;
    private String property = null;
    private String location = null;

    public void setLibrary(String library) {
        this.library = library;
        IAntTaskUtils.logParam(this.getProject(), "library--> " + library);
    }

    public void setProperty(String property) {
        this.property = property;
        IAntTaskUtils.logParam(this.getProject(), "property--> " + property);
    }

    public void setLocation(String location) {
        this.location = location;
        IAntTaskUtils.logParam(this.getProject(), "location--> " + location);
    }

    @Override
    public void execute() throws BuildException {
        if (this.property == null) {
            BuildException noProperty = new BuildException("property attribute is required.", this.getLocation());
            String taskLocation = noProperty.getLocation().toString();
            this.log("property attribute is required." + taskLocation, 0);
            throw noProperty;
        }
        if (this.library == null) {
            BuildException noProperty = new BuildException("library attribute is required.", this.getLocation());
            String taskLocation = noProperty.getLocation().toString();
            this.log("property attribute is required." + taskLocation, 0);
            throw noProperty;
        }
        IFSFile parentDirectory = null;
        String eventFileLocationName = null;
        AS400 as400 = this.getAS400();
        try {
            if (this.location == null || this.location.trim().length() == 0) {
                IFSFile tmpDirectory = new IFSFile(as400, TMP_DIR);
                if (!tmpDirectory.exists()) {
                    tmpDirectory.mkdir();
                }
                if (!tmpDirectory.exists()) {
                    BuildException wrongTmpDir = new BuildException("Cannot create temparory directory for the event file", this.getLocation());
                    String taskLocation = wrongTmpDir.getLocation().toString();
                    this.log("Cannot create temparory directory for the event file" + taskLocation, 0);
                    throw wrongTmpDir;
                }
                parentDirectory = tmpDirectory;
            } else {
                IFSFile specifiedDirectory = new IFSFile(as400, this.location);
                if (!specifiedDirectory.exists()) {
                    specifiedDirectory.mkdir();
                } else if (!specifiedDirectory.isDirectory()) {
                    BuildException wrongEventFileDir = new BuildException("specified event file directory value is actually a file", this.getLocation());
                    String taskLocation = wrongEventFileDir.getLocation().toString();
                    this.log("specified event file directory value is actually a file" + taskLocation, 0);
                    throw wrongEventFileDir;
                }
                parentDirectory = specifiedDirectory;
            }
            as400.connectService(2);
            Job[] commandServerJobs = as400.getJobs(2);
            Job thisJob = commandServerJobs[0];
            String jobNumber = thisJob.getNumber();
            eventFileLocationName = EVENTFILE_LOCATION_NAME_PREFIX + jobNumber;
            eventFileLocationName = String.valueOf(parentDirectory.getAbsolutePath()) + "/" + eventFileLocationName;
            IFSFile eventFileDirectory = new IFSFile(as400, eventFileLocationName);
            eventFileDirectory.mkdir();
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            String stackTrace = sw.toString();
            this.log(stackTrace, 0);
            e.printStackTrace();
            BuildException eventFileCreation = new BuildException("Exception when creating directory to hold event file.", this.getLocation());
            String taskLocation = eventFileCreation.getLocation().toString();
            this.log("Exception when creating directory to hold event file." + taskLocation, 0);
            throw eventFileCreation;
        }
        String fromEventFileName = String.valueOf(this.library) + "/" + EVENT_FILE_NAME;
        String toEventFileName = "QTEMP/EVFEVENT";
        String cpyfCommand = CPYF_COMMAND_FIRSTPART + fromEventFileName + CPYF_COMMAND_SECONDPART + toEventFileName + CPYF_COMMAND_THIRDPART;
        this.runCommand(cpyfCommand);
        String fromLocation = TEMP_EVENTFILE_IFS_PATH;
        String toLocation = String.valueOf(eventFileLocationName) + "/" + EVENT_FILE_IFSNAME;
        String copyCommand = COPY_COMMAND_FIRSTPART + fromLocation + COPY_COMMAND_SECONDPART + toLocation + COPY_COMMAND_THIRDPART;
        this.runCommand(copyCommand);
        this.getProject().setNewProperty(this.property, toLocation);
    }
}

