/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iant.listener;

import com.ibm.etools.iseries.util.IBMIQSYSEventFileCommandDetector;
import com.ibm.etools.iseries.util.IBMIQSYSEventFileInformation;
import com.ibm.iant.IBMIBuildEvent;
import com.ibm.iant.IIBMIEventFileListener;
import com.ibm.iant.listener.IBMICommandListener;
import org.apache.tools.ant.BuildException;

public abstract class AbstractIBMIEventFileListener
extends IBMICommandListener
implements IIBMIEventFileListener {
    private IBMIQSYSEventFileInformation eventFileInfo;
    private String eventFileLibrary;
    private String eventFileFile;
    private String eventFileMember;
    private int ccsid = 37;

    @Override
    public void beforeCommandRun(IBMIBuildEvent event) {
        super.beforeCommandRun(event);
        IBMIQSYSEventFileCommandDetector eventFileCommandDetector = IBMIQSYSEventFileCommandDetector.getDefaultEventFileDetector();
        String command = event.getCommand();
        String eventFileMemberName = eventFileCommandDetector.getEventFileMemberName(command);
        if (eventFileMemberName != null) {
            this.eventFileInfo = new IBMIQSYSEventFileInformation(event.getSystem(), command, eventFileMemberName);
            try {
                this.eventFileInfo.writeLDA(command, eventFileMemberName);
            }
            catch (Exception e) {
                throw new BuildException((Throwable)e);
            }
        } else {
            this.eventFileInfo = null;
        }
    }

    public void setEventFileLibrary(String eventFileLibrary) {
        this.eventFileLibrary = eventFileLibrary;
    }

    public void setEventFileFile(String eventFileFile) {
        this.eventFileFile = eventFileFile;
    }

    public void setEventFileMember(String eventFileMember) {
        this.eventFileMember = eventFileMember;
    }

    public void setCcsid(int ccsid) {
        this.ccsid = ccsid;
    }

    @Override
    public String getEventFileLibrary() {
        return this.eventFileLibrary;
    }

    @Override
    public String getEventFileFile() {
        return this.eventFileFile;
    }

    @Override
    public String getEventFileMember() {
        return this.eventFileMember;
    }

    @Override
    public int getCCSID() {
        return this.ccsid;
    }

    @Override
    public void afterCommandRun(IBMIBuildEvent event) {
        super.afterCommandRun(event);
        if (this.eventFileInfo != null) {
            try {
                if (this.eventFileInfo.readLDA()) {
                    this.setEventFileLibrary(this.eventFileInfo.getEventFileLibraryName());
                    this.setEventFileFile(this.eventFileInfo.getEventFileName());
                    this.setEventFileMember(this.eventFileInfo.getEventFileMemberName());
                    this.setCcsid(event.getSystem().getCcsid());
                    this.processEventFile(event);
                }
            }
            catch (BuildException e) {
                throw e;
            }
            catch (Exception e) {
                throw new BuildException((Throwable)e);
            }
        }
        this.cleanup();
    }

    @Override
    public void cleanup() {
        this.eventFileInfo = null;
        this.eventFileLibrary = null;
        this.eventFileFile = null;
        this.eventFileMember = null;
    }
}

