/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iant;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.CommandCall;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.iant.taskdefs.AbstractIBMiCommandTask;
import com.ibm.iant.types.IBMiRemoteCommand;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.util.Vector;

public class IBMiRemoteCommandUtils {
    public static boolean executeRemoteCommands(Vector<String> cmds, String prefix, AbstractIBMiCommandTask task, AS400 connection, boolean quietly) throws AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, PropertyVetoException {
        boolean allCommandsSucceded = true;
        for (String c : cmds) {
            String remoteCmd = c;
            if (remoteCmd.length() > 0) {
                AS400Message[] messageList;
                boolean success;
                CommandCall cmd = new CommandCall(connection);
                cmd.setMessageOption(2);
                if (!quietly) {
                    task.log(String.valueOf(prefix) + ">>" + remoteCmd);
                }
                if (!(success = cmd.run(remoteCmd))) {
                    allCommandsSucceded = false;
                }
                if ((messageList = cmd.getMessageList()).length <= 0) continue;
                AS400Message[] aS400MessageArray = messageList;
                int n = messageList.length;
                int n2 = 0;
                while (n2 < n) {
                    AS400Message m = aS400MessageArray[n2];
                    if (!quietly) {
                        Thread.sleep(1L);
                        task.log("  <<" + m.getID() + ": " + m.getText(), success ? 2 : 0);
                        if (m.getHelp() != null && !m.getHelp().equals("")) {
                            task.log("  <<" + m.getHelp(), success ? 2 : 0);
                        }
                        Thread.sleep(1L);
                    }
                    ++n2;
                }
                continue;
            }
            if (quietly) continue;
            Thread.sleep(1L);
            task.log(String.valueOf(prefix) + " - Nothing to execute!", 0);
            Thread.sleep(1L);
        }
        return allCommandsSucceded;
    }

    public static boolean executeIBMiRemoteCommands(Vector<IBMiRemoteCommand> cmds, String prefix, AbstractIBMiCommandTask task, AS400 connection, boolean quietly) throws AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, PropertyVetoException {
        boolean allCommandsSucceded = true;
        for (IBMiRemoteCommand c : cmds) {
            String remoteCmd = c.getCommand();
            if (remoteCmd.length() > 0) {
                AS400Message[] messageList;
                boolean success;
                CommandCall cmd = new CommandCall(connection);
                cmd.setMessageOption(2);
                if (!quietly) {
                    task.log(String.valueOf(prefix) + ">>" + remoteCmd);
                }
                if (!(success = cmd.run(remoteCmd))) {
                    allCommandsSucceded = false;
                }
                if ((messageList = cmd.getMessageList()).length <= 0) continue;
                AS400Message[] aS400MessageArray = messageList;
                int n = messageList.length;
                int n2 = 0;
                while (n2 < n) {
                    AS400Message m = aS400MessageArray[n2];
                    if (!quietly) {
                        Thread.sleep(1L);
                        task.log("  <<" + m.getID() + ": " + m.getText(), success ? 2 : 0);
                        if (m.getHelp() != null && !m.getHelp().equals("")) {
                            task.log("  <<" + m.getHelp(), success ? 2 : 0);
                        }
                        Thread.sleep(1L);
                    }
                    ++n2;
                }
                continue;
            }
            if (quietly) continue;
            Thread.sleep(1L);
            task.log(String.valueOf(prefix) + " - Nothing to execute!", 0);
            Thread.sleep(1L);
        }
        return allCommandsSucceded;
    }
}

