/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iant;

public class IBMiLibraryValidator {
    public static final String VARIANTS = "@\u00e0\u00c6$\u00c5#\u00c4\u00d8\u00d6\u00a7\u015e\u0130\u00a5\u00d1\u00a3\u00d0";
    public static final StringBuffer VALIDCHARS_FIRSTPOS = new StringBuffer("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ@\u00e0\u00c6$\u00c5#\u00c4\u00d8\u00d6\u00a7\u015e\u0130\u00a5\u00d1\u00a3\u00d0");
    public static final StringBuffer VALIDCHARS_ENDPOS = new StringBuffer("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789._@\u00e0\u00c6$\u00c5#\u00c4\u00d8\u00d6\u00a7\u015e\u0130\u00a5\u00d1\u00a3\u00d0");
    private static final StringBuffer specialCharsExtended = new StringBuffer("'\"?*");

    public static boolean isOneOf(char testChar, StringBuffer charSet) {
        int jdx = 0;
        while (jdx < charSet.length()) {
            if (testChar == charSet.charAt(jdx)) {
                return true;
            }
            ++jdx;
        }
        return false;
    }

    public static boolean onlyContains(String newText, StringBuffer charSet, int startingPos) {
        if (newText == null) {
            return true;
        }
        boolean onlyContains = true;
        int newLen = newText.length();
        if (startingPos >= newLen) {
            return onlyContains;
        }
        int nbrChars = charSet.length();
        int idx = startingPos;
        while (onlyContains && idx < newLen) {
            boolean match = false;
            int jdx = 0;
            while (!match && jdx < nbrChars) {
                if (newText.charAt(idx) == charSet.charAt(jdx)) {
                    match = true;
                }
                ++jdx;
            }
            if (!match) {
                onlyContains = false;
            }
            ++idx;
        }
        return onlyContains;
    }

    public static boolean containsBadCharacters(String newText, StringBuffer badChars, int startingPos) {
        boolean contains = false;
        int newLen = newText.length();
        if (startingPos >= newLen) {
            return contains;
        }
        int nbrBadChars = badChars.length();
        int idx = startingPos;
        while (!contains && idx < newLen) {
            int jdx = 0;
            while (!contains && jdx < nbrBadChars) {
                if (newText.charAt(idx) == badChars.charAt(jdx)) {
                    contains = true;
                }
                ++jdx;
            }
            ++idx;
        }
        return contains;
    }

    public static boolean isValidLibraryName(String libName) {
        String uppercaseName = new String(libName);
        if (libName.startsWith("\"")) {
            if (!libName.endsWith("\"")) {
                return false;
            }
            String tempLib = libName.substring(1, libName.length() - 1);
            if (IBMiLibraryValidator.containsBadCharacters(tempLib, specialCharsExtended, 0)) {
                return false;
            }
            if (tempLib.equals(tempLib.toUpperCase())) {
                uppercaseName = tempLib;
            }
        } else {
            uppercaseName = libName.toUpperCase();
            if (!IBMiLibraryValidator.isOneOf(libName.charAt(0), VALIDCHARS_FIRSTPOS)) {
                return false;
            }
            if (!IBMiLibraryValidator.onlyContains(libName, VALIDCHARS_ENDPOS, 1)) {
                return false;
            }
        }
        return uppercaseName.length() <= 10;
    }
}

