/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iant;

import java.io.BufferedWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DefaultLogger;
import org.apache.tools.ant.util.StringUtils;

public class IBMiAntLogger
extends DefaultLogger {
    public static final String ENCODING_UTF_8 = "UTF-8";
    protected PrintWriter antOut;
    protected PrintWriter antErr;
    protected int errorCount = 0;
    protected long buildStartTime = System.currentTimeMillis();

    public void setOutputPrintStream(PrintStream output) {
        this.out = new PrintStream(output, true);
        try {
            this.antOut = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter((OutputStream)output, ENCODING_UTF_8)), true);
        }
        catch (Exception e) {
            this.antOut = null;
        }
    }

    public void setErrorPrintStream(PrintStream err) {
        this.err = new PrintStream(err, true);
        try {
            this.antErr = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter((OutputStream)err, ENCODING_UTF_8)), true);
        }
        catch (Exception e) {
            this.antErr = null;
        }
    }

    protected void printMessage(String message, PrintWriter writer, int priority) {
        if (message.startsWith("Warning: Reference") && message.endsWith("referencing ids defined in non-executed targets.")) {
            return;
        }
        writer.println(message);
    }

    protected void printMessage(String message, PrintStream stream, int priority) {
        if (stream == this.out) {
            this.printMessage(message, this.antOut, priority);
        } else {
            this.printMessage(message, this.antErr, priority);
        }
    }

    public void messageLogged(BuildEvent event) {
        super.messageLogged(event);
        int priority = event.getPriority();
        if (priority == 0) {
            ++this.errorCount;
        }
    }

    public void buildFinished(BuildEvent event) {
        Throwable error = event.getException();
        StringBuffer message = new StringBuffer();
        if (error == null) {
            if (this.errorCount > 0) {
                message.append(StringUtils.LINE_SEP);
                message.append(this.getBuildFailedMessage());
                message.append(StringUtils.LINE_SEP);
            } else {
                message.append(StringUtils.LINE_SEP);
                message.append(this.getBuildSuccessfulMessage());
            }
        } else {
            message.append(StringUtils.LINE_SEP);
            message.append(this.getBuildFailedMessage());
            message.append(StringUtils.LINE_SEP);
            while (error instanceof BuildException) {
                Throwable cause = ((BuildException)error).getCause();
                if (cause == null || !cause.toString().equals(error.getMessage())) break;
                error = cause;
            }
            if (3 <= this.msgOutputLevel || !(error instanceof BuildException)) {
                message.append(StringUtils.getStackTrace((Throwable)error));
            } else {
                message.append(error.toString()).append(lSep);
            }
        }
        message.append(StringUtils.LINE_SEP);
        message.append("Total time: ");
        message.append(IBMiAntLogger.formatTime((long)(System.currentTimeMillis() - this.buildStartTime)));
        String msg = message.toString();
        if (error == null && this.errorCount <= 0) {
            this.printMessage(msg, this.out, 3);
        } else {
            this.printMessage(msg, this.err, 0);
        }
        this.log(msg);
    }

    public void buildStarted(BuildEvent event) {
        super.buildStarted(event);
        this.buildStartTime = System.currentTimeMillis();
    }
}

