/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teampdp.synchronization.ui.view;

import com.ibm.pdp.generation.manager.GenerationCache;
import com.ibm.pdp.generation.manager.GenerationCacheController;
import com.ibm.pdp.generation.manager.view.GenerationManagerView;
import com.ibm.pdp.server.repository.PTRepositoryManager;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.teampdp.synchronization.ui.model.DeactivateDesynchronizationItem;
import com.ibm.teampdp.synchronization.ui.model.DeactivateDesynchronizationManager;
import com.ibm.teampdp.synchronization.ui.view.Messages;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

public class GenerationCacheRefreshAction
extends Action
implements IViewActionDelegate {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2014, 2017.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private IViewPart _view;
    public static final String _ID = String.valueOf(GenerationCacheRefreshAction.class.getName()) + "_ID";
    public static Job job;

    public void run(IAction arg0) {
        if (job != null) {
            job.cancel();
            job = null;
        }
        Job newJob = new Job(Messages.GenerationCacheRefreshAction_Create_cache){

            public IStatus run(IProgressMonitor monitor) {
                ArrayList cacheDatas;
                ITeamRepository teamRepository = PTRepositoryManager.getTeamRepository();
                if (teamRepository != null) {
                    try {
                        List<DeactivateDesynchronizationItem> list = DeactivateDesynchronizationManager.getManager().load((IProgressMonitor)new NullProgressMonitor());
                        DeactivateDesynchronizationManager.getManager().buildEquivalentCache(list.iterator());
                    }
                    catch (Throwable throwable) {}
                }
                job = this;
                boolean refresh = true;
                GenerationCache gc = GenerationCacheController.getCache();
                if (gc != null && (cacheDatas = gc.getGenerationCacheDatas()) != null && cacheDatas.size() != 0) {
                    refresh = false;
                }
                GenerationCacheController.createGenerationCacheDatas((IProgressMonitor)monitor);
                if (job == this) {
                    job = null;
                }
                class RefreshViewRunnable
                implements Runnable {
                    boolean resizeColumn = false;

                    public RefreshViewRunnable(boolean resizeColumn) {
                        this.resizeColumn = resizeColumn;
                    }

                    @Override
                    public void run() {
                        if (GenerationCacheRefreshAction.this._view instanceof GenerationManagerView) {
                            ((GenerationManagerView)GenerationCacheRefreshAction.this._view).sort();
                            ((GenerationManagerView)GenerationCacheRefreshAction.this._view).refresh(this.resizeColumn);
                        }
                    }
                }
                Display.getDefault().asyncExec((Runnable)new RefreshViewRunnable(refresh));
                return Status.OK_STATUS;
            }
        };
        newJob.setUser(true);
        newJob.schedule();
    }

    public void selectionChanged(IAction arg0, ISelection arg1) {
    }

    public void init(IViewPart view) {
        this.setAccelerator(0x100000E);
        this._view = view;
    }
}

