/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teampdp.synchronization.ui.view;

import com.ibm.pdp.explorer.view.service.PTWidgetTool;
import com.ibm.pdp.server.repository.PTRepositoryManager;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.teampdp.synchronization.ui.model.DeactivateDesynchronizationDesignStateIDs;
import com.ibm.teampdp.synchronization.ui.model.DeactivateDesynchronizationManager;
import com.ibm.teampdp.synchronization.ui.model.DeactivateDesynchronizatonError;
import com.ibm.teampdp.synchronization.ui.view.DeactivateDesynchronizationWizardPage;
import com.ibm.teampdp.synchronization.ui.view.Messages;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class DeactivateDesynchronizationWizardPageModifiedDesigns
extends WizardPage {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2017.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private ListViewer _listViewer = null;
    private boolean areDataInitialized = false;
    private List<DeactivateDesynchronizationDesignStateIDs> allDesignStateIds;
    private List<String> changesetsUUIDs = null;
    private List<DeactivateDesynchronizatonError> dde = null;
    private TreeSet<String> modifiedDesigns = null;
    private TreeSet<String> genSuperRefs = null;

    public void setDataInitialized(boolean areDataInitialized) {
        this.areDataInitialized = areDataInitialized;
    }

    public TreeSet<String> getGenSuperRefs() {
        return this.genSuperRefs;
    }

    protected DeactivateDesynchronizationWizardPageModifiedDesigns(String pageName) {
        super(pageName);
        this.setTitle(Messages.DeactivateDesynchronizationWizardPageModifiedDesigns_modified_designs);
        this.setDescription(Messages.DeactivateDesynchronizationWizardPageModifiedDesigns_List_of_modified);
    }

    public void createControl(Composite parent) {
        Composite composite = PTWidgetTool.createComposite((Composite)parent, (int)1, (boolean)false);
        this._listViewer = new ListViewer(composite, 2816);
        GridData gridData2 = new GridData(4, 4, true, true);
        this._listViewer.getList().setLayoutData((Object)gridData2);
        this.setControl((Control)composite);
        this._listViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible && !this.areDataInitialized) {
            this.areDataInitialized = true;
            DeactivateDesynchronizationWizardPage previousPage = (DeactivateDesynchronizationWizardPage)this.getPreviousPage();
            IWorkItem workItem = previousPage.getWorkItem();
            IWorkspace stream = previousPage.getStream();
            this.updateModifiedDesigns(workItem, stream);
        }
    }

    private void updateModifiedDesigns(final IWorkItem workItem, final IWorkspace stream) {
        this.modifiedDesigns = new TreeSet();
        this.genSuperRefs = new TreeSet();
        this.changesetsUUIDs = new ArrayList<String>();
        this.dde = new ArrayList<DeactivateDesynchronizatonError>();
        ITeamRepository repo = PTRepositoryManager.getTeamRepository();
        if (repo == null) {
            throw new RuntimeException(Messages.DeactivateDesynchronizationWizardPageModifiedDesigns_Sever_connection_lost);
        }
        Job newJob = new Job("Analyzing work item."){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    DeactivateDesynchronizationWizardPageModifiedDesigns.this.allDesignStateIds = DeactivateDesynchronizationManager.analyze(workItem, stream, DeactivateDesynchronizationWizardPageModifiedDesigns.this.modifiedDesigns, DeactivateDesynchronizationWizardPageModifiedDesigns.this.genSuperRefs, monitor, true, DeactivateDesynchronizationWizardPageModifiedDesigns.this.changesetsUUIDs, null, DeactivateDesynchronizationWizardPageModifiedDesigns.this.dde);
                    if (DeactivateDesynchronizationWizardPageModifiedDesigns.this.allDesignStateIds == null || DeactivateDesynchronizationWizardPageModifiedDesigns.this.allDesignStateIds.size() == 0) {
                        DeactivateDesynchronizatonError error = new DeactivateDesynchronizatonError(true, Messages.DeactivateDesynchronizationWizardPageModifiedDesigns_Modified_design_not_found);
                        DeactivateDesynchronizationWizardPageModifiedDesigns.this.dde.add(error);
                    }
                }
                catch (TeamRepositoryException e) {
                    e.printStackTrace();
                }
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        DeactivateDesynchronizationWizardPageModifiedDesigns.this._listViewer.setInput((Object)DeactivateDesynchronizationWizardPageModifiedDesigns.this.modifiedDesigns);
                        DeactivateDesynchronizationWizardPageModifiedDesigns.this._listViewer.refresh();
                    }
                });
                return Status.OK_STATUS;
            }
        };
        newJob.setUser(true);
        newJob.schedule();
    }

    public List<DeactivateDesynchronizationDesignStateIDs> getAllDesignStateIds() {
        return this.allDesignStateIds;
    }

    public List<String> getChangesetsUUIDs() {
        return this.changesetsUUIDs;
    }

    public List<DeactivateDesynchronizatonError> getErrors() {
        return this.dde;
    }
}

