/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teampdp.synchronization.ui.view;

import com.ibm.pdp.explorer.view.service.PTWidgetTool;
import com.ibm.team.filesystem.ui.WORKSPACES_OR_STREAMS;
import com.ibm.team.filesystem.ui.WorkspaceAndStreamSelectionDialog;
import com.ibm.team.filesystem.ui.WorkspaceAndStreamSelectionDialogOptions;
import com.ibm.team.filesystem.ui.wrapper.AbstractPlaceWrapper;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.rcp.ui.workitempicker.WorkItemSelectionDialog;
import com.ibm.teampdp.synchronization.ui.model.DeactivateDesynchronizationItem;
import com.ibm.teampdp.synchronization.ui.model.DeactivateDesynchronizationManager;
import com.ibm.teampdp.synchronization.ui.view.DeactivateDesynchronizationWizard;
import com.ibm.teampdp.synchronization.ui.view.DeactivateDesynchronizationWizardPageModifiedDesigns;
import com.ibm.teampdp.synchronization.ui.view.Messages;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class DeactivateDesynchronizationWizardPage
extends WizardPage {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2017.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Button _chooseStreamButton;
    private Button _chooseWorkItemButton;
    private Text _workItemText;
    private Text _streamText;
    private IWorkItem _workItem;
    private IWorkspace _stream;
    private ITeamRepository repo;
    private DeactivateDesynchronizationManager _ddm;

    protected DeactivateDesynchronizationWizardPage(String pageName, DeactivateDesynchronizationManager ddm) {
        super(pageName);
        this._ddm = ddm;
        this.setTitle(Messages.DeactivateDesynchronizationWizardPage_Create_a_new_item);
    }

    public void createControl(Composite parent) {
        Composite composite = PTWidgetTool.createComposite((Composite)parent, (int)1, (boolean)false);
        this.createBaseGroup(composite);
        this.setControl((Control)composite);
    }

    protected void createBaseGroup(Composite parent) {
        Composite composite = PTWidgetTool.createComposite((Composite)parent, (int)3, (boolean)false);
        GridData gridData = (GridData)composite.getLayoutData();
        gridData.grabExcessVerticalSpace = true;
        PTWidgetTool.createLabel((Composite)composite, (String)Messages.DeactivateDesynchronizationWizardPage_Work_item);
        this._workItemText = PTWidgetTool.createTextField((Composite)composite, (boolean)false, (boolean)true);
        this._chooseWorkItemButton = PTWidgetTool.createPushButton((Composite)composite, (String)"...", (boolean)true);
        this.addSelectionListener(this._chooseWorkItemButton);
        PTWidgetTool.createLabel((Composite)composite, (String)Messages.DeactivateDesynchronizationWizardPage_Stream);
        this._streamText = PTWidgetTool.createTextField((Composite)composite, (boolean)false, (boolean)true);
        this._chooseStreamButton = PTWidgetTool.createPushButton((Composite)composite, (String)"...", (boolean)true);
        this.addSelectionListener(this._chooseStreamButton);
    }

    protected void addSelectionListener(Button pbControl) {
        pbControl.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DeactivateDesynchronizationWizardPage.this.handleButtonSelected(e);
            }
        });
    }

    protected void handleButtonSelected(SelectionEvent e) {
        if (e.widget == this._chooseWorkItemButton) {
            final IWorkItemHandle workItemHandle = WorkItemSelectionDialog.getWorkItem((Shell)Display.getDefault().getActiveShell());
            if (workItemHandle == null) {
                return;
            }
            ((DeactivateDesynchronizationWizardPageModifiedDesigns)this.getNextPage()).setDataInitialized(false);
            this.repo = (ITeamRepository)workItemHandle.getOrigin();
            Job newJob = new Job("Retrieve work item"){

                public IStatus run(IProgressMonitor monitor) {
                    ITeamRepository repo = (ITeamRepository)workItemHandle.getOrigin();
                    try {
                        final IWorkItem workItem = (IWorkItem)repo.itemManager().fetchCompleteItem((IItemHandle)workItemHandle, 1, (IProgressMonitor)new NullProgressMonitor());
                        DeactivateDesynchronizationWizardPage.this._workItem = workItem;
                        Display.getDefault().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                DeactivateDesynchronizationWizardPage.this._workItemText.setText("[" + workItem.getId() + "] " + workItem.getHTMLSummary().getPlainText());
                                DeactivateDesynchronizationWizardPage.this.setPageComplete(DeactivateDesynchronizationWizardPage.this.isPageComplete());
                            }
                        });
                    }
                    catch (TeamRepositoryException e1) {
                        e1.printStackTrace();
                    }
                    return Status.OK_STATUS;
                }
            };
            newJob.setUser(true);
            newJob.schedule();
        } else if (e.widget == this._chooseStreamButton && this.repo != null) {
            WorkspaceAndStreamSelectionDialogOptions options = new WorkspaceAndStreamSelectionDialogOptions();
            options.setShowWorkspaces(WORKSPACES_OR_STREAMS.STREAMS);
            options.setShowWorkspacesRadio(false);
            options.setForceRepo(false);
            options.setTarget(null);
            options.setComponents(null);
            options.setExactOwnerName(null);
            options.setFilter(null);
            IWorkspace stream = null;
            AbstractPlaceWrapper streamWrapper = WorkspaceAndStreamSelectionDialog.getWorkspaceOrStream((Shell)Display.getDefault().getActiveShell(), (ITeamRepository)this.repo, (WorkspaceAndStreamSelectionDialogOptions)options);
            if (streamWrapper != null) {
                ((DeactivateDesynchronizationWizardPageModifiedDesigns)this.getNextPage()).setDataInitialized(false);
                ITeamRepository repo2 = streamWrapper.getRepository();
                stream = streamWrapper.getWorkspace();
                if (repo2 != null && stream != null && stream.isStream()) {
                    this._stream = stream;
                    this._streamText.setText(stream.getName());
                    this.setPageComplete(this.isPageComplete());
                }
            }
        }
    }

    public IWorkItem getWorkItem() {
        return this._workItem;
    }

    public IWorkspace getStream() {
        return this._stream;
    }

    public boolean isPageComplete() {
        if (this._workItem == null) {
            String message = Messages.DeactivateDesynchronizationWizardPage_Missing_work_item;
            this.setErrorMessage(message);
            return false;
        }
        if (this._stream == null) {
            String message = Messages.DeactivateDesynchronizationWizardPage_Missing_stream;
            this.setErrorMessage(message);
            return false;
        }
        DeactivateDesynchronizationItem ddi = ((DeactivateDesynchronizationWizard)this.getWizard()).createItem();
        if (this._ddm.getItems().contains(ddi)) {
            String message = Messages.DeactivateDesynchronizationWizardPage_This_workitem_already_exist;
            this.setErrorMessage(message);
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }
}

