/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teampdp.synchronization.ui.view;

import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.teampdp.synchronization.ui.model.DeactivateDesynchronizationDesignStateIDs;
import com.ibm.teampdp.synchronization.ui.model.DeactivateDesynchronizationItem;
import com.ibm.teampdp.synchronization.ui.model.DeactivateDesynchronizationManager;
import com.ibm.teampdp.synchronization.ui.model.DeactivateDesynchronizatonError;
import com.ibm.teampdp.synchronization.ui.view.DeactivateDesynchronizationWizardPage;
import com.ibm.teampdp.synchronization.ui.view.DeactivateDesynchronizationWizardPageGenSuperRefs;
import com.ibm.teampdp.synchronization.ui.view.DeactivateDesynchronizationWizardPageModifiedDesigns;
import com.ibm.teampdp.synchronization.ui.view.Messages;
import java.util.List;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;

public class DeactivateDesynchronizationWizard
extends Wizard {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2017.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private DeactivateDesynchronizationWizardPage page;
    private DeactivateDesynchronizationWizardPageModifiedDesigns page2;
    private DeactivateDesynchronizationWizardPageGenSuperRefs page3;
    private DeactivateDesynchronizationManager _ddm;
    private DeactivateDesynchronizationItem newItem;

    public DeactivateDesynchronizationItem getNewItem() {
        return this.newItem;
    }

    public DeactivateDesynchronizationWizard(DeactivateDesynchronizationManager ddm) {
        this.setWindowTitle(Messages.DeactivateDesynchronizationWizard_New_desynchronization_item);
        this._ddm = ddm;
    }

    public boolean performFinish() {
        DeactivateDesynchronizationItem ddi = this.createItem();
        this._ddm.addNewItem(ddi);
        this.newItem = ddi;
        return true;
    }

    public void addPages() {
        this.page = new DeactivateDesynchronizationWizardPage("deactivateDesynchronizationPage", this._ddm);
        this.addPage((IWizardPage)this.page);
        this.page2 = new DeactivateDesynchronizationWizardPageModifiedDesigns("modifiedDesignsPage");
        this.addPage((IWizardPage)this.page2);
        this.page3 = new DeactivateDesynchronizationWizardPageGenSuperRefs("generatedFileSuperRef");
        this.addPage((IWizardPage)this.page3);
    }

    DeactivateDesynchronizationItem createItem() {
        IWorkItem workItem = this.page.getWorkItem();
        int workItemNumber = workItem.getId();
        String workItemSummary = workItem.getHTMLSummary().getPlainText();
        String workItemUUID = workItem.getItemId().getUuidValue();
        IWorkspace stream = this.page.getStream();
        String streamTitle = stream.getName();
        String streamUUID = stream.getItemId().getUuidValue();
        List<DeactivateDesynchronizationDesignStateIDs> dddStateIDs = this.page2.getAllDesignStateIds();
        List<String> changesetUUIDs = this.page2.getChangesetsUUIDs();
        List<DeactivateDesynchronizatonError> errors = this.page2.getErrors();
        DeactivateDesynchronizationItem ddItem = new DeactivateDesynchronizationItem(workItemNumber, workItemSummary, workItemUUID, streamTitle, streamUUID);
        if (dddStateIDs == null) {
            ddItem.setToComplete(true);
        } else {
            ddItem.getChangeSetUUIDs().clear();
            for (String uuid : changesetUUIDs) {
                ddItem.getChangeSetUUIDs().add(uuid);
            }
            if (errors != null && errors.size() != 0) {
                ddItem.setError(errors.get(0));
            }
            ddItem.getDesignStateIDs().addAll(dddStateIDs);
        }
        return ddItem;
    }
}

