/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teampdp.synchronization.ui.view;

import com.ibm.etools.webtools.flatui.SnappyTableViewer;
import com.ibm.pdp.explorer.plugin.PTExplorerPlugin;
import com.ibm.pdp.explorer.view.service.PTWidgetTool;
import com.ibm.pdp.server.repository.PTRepositoryManager;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.teampdp.synchronization.ui.model.DeactivateDesynchronizationDesignStateIDs;
import com.ibm.teampdp.synchronization.ui.model.DeactivateDesynchronizationItem;
import com.ibm.teampdp.synchronization.ui.model.DeactivateDesynchronizationManager;
import com.ibm.teampdp.synchronization.ui.model.DeactivateDesynchronizatonError;
import com.ibm.teampdp.synchronization.ui.view.DeactivateDesynchronizationItemLabelProvider;
import com.ibm.teampdp.synchronization.ui.view.DeactivateDesynchronizationWizard;
import com.ibm.teampdp.synchronization.ui.view.Messages;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.SortedSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.PlatformUI;

public class DeactivateDesynchronizationDialog
extends TrayDialog {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2017.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String HELP_PLUGIN = "com.ibm.pdp.doc.cshelp";
    private Table _tblTable;
    private SnappyTableViewer _tblViewer;
    private Button _pbAdd;
    private Button _pbDelete;
    private Button _pbFix;
    DeactivateDesynchronizationManager _ddm;
    private final String _WARNING = "_WARNING";
    private final String _WORKITEM = "_WORKITEM";
    private final String _STREAM = "_STREAM";

    public DeactivateDesynchronizationDialog(Shell shell, DeactivateDesynchronizationManager ddm) {
        super(shell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this._ddm = ddm;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.DeactivateDesynchronizationDialog_Desynchronization_dialog);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, this.getContextId());
        composite.setLayout((Layout)new GridLayout(1, false));
        GridData gridData = new GridData(4, 4, true, true);
        gridData.widthHint = 800;
        composite.setLayoutData((Object)gridData);
        this.createDesactivationGroup(composite);
        this.createMessageComposite(composite);
        this.setupData();
        return composite;
    }

    private String getContextId() {
        return "com.ibm.pdp.doc.cshelp.desactivation";
    }

    private void createDesactivationGroup(Composite parent) {
        String grpLabel = Messages.DeactivateDesynchronizationDialog_WorkItem_and_scope;
        Group group = PTWidgetTool.createGroup((Composite)parent, (int)2, (int)1, (String)grpLabel);
        GridData gridData = new GridData(4, 4, true, true);
        group.setLayoutData((Object)gridData);
        this._tblTable = PTWidgetTool.createTable((Composite)group, (int)67586);
        String[] headers = new String[]{" " + Messages.DeactivateDesynchronizationDialog_Error_warning, " " + Messages.DeactivateDesynchronizationDialog_Work_item, " " + Messages.DeactivateDesynchronizationDialog_Stream};
        int i = 0;
        while (i < headers.length) {
            TableColumn column = new TableColumn(this._tblTable, 0);
            column.setText(headers[i]);
            if (i == 0) {
                column.setWidth(100);
            } else if (i == 1) {
                column.setWidth(200);
            } else {
                column.setWidth(400);
            }
            ++i;
        }
        gridData = new GridData(4, 4, true, true);
        gridData.heightHint = 300;
        this._tblTable.setLayoutData((Object)gridData);
        this._tblViewer = new SnappyTableViewer(this._tblTable);
        String[] columnProperties = new String[]{"_WARNING", "_WORKITEM", "_STREAM"};
        this._tblViewer.setColumnProperties(columnProperties);
        this._tblViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this._tblViewer.setLabelProvider((IBaseLabelProvider)new DeactivateDesynchronizationItemLabelProvider());
        this._tblTable.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 127) {
                    DeactivateDesynchronizationDialog.this.deleteDesactivationSynch();
                }
            }
        });
        this._tblViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                DeactivateDesynchronizationDialog.this.setCellEditor();
                DeactivateDesynchronizationDialog.this.refreshButtons();
            }
        });
        this.createRightButtonsComposite((Composite)group);
    }

    private void createRightButtonsComposite(Composite parent) {
        Composite composite = PTWidgetTool.createComposite((Composite)parent, (int)1, (int)1, (boolean)false);
        GridData gridData = new GridData(4, 128, false, true);
        composite.setLayoutData((Object)gridData);
        this._pbAdd = this.createButton(composite, "list_add", Messages.DeactivateDesynchronizationDialog_Add);
        this._pbDelete = this.createButton(composite, "list_delete", Messages.DeactivateDesynchronizationDialog_Delete);
        this._pbFix = new Button(composite, 0);
        this._pbFix.setToolTipText(Messages.DeactivateDesynchronizationDialog_Update);
        this._pbFix.setImage(PTExplorerPlugin.getDefault().getImage("refresh"));
        this.addSelectionListener(this._pbFix);
    }

    private Button createButton(Composite parent, String imageKey, String tooltip) {
        Button pbButton = new Button(parent, 0);
        pbButton.setToolTipText(tooltip);
        pbButton.setImage(PTExplorerPlugin.getDefault().getImage(imageKey));
        this.addSelectionListener(pbButton);
        return pbButton;
    }

    private void createMessageComposite(Composite parent) {
        Composite composite = PTWidgetTool.createComposite((Composite)parent, (int)2, (int)2, (boolean)false);
        GridData gridData = new GridData(4, 3, true, false);
        composite.setLayoutData((Object)gridData);
    }

    private void addSelectionListener(Button pbControl) {
        pbControl.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.widget == DeactivateDesynchronizationDialog.this._pbAdd) {
                    DeactivateDesynchronizationDialog.this.addDesactivationSynch();
                } else if (e.widget == DeactivateDesynchronizationDialog.this._pbDelete) {
                    DeactivateDesynchronizationDialog.this.deleteDesactivationSynch();
                } else if (e.widget == DeactivateDesynchronizationDialog.this._pbFix) {
                    DeactivateDesynchronizationDialog.this.fix();
                }
            }
        });
    }

    private void addDesactivationSynch() {
        DeactivateDesynchronizationWizard wizard = new DeactivateDesynchronizationWizard(this._ddm);
        WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
        dialog.open();
        DeactivateDesynchronizationItem ddi = wizard.getNewItem();
        if (ddi != null) {
            ArrayList<DeactivateDesynchronizationItem> list = new ArrayList<DeactivateDesynchronizationItem>();
            list.add(ddi);
            this.analyseDesactivateItem(list, false);
        }
    }

    private void analyseDesactivateItem(Collection<DeactivateDesynchronizationItem> ddiList, boolean checkChangeSetNumber) {
        final ITeamRepository repo = PTRepositoryManager.getTeamRepository();
        if (repo == null) {
            throw new RuntimeException(Messages.DeactivateDesynchronizationDialog_Server_connection_lost);
        }
        if (this.getButton(0) != null) {
            this.getButton(0).setEnabled(false);
        }
        class MyJob
        extends Job {
            private boolean _checkChangeSetNumber;
            private Collection<DeactivateDesynchronizationItem> _ddiList;

            MyJob(String title, Collection<DeactivateDesynchronizationItem> ddiList, boolean checkChangeSetNumber) {
                super(title);
                this._ddiList = ddiList;
                this._checkChangeSetNumber = checkChangeSetNumber;
            }

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    for (DeactivateDesynchronizationItem _ddi : this._ddiList) {
                        String streamUUID = _ddi.getStreamUUID();
                        IItemHandle streamHandle = IWorkspace.ITEM_TYPE.createItemHandle(UUID.valueOf((String)streamUUID), null);
                        String workItemUUID = _ddi.getWorkItemUUID();
                        IItemHandle workItemHandle = IWorkItem.ITEM_TYPE.createItemHandle(UUID.valueOf((String)workItemUUID), null);
                        IWorkItem workItem = (IWorkItem)repo.itemManager().fetchCompleteItem(workItemHandle, 1, (IProgressMonitor)new NullProgressMonitor());
                        IWorkspace wiStream = (IWorkspace)repo.itemManager().fetchCompleteItem(streamHandle, 1, (IProgressMonitor)new NullProgressMonitor());
                        _ddi.setStreamTitle(wiStream.getName());
                        _ddi.setWorkItemNumber(workItem.getId());
                        _ddi.setWorkItemSummary(workItem.getHTMLSummary().getPlainText());
                        ArrayList<String> changeSetsUUIDs = new ArrayList<String>();
                        ArrayList<String> changeSetsToControls = null;
                        if (this._checkChangeSetNumber) {
                            changeSetsToControls = new ArrayList<String>();
                            changeSetsToControls.addAll(_ddi.getChangeSetUUIDs());
                        }
                        ArrayList<DeactivateDesynchronizatonError> errors = new ArrayList<DeactivateDesynchronizatonError>();
                        boolean isToComplete = _ddi.isToComplete();
                        List<DeactivateDesynchronizationDesignStateIDs> dddStateIds = DeactivateDesynchronizationManager.analyze(workItem, wiStream, null, null, monitor, _ddi.isToComplete(), changeSetsUUIDs, changeSetsToControls, errors);
                        if (isToComplete) {
                            _ddi.setToComplete(false);
                            _ddi.getDesignStateIDs().clear();
                            _ddi.getDesignStateIDs().addAll(dddStateIds);
                        }
                        _ddi.getChangeSetUUIDs().clear();
                        _ddi.getChangeSetUUIDs().addAll(changeSetsUUIDs);
                        if (errors.size() != 0) {
                            _ddi.setError((DeactivateDesynchronizatonError)errors.get(0));
                            continue;
                        }
                        if (_ddi.getDesignStateIDs() != null && _ddi.getDesignStateIDs().size() != 0) continue;
                        DeactivateDesynchronizatonError error = new DeactivateDesynchronizatonError(true, Messages.DeactivateDesynchronizationDialog_Modified_design_not_found);
                        _ddi.setError(error);
                    }
                }
                catch (TeamRepositoryException e) {
                    e.printStackTrace();
                }
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (this.getButton(0) != null) {
                            this.getButton(0).setEnabled(true);
                        }
                        _tblViewer.refresh();
                    }
                });
                return Status.OK_STATUS;
            }
        }
        MyJob newJob = new MyJob("Analyze work item.", ddiList, checkChangeSetNumber);
        newJob.setUser(true);
        newJob.schedule();
    }

    private void deleteDesactivationSynch() {
        int beforeIndex;
        int afterIndex = beforeIndex = this._tblTable.getSelectionIndex();
        afterIndex = Math.min(this._tblTable.getItemCount() - this._tblTable.getSelectionCount() - 1, afterIndex);
        IStructuredSelection selection = (IStructuredSelection)this._tblViewer.getSelection();
        if (selection.size() > 0) {
            this._ddm.removeAllSyncItem(selection.toList());
        }
        this._tblViewer.refresh();
        this._tblTable.setSelection(afterIndex);
        this.refreshButtons();
        this.setPerformActionEnabled(this.isDialogComplete());
    }

    private void fix() {
        IStructuredSelection selection = (IStructuredSelection)this._tblViewer.getSelection();
        if (selection.size() > 0) {
            ArrayList<DeactivateDesynchronizationItem> list2 = new ArrayList<DeactivateDesynchronizationItem>();
            List list = selection.toList();
            for (Object object : list) {
                if (!(object instanceof DeactivateDesynchronizationItem)) continue;
                DeactivateDesynchronizationItem ddi = (DeactivateDesynchronizationItem)object;
                ddi.setError(null);
                ddi.setToComplete(true);
                ddi.setModified(true);
                list2.add(ddi);
            }
            this.analyseDesactivateItem(list2, false);
        }
    }

    private void setCellEditor() {
        CellEditor[] cellEditors = new CellEditor[]{new TextCellEditor((Composite)this._tblTable), new TextCellEditor((Composite)this._tblTable), new TextCellEditor((Composite)this._tblTable)};
        this._tblViewer.setCellEditors(cellEditors);
    }

    protected Control createButtonBar(Composite parent) {
        Control control = super.createButtonBar(parent);
        this.setPerformActionEnabled(this.isDialogComplete());
        return control;
    }

    private void refreshButtons() {
    }

    protected void okPressed() {
        Shell shell = this.getShell();
        shell.setCursor(new Cursor((Device)shell.getDisplay(), 1));
        shell.setCursor(null);
        super.okPressed();
    }

    private boolean isDialogComplete() {
        return true;
    }

    private void setPerformActionEnabled(boolean enabled) {
        Button pbOk = this.getButton(0);
        if (pbOk != null) {
            pbOk.setEnabled(enabled);
        }
    }

    private void setupData() {
        this.reinit(this._ddm.getItems());
        this.analyseDesactivateItem(this._ddm.getItems(), true);
        this._tblViewer.setInput(this._ddm.getItems());
        this.refreshButtons();
    }

    private void reinit(SortedSet<DeactivateDesynchronizationItem> items) {
        for (DeactivateDesynchronizationItem ddi : items) {
            ddi.setError(null);
        }
    }
}

