/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teampdp.synchronization.ui.model;

import com.ibm.pdp.explorer.model.service.PTModelService;
import com.ibm.pdp.framework.PdpTool;
import com.ibm.pdp.generation.manager.EquivalentStateIdCache;
import com.ibm.pdp.generation.manager.EquivalentStateIdCacheSerializer;
import com.ibm.pdp.mdl.meta.Reference;
import com.ibm.pdp.resources.PdpResourcesMgr;
import com.ibm.pdp.server.repository.PTRepositoryManager;
import com.ibm.pdp.util.Util;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IFileContentManager;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.common.IFileContent;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.foundation.common.util.Adapters;
import com.ibm.team.links.client.ILinkManager;
import com.ibm.team.links.common.IItemReference;
import com.ibm.team.links.common.ILink;
import com.ibm.team.links.common.ILinkCollection;
import com.ibm.team.links.common.IReference;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IConfiguration;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.common.ComponentNotInWorkspaceException;
import com.ibm.team.scm.common.IChange;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFlowNodeHandle;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.dto.IAncestorReport;
import com.ibm.team.scm.common.dto.ILocateChangeSetsSearchCriteria;
import com.ibm.team.scm.common.dto.ILocateChangeSetsSearchResult;
import com.ibm.team.scm.common.dto.INameItemPair;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.teampdp.synchronization.bean.SyncItemBean;
import com.ibm.teampdp.synchronization.bean.SyncStateBean;
import com.ibm.teampdp.synchronization.client.ISynchronizationClient;
import com.ibm.teampdp.synchronization.client.SynchronizationClientFactory;
import com.ibm.teampdp.synchronization.ui.model.DeactivateDesynchronizationDesignStateIDs;
import com.ibm.teampdp.synchronization.ui.model.DeactivateDesynchronizationItem;
import com.ibm.teampdp.synchronization.ui.model.DeactivateDesynchronizatonError;
import com.ibm.teampdp.synchronization.ui.model.Messages;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;

public class DeactivateDesynchronizationManager {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2017.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static DeactivateDesynchronizationManager ddm;
    private SortedSet<DeactivateDesynchronizationItem> items;
    private Set<DeactivateDesynchronizationItem> itemsToDelete;

    public static DeactivateDesynchronizationManager getManager() {
        if (ddm == null) {
            ddm = new DeactivateDesynchronizationManager();
        }
        return ddm;
    }

    public SortedSet<DeactivateDesynchronizationItem> getItems() {
        if (this.items == null) {
            this.items = new TreeSet<DeactivateDesynchronizationItem>();
        }
        return this.items;
    }

    public static List<DeactivateDesynchronizationDesignStateIDs> analyze(IWorkItem workItem, IWorkspace stream, TreeSet<String> modifiedDesigns, TreeSet<String> genSuperRefs, IProgressMonitor monitor, boolean computeStateIDs, List<String> changeSetsUUIDs, List<String> toControlChangeSetsUUIDs, List<DeactivateDesynchronizatonError> errors) throws TeamRepositoryException {
        List<DeactivateDesynchronizationDesignStateIDs> results = new ArrayList<DeactivateDesynchronizationDesignStateIDs>();
        if (workItem == null) {
            if (errors != null) {
                errors.clear();
                errors.add(new DeactivateDesynchronizatonError(false, Messages.DeactivateDesynchronizationManager_Work_item_not_found));
            }
            return results;
        }
        if (stream == null) {
            if (errors != null) {
                errors.clear();
                errors.add(new DeactivateDesynchronizatonError(false, Messages.DeactivateDesynchronizationManager_Stream_not_found));
            }
            return results;
        }
        ITeamRepository repo = PTRepositoryManager.getTeamRepository();
        if (repo == null) {
            throw new RuntimeException(Messages.DeactivateDesynchronizationManager_Server_connection_lost);
        }
        List<IChangeSetHandle> changeSetHandlesInStream = DeactivateDesynchronizationManager.findChangeSetHandlesFromWorkItemAndFromStream(workItem, stream, monitor, repo);
        if (changeSetHandlesInStream == null || changeSetHandlesInStream.size() == 0) {
            if (errors != null) {
                errors.clear();
                errors.add(new DeactivateDesynchronizatonError(true, Messages.DeactivateDesynchronizationManager_No_change_set_in_stream));
            }
            return results;
        }
        if (toControlChangeSetsUUIDs != null && changeSetsUUIDs == null) {
            changeSetsUUIDs = new ArrayList<String>();
        }
        if (changeSetsUUIDs != null) {
            for (IChangeSetHandle changeSetHandle : changeSetHandlesInStream) {
                changeSetsUUIDs.add(changeSetHandle.getItemId().getUuidValue());
            }
        }
        if (toControlChangeSetsUUIDs != null) {
            DeactivateDesynchronizationManager.controlChangeSetsUUIDs(changeSetsUUIDs, toControlChangeSetsUUIDs, errors);
            return null;
        }
        IItemManager itemManager = repo.itemManager();
        List changeSets = itemManager.fetchCompleteItems(changeSetHandlesInStream, 0, monitor);
        IWorkspaceManager workspaceManager = (IWorkspaceManager)repo.getClientLibrary(IWorkspaceManager.class);
        for (IChangeSet cs : changeSets) {
            for (Object o : cs.changes()) {
                IChange change = (IChange)o;
                if (change.kind() != 2) continue;
                IPath afterPath = DeactivateDesynchronizationManager.getFullPathForChange(stream, monitor, workspaceManager, cs, change);
                IVersionableHandle before = change.beforeState();
                IVersionableHandle after = change.afterState();
                ArrayList<IVersionableHandle> versionableHandleList = new ArrayList<IVersionableHandle>();
                versionableHandleList.add(before);
                versionableHandleList.add(after);
                List versionableList = workspaceManager.versionableManager().fetchCompleteStates(versionableHandleList, monitor);
                String stateIdBefore = null;
                String stateIdAfter = null;
                String designUUID = null;
                boolean nextChange = false;
                for (IVersionable iVersionable : versionableList) {
                    IFileItem fileItem;
                    String fileName;
                    int dotIndex;
                    if (!iVersionable.hasFullState() || (dotIndex = (fileName = (fileItem = (IFileItem)iVersionable.getFullState()).getName()).lastIndexOf(".")) == -1) continue;
                    String type = fileName.substring(dotIndex + 1);
                    if (!PTModelService.accept((String)type)) {
                        nextChange = true;
                        break;
                    }
                    if (!computeStateIDs) continue;
                    if (iVersionable.getStateId().equals((Object)before.getStateId())) {
                        stateIdBefore = DeactivateDesynchronizationManager.getStateID(monitor, repo, fileItem);
                        continue;
                    }
                    designUUID = fileItem.getItemId().getUuidValue();
                    if (modifiedDesigns != null) {
                        modifiedDesigns.add(afterPath.toString());
                    }
                    if (genSuperRefs != null) {
                        String fullName = afterPath.toString();
                        String logicalName = PdpTool.removeRPPFolderFromFileName((String)fullName);
                        Iterator superReferences = PdpResourcesMgr.getInstance().getGenerationSuperReferences(logicalName);
                        while (superReferences.hasNext()) {
                            Reference reference = (Reference)superReferences.next();
                            String generatedFile = reference.getSourceId();
                            if (generatedFile.indexOf("/%") != -1) {
                                generatedFile = generatedFile.substring(generatedFile.indexOf("/%") + 2);
                            }
                            genSuperRefs.add(generatedFile);
                        }
                    }
                    stateIdAfter = DeactivateDesynchronizationManager.getStateID(monitor, repo, fileItem);
                }
                if (nextChange || !computeStateIDs) continue;
                String designID = afterPath.toString();
                DeactivateDesynchronizationDesignStateIDs dddsi = new DeactivateDesynchronizationDesignStateIDs(designID, designUUID, stateIdBefore, stateIdAfter);
                results.add(dddsi);
            }
        }
        results = DeactivateDesynchronizationManager.compress(results);
        return results;
    }

    public boolean buildEquivalentCache(Iterator<DeactivateDesynchronizationItem> iter) {
        class MyJob
        extends Job {
            private Iterator<DeactivateDesynchronizationItem> _iter;

            MyJob(String s) {
                super(s);
            }

            public void setList(Iterator<DeactivateDesynchronizationItem> iter) {
                this._iter = iter;
            }

            protected IStatus run(IProgressMonitor monitor) {
                DeactivateDesynchronizationManager.this._buildEquivalentCache(this._iter);
                return Status.OK_STATUS;
            }
        }
        MyJob newJob = new MyJob("Create design equivalent cache");
        newJob.setList(iter);
        newJob.setUser(true);
        newJob.schedule();
        try {
            newJob.join();
        }
        catch (InterruptedException ie) {
            throw Util.rethrow((Throwable)ie);
        }
        return true;
    }

    private boolean _buildEquivalentCache(Iterator<DeactivateDesynchronizationItem> iter) {
        EquivalentStateIdCache esIdCache = new EquivalentStateIdCache();
        Iterator<DeactivateDesynchronizationItem> ddItemsIterator = iter;
        while (ddItemsIterator.hasNext()) {
            DeactivateDesynchronizationItem deactivateDesynchronizationItem = ddItemsIterator.next();
            String streamUUID = deactivateDesynchronizationItem.getStreamUUID();
            String workItemUUID = deactivateDesynchronizationItem.getWorkItemUUID();
            IWorkItem workItem = this.getWorkItem(workItemUUID);
            int workItemNumber = workItem.getId();
            deactivateDesynchronizationItem.setWorkItemNumber(workItemNumber);
            for (SyncStateBean syncStateBean : deactivateDesynchronizationItem.getDesignStateIDs()) {
                IFlowNodeHandle streamHandle;
                String designId = syncStateBean.getDesignID();
                IWorkspaceHandle workspace = this.getRepositoryWorkspaceFor(designId);
                if (workspace == null || (streamHandle = this.getStreamHandleFor(workspace)) == null || !streamHandle.getItemId().getUuidValue().equals(streamUUID)) continue;
                String workItemTitle = workItem.getHTMLSummary().getPlainText();
                esIdCache.addEquivalentStateId(designId, syncStateBean.getStateIdBefore(), syncStateBean.getStateIdAfter(), workItemNumber, workItemTitle);
            }
        }
        EquivalentStateIdCache.setCurrentEquivalentStateIdCache((EquivalentStateIdCache)esIdCache);
        EquivalentStateIdCacheSerializer serializer = new EquivalentStateIdCacheSerializer();
        serializer.serialize(esIdCache, EquivalentStateIdCacheSerializer.getDefaultEquivalentStateIdCacheFileName());
        return true;
    }

    private IWorkItem getWorkItem(String workItemUUID) {
        IWorkItem workItem = null;
        IItemHandle workItemHandle = IWorkItem.ITEM_TYPE.createItemHandle(UUID.valueOf((String)workItemUUID), null);
        ITeamRepository repo = PTRepositoryManager.getTeamRepository();
        try {
            workItem = (IWorkItem)repo.itemManager().fetchCompleteItem(workItemHandle, 1, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (TeamRepositoryException e) {
            Util.rethrow((Throwable)e);
        }
        return workItem;
    }

    private IFlowNodeHandle getStreamHandleFor(IWorkspaceHandle workspace) {
        IFlowNodeHandle streamHandle = null;
        ITeamRepository repo = PTRepositoryManager.getTeamRepository();
        IWorkspaceManager workspaceManager = (IWorkspaceManager)repo.getClientLibrary(IWorkspaceManager.class);
        try {
            IWorkspaceConnection connection = workspaceManager.getWorkspaceConnection(workspace, null);
            connection.getName();
            streamHandle = connection.getFlowTable().getCurrentAcceptFlow().getFlowNode();
        }
        catch (TeamRepositoryException e) {
            Util.rethrow((Throwable)e);
        }
        return streamHandle;
    }

    private IWorkspaceHandle getRepositoryWorkspaceFor(String designId) {
        IResource resource2;
        Path path = new Path(designId);
        IFile designResource = PdpTool.getFile((IPath)path);
        if (!designResource.exists()) {
            return null;
        }
        IWorkspaceHandle workspace = null;
        IShareable shareable = (IShareable)Adapters.getAdapter((Object)designResource, IShareable.class);
        if (shareable == null && (resource2 = (IResource)Adapters.getAdapter((Object)designResource, IResource.class)) != null) {
            shareable = (IShareable)resource2.getAdapter(IShareable.class);
        }
        if (shareable != null) {
            ISharingDescriptor descriptor = null;
            try {
                descriptor = shareable.getShare(null).getSharingDescriptor();
            }
            catch (FileSystemException e) {
                Util.rethrow((Throwable)e);
            }
            workspace = (IWorkspaceHandle)descriptor.getConnectionHandle();
        }
        return workspace;
    }

    private static void controlChangeSetsUUIDs(List<String> changeSetsUUIDs, List<String> toControlChangeSetsUUIDs, List<DeactivateDesynchronizatonError> errors) {
        ArrayList<String> addedChangedSets = new ArrayList<String>();
        ArrayList<String> removedChangedSets = new ArrayList<String>();
        for (String toControl : toControlChangeSetsUUIDs) {
            if (changeSetsUUIDs.contains(toControl)) continue;
            removedChangedSets.add(toControl);
        }
        for (String changeSet : changeSetsUUIDs) {
            if (toControlChangeSetsUUIDs.contains(changeSet)) continue;
            addedChangedSets.add(changeSet);
        }
        if (removedChangedSets.size() == 0 && addedChangedSets.size() == 0) {
            return;
        }
        String message = String.valueOf(removedChangedSets.size() != 0 ? NLS.bind((String)Messages.DeactivateDesynchronizationManager_removed, (Object[])new Object[]{removedChangedSets.size()}) : "") + (addedChangedSets.size() != 0 ? NLS.bind((String)Messages.DeactivateDesynchronizationManager_added, (Object[])new Object[]{addedChangedSets.size()}) : "");
        errors.add(new DeactivateDesynchronizatonError(true, String.valueOf(Messages.DeactivateDesynchronizationManager_some_changeset_added_removed) + message));
    }

    protected static String getStateID(IProgressMonitor monitor, ITeamRepository repo, IFileItem fileItem) throws TeamRepositoryException {
        IFileContent content = fileItem.getContent();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        IFileContentManager contentManager = FileSystemCore.getContentManager((ITeamRepository)repo);
        contentManager.retrieveContent((IFileItemHandle)fileItem, content, (OutputStream)outputStream, monitor);
        String readContent = outputStream.toString();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(readContent.getBytes());
        try {
            return PTModelService.getStateId((InputStream)inputStream);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    protected static IPath getFullPathForChange(IWorkspace stream, IProgressMonitor monitor, IWorkspaceManager workspaceManager, IChangeSet cs, IChange change) throws TeamRepositoryException, ItemNotFoundException, ComponentNotInWorkspaceException {
        IWorkspaceConnection connection = workspaceManager.getWorkspaceConnection((IWorkspaceHandle)stream, null);
        IComponentHandle componentHandle = cs.getComponent();
        IConfiguration configuration = connection.configuration(componentHandle);
        ArrayList<IVersionableHandle> afterHandles = new ArrayList<IVersionableHandle>();
        afterHandles.add(change.afterState());
        List afterAncestors = configuration.determineAncestorsInHistory(afterHandles, monitor);
        IPath afterPath = DeactivateDesynchronizationManager.getFullPath(afterAncestors);
        return afterPath;
    }

    private static IPath getFullPath(List<?> ancestors) throws TeamRepositoryException {
        StringBuilder buffer = new StringBuilder("");
        for (Object ancestorObj : ancestors) {
            IAncestorReport ancestorImpl = (IAncestorReport)ancestorObj;
            for (Object nameItemPairObj : ancestorImpl.getNameItemPairs()) {
                INameItemPair nameItemPair = (INameItemPair)nameItemPairObj;
                String pathName = nameItemPair.getName();
                if (pathName == null || pathName.equals("")) continue;
                buffer.append('/').append(pathName);
            }
        }
        return new Path(buffer.toString());
    }

    protected static List<IChangeSetHandle> findChangeSetHandlesFromWorkItemAndFromStream(IWorkItem workItem, IWorkspace stream, IProgressMonitor monitor, ITeamRepository repo) throws TeamRepositoryException {
        IItemReference workItemReference;
        ILinkManager linkManager = (ILinkManager)repo.getClientLibrary(ILinkManager.class);
        ILinkCollection linkCollection = linkManager.findLinksByTarget("com.ibm.team.filesystem.workitems.change_set", (IReference)(workItemReference = linkManager.referenceFactory().createReferenceToItem((IItemHandle)workItem)), monitor).getAllLinksFromHereOn();
        if (linkCollection.isEmpty()) {
            return null;
        }
        ArrayList<IChangeSetHandle> allChangeSetHandles = new ArrayList<IChangeSetHandle>();
        for (ILink link : linkCollection) {
            IChangeSetHandle changeSetHandle = (IChangeSetHandle)link.getSourceRef().resolve();
            allChangeSetHandles.add(changeSetHandle);
        }
        IWorkspaceManager workspaceManager = (IWorkspaceManager)repo.getClientLibrary(IWorkspaceManager.class);
        ArrayList<IWorkspace> streams = new ArrayList<IWorkspace>();
        streams.add(stream);
        ArrayList<IChangeSetHandle> changeSetHandlesInStream = new ArrayList<IChangeSetHandle>();
        ILocateChangeSetsSearchCriteria scope = ILocateChangeSetsSearchCriteria.FACTORY.create(allChangeSetHandles, streams, Collections.EMPTY_LIST, Collections.EMPTY_LIST);
        List result = workspaceManager.locateChangeSets(scope, monitor);
        for (ILocateChangeSetsSearchResult iLocateChangeSetsSearchResult : result) {
            if (iLocateChangeSetsSearchResult.getWorkspaces().size() == 0) continue;
            changeSetHandlesInStream.add(iLocateChangeSetsSearchResult.getChangeSet());
        }
        return changeSetHandlesInStream;
    }

    public static List<DeactivateDesynchronizationDesignStateIDs> compress(List<DeactivateDesynchronizationDesignStateIDs> dddStateIDs) {
        HashMap map = new HashMap();
        boolean hasDouble = false;
        for (DeactivateDesynchronizationDesignStateIDs dddStateID : dddStateIDs) {
            String key = dddStateID.getDesignID();
            if (!map.containsKey(key)) {
                ArrayList<DeactivateDesynchronizationDesignStateIDs> newList = new ArrayList<DeactivateDesynchronizationDesignStateIDs>();
                newList.add(dddStateID);
                map.put(key, newList);
                continue;
            }
            hasDouble = true;
            List listDddStateIDs = (List)map.get(key);
            listDddStateIDs.add(dddStateID);
        }
        if (!hasDouble) {
            return dddStateIDs;
        }
        for (String key : map.keySet()) {
            List listForOneDesign = (List)map.get(key);
            if (listForOneDesign.size() == 1) continue;
            DeactivateDesynchronizationManager.compressOneDesignList(listForOneDesign);
            if (listForOneDesign.size() <= 1) continue;
            Object[] param = new String[]{key};
            String message = NLS.bind((String)Messages.DeactivateDesynchronizationManager_No_mergeable, (Object[])param);
            throw new RuntimeException(message);
        }
        ArrayList<DeactivateDesynchronizationDesignStateIDs> result = new ArrayList<DeactivateDesynchronizationDesignStateIDs>();
        for (String key : map.keySet()) {
            result.addAll((Collection)map.get(key));
        }
        return result;
    }

    private static void compressOneDesignList(List<DeactivateDesynchronizationDesignStateIDs> listForOneDesign) {
        int i = listForOneDesign.size() - 1;
        while (i >= 0) {
            DeactivateDesynchronizationDesignStateIDs currentDddsIds = listForOneDesign.get(i);
            if (currentDddsIds.getStateIdBeforeModification().equals(currentDddsIds.getStateIdAfterModification())) {
                listForOneDesign.remove(i);
            } else {
                int j = i - 1;
                while (j >= 0) {
                    DeactivateDesynchronizationDesignStateIDs otherDddsIds = listForOneDesign.get(j);
                    if (currentDddsIds.getStateIdBeforeModification().equals(otherDddsIds.getStateIdAfterModification())) {
                        otherDddsIds.setStateIdAfterModification(currentDddsIds.getStateIdAfterModification());
                        listForOneDesign.remove(i);
                    } else if (currentDddsIds.getStateIdAfterModification().equals(otherDddsIds.getStateIdBeforeModification())) {
                        otherDddsIds.setStateIdBeforeModification(currentDddsIds.getStateIdBeforeModification());
                        listForOneDesign.remove(i);
                    }
                    --j;
                }
            }
            --i;
        }
    }

    public List<DeactivateDesynchronizationItem> load(IProgressMonitor monitor) {
        try {
            ArrayList<DeactivateDesynchronizationItem> result = new ArrayList<DeactivateDesynchronizationItem>();
            this.getItems().clear();
            this.getSyncItemsToDelete().clear();
            final HashSet beans = new HashSet();
            Job internJob = new Job("DeactivateDesynchronizationManager#load Job..."){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        beans.addAll(DeactivateDesynchronizationManager.this.getSynchronizationClient().getSyncItems(monitor));
                    }
                    catch (TeamRepositoryException e) {
                        return new Status(4, "com.ibm.teampdp.synchronization.ui", null, (Throwable)e);
                    }
                    return Status.OK_STATUS;
                }
            };
            internJob.setUser(false);
            internJob.schedule();
            try {
                internJob.join();
            }
            catch (InterruptedException ie) {
                throw Util.rethrow((Throwable)ie);
            }
            IStatus stat = internJob.getResult();
            if (stat != Status.OK_STATUS && stat.getException() != null) {
                throw Util.rethrow((Throwable)stat.getException());
            }
            int tempNumber = Integer.MIN_VALUE;
            for (SyncItemBean bean : beans) {
                DeactivateDesynchronizationItem deactivateDesynchronizationItem = new DeactivateDesynchronizationItem(tempNumber++, "LATER", bean.getWorkItemUUID(), "LATER", bean.getStreamUUID());
                deactivateDesynchronizationItem.setSyncItemUUID(bean.getSyncItemUUID());
                deactivateDesynchronizationItem.getChangeSetUUIDs().addAll(bean.getChangeSetUUIDs());
                for (SyncStateBean state : bean.getSyncStates()) {
                    DeactivateDesynchronizationDesignStateIDs designStateIDs = new DeactivateDesynchronizationDesignStateIDs(state.getDesignID(), state.getFileItemUUID(), state.getStateIdBefore(), state.getStateIdAfter());
                    deactivateDesynchronizationItem.getSyncStates().add(designStateIDs);
                }
                result.add(deactivateDesynchronizationItem);
            }
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw Util.rethrow((Throwable)e);
        }
    }

    public void commit(IProgressMonitor progressMonitor) {
        final ArrayList<SyncItemBean> addedSyncItems = new ArrayList<SyncItemBean>();
        final ArrayList<SyncItemBean> modifiedSyncItems = new ArrayList<SyncItemBean>();
        final String[] deletedSyncItemsUUIDs = new String[this.getSyncItemsToDelete().size()];
        for (SyncItemBean syncItemBean : this.getItems()) {
            if (syncItemBean.getSyncItemUUID() != null) {
                if (!((DeactivateDesynchronizationItem)syncItemBean).isModified()) continue;
                modifiedSyncItems.add(syncItemBean);
                continue;
            }
            addedSyncItems.add(syncItemBean);
        }
        boolean bl = false;
        for (SyncItemBean syncItemBean : this.getSyncItemsToDelete()) {
            if (syncItemBean.getSyncItemUUID() == null) continue;
            deletedSyncItemsUUIDs[++var5_11] = syncItemBean.getSyncItemUUID();
        }
        if (addedSyncItems.size() == 0 && modifiedSyncItems.size() == 0 && deletedSyncItemsUUIDs.length == 0) {
            return;
        }
        Job job = new Job("DeactivateDesynchronizationManager#commit Job..."){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    String[] newSyncItemsUUIDs = DeactivateDesynchronizationManager.this.getSynchronizationClient().commitSyncItems(addedSyncItems.toArray(new SyncItemBean[addedSyncItems.size()]), modifiedSyncItems.toArray(new SyncItemBean[modifiedSyncItems.size()]), deletedSyncItemsUUIDs, (IProgressMonitor)new NullProgressMonitor());
                    int i = 0;
                    while (i < newSyncItemsUUIDs.length) {
                        ((SyncItemBean)addedSyncItems.get(i)).setSyncItemUUID(newSyncItemsUUIDs[i]);
                        ++i;
                    }
                    for (SyncItemBean bean : modifiedSyncItems) {
                        ((DeactivateDesynchronizationItem)bean).setModified(false);
                    }
                }
                catch (TeamRepositoryException e) {
                    return new Status(4, "com.ibm.teampdp.synchronization.ui", null, (Throwable)e);
                }
                return Status.OK_STATUS;
            }
        };
        job.setUser(false);
        job.schedule();
        try {
            job.join();
        }
        catch (InterruptedException ie) {
            throw Util.rethrow((Throwable)ie);
        }
        IStatus stat = job.getResult();
        if (stat != Status.OK_STATUS && stat.getException() != null) {
            throw Util.rethrow((Throwable)stat.getException());
        }
    }

    private Set<DeactivateDesynchronizationItem> getSyncItemsToDelete() {
        if (this.itemsToDelete == null) {
            this.itemsToDelete = new HashSet<DeactivateDesynchronizationItem>();
        }
        return this.itemsToDelete;
    }

    private ISynchronizationClient getSynchronizationClient() {
        ITeamRepository teamRepository = PTRepositoryManager.getTeamRepository();
        return SynchronizationClientFactory.getQueryClient((ITeamRepository)teamRepository);
    }

    public void removeAllSyncItem(List<DeactivateDesynchronizationItem> list) {
        ArrayList<DeactivateDesynchronizationItem> syncList = new ArrayList<DeactivateDesynchronizationItem>();
        for (DeactivateDesynchronizationItem deactivateDesynchronizationItem : list) {
            if (deactivateDesynchronizationItem.getSyncItemUUID() == null) continue;
            syncList.add(deactivateDesynchronizationItem);
        }
        this.getSyncItemsToDelete().addAll(syncList);
        this.getItems().removeAll(list);
    }

    public void addNewItem(DeactivateDesynchronizationItem newItem) {
        String wiUUID = newItem.getWorkItemUUID();
        String streamUUID = newItem.getStreamUUID();
        SyncItemBean deletedItemFound = null;
        for (SyncItemBean syncItemBean : this.getSyncItemsToDelete()) {
            if (!syncItemBean.getWorkItemUUID().equals(wiUUID) || !syncItemBean.getStreamUUID().equals(streamUUID)) continue;
            deletedItemFound = syncItemBean;
            break;
        }
        if (deletedItemFound != null) {
            newItem.setSyncItemUUID(deletedItemFound.getSyncItemUUID());
            newItem.setModified(true);
            this.getSyncItemsToDelete().remove(deletedItemFound);
        }
        this.getItems().add(newItem);
    }
}

