/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teampdp.synchronization.client.internal;

import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.EventSource;
import com.ibm.team.repository.client.util.IClientLibraryContext;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.teampdp.db.model.pdpmodel.mdl.PdpmodelFactory;
import com.ibm.teampdp.db.model.pdpmodel.mdl.UUIDArrayHelper;
import com.ibm.teampdp.synchronization.bean.SyncItemBean;
import com.ibm.teampdp.synchronization.bean.SyncStateBean;
import com.ibm.teampdp.synchronization.client.ISynchronizationClient;
import com.ibm.teampdp.synchronization.common.ISynchronizationService;
import com.ibm.teampdp.synchronization.model.ISyncItem;
import com.ibm.teampdp.synchronization.model.ISyncState;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;

public class SynchronizationClient
extends EventSource
implements ISynchronizationClient {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2017.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private IClientLibraryContext _context;

    public SynchronizationClient(IClientLibraryContext context) {
        this._context = context;
    }

    protected IClientLibraryContext getContext() {
        return this._context;
    }

    protected ITeamRepository getRepository() {
        return this._context.teamRepository();
    }

    protected <T> T getService(Class<T> clazz) {
        return (T)this.getContext().getServiceInterface(clazz);
    }

    protected Object callCancelableService(IProgressMonitor progressMonitor, IClientLibraryContext.IServiceRunnable serviceRunnable) throws TeamRepositoryException {
        return this.getContext().callCancelableService(serviceRunnable, progressMonitor);
    }

    @Override
    public String[] commitSyncItems(final SyncItemBean[] addedSyncItems, final SyncItemBean[] modifiedSyncItems, final String[] deletedSyncItemsUUIDs, IProgressMonitor progressMonitor) throws TeamRepositoryException {
        return (String[])this.callCancelableService(progressMonitor, new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                return SynchronizationClient.this.getService(ISynchronizationService.class).commitSyncItems(SynchronizationClient.this.convertSyncItemBean(addedSyncItems), SynchronizationClient.this.convertSyncItemBean(modifiedSyncItems), deletedSyncItemsUUIDs);
            }
        });
    }

    @Override
    public Set<SyncItemBean> getSyncItems(IProgressMonitor progressMonitor) throws TeamRepositoryException {
        return (Set)this.callCancelableService(progressMonitor, new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                ISyncItem[] result = SynchronizationClient.this.getService(ISynchronizationService.class).getSyncItems();
                HashSet<SyncItemBean> list = new HashSet<SyncItemBean>();
                ISyncItem[] iSyncItemArray = result;
                int n = result.length;
                int n2 = 0;
                while (n2 < n) {
                    ISyncItem syncItem = iSyncItemArray[n2];
                    list.add(SynchronizationClient.this.convertSyncItem(syncItem));
                    ++n2;
                }
                return list;
            }
        });
    }

    private ISyncItem[] convertSyncItemBean(SyncItemBean[] syncItemBeans) {
        ISyncItem[] syncItems = new ISyncItem[syncItemBeans.length];
        int i = 0;
        while (i < syncItemBeans.length) {
            SyncItemBean syncItemBean = syncItemBeans[i];
            ISyncItem item = (ISyncItem)ISyncItem.ITEM_TYPE.createItem();
            item.setStreamUUID(UUID.valueOf((String)syncItemBean.getStreamUUID()));
            item.setWorkItemUUID(UUID.valueOf((String)syncItemBean.getWorkItemUUID()));
            if (syncItemBean.getSyncItemUUID() != null) {
                item.setContextId(UUID.valueOf((String)syncItemBean.getSyncItemUUID()));
            }
            if (!syncItemBean.getChangeSetUUIDs().isEmpty()) {
                for (String csUUID : syncItemBean.getChangeSetUUIDs()) {
                    UUIDArrayHelper helper = PdpmodelFactory.eINSTANCE.createUUIDArrayHelper();
                    helper.setUuidArrayItem(UUID.valueOf((String)csUUID));
                    item.getChangeSetUUIDs().add(helper);
                }
            }
            if (!syncItemBean.getSyncStates().isEmpty()) {
                for (SyncStateBean syncStateBean : syncItemBean.getSyncStates()) {
                    ISyncState state = (ISyncState)ISyncState.ITEM_TYPE.createItem();
                    item.getSyncStates().add(state);
                    state.setDesignID(syncStateBean.getDesignID());
                    if (syncStateBean.getFileItemUUID() != null) {
                        state.setFileItemUUID(UUID.valueOf((String)syncStateBean.getFileItemUUID()));
                    }
                    state.setStateIdAfter(syncStateBean.getStateIdAfter());
                    state.setStateIdBefore(syncStateBean.getStateIdBefore());
                }
            }
            syncItems[i] = item;
            ++i;
        }
        return syncItems;
    }

    private SyncItemBean convertSyncItem(ISyncItem syncItem) {
        SyncItemBean syncItemBean = new SyncItemBean();
        syncItemBean.setStreamUUID(syncItem.getStreamUUID().getUuidValue());
        syncItemBean.setWorkItemUUID(syncItem.getWorkItemUUID().getUuidValue());
        if (syncItem.getItemId().getUuidValue() == null) {
            return null;
        }
        syncItemBean.setSyncItemUUID(syncItem.getItemId().getUuidValue());
        for (Object object : syncItem.getChangeSetUUIDs()) {
            UUIDArrayHelper helper = (UUIDArrayHelper)object;
            syncItemBean.getChangeSetUUIDs().add(helper.getUuidArrayItem().getUuidValue());
        }
        for (Object object : syncItem.getSyncStates()) {
            ISyncState syncState = (ISyncState)object;
            SyncStateBean stateBean = new SyncStateBean();
            stateBean.setSyncStateUUID(syncState.getItemId().getUuidValue());
            stateBean.setDesignID(syncState.getDesignID());
            stateBean.setStateIdAfter(syncState.getStateIdAfter());
            stateBean.setStateIdBefore(syncState.getStateIdBefore());
            stateBean.setFileItemUUID(syncState.getFileItemUUID().getUuidValue());
            syncItemBean.getSyncStates().add(stateBean);
        }
        return syncItemBean;
    }
}

