/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teampdp.participant.client;

import com.ibm.pdp.explorer.model.PTElement;
import com.ibm.pdp.explorer.model.PTMessageManager;
import com.ibm.pdp.explorer.model.service.PTModelService;
import com.ibm.pdp.mdl.kernel.RadicalEntity;
import com.ibm.pdp.server.repository.PTRepositoryManager;
import com.ibm.pdp.util.Util;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.process.common.IProcessConfigurationElement;
import com.ibm.team.process.common.advice.AdvisableOperation;
import com.ibm.team.process.common.advice.runtime.IOperationParticipant;
import com.ibm.team.process.common.advice.runtime.IParticipantInfoCollector;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IConfiguration;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.common.IChange;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.process.DeliverOperationData;
import com.ibm.teampdp.participant.client.tool.PDPParticipantTool;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;

public class PDPDesignFileScanParticipant
implements IOperationParticipant {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2017.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String _NOT_IMPLEMENTED = "This client deliver participant cannot be used on this version of RTC - Need at least RTC 6.0.2 lastest fix pack.";

    public final void run(AdvisableOperation operation, IProcessConfigurationElement advisorConfiguration, IParticipantInfoCollector collector, IProgressMonitor monitor) throws TeamRepositoryException {
        try {
            this.checkDeliver(operation, advisorConfiguration, collector, monitor);
        }
        catch (Exception cause) {
            throw new TeamRepositoryException((Throwable)cause);
        }
    }

    private void checkDeliver(AdvisableOperation operation, IProcessConfigurationElement advisorConfiguration, IParticipantInfoCollector collector, IProgressMonitor monitor) throws TeamRepositoryException {
        IVersionableHandle[] array;
        if (!(operation.getOperationData() instanceof DeliverOperationData)) {
            return;
        }
        DeliverOperationData operationData = (DeliverOperationData)operation.getOperationData();
        ITeamRepository teamRepository = PTRepositoryManager.getTeamRepository();
        IWorkspaceManager workspaceManager = (IWorkspaceManager)teamRepository.getClientLibrary(IWorkspaceManager.class);
        IWorkspaceConnection connection = workspaceManager.getWorkspaceConnection((IWorkspaceHandle)operationData.getSourceWorkspace(), null);
        IWorkspaceHandle scanWorkspaceHandle = this.getScanWorkspace(teamRepository, operationData.getDestWorkspace());
        if (scanWorkspaceHandle == null) {
            return;
        }
        ArrayList<Object> updatedHandles = new ArrayList<Object>();
        ArrayList<IFileItemHandle> deletedHandles = new ArrayList<IFileItemHandle>();
        HashSet<String> sharedProjects = new HashSet<String>();
        List changeSetHandles = operationData.getChangeSetHandles();
        List changeSets = teamRepository.itemManager().fetchCompleteItems(changeSetHandles, 0, null);
        for (IChangeSet changeSet : changeSets) {
            IComponentHandle componentHandle = changeSet.getComponent();
            IConfiguration configuration = connection.configuration(componentHandle);
            for (Object o : changeSet.changes()) {
                IFileItemHandle beforeHandle;
                IPath afterPath;
                List afterAncestors;
                ArrayList<IVersionableHandle> afterHandles;
                IChange change = (IChange)o;
                if (change.kind() == 2) {
                    afterHandles = new ArrayList<IVersionableHandle>();
                    afterHandles.add(change.afterState());
                    afterAncestors = configuration.determineAncestorsInHistory(afterHandles, monitor);
                    afterPath = PDPParticipantTool.getFullPath(afterAncestors);
                    if (!(change.beforeState() instanceof IFileItemHandle) || !(change.afterState() instanceof IFileItemHandle) || afterPath.getFileExtension() == null || !PTModelService.accept((String)afterPath.getFileExtension().toLowerCase())) continue;
                    beforeHandle = (IFileItemHandle)change.beforeState();
                    InputStream beforeInputStream = PDPDesignFileScanParticipant.getFileContent(workspaceManager, teamRepository, beforeHandle);
                    RadicalEntity beforeObject = this.loadResource(beforeInputStream);
                    TreeSet<String> beforeDesignIds = new TreeSet<String>();
                    Map beforeSolidRelations = PTElement.getSolidRelations((RadicalEntity)beforeObject);
                    for (RadicalEntity beforeSubRef : beforeSolidRelations.keySet()) {
                        beforeDesignIds.add(beforeSubRef.getDesignId(""));
                    }
                    IFileItemHandle afterHandle = (IFileItemHandle)change.afterState();
                    InputStream afterInputStream = PDPDesignFileScanParticipant.getFileContent(workspaceManager, teamRepository, afterHandle);
                    RadicalEntity afterObject = this.loadResource(afterInputStream);
                    TreeSet<String> afterDesignIds = new TreeSet<String>();
                    Map afterSolidRelations = PTElement.getSolidRelations((RadicalEntity)afterObject);
                    for (RadicalEntity afterSubRef : afterSolidRelations.keySet()) {
                        afterDesignIds.add(afterSubRef.getDesignId(""));
                    }
                    if (((Object)beforeDesignIds).equals(afterDesignIds)) continue;
                    updatedHandles.add(afterHandle);
                    continue;
                }
                if (change.kind() == 1) {
                    afterHandles = new ArrayList();
                    afterHandles.add(change.afterState());
                    afterAncestors = configuration.determineAncestorsInHistory(afterHandles, monitor);
                    afterPath = PDPParticipantTool.getFullPath(afterAncestors);
                    if (change.afterState() instanceof IFolderHandle) {
                        if (afterPath.segmentCount() != 1) continue;
                        sharedProjects.add(afterPath.segment(0));
                        continue;
                    }
                    if (!(change.afterState() instanceof IFileItemHandle) || afterPath.getFileExtension() == null || !PTModelService.accept((String)afterPath.getFileExtension().toLowerCase()) || sharedProjects.contains(afterPath.segment(0))) continue;
                    updatedHandles.add(change.afterState());
                    continue;
                }
                if (change.kind() != 16) continue;
                ArrayList<IVersionableHandle> beforeHandles = new ArrayList<IVersionableHandle>();
                beforeHandles.add(change.beforeState());
                List beforeAncestors = configuration.determineAncestorsInHistory(beforeHandles, monitor);
                IPath beforePath = PDPParticipantTool.getFullPath(beforeAncestors);
                if (!(change.beforeState() instanceof IFileItemHandle) || beforePath.getFileExtension() == null || !PTModelService.accept((String)beforePath.getFileExtension().toLowerCase())) continue;
                beforeHandle = (IFileItemHandle)change.beforeState();
                deletedHandles.add(beforeHandle);
            }
        }
        if (updatedHandles.size() > 0) {
            array = updatedHandles.toArray(new IVersionableHandle[updatedHandles.size()]);
            this.scanFiles(teamRepository, array, operationData.getDestWorkspace(), true);
        }
        if (deletedHandles.size() > 0) {
            array = deletedHandles.toArray(new IFileItemHandle[deletedHandles.size()]);
            this.deleteSourceCodeData(teamRepository, operationData.getDestWorkspace(), (IFileItemHandle[])array, false, 1, new NullProgressMonitor());
        }
    }

    private void deleteSourceCodeData(ITeamRepository teamRepository, IWorkspace destWorkspace, IFileItemHandle[] array, boolean b, int i, NullProgressMonitor monitor) throws TeamRepositoryException {
        try {
            Object scdClientAPI = teamRepository.getClientLibrary(Class.forName("com.ibm.team.enterprise.scd.client.IScdClientAPI"));
            Method method = scdClientAPI.getClass().getMethod("deleteSourceCodeData", IWorkspaceHandle.class, IFileItemHandle[].class, Boolean.TYPE, Integer.TYPE, IProgressMonitor.class);
            method.invoke(scdClientAPI, destWorkspace, array, b, i, monitor);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new TeamRepositoryException(_NOT_IMPLEMENTED);
        }
        catch (SecurityException securityException) {
            throw new TeamRepositoryException(_NOT_IMPLEMENTED);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new TeamRepositoryException(_NOT_IMPLEMENTED);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new TeamRepositoryException(_NOT_IMPLEMENTED);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new TeamRepositoryException(_NOT_IMPLEMENTED);
        }
        catch (InvocationTargetException e) {
            throw new TeamRepositoryException(e.getCause());
        }
    }

    private void scanFiles(ITeamRepository teamRepository, IVersionableHandle[] array, IWorkspace destWorkspace, boolean b) throws TeamRepositoryException {
        try {
            Object scdClientAPI = teamRepository.getClientLibrary(Class.forName("com.ibm.team.enterprise.scd.client.IScdClientAPI"));
            Method method = scdClientAPI.getClass().getMethod("scanFiles", IVersionableHandle[].class, IWorkspaceHandle.class, Boolean.TYPE);
            method.invoke(scdClientAPI, array, destWorkspace, b);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new TeamRepositoryException(_NOT_IMPLEMENTED);
        }
        catch (SecurityException securityException) {
            throw new TeamRepositoryException(_NOT_IMPLEMENTED);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new TeamRepositoryException(_NOT_IMPLEMENTED);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new TeamRepositoryException(_NOT_IMPLEMENTED);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new TeamRepositoryException(_NOT_IMPLEMENTED);
        }
        catch (InvocationTargetException e) {
            throw new TeamRepositoryException(e.getCause());
        }
    }

    private IWorkspaceHandle getScanWorkspace(ITeamRepository teamRepository, IWorkspace destWorkspace) throws TeamRepositoryException {
        try {
            Object scdClient = teamRepository.getClientLibrary(Class.forName("com.ibm.team.enterprise.scd.internal.client.IScdClient"));
            Method method1 = scdClient.getClass().getMethod("getScanConfiguration", IWorkspaceHandle.class);
            Object scanConfiguration = method1.invoke(scdClient, destWorkspace);
            if (scanConfiguration != null) {
                Method method2 = scanConfiguration.getClass().getMethod("getScanWorkspace", new Class[0]);
                Object scanWorkspaceHandle = method2.invoke(scanConfiguration, new Object[0]);
                return (IWorkspaceHandle)scanWorkspaceHandle;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new TeamRepositoryException(_NOT_IMPLEMENTED);
        }
        catch (SecurityException securityException) {
            throw new TeamRepositoryException(_NOT_IMPLEMENTED);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new TeamRepositoryException(_NOT_IMPLEMENTED);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new TeamRepositoryException(_NOT_IMPLEMENTED);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new TeamRepositoryException(_NOT_IMPLEMENTED);
        }
        catch (InvocationTargetException e) {
            throw new TeamRepositoryException(e.getCause());
        }
        return null;
    }

    private static InputStream getFileContent(final IWorkspaceManager workspaceManager, final ITeamRepository teamRepository, final IFileItemHandle hFile) {
        final ByteArrayOutputStream[] outputStreams = new ByteArrayOutputStream[1];
        Job internJob = new Job("PDPDesignFileScanParticipant#getFileContent Job..."){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    IVersionable versionable = workspaceManager.versionableManager().fetchCompleteState((IVersionableHandle)hFile, (IProgressMonitor)new NullProgressMonitor());
                    if (versionable instanceof IFileItem) {
                        IFileItem file = (IFileItem)versionable;
                        int length = (int)file.getContent().getEstimatedConvertedLength();
                        if (length < 0) {
                            length = Integer.MAX_VALUE;
                        }
                        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(length);
                        FileSystemCore.getContentManager((ITeamRepository)teamRepository).retrieveContent((IFileItemHandle)file, file.getContent(), (OutputStream)outputStream, null);
                        outputStreams[0] = outputStream;
                    }
                }
                catch (TeamRepositoryException e) {
                    PTMessageManager.logError((Throwable)e);
                }
                return Status.OK_STATUS;
            }
        };
        internJob.setUser(false);
        internJob.schedule();
        try {
            internJob.join();
        }
        catch (InterruptedException e) {
            throw Util.rethrow((Throwable)e);
        }
        ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStreams[0].toByteArray());
        return inputStream;
    }

    private RadicalEntity loadResource(InputStream inputStream) {
        RadicalEntity radicalObject = null;
        URI uri = URI.createURI((String)"foo");
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource resource = resourceSet.createResource(uri);
        try {
            resource.load(inputStream, Collections.EMPTY_MAP);
            radicalObject = (RadicalEntity)resource.getContents().get(0);
        }
        catch (IOException e) {
            PTMessageManager.logError((Throwable)e);
        }
        return radicalObject;
    }
}

