/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teampdp.edition.pac.client;

import com.ibm.pdp.pdpeditor.editor.interfaces.IControlOnEdition;
import com.ibm.pdp.pdpeditor.editor.interfaces.IPathResolution;
import com.ibm.pdp.server.repository.PTRepositoryManager;
import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeManager;
import com.ibm.team.filesystem.rcp.core.internal.FileSystemResourcesPlugin;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IActivityFolder;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncModel;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IIncomingActivityFolder;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IIncomingActivitySource;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IIncomingRemoteActivity;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IIncomingRemoteChangeSummary;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IOutgoingActivityFolder;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IOutgoingActivitySource;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IOutgoingRemoteActivity;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IOutgoingRemoteChangeSummary;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ISuspendedActivitySource;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IWorkspaceSyncContext;
import com.ibm.team.filesystem.ui.changes.configuration.LocalConfiguration;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;

public class ControlAndOrganizeFiles
implements IControlOnEdition {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2017.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public void preControl(Set<IPathResolution> listOfFilesToControl) {
        IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(listOfFilesToControl.iterator().next().getPath());
        try {
            IShareable target = (IShareable)resource.getAdapter(IShareable.class);
            IShare share = target.getShare((IProgressMonitor)new NullProgressMonitor());
            ISharingDescriptor sharingDescriptor = share.getSharingDescriptor();
            if (sharingDescriptor == null) {
                return;
            }
            Map loggedRepositories = PTRepositoryManager.getLoggedRepositories();
            ITeamRepository teamRepository = (ITeamRepository)loggedRepositories.get(sharingDescriptor.getRepositoryId());
            if (teamRepository == null) {
                return;
            }
            if (!sharingDescriptor.associatedWithWorkspace()) {
                return;
            }
            IWorkspaceHandle workspaceHandle = (IWorkspaceHandle)sharingDescriptor.getConnectionHandle();
            ArrayList<IWorkspaceHandle> workspaceHandles = new ArrayList<IWorkspaceHandle>();
            workspaceHandles.add(workspaceHandle);
            List workspaces = teamRepository.itemManager().fetchCompleteItems(workspaceHandles, 0, null);
            IWorkspace workspace = (IWorkspace)workspaces.get(0);
            workspace.getItemId();
            IWorkspaceManager workspaceManager = (IWorkspaceManager)teamRepository.getClientLibrary(IWorkspaceManager.class);
            IWorkspaceConnection wksConnection = workspaceManager.getWorkspaceConnection((IWorkspaceHandle)workspace, null);
            Set<IPath> incomingPaths = Collections.emptySet();
            Set<IPath> outgoingPaths = Collections.emptySet();
            Set<IPath> unresolvedPaths = Collections.emptySet();
            incomingPaths = ControlAndOrganizeFiles.collectIncomingPaths(wksConnection);
            this.detectModifiedPath(incomingPaths, listOfFilesToControl, IPathResolution.ServerValue.INCOMING);
            outgoingPaths = ControlAndOrganizeFiles.collectOutgoingPaths(wksConnection);
            this.detectModifiedPath(outgoingPaths, listOfFilesToControl, IPathResolution.ServerValue.OUTGOING);
            unresolvedPaths = ControlAndOrganizeFiles.collectUnresolvedPaths(teamRepository, workspace, wksConnection);
            this.detectModifiedPath(unresolvedPaths, listOfFilesToControl, IPathResolution.ServerValue.UNRESOLVED);
            for (IPathResolution path : listOfFilesToControl) {
                if (path.getServerValue() != IPathResolution.ServerValue.UNKNOWN) continue;
                path.setServerValue(IPathResolution.ServerValue.NOT_PRESENT);
            }
        }
        catch (Exception exception) {}
    }

    private void detectModifiedPath(Set<IPath> modifiedPaths, Set<IPathResolution> pathList, IPathResolution.ServerValue typeOfModification) {
        for (IPathResolution currentPath : pathList) {
            if (!modifiedPaths.contains(currentPath.getPath())) continue;
            currentPath.setServerValue(typeOfModification);
        }
    }

    private static Set<IPath> collectIncomingPaths(IWorkspaceConnection connection) {
        IComponentSyncContext[] componentSyncContexts;
        HashSet<IPath> incomingPaths = new HashSet<IPath>();
        IComponentSyncModel model = FileSystemResourcesPlugin.getComponentSyncModel();
        IWorkspaceSyncContext wksSyncContext = model.getWorkspaceSyncContext(connection);
        IComponentSyncContext[] iComponentSyncContextArray = componentSyncContexts = LocalConfiguration.getVisibleComponentSyncContexts((IWorkspaceSyncContext)wksSyncContext);
        int n = componentSyncContexts.length;
        int n2 = 0;
        while (n2 < n) {
            IComponentSyncContext componentSyncContext = iComponentSyncContextArray[n2];
            List activitySources = componentSyncContext.getActivitySources();
            if (activitySources != null) {
                for (Object activitySource : activitySources) {
                    if (activitySource instanceof IIncomingActivitySource) {
                        IIncomingActivitySource incomingActivitySource = (IIncomingActivitySource)activitySource;
                        List remoteActivities = incomingActivitySource.getActivities();
                        for (Object remoteActivity : remoteActivities) {
                            if (!(remoteActivity instanceof IIncomingRemoteActivity)) continue;
                            IIncomingRemoteActivity incomingActivity = (IIncomingRemoteActivity)remoteActivity;
                            for (Object folder : incomingActivity.getFolders()) {
                                if (!(folder instanceof IIncomingActivityFolder)) continue;
                                IIncomingActivityFolder incomingFolder = (IIncomingActivityFolder)folder;
                                List changes = incomingFolder.getActivity().getChanges((IActivityFolder)incomingFolder);
                                for (Object change : changes) {
                                    if (!(change instanceof IIncomingRemoteChangeSummary)) continue;
                                    IIncomingRemoteChangeSummary summary = (IIncomingRemoteChangeSummary)change;
                                    incomingPaths.add((IPath)new Path(summary.getAfterPath()));
                                }
                            }
                        }
                        continue;
                    }
                    if (activitySource instanceof IOutgoingActivitySource) continue;
                    boolean cfr_ignored_0 = activitySource instanceof ISuspendedActivitySource;
                }
            }
            ++n2;
        }
        return incomingPaths;
    }

    private static Set<IPath> collectOutgoingPaths(IWorkspaceConnection connection) {
        IComponentSyncContext[] componentSyncContexts;
        HashSet<IPath> outgoingPaths = new HashSet<IPath>();
        IComponentSyncModel model = FileSystemResourcesPlugin.getComponentSyncModel();
        IWorkspaceSyncContext wksSyncContext = model.getWorkspaceSyncContext(connection);
        IComponentSyncContext[] iComponentSyncContextArray = componentSyncContexts = LocalConfiguration.getVisibleComponentSyncContexts((IWorkspaceSyncContext)wksSyncContext);
        int n = componentSyncContexts.length;
        int n2 = 0;
        while (n2 < n) {
            IComponentSyncContext componentSyncContext = iComponentSyncContextArray[n2];
            List activitySources = componentSyncContext.getActivitySources();
            if (activitySources != null) {
                for (Object activitySource : activitySources) {
                    if (activitySource instanceof IIncomingActivitySource) continue;
                    if (activitySource instanceof IOutgoingActivitySource) {
                        IOutgoingActivitySource outgoingActivitySource = (IOutgoingActivitySource)activitySource;
                        List remoteActivities = outgoingActivitySource.getActivities();
                        for (Object remoteActivity : remoteActivities) {
                            if (!(remoteActivity instanceof IOutgoingRemoteActivity)) continue;
                            IOutgoingRemoteActivity outgoingActivity = (IOutgoingRemoteActivity)remoteActivity;
                            for (Object folder : outgoingActivity.getFolders()) {
                                if (!(folder instanceof IOutgoingActivityFolder)) continue;
                                IOutgoingActivityFolder outgoingFolder = (IOutgoingActivityFolder)folder;
                                List changes = outgoingFolder.getActivity().getChanges((IActivityFolder)outgoingFolder);
                                for (Object change : changes) {
                                    if (!(change instanceof IOutgoingRemoteChangeSummary)) continue;
                                    IOutgoingRemoteChangeSummary summary = (IOutgoingRemoteChangeSummary)change;
                                    outgoingPaths.add((IPath)new Path(summary.getAfterPath()));
                                }
                            }
                        }
                        continue;
                    }
                    boolean cfr_ignored_0 = activitySource instanceof ISuspendedActivitySource;
                }
            }
            ++n2;
        }
        return outgoingPaths;
    }

    private static Set<IPath> collectUnresolvedPaths(ITeamRepository teamRepository, IWorkspace sourceWorkspace, IWorkspaceConnection connection) throws TeamRepositoryException {
        HashSet<IPath> unresolvedPaths = new HashSet<IPath>();
        List hComponents = connection.getComponents();
        List items = teamRepository.itemManager().fetchCompleteItems(hComponents, 0, null);
        Collection sandboxes = SharingManager.getInstance().getRegisteredSandboxes();
        if (sandboxes.size() > 0) {
            ISandbox sandbox = (ISandbox)sandboxes.iterator().next();
            for (IItem item : items) {
                ILocalChange[] array;
                if (!(item instanceof IComponent)) continue;
                IComponent component = (IComponent)item;
                ILocalChange[] iLocalChangeArray = array = LocalChangeManager.getInstance().getPendingChanges((IContextHandle)sourceWorkspace, (IComponentHandle)component, sandbox);
                int n = array.length;
                int n2 = 0;
                while (n2 < n) {
                    ILocalChange localChange = iLocalChangeArray[n2];
                    if (localChange.isType(2) || localChange.isType(1) || localChange.isType(4)) {
                        unresolvedPaths.add(localChange.getPath().toPath());
                    }
                    ++n2;
                }
            }
        }
        return unresolvedPaths;
    }

    private IOutgoingRemoteActivity getChangeSetWithPath(IWorkspaceConnection connection, IPath path) {
        IComponentSyncContext[] componentSyncContexts;
        IComponentSyncModel model = FileSystemResourcesPlugin.getComponentSyncModel();
        IWorkspaceSyncContext wksSyncContext = model.getWorkspaceSyncContext(connection);
        IComponentSyncContext[] iComponentSyncContextArray = componentSyncContexts = LocalConfiguration.getVisibleComponentSyncContexts((IWorkspaceSyncContext)wksSyncContext);
        int n = componentSyncContexts.length;
        int n2 = 0;
        while (n2 < n) {
            IComponentSyncContext componentSyncContext = iComponentSyncContextArray[n2];
            List activitySources = componentSyncContext.getActivitySources();
            if (activitySources != null) {
                for (Object activitySource : activitySources) {
                    if (activitySource instanceof IIncomingActivitySource) continue;
                    if (activitySource instanceof IOutgoingActivitySource) {
                        IOutgoingActivitySource outgoingActivitySource = (IOutgoingActivitySource)activitySource;
                        List remoteActivities = outgoingActivitySource.getActivities();
                        for (Object remoteActivity : remoteActivities) {
                            if (!(remoteActivity instanceof IOutgoingRemoteActivity)) continue;
                            IOutgoingRemoteActivity outgoingActivity = (IOutgoingRemoteActivity)remoteActivity;
                            for (Object folder : outgoingActivity.getFolders()) {
                                if (!(folder instanceof IOutgoingActivityFolder)) continue;
                                IOutgoingActivityFolder outgoingFolder = (IOutgoingActivityFolder)folder;
                                List changes = outgoingFolder.getActivity().getChanges((IActivityFolder)outgoingFolder);
                                for (Object change : changes) {
                                    IOutgoingRemoteChangeSummary summary;
                                    Path currentPath;
                                    if (!(change instanceof IOutgoingRemoteChangeSummary) || !(currentPath = new Path((summary = (IOutgoingRemoteChangeSummary)change).getAfterPath())).equals((Object)path)) continue;
                                    return outgoingActivity;
                                }
                            }
                        }
                        continue;
                    }
                    boolean cfr_ignored_0 = activitySource instanceof ISuspendedActivitySource;
                }
            }
            ++n2;
        }
        return null;
    }

    public Set<IPath> filterFiles(Set<IPathResolution> listOfFilesToControl) {
        HashSet<IPath> result = new HashSet<IPath>();
        for (IPathResolution currentPath : listOfFilesToControl) {
            if (currentPath.getServerValue() != IPathResolution.ServerValue.INCOMING && currentPath.getServerValue() != IPathResolution.ServerValue.OUTGOING && currentPath.getServerValue() != IPathResolution.ServerValue.UNRESOLVED) continue;
            result.add(currentPath.getPath());
        }
        return result;
    }

    public void postProcess(Set<IPathResolution> listOfFilesModified) {
        IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(listOfFilesModified.iterator().next().getPath());
        try {
            IShareable target = (IShareable)resource.getAdapter(IShareable.class);
            IShare share = target.getShare((IProgressMonitor)new NullProgressMonitor());
            ISharingDescriptor sharingDescriptor = share.getSharingDescriptor();
            if (sharingDescriptor == null) {
                return;
            }
            Map loggedRepositories = PTRepositoryManager.getLoggedRepositories();
            ITeamRepository teamRepository = (ITeamRepository)loggedRepositories.get(sharingDescriptor.getRepositoryId());
            if (teamRepository == null) {
                return;
            }
            if (!sharingDescriptor.associatedWithWorkspace()) {
                return;
            }
            IWorkspaceHandle workspaceHandle = (IWorkspaceHandle)sharingDescriptor.getConnectionHandle();
            ArrayList<IWorkspaceHandle> workspaceHandles = new ArrayList<IWorkspaceHandle>();
            workspaceHandles.add(workspaceHandle);
            List workspaces = teamRepository.itemManager().fetchCompleteItems(workspaceHandles, 0, null);
            IWorkspace workspace = (IWorkspace)workspaces.get(0);
            workspace.getItemId();
            IWorkspaceManager workspaceManager = (IWorkspaceManager)teamRepository.getClientLibrary(IWorkspaceManager.class);
            IWorkspaceConnection wksConnection = workspaceManager.getWorkspaceConnection((IWorkspaceHandle)workspace, null);
            long before = new Date().getTime();
            int count = 0;
            IPath cblpdpPath = null;
            for (IPathResolution path : listOfFilesModified) {
                if (!path.getPath().getFileExtension().equals("cblpdp")) continue;
                cblpdpPath = path.getPath();
            }
            while (this.getChangeSetWithPath(wksConnection, cblpdpPath) == null) {
                ++count;
            }
            long after = new Date().getTime();
            System.out.println(String.valueOf(after - before) + " : " + count);
            HashSet<IPath> filesFound = new HashSet<IPath>();
            HashSet<IOutgoingRemoteActivity> problemsCS = new HashSet<IOutgoingRemoteActivity>();
            HashSet<IOutgoingRemoteActivity> okCS = new HashSet<IOutgoingRemoteActivity>();
            for (IPathResolution path : listOfFilesModified) {
                if (filesFound.contains(path)) continue;
                IOutgoingRemoteActivity outgoingActivity = this.getChangeSetWithPath(wksConnection, path.getPath());
                Set<IPath> filesConcerned = this.getConcernedFilesFor(outgoingActivity);
                if (this.isAllFilesInChangeSet(filesConcerned, listOfFilesModified)) {
                    filesFound.addAll(filesConcerned);
                    okCS.add(outgoingActivity);
                    continue;
                }
                problemsCS.add(outgoingActivity);
            }
            if (!okCS.isEmpty()) {
                for (IOutgoingRemoteActivity activity : okCS) {
                    ArrayList<IChangeSet> l = new ArrayList<IChangeSet>();
                    l.add(activity.getChangeSet());
                    wksConnection.closeChangeSets(l, null);
                }
            }
            if (!problemsCS.isEmpty()) {
                for (IOutgoingRemoteActivity activity : problemsCS) {
                    ArrayList<IChangeSetHandle> orig = new ArrayList<IChangeSetHandle>();
                    orig.add(activity.getChangeSetHandle());
                    IChangeSetHandle csh = wksConnection.createChangeSet(activity.getChangeSet().getComponent(), null);
                    ArrayList<IChangeSetHandle> dest = new ArrayList<IChangeSetHandle>();
                    dest.add(csh);
                    Set<IPath> allPaths = this.getOnlyConcernedFilesFor(activity, listOfFilesModified);
                    ArrayList<IVersionableHandle> handles = new ArrayList<IVersionableHandle>();
                    for (IPath path : allPaths) {
                        handles.add(PTRepositoryManager.getVersionableHandle((IWorkspaceHandle)workspaceHandle, (IPath)path));
                    }
                    wksConnection.relocateChanges(dest, handles, orig, null);
                }
            }
        }
        catch (Exception exception) {}
    }

    private Set<IPath> getOnlyConcernedFilesFor(IOutgoingRemoteActivity outgoingActivity, Set<IPathResolution> listOfFilesModified) {
        HashSet<Path> resultInPending = new HashSet<Path>();
        HashSet<IPath> result = new HashSet<IPath>();
        for (Object folder : outgoingActivity.getFolders()) {
            if (!(folder instanceof IOutgoingActivityFolder)) continue;
            IOutgoingActivityFolder outgoingFolder = (IOutgoingActivityFolder)folder;
            List changes = outgoingFolder.getActivity().getChanges((IActivityFolder)outgoingFolder);
            for (Object change : changes) {
                if (!(change instanceof IOutgoingRemoteChangeSummary)) continue;
                IOutgoingRemoteChangeSummary summary = (IOutgoingRemoteChangeSummary)change;
                Path currentPath = new Path(summary.getAfterPath());
                resultInPending.add(currentPath);
            }
        }
        if (!resultInPending.isEmpty()) {
            for (IPathResolution ipathR : listOfFilesModified) {
                result.add(ipathR.getPath());
            }
            result.retainAll(resultInPending);
        }
        return result;
    }

    private Set<IPath> getConcernedFilesFor(IOutgoingRemoteActivity outgoingActivity) {
        HashSet<IPath> result = new HashSet<IPath>();
        for (Object folder : outgoingActivity.getFolders()) {
            if (!(folder instanceof IOutgoingActivityFolder)) continue;
            IOutgoingActivityFolder outgoingFolder = (IOutgoingActivityFolder)folder;
            List changes = outgoingFolder.getActivity().getChanges((IActivityFolder)outgoingFolder);
            for (Object change : changes) {
                if (!(change instanceof IOutgoingRemoteChangeSummary)) continue;
                IOutgoingRemoteChangeSummary summary = (IOutgoingRemoteChangeSummary)change;
                Path currentPath = new Path(summary.getAfterPath());
                result.add((IPath)currentPath);
            }
        }
        return result;
    }

    private boolean isAllFilesInChangeSet(Set<IPath> filesConcerned, Set<IPathResolution> listOfFilesModified) {
        for (IPath path : filesConcerned) {
            boolean found = false;
            for (IPathResolution pathRes : listOfFilesModified) {
                if (!pathRes.getPath().equals((Object)path)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }
}

