/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teampdp.cli.internal.subcommand.uploadsandbox.resolver;

import com.ibm.pdp.mdl.kernel.RadicalEntity;
import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.IRelativeLocation;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.teampdp.cli.internal.subcommand.uploadsandbox.resolver.IChangeSetLog;
import com.ibm.teampdp.cli.internal.subcommand.uploadsandbox.resolver.IChangeSetResolver;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class AffinityChangeSetResolver
implements IChangeSetResolver {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2015.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static Set<String> DESIGN_FILE_EXTENSIONS = null;
    private static List<String> RPP_SOURCE_FILE_EXTENSIONS = Arrays.asList("cbl", "bms", "map", "mfs", "ddl", "txt", "cpy");
    private static List<String> RPP_MODEL_FILE_EXTENSIONS = null;
    private HashMap<String, LinkedHashMap<String, IChangeSetHandle>> componentUUID2ChangeSets = new HashMap();
    private HashMap<String, String> projectToPdpRootPaths = new HashMap();
    private DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
    private SAXParserFactory spf = SAXParserFactory.newInstance();
    private IChangeSetLog log;
    private String comment;

    static {
        RPP_MODEL_FILE_EXTENSIONS = new ArrayList<String>();
        for (String ext : RPP_SOURCE_FILE_EXTENSIONS) {
            RPP_MODEL_FILE_EXTENSIONS.add(String.valueOf(ext) + "pdp");
        }
    }

    public AffinityChangeSetResolver(String commentPattern, IChangeSetLog log) {
        this.log = log;
        this.comment = commentPattern != null ? commentPattern : "CS";
    }

    @Override
    public IChangeSetHandle getChangeSetForShareOperation(IWorkspaceConnection workspaceConnection, IComponentHandle componentHandle, List<ILocation> shareRoots, IProgressMonitor monitor) throws TeamRepositoryException {
        return null;
    }

    @Override
    public IChangeSetResolver.ChangeSetHolder getChangeSetForCheckinOperation(IWorkspaceConnection workspaceConnection, ILocalChange localChange, IProgressMonitor monitor) throws TeamRepositoryException {
        IChangeSetHandle csh = null;
        boolean toBeRunAlone = false;
        IRelativeLocation localChangeRelativeLocation = localChange.getPath();
        IPath localChangePath = localChangeRelativeLocation.toPath();
        String fileExtension = localChangePath.getFileExtension();
        if (this.getAcceptedExtensions().contains(fileExtension)) {
            String key = localChangePath.toString();
            csh = this.getChangeSet(localChange.getComponent(), key);
            if (csh == null) {
                String csComment = this.computeChangeSetCommentForDesign(localChangePath);
                csh = workspaceConnection.createChangeSet(localChange.getComponent(), csComment, false, monitor);
                if (this.log != null) {
                    this.log.info("ChangeSet created for design (" + key + "): " + csComment);
                }
                this.putChangeSet(localChange.getComponent(), key, csh);
            }
        } else if (RPP_MODEL_FILE_EXTENSIONS.contains(fileExtension)) {
            String modelKey = localChangePath.toString();
            csh = this.getChangeSet(localChange.getComponent(), modelKey);
            if (csh == null) {
                IPath sourcePath;
                String designPath = this.findPdPRootPath(localChange.getSandboxRoot(), localChangePath.segment(0));
                if (designPath == null || designPath.isEmpty()) {
                    sourcePath = localChangePath.removeFileExtension().addFileExtension(fileExtension.replace("pdp", ""));
                } else {
                    IPath path = localChangeRelativeLocation.uptoSegment(1).append(designPath).append(localChangeRelativeLocation.removeFirstSegments(2)).toPath();
                    sourcePath = path.removeFileExtension().addFileExtension(fileExtension.replace("pdp", ""));
                }
                csh = this.findAndStoreChangeSetOutOfModelOrSource(workspaceConnection, localChange.getSandboxRoot(), localChange.getComponent(), localChangePath, sourcePath, monitor);
            }
        } else if (RPP_SOURCE_FILE_EXTENSIONS.contains(fileExtension)) {
            csh = this.getChangeSet(localChange.getComponent(), localChangePath.toString());
            if (csh == null) {
                IPath modelPath;
                String designPath = this.findPdPRootPath(localChange.getSandboxRoot(), localChangePath.segment(0));
                if (designPath == null || designPath.isEmpty()) {
                    modelPath = localChangePath.removeFileExtension().addFileExtension(String.valueOf(fileExtension) + "pdp");
                } else {
                    IPath path = localChangeRelativeLocation.uptoSegment(1).append(designPath).append(localChangeRelativeLocation.removeFirstSegments(1)).toPath();
                    modelPath = path.removeFileExtension().addFileExtension(String.valueOf(fileExtension) + "pdp");
                }
                csh = this.getChangeSet(localChange.getComponent(), modelPath.toString());
                if (csh == null) {
                    csh = this.findAndStoreChangeSetOutOfModelOrSource(workspaceConnection, localChange.getSandboxRoot(), localChange.getComponent(), modelPath, localChangePath, monitor);
                }
            }
        } else {
            csh = this.getChangeSet(localChange.getComponent(), "");
            if (csh == null) {
                csh = workspaceConnection.createChangeSet(localChange.getComponent(), String.valueOf(this.comment) + " - Miscellaneous", false, monitor);
                this.putChangeSet(localChange.getComponent(), "", csh);
            }
            toBeRunAlone = true;
        }
        IChangeSetResolver.ChangeSetHolder result = new IChangeSetResolver.ChangeSetHolder();
        result.handle = csh;
        result.toBeRunAlone = toBeRunAlone;
        return result;
    }

    private IChangeSetHandle findAndStoreChangeSetOutOfModelOrSource(IWorkspaceConnection workspaceConnection, ILocation sandboxLocation, IComponentHandle component, IPath modelFilePath, IPath sourceFilePath, IProgressMonitor monitor) throws TeamRepositoryException {
        File modelFile = new File(sandboxLocation.toOSString(), modelFilePath.toOSString());
        String designKey = null;
        if (modelFile.isFile()) {
            designKey = this.searchDesignKey(sandboxLocation, modelFile);
        }
        IChangeSetHandle csh = null;
        if (designKey != null) {
            csh = this.getChangeSet(component, designKey);
        }
        if (csh != null) {
            if (this.log != null) {
                this.log.info("ChangeSet located from design (" + designKey + ")");
            }
            this.putChangeSet(component, modelFilePath.toString(), csh);
            this.putChangeSet(component, sourceFilePath.toString(), csh);
            return csh;
        }
        String csComment = designKey != null ? this.computeChangeSetCommentForDesign((IPath)new Path(designKey)) : this.computeChangeSetCommentForSource(sourceFilePath);
        csh = workspaceConnection.createChangeSet(component, csComment, false, monitor);
        StringBuffer sb = new StringBuffer("ChangeSet created for model/source (design: ");
        sb.append(designKey);
        sb.append(", model: ");
        sb.append(modelFilePath.toString());
        sb.append(", file: ");
        sb.append(sourceFilePath.toString());
        sb.append("): ");
        sb.append(csComment);
        if (this.log != null) {
            this.log.info(sb.toString());
        }
        if (designKey != null) {
            this.putChangeSet(component, designKey, csh);
        }
        this.putChangeSet(component, modelFilePath.toString(), csh);
        this.putChangeSet(component, sourceFilePath.toString(), csh);
        return csh;
    }

    private String searchDesignKey(final ILocation sandboxLocation, File modelFile) {
        final String[] key = new String[1];
        DefaultHandler handler = new DefaultHandler(){

            @Override
            public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                String sRelation;
                if ("subRef".equals(qName) && (sRelation = attributes.getValue("relation")) != null && sRelation.endsWith("_entrypoint")) {
                    String sProject = attributes.getValue("project");
                    String sName = attributes.getValue("name");
                    String sType = attributes.getValue("type");
                    try {
                        IPath p = new Path("/").append(sProject);
                        String pdpRootPath = AffinityChangeSetResolver.this.findPdPRootPath(sandboxLocation, sProject);
                        if (pdpRootPath != null) {
                            p = p.append(pdpRootPath);
                        }
                        p = p.append(sName).addFileExtension(sType);
                        key[0] = p.toString();
                    }
                    catch (TeamRepositoryException tre) {
                        tre.printStackTrace(System.err);
                    }
                }
            }
        };
        try {
            this.spf.newSAXParser().parse(modelFile, handler);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        return key[0];
    }

    private String findPdPRootPath(ILocation sandboxRoot, String project) throws TeamRepositoryException {
        File pdppathFile;
        String pdpRootPath = this.projectToPdpRootPaths.get(project);
        if (pdpRootPath == null && (pdppathFile = new File(sandboxRoot.append(project).toOSString(), ".pdppath")).isFile()) {
            try {
                Document d = this.dbf.newDocumentBuilder().parse(pdppathFile);
                Element pdp_path = (Element)d.getElementsByTagName("pdp_path").item(0);
                pdpRootPath = pdp_path.getAttribute("pdpRootPath");
                this.projectToPdpRootPaths.put(project, pdpRootPath);
            }
            catch (Exception e) {
                throw new TeamRepositoryException((Throwable)e);
            }
        }
        return pdpRootPath;
    }

    private IChangeSetHandle getChangeSet(IComponentHandle component, String key) {
        String componentKey = component.getItemId().getUuidValue();
        LinkedHashMap<String, Object> changeSets = this.componentUUID2ChangeSets.get(componentKey);
        if (changeSets == null) {
            changeSets = new LinkedHashMap();
            this.componentUUID2ChangeSets.put(componentKey, changeSets);
        }
        return changeSets.get(key);
    }

    private void putChangeSet(IComponentHandle component, String key, IChangeSetHandle changeSet) {
        String componentKey = component.getItemId().getUuidValue();
        LinkedHashMap<String, Object> changeSets = this.componentUUID2ChangeSets.get(componentKey);
        if (changeSets == null) {
            changeSets = new LinkedHashMap();
            this.componentUUID2ChangeSets.put(componentKey, changeSets);
        }
        changeSets.put(key, changeSet);
    }

    private String computeChangeSetCommentForDesign(IPath localChangePath) {
        StringBuffer sb = new StringBuffer(this.comment);
        sb.append(" (");
        sb.append(localChangePath.segment(0));
        sb.append(" ");
        sb.append(localChangePath.getFileExtension());
        sb.append(" ");
        sb.append(localChangePath.removeFileExtension().lastSegment());
        sb.append(")");
        return sb.toString();
    }

    private String computeChangeSetCommentForSource(IPath sourcePath) {
        StringBuffer sb = new StringBuffer(this.comment);
        sb.append(" (");
        sb.append(sourcePath.segment(0));
        sb.append(" ");
        sb.append(sourcePath.getFileExtension());
        sb.append(" ");
        sb.append(sourcePath.segment(sourcePath.segmentCount() - 1));
        sb.append(" ");
        sb.append(sourcePath.removeFileExtension().lastSegment());
        sb.append(")");
        return sb.toString();
    }

    private Set<String> getAcceptedExtensions() {
        if (DESIGN_FILE_EXTENSIONS == null) {
            DESIGN_FILE_EXTENSIONS = new HashSet<String>();
            HashSet ePackages = new HashSet();
            ePackages.addAll(EPackage.Registry.INSTANCE.values());
            for (Object object : ePackages) {
                if (!(object instanceof EPackage)) continue;
                EPackage ePackage = (EPackage)object;
                for (EClassifier eClassifier : ePackage.getEClassifiers()) {
                    EClass eClass;
                    if (!(eClassifier instanceof EClass) || (eClass = (EClass)eClassifier).isAbstract()) continue;
                    for (EClass eSuperClass : eClass.getEAllSuperTypes()) {
                        if (!eSuperClass.getName().equals(RadicalEntity.class.getSimpleName())) continue;
                        DESIGN_FILE_EXTENSIONS.add(eClass.getName().toLowerCase());
                    }
                }
            }
        }
        return DESIGN_FILE_EXTENSIONS;
    }
}

