/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teampdp.cli.internal.subcommand.uploadsandbox;

import com.ibm.team.links.common.IItemReference;
import com.ibm.team.links.common.IReference;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.client.WorkItemOperation;
import com.ibm.team.workitem.client.WorkItemWorkingCopy;
import com.ibm.team.workitem.common.model.IAttachment;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.WorkItemEndPoints;
import com.ibm.team.workitem.common.model.WorkItemLinkTypes;
import com.ibm.teampdp.cli.internal.nls.Messages;
import com.ibm.teampdp.cli.internal.subcommand.IRPPzDSLangDefWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.runtime.IProgressMonitor;

public class RPPWorkItemUploadAttachmentOperation
extends WorkItemOperation {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2016.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private String fFileName;
    private String fContentType;
    private String fEncoding;
    private String fDescription;
    private IRPPzDSLangDefWriter fStdErr;
    private boolean result = true;

    public RPPWorkItemUploadAttachmentOperation(String fileName, String contentType, String encoding, String description, IRPPzDSLangDefWriter stdErr) {
        super("Initializing Work Item", IWorkItem.FULL_PROFILE);
        this.fFileName = fileName;
        this.fContentType = contentType;
        this.fEncoding = encoding;
        this.fDescription = description;
        this.fStdErr = stdErr;
    }

    protected void execute(WorkItemWorkingCopy workingCopy, IProgressMonitor monitor) throws TeamRepositoryException {
        try {
            RPPWorkItemUploadAttachmentOperation.attachFile(workingCopy, this.fFileName, this.fContentType, this.fEncoding, this.fDescription, this.fStdErr, monitor);
        }
        catch (IOException ex) {
            this.result = false;
            this.fStdErr.println(Messages.RPPUploadSandoxCommand_LINK_WORKITEM_CS_ERROR, ex);
        }
    }

    public boolean getResult() {
        return this.result;
    }

    private static void attachFile(WorkItemWorkingCopy workingCopy, String name, String contentType, String encoding, String description, IRPPzDSLangDefWriter fStdErr, IProgressMonitor monitor) throws TeamRepositoryException, IOException {
        File attachmentFile = new File(name);
        FileInputStream fis = new FileInputStream(attachmentFile);
        IWorkItem workItem = workingCopy.getWorkItem();
        IWorkItemClient workItemClient = (IWorkItemClient)((ITeamRepository)workItem.getOrigin()).getClientLibrary(IWorkItemClient.class);
        try {
            IAttachment newAttachment = workItemClient.createAttachment(workItem.getProjectArea(), attachmentFile.getName(), description, contentType, encoding, (InputStream)fis, monitor);
            newAttachment = (IAttachment)newAttachment.getWorkingCopy();
            newAttachment = workItemClient.saveAttachment(newAttachment, monitor);
            IItemReference reference = WorkItemLinkTypes.createAttachmentReference((IAttachment)newAttachment);
            workingCopy.getReferences().add(WorkItemEndPoints.ATTACHMENT, (IReference)reference);
        }
        finally {
            if (fis != null) {
                fis.close();
            }
        }
    }
}

