/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teampdp.cli.internal.subcommand.uploadsandbox;

import com.ibm.team.filesystem.cli.core.subcommands.IScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.util.CLIFileSystemClientException;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.ILocalChangeManager;
import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.internal.IRepositoryResolver;
import com.ibm.team.filesystem.client.internal.PathLocation;
import com.ibm.team.filesystem.client.operations.CommitDilemmaHandler;
import com.ibm.team.filesystem.client.operations.ICheckinOperation;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.filesystem.client.rest.parameters.ParmsBackupDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsComponentChange;
import com.ibm.team.filesystem.client.rest.parameters.ParmsConfigurationChanges;
import com.ibm.team.filesystem.client.rest.parameters.ParmsCreateChangeSet;
import com.ibm.team.filesystem.client.rest.parameters.ParmsDeletedContentDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsPutComponent;
import com.ibm.team.filesystem.client.rest.parameters.ParmsPutWorkspace;
import com.ibm.team.filesystem.client.rest.parameters.ParmsSandboxUpdateDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsSandboxes;
import com.ibm.team.filesystem.client.rest.parameters.ParmsShare;
import com.ibm.team.filesystem.client.rest.parameters.ParmsShareRequest;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspace;
import com.ibm.team.filesystem.client.workitems.IFileSystemWorkItemManager;
import com.ibm.team.filesystem.common.internal.rest.client.changeset.CreateResultDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.ConfigurationDescriptorDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.ShareDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.WorkspaceComponentDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.WorkspaceDetailsDTO;
import com.ibm.team.filesystem.common.internal.rest.client.share.ShareOverlapDTO;
import com.ibm.team.filesystem.common.internal.rest.client.share.ShareResultDTO;
import com.ibm.team.filesystem.common.internal.rest.client.workspace.PutWorkspaceResultDTO;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.validation.PropertyConstraintException;
import com.ibm.team.rtc.cli.infrastructure.internal.core.CLIClientException;
import com.ibm.team.rtc.cli.infrastructure.internal.core.IClientConfiguration;
import com.ibm.team.rtc.cli.infrastructure.internal.core.ISubcommand;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLine;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.util.IndentingPrintStream;
import com.ibm.team.rtc.cli.infrastructure.internal.util.StringUtil;
import com.ibm.team.scm.client.IConfiguration;
import com.ibm.team.scm.client.IFlowNodeConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.dto.IChangeHistorySyncReport;
import com.ibm.team.scm.common.dto.IComponentSearchCriteria;
import com.ibm.team.scm.common.dto.IWorkspaceSearchCriteria;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.teampdp.cli.internal.nls.Messages;
import com.ibm.teampdp.cli.internal.subcommand.DefaultRPPzDSLangDefWriter;
import com.ibm.teampdp.cli.internal.subcommand.IRPPzDSLangDefWriter;
import com.ibm.teampdp.cli.internal.subcommand.showstatus.RPPShowStatusCommand;
import com.ibm.teampdp.cli.internal.subcommand.uploadsandbox.RPPUploadSandoxCommandOpts;
import com.ibm.teampdp.cli.internal.subcommand.uploadsandbox.RPPWorkItemUploadAttachmentOperation;
import com.ibm.teampdp.cli.internal.subcommand.uploadsandbox.resolver.ChangeSetLog;
import com.ibm.teampdp.cli.internal.subcommand.uploadsandbox.resolver.IChangeSetLog;
import com.ibm.teampdp.cli.internal.subcommand.uploadsandbox.resolver.IChangeSetResolver;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.osgi.util.NLS;

public class RPPUploadSandoxCommand
implements ISubcommand {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2015, 2020.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String COB_EXTENSION = ".COB";
    private IScmClientConfiguration fConfig;
    private IRPPzDSLangDefWriter fStdErr;
    private ISandbox fSandbox;
    private IRPPzDSLangDefWriter fSdtOut;
    private IFilesystemRestClient fClient;
    private ITeamRepository fRepo;
    private IWorkspace fWorkspace;
    private IWorkspaceConnection fWorkspaceConnection;
    private List<IComponent> fExistingComponentsInWorkspace;
    private String fSandBoxPath;
    private String fLocationName;
    private IProjectArea fProjectArea;
    private IWorkspaceConnection fStreamConnection;
    boolean fIsDryRun = true;
    private boolean fReShareAll = false;
    private String fCsComment;
    private String fStatusFile;
    private int fWorkItemNumber = 0;
    private boolean fVerbose;
    private String fWorkspaceName;
    private boolean fIsRefreshSandbox;
    private IndentingPrintStream fIndentStdErr;
    private String fConfigDir;
    private boolean fIsGlobalStrategy = true;
    IChangeSetResolver fChangeSetResolver = null;
    private IChangeSetLog log = new ChangeSetLog();
    private boolean fIsSepareCobolComp = false;
    private LinkedHashMap<IChangeSetHandle, LocalChangesHolder> fChangeSet2LocalChanges = new LinkedHashMap();
    private Set<String> fCsUUIDs;
    private HashMap<String, IComponentHandle> componentMap = null;

    private void validateCommandLine(ICommandLine cmdLine) throws FileSystemException {
        if (!cmdLine.hasOption((IOptionKey)RPPUploadSandoxCommandOpts.OPT_WORKSPACE)) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.RPPCliCommand_MISSING_REQUIRED_ARGUMENT, (Object)RPPUploadSandoxCommandOpts.OPT_WORKSPACE.getName()));
        }
        if (!cmdLine.hasOption((IOptionKey)RPPUploadSandoxCommandOpts.OPT_SANDBOX)) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.RPPCliCommand_MISSING_REQUIRED_ARGUMENT, (Object)RPPUploadSandoxCommandOpts.OPT_SANDBOX.getName()));
        }
        if (!cmdLine.hasOption((IOptionKey)RPPUploadSandoxCommandOpts.OPT_LOCATION)) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.RPPCliCommand_MISSING_REQUIRED_ARGUMENT, (Object)RPPUploadSandoxCommandOpts.OPT_LOCATION.getName()));
        }
        if (!cmdLine.hasOption((IOptionKey)RPPUploadSandoxCommandOpts.OPT_PROJECT_AREA)) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.RPPCliCommand_MISSING_REQUIRED_ARGUMENT, (Object)RPPUploadSandoxCommandOpts.OPT_PROJECT_AREA.getName()));
        }
        if (!cmdLine.hasOption((IOptionKey)RPPUploadSandoxCommandOpts.OPT_STREAM)) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.RPPCliCommand_MISSING_REQUIRED_ARGUMENT, (Object)RPPUploadSandoxCommandOpts.OPT_STREAM.getName()));
        }
        if (!cmdLine.hasOption((IOptionKey)RPPUploadSandoxCommandOpts.OPT_COMMENT)) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.RPPCliCommand_MISSING_REQUIRED_ARGUMENT, (Object)RPPUploadSandoxCommandOpts.OPT_COMMENT.getName()));
        }
        if (cmdLine.hasOption((IOptionKey)RPPUploadSandoxCommandOpts.OPT_STRATEGY)) {
            String strategy = cmdLine.getOption((IOptionKey)RPPUploadSandoxCommandOpts.OPT_STRATEGY, null);
            if (!"global".equals(strategy) && !"affinity".equals(strategy)) {
                throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.RPPCliCommand_MISSING_REQUIRED_ARGUMENT, (Object)RPPUploadSandoxCommandOpts.OPT_STRATEGY.getName()));
            }
            this.fIsGlobalStrategy = "global".equals(strategy);
        }
        if (cmdLine.hasOption((IOptionKey)RPPUploadSandoxCommandOpts.OPT_SEPARATE_COB_COMP)) {
            this.fIsSepareCobolComp = true;
        }
        if (cmdLine.hasOption((IOptionKey)RPPUploadSandoxCommandOpts.OPT_WORKITEM)) {
            String workItem = cmdLine.getOption((IOptionKey)RPPUploadSandoxCommandOpts.OPT_WORKITEM, null);
            try {
                this.fWorkItemNumber = Integer.parseInt(workItem);
            }
            catch (Exception exception) {
                throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.RPPCliCommand_MISSING_REQUIRED_ARGUMENT, (Object)RPPUploadSandoxCommandOpts.OPT_WORKITEM.getName()));
            }
        }
    }

    public int run(IClientConfiguration config) throws CLIClientException {
        int result = this.runCommand(config);
        if (result != 0) {
            return -1;
        }
        return 0;
    }

    /*
     * Exception decompiling
     */
    public int runCommand(IClientConfiguration config) throws CLIClientException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static IWorkspaceConnection findNamedWorkspaceConnection(String nameOrUUID, ITeamRepository repo, IScmClientConfiguration config) throws FileSystemException, RepoUtil.UnmatchedSelectorException, RepoUtil.AmbiguousSelectorException {
        IWorkspace wsHandle = RPPUploadSandoxCommand.findNamedWorkspace(nameOrUUID, repo, config);
        IWorkspaceManager manager = SCMPlatform.getWorkspaceManager((ITeamRepository)repo);
        try {
            return manager.getWorkspaceConnection((IWorkspaceHandle)wsHandle, null);
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap((String)NLS.bind((String)Messages.RepoUtil_11, (Object)nameOrUUID), (TeamRepositoryException)e, (IndentingPrintStream)new IndentingPrintStream((OutputStream)config.getContext().stderr()), (String)repo.getRepositoryURI());
        }
    }

    private static IWorkspace findNamedWorkspace(String selector, ITeamRepository repo, IScmClientConfiguration config) throws FileSystemException, RepoUtil.UnmatchedSelectorException, RepoUtil.AmbiguousSelectorException {
        ArrayList workspaceHandles = new ArrayList();
        IWorkspaceSearchCriteria criteria = IWorkspaceSearchCriteria.FACTORY.newInstance().setExactName(selector);
        criteria.setKind(2);
        try {
            List foundWorkspaceHandles = SCMPlatform.getWorkspaceManager((ITeamRepository)repo).findWorkspaces(criteria, Integer.MAX_VALUE, null);
            workspaceHandles.addAll(foundWorkspaceHandles);
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap((String)Messages.RepoUtil_9, (TeamRepositoryException)e, (IndentingPrintStream)new IndentingPrintStream((OutputStream)config.getContext().stderr()), (String)repo.getRepositoryURI());
        }
        ArrayList<IWorkspace> workspaces = new ArrayList<IWorkspace>();
        if (workspaceHandles.size() > 0) {
            try {
                List fetchedWorkspaces = repo.itemManager().fetchCompleteItems(workspaceHandles, 0, null);
                for (IItem item : fetchedWorkspaces) {
                    if (item == null || !(item instanceof IWorkspace)) continue;
                    IWorkspace workspace = (IWorkspace)item;
                    workspaces.add(workspace);
                }
            }
            catch (TeamRepositoryException e) {
                throw StatusHelper.wrap((String)Messages.RepoUtil_10, (TeamRepositoryException)e, (IndentingPrintStream)new IndentingPrintStream((OutputStream)config.getContext().stderr()), (String)repo.getRepositoryURI());
            }
        }
        if (workspaces.size() == 0) {
            throw new RepoUtil.UnmatchedSelectorException(RepoUtil.ItemType.WORKSPACE, selector, Collections.EMPTY_LIST, Collections.EMPTY_LIST);
        }
        if (workspaces.size() > 1) {
            throw new RepoUtil.AmbiguousSelectorException(RepoUtil.ItemType.WORKSPACE, selector, workspaces, workspaces, repo);
        }
        return (IWorkspace)workspaces.get(0);
    }

    protected int doRun() throws CLIClientException {
        File directory;
        File[] fList;
        Object items;
        int result = 0;
        this.fSdtOut.write(Messages.RPPUploadSandoxCommand_UPLOAD_START);
        HashSet<String> existingComponents = new HashSet<String>();
        if (this.fExistingComponentsInWorkspace != null) {
            for (IComponent component : this.fExistingComponentsInWorkspace) {
                existingComponents.add(component.getName());
            }
        }
        HashSet<String> newComponents = new HashSet<String>();
        HashSet<String> sharedFolders = new HashSet<String>();
        HashSet<String> localFolders = new HashSet<String>();
        HashSet<String> foldersToShare = new HashSet<String>();
        if (!this.fReShareAll) {
            try {
                List componentHandles = this.fWorkspaceConnection.getComponents();
                for (IComponentHandle compHandle : componentHandles) {
                    IConfiguration compConfig = this.fWorkspaceConnection.configuration(compHandle);
                    Map handles = compConfig.childEntriesForRoot(null);
                    items = compConfig.fetchCompleteItems(new ArrayList(handles.values()), null);
                    Iterator iterator = items.iterator();
                    while (iterator.hasNext()) {
                        IVersionable v = (IVersionable)iterator.next();
                        if (v == null || !(v instanceof IFolder)) continue;
                        sharedFolders.add(v.getName());
                    }
                }
            }
            catch (TeamRepositoryException tre) {
                throw new CLIClientException((Throwable)tre);
            }
        }
        if ((fList = (directory = new File(this.fSandBoxPath)).listFiles()) == null) {
            return -1;
        }
        items = fList;
        int handles = fList.length;
        int compConfig = 0;
        while (compConfig < handles) {
            File file = items[compConfig];
            if (file.isDirectory() && !file.getName().startsWith(".") && file.getName().startsWith(this.fLocationName)) {
                localFolders.add(file.getName());
            }
            ++compConfig;
        }
        for (String folder : localFolders) {
            if (sharedFolders.contains(folder)) continue;
            foldersToShare.add(folder);
            String componentName = folder;
            if (!this.fIsSepareCobolComp) {
                componentName = folder.replace(COB_EXTENSION, "");
            }
            if (existingComponents.contains(componentName)) continue;
            newComponents.add(componentName);
        }
        for (String component : newComponents) {
            try {
                if (this.createComponent(component)) continue;
                this.fStdErr.println(String.valueOf(Messages.RPPUploadSandoxCommand_ERROR_COMP_CREATION) + component);
                result = -1;
            }
            catch (PropertyConstraintException propertyConstraintException) {
                try {
                    IComponentHandle componentHandle = this.getComponentMap(this.fRepo, (IProgressMonitor)new NullProgressMonitor()).get(component);
                    if (componentHandle == null) continue;
                    this.fWorkspaceConnection.addComponent(componentHandle, true, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (Exception e1) {
                    this.fStdErr.println(String.valueOf(Messages.RPPUploadSandoxCommand_ERROR_COMP_CREATION) + component, e1);
                    result = -1;
                }
            }
            catch (Exception e) {
                this.fStdErr.println(String.valueOf(Messages.RPPUploadSandoxCommand_ERROR_COMP_CREATION) + component, e);
                result = -1;
            }
        }
        for (String folder : foldersToShare) {
            try {
                if (!this.share(this.fSandBoxPath, folder, this.fIsSepareCobolComp ? folder : folder.replace(COB_EXTENSION, ""))) {
                    this.fStdErr.println(String.valueOf(Messages.RPPUploadSandoxCommand_SHARE_ERROR) + " " + folder);
                    result = -1;
                }
            }
            catch (Exception e) {
                result = -1;
                this.fStdErr.println(String.valueOf(Messages.RPPUploadSandoxCommand_SHARE_ERROR) + " " + folder, e);
            }
            try {
                this.updateSandbox();
            }
            catch (FileSystemException fileSystemException) {}
        }
        if (this.fStatusFile != null) {
            HashSet<String> foldersToCheking = new HashSet<String>();
            HashSet<String> foldersToDeliver = new HashSet<String>();
            RPPShowStatusCommand.checkStatus(foldersToCheking, foldersToDeliver, this.fStatusFile, false);
            HashSet<String> createdChangeset = new HashSet<String>();
            Iterator iterator = foldersToCheking.iterator();
            while (iterator.hasNext()) {
                String folder;
                block42: {
                    String componentName = folder = (String)iterator.next();
                    if (!this.fIsSepareCobolComp) {
                        componentName = folder.replace(COB_EXTENSION, "");
                    }
                    if (!createdChangeset.contains(componentName)) {
                        createdChangeset.add(componentName);
                        try {
                            this.fSdtOut.write(String.valueOf(Messages.RPPUploadSandoxCommand_CS_CREATION) + " " + componentName);
                            String csUUID = this.createChangeSet(componentName);
                            if (csUUID == null) break block42;
                            this.fCsUUIDs.add(csUUID);
                        }
                        catch (Exception e) {
                            result = -1;
                            this.fStdErr.println(String.valueOf(Messages.RPPUploadSandoxCommand_CS_CREATION_ERROR) + " " + componentName, e);
                            continue;
                        }
                    }
                }
                try {
                    this.checkin(folder);
                }
                catch (Exception e) {
                    result = -1;
                    this.fStdErr.println(String.valueOf(Messages.RPPUploadSandoxCommand_CHEKIN_FOLDER_ERROR) + " " + folder, e);
                }
            }
        }
        if (this.fStatusFile == null) {
            try {
                this.checkin();
            }
            catch (Exception e) {
                result = -1;
                this.fStdErr.println(Messages.RPPUploadSandoxCommand_CHECKIN_ALL_ERROR, e);
            }
        }
        if (this.fWorkItemNumber > 0) {
            try {
                if (!this.linkChangeSetsToWorkItem()) {
                    result = -1;
                    this.fStdErr.println(Messages.RPPUploadSandoxCommand_LINK_WORKITEM_CS_ERROR);
                }
            }
            catch (TeamRepositoryException e) {
                result = -1;
                this.fStdErr.println(Messages.RPPUploadSandoxCommand_LINK_WORKITEM_CS_ERROR, (Exception)((Object)e));
            }
        }
        try {
            if (!this.deliver()) {
                this.fStdErr.println(Messages.RPPUploadSandoxCommand_ERROR_DELIVER);
                result = -1;
            }
        }
        catch (Exception e) {
            this.fStdErr.println(Messages.RPPUploadSandoxCommand_ERROR_DELIVER, e);
            result = -1;
        }
        this.fSdtOut.write(Messages.RPPUploadSandoxCommand_UPLOAD_END);
        return result;
    }

    private boolean linkChangeSetsToWorkItem() throws TeamRepositoryException {
        List changeSetHandles;
        this.fSdtOut.write(Messages.RPPUploadSandoxCommand_LINK_WI_CHANGESET_START);
        int nbCsFound = 0;
        boolean result = true;
        NullProgressMonitor progressMonitor = new NullProgressMonitor();
        IWorkItemClient workItemClient = (IWorkItemClient)this.fRepo.getClientLibrary(IWorkItemClient.class);
        IFileSystemWorkItemManager fileSystemWorkItemManager = (IFileSystemWorkItemManager)this.fRepo.getClientLibrary(IFileSystemWorkItemManager.class);
        IWorkItem workItem = workItemClient.findWorkItemById(this.fWorkItemNumber, IWorkItem.FULL_PROFILE, (IProgressMonitor)progressMonitor);
        if (workItem == null) {
            this.fStdErr.println(String.valueOf(Messages.RPPUploadSandoxCommand_LINK_WORKITEM_CS_ERROR) + " -> Cannot find work item : " + this.fWorkItemNumber);
            return false;
        }
        for (String csUUID : this.fCsUUIDs) {
            try {
                ++nbCsFound;
                IItemHandle handle = IComponent.ITEM_TYPE.createItemHandle(UUID.valueOf((String)csUUID), null);
                IItem item = this.fRepo.itemManager().fetchCompleteItem(handle, 0, null);
                IChangeSetHandle changeSetHandle = (IChangeSetHandle)item.getItemHandle();
                fileSystemWorkItemManager.createLink((IWorkspaceHandle)this.fWorkspace, changeSetHandle, new IWorkItemHandle[]{(IWorkItemHandle)workItem.getItemHandle()}, (IProgressMonitor)progressMonitor);
            }
            catch (Exception e) {
                result = false;
                this.fStdErr.println(Messages.RPPUploadSandoxCommand_LINK_WORKITEM_CS_ERROR, e);
            }
        }
        if (!this.fIsGlobalStrategy) {
            for (IChangeSetHandle changeSetHandle : this.fChangeSet2LocalChanges.keySet()) {
                try {
                    ++nbCsFound;
                    fileSystemWorkItemManager.createLink((IWorkspaceHandle)this.fWorkspace, changeSetHandle, new IWorkItemHandle[]{(IWorkItemHandle)workItem.getItemHandle()}, (IProgressMonitor)progressMonitor);
                }
                catch (Exception e) {
                    result = false;
                    this.fStdErr.println(Messages.RPPUploadSandoxCommand_LINK_WORKITEM_CS_ERROR, e);
                }
            }
        }
        if ((changeSetHandles = this.fWorkspaceConnection.activeChangeSets()).size() != nbCsFound) {
            this.fStdErr.println(String.valueOf(Messages.RPPUploadSandoxCommand_LINK_WORKITEM_CS_ERROR) + " -> check for changes number differ : " + nbCsFound + "/" + changeSetHandles.size());
        }
        try {
            if (!new File(String.valueOf(this.fSandBoxPath) + "/.metadata/.zcompmap.out.log").exists() && !this.linkAttachmentsToWorkItem(workItem)) {
                result = false;
            }
        }
        catch (Exception ex) {
            result = false;
            this.fStdErr.println(Messages.RPPUploadSandoxCommand_LINK_WORKITEM_CS_ERROR, ex);
        }
        this.fSdtOut.write(Messages.RPPUploadSandoxCommand_LINK_WI_CHANGESET_END);
        return result;
    }

    private boolean linkAttachmentsToWorkItem(IWorkItem workItem) throws TeamRepositoryException, IOException {
        ArrayList<String> filesToZip = new ArrayList<String>();
        String baseDir = String.valueOf(this.fSandBoxPath) + "/.metadata/";
        filesToZip.add(String.valueOf(baseDir) + ".pacmigration.log");
        filesToZip.add(String.valueOf(baseDir) + ".pacdispatchmacro.log");
        filesToZip.add(String.valueOf(baseDir) + "imported_data_" + this.fLocationName + ".xml");
        byte[] data = new byte[8192];
        String zipFileName = String.valueOf(baseDir) + "RPP_LOGS_" + System.currentTimeMillis() + ".zip";
        FileOutputStream fout = new FileOutputStream(zipFileName);
        ZipOutputStream zout = new ZipOutputStream(fout);
        boolean flag = false;
        for (String fileName : filesToZip) {
            File file = new File(fileName);
            if (!file.exists()) continue;
            flag = true;
            ZipEntry ze = new ZipEntry(fileName);
            zout.putNextEntry(ze);
            FileInputStream fileInputStream = new FileInputStream(fileName);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream, 8192);
            int size = -1;
            while ((size = bufferedInputStream.read(data, 0, 8192)) != -1) {
                zout.write(data, 0, size);
            }
            bufferedInputStream.close();
            zout.closeEntry();
        }
        zout.close();
        if (flag) {
            File file = new File(zipFileName);
            RPPWorkItemUploadAttachmentOperation operation = new RPPWorkItemUploadAttachmentOperation(file.getAbsolutePath(), "application/unknown", "us-ascii", file.getName(), this.fStdErr);
            operation.run((IWorkItemHandle)workItem, null);
            return operation.getResult();
        }
        return true;
    }

    protected IRPPzDSLangDefWriter getWriter(PrintStream out, boolean verbose, boolean quiet, boolean isError) {
        DefaultRPPzDSLangDefWriter writer = new DefaultRPPzDSLangDefWriter(out);
        writer.setVerbose(verbose);
        writer.setQuiet(quiet);
        writer.setErrorWrite(isError);
        return writer;
    }

    private boolean createComponent(String name) throws TeamRepositoryException {
        this.fSdtOut.write(String.valueOf(Messages.RPPUploadSandoxCommand_COMP_CREATION) + name);
        ParmsPutWorkspace parms = new ParmsPutWorkspace();
        parms.workspace = new ParmsWorkspace();
        parms.workspace.repositoryUrl = this.fRepo.getRepositoryURI();
        parms.workspace.workspaceItemId = this.fWorkspace.getItemId().getUuidValue();
        parms.configurationChanges = new ParmsConfigurationChanges();
        parms.configurationChanges.components = new ParmsComponentChange[]{new ParmsComponentChange()};
        parms.configurationChanges.components[0].cmd = "addComponent";
        parms.configurationChanges.components[0].name = name;
        PutWorkspaceResultDTO result = this.fClient.postPutWorkspace(parms, null);
        if (!result.isSetComponentsAdded()) {
            return false;
        }
        List componentsAdded = result.getComponentsAdded();
        if (componentsAdded.size() != 1) {
            return false;
        }
        ParmsPutComponent parmsComponent = new ParmsPutComponent();
        parmsComponent.componentItemId = ((ConfigurationDescriptorDTO)componentsAdded.get(0)).getComponentItemId();
        parmsComponent.newOwnerItemType = this.fProjectArea.getItemType().getName();
        parmsComponent.newOwnerItemId = this.fProjectArea.getItemId().getUuidValue();
        parmsComponent.repositoryUrl = this.fRepo.getRepositoryURI();
        this.fClient.postPutComponent(parmsComponent, null);
        return true;
    }

    private boolean share(String sandBox, String folder, String componentName) throws TeamRepositoryException {
        ShareResultDTO shareResult;
        this.fSdtOut.write(String.valueOf(Messages.RPPUploadSandoxCommand_SHARE_FOLDER) + folder + Messages.RPPUploadSandoxCommand_INTO_COMPONENT + " " + componentName);
        ParmsShare parmsShare = new ParmsShare();
        ParmsWorkspace ws = new ParmsWorkspace(this.fRepo.getRepositoryURI(), this.fWorkspace.getItemId().getUuidValue());
        parmsShare.shareRequests = this.generateShareRequests(String.valueOf(sandBox) + "\\" + folder, componentName, ws);
        if (parmsShare.shareRequests == null) {
            return false;
        }
        parmsShare.overwrite = true;
        parmsShare.sandboxUpdateDilemmaHandler = new ParmsSandboxUpdateDilemmaHandler();
        parmsShare.sandboxUpdateDilemmaHandler.backupDilemmaHandler = new ParmsBackupDilemmaHandler();
        parmsShare.sandboxUpdateDilemmaHandler.backupDilemmaHandler.backupEnabled = true;
        parmsShare.sandboxUpdateDilemmaHandler.deletedContentDilemmaHandler = new ParmsDeletedContentDilemmaHandler();
        parmsShare.sandboxUpdateDilemmaHandler.deletedContentDilemmaHandler.deletedContentDirection = "continue";
        if (!this.fIsGlobalStrategy) {
            parmsShare.checkInNewShareChildren = false;
        }
        if ((shareResult = this.fClient.postShare(parmsShare, null)) != null) {
            if (shareResult.getShareOverlaps().size() > 0) {
                this.fStdErr.println(Messages.RPPUploadSandoxCommand_SHARE_ERROR_OVERLAPING);
                for (ShareOverlapDTO shareOverlap : shareResult.getShareOverlaps()) {
                    Iterator localIterator2 = shareOverlap.getOverlappingShares().iterator();
                    ShareDTO shareDTO = (ShareDTO)localIterator2.next();
                    List pathSegments = shareDTO.getPath().getSegments();
                    String path = StringUtil.createPathString((String[])pathSegments.toArray(new String[pathSegments.size()]));
                    this.fStdErr.println(" " + path);
                    localIterator2.hasNext();
                }
                return false;
            }
            List cs = shareResult.getChangeSetsCommitted();
            if (cs != null && cs.size() == 1) {
                String csUUID = cs.get(0).toString();
                this.fCsUUIDs.add(csUUID);
            }
        }
        this.fClient.postDeregisterSandbox(new ParmsSandboxes(new String[]{sandBox}), null);
        return true;
    }

    private void updateSandbox() throws FileSystemException {
        if (this.fSandbox == null) {
            ILocation source = SubcommandUtil.makeAbsolutePath((IScmClientConfiguration)this.fConfig, (String)this.fSandBoxPath);
            this.fSandbox = SubcommandUtil.findSandboxContaining((ILocation)source);
        }
    }

    private ParmsShareRequest[] generateShareRequests(String folder, String componentName, ParmsWorkspace ws) throws FileSystemException {
        Object sandboxPath;
        ArrayList<String> shares;
        ArrayList<ParmsShareRequest> shareRequests = new ArrayList<ParmsShareRequest>();
        HashMap<String, ArrayList<String>> sandboxToShares = new HashMap<String, ArrayList<String>>();
        ILocation root = SubcommandUtil.makeAbsolutePath((IScmClientConfiguration)this.fConfig, (String)folder);
        ILocation rootParent = root.getParent();
        File sandboxFile = null;
        if (!rootParent.isEmpty()) {
            sandboxFile = SubcommandUtil.findAncestorCFARoot((String)root.toOSString());
        }
        if ((shares = (ArrayList<String>)sandboxToShares.get((sandboxPath = sandboxFile == null ? rootParent : new PathLocation(sandboxFile.getAbsolutePath())).toOSString())) == null) {
            shares = new ArrayList<String>();
            sandboxToShares.put(sandboxPath.toOSString(), shares);
        }
        shares.add(root.getLocationRelativeTo(sandboxPath).toString());
        WorkspaceComponentDTO component = this.getWorkspaceComponentDTO(ws, componentName);
        if (component == null) {
            this.fStdErr.println(NLS.bind((String)Messages.RPPUploadSandoxCommand_SHARE_FOLDER_ACCEPT_COMPONENT, (Object)this.fWorkspace.getName(), (Object)componentName));
            return null;
        }
        for (Map.Entry entry : sandboxToShares.entrySet()) {
            ParmsShareRequest shareRequest = new ParmsShareRequest();
            shareRequest.workspace = ws;
            shareRequest.componentItemId = component.getItemId();
            shareRequest.parentFolderItemId = component.getRootFolder();
            shareRequest.sandboxPath = (String)entry.getKey();
            shareRequest.itemsToShare = ((List)entry.getValue()).toArray(new String[((List)entry.getValue()).size()]);
            shareRequests.add(shareRequest);
        }
        return shareRequests.toArray(new ParmsShareRequest[shareRequests.size()]);
    }

    private WorkspaceComponentDTO getWorkspaceComponentDTO(ParmsWorkspace ws, String componentName) throws FileSystemException {
        WorkspaceComponentDTO component = null;
        WorkspaceDetailsDTO wsDetails = (WorkspaceDetailsDTO)RepoUtil.getWorkspaceDetails(Collections.singletonList(ws), (IFilesystemRestClient)this.fClient, (IScmClientConfiguration)this.fConfig).get(0);
        for (Object object : wsDetails.getComponents()) {
            WorkspaceComponentDTO comp = (WorkspaceComponentDTO)object;
            if (!componentName.equals(comp.getName())) continue;
            component = comp;
            break;
        }
        return component;
    }

    private String createChangeSet(String componentName) throws TeamRepositoryException {
        ParmsWorkspace ws = new ParmsWorkspace(this.fRepo.getRepositoryURI(), this.fWorkspace.getItemId().getUuidValue());
        WorkspaceComponentDTO component = this.getWorkspaceComponentDTO(ws, componentName);
        ParmsCreateChangeSet parms = new ParmsCreateChangeSet();
        parms.workspace = ws;
        parms.componentItemId = component.getItemId();
        parms.comment = this.fCsComment;
        parms.current = true;
        CreateResultDTO result = this.fClient.postCreateChangeSet(parms, null);
        return result.getChangeSetItemId();
    }

    private void checkin(String folder) throws TeamRepositoryException {
        this.fSdtOut.write(String.valueOf(Messages.RPPUploadSandoxCommand_CHECKIN_FOLDER) + folder);
        String component = folder;
        if (!this.fIsSepareCobolComp) {
            component = folder.replace(COB_EXTENSION, "");
        }
        CLIFileSystemClientException checkinEx = null;
        ILocalChangeManager lcm = FileSystemCore.getSharingManager().getLocalChangeManager();
        IContextHandle wsHandle = this.fWorkspaceConnection.getContextHandle();
        ICheckinOperation checkinOperation = IOperationFactory.instance.getCheckinOperation(null, new IRepositoryResolver(){

            public ITeamRepository getRepoFor(String arg0, UUID arg1) {
                return RPPUploadSandoxCommand.this.fRepo;
            }
        });
        List componentHandles = this.fWorkspaceConnection.getComponents();
        NullProgressMonitor progressMonitor = new NullProgressMonitor();
        IComponentHandle compHandle = null;
        for (IComponentHandle componentHandle : componentHandles) {
            IComponent comp = (IComponent)this.fRepo.itemManager().fetchCompleteItem((IItemHandle)componentHandle, 0, (IProgressMonitor)progressMonitor);
            if (!component.equals(comp.getName())) continue;
            compHandle = componentHandle;
            break;
        }
        if (compHandle == null) {
            this.fStdErr.println(String.valueOf(Messages.RPPUploadSandoxCommand_CHECKIN_ERROR_COMPONENT_NOT_FOUND) + component);
            return;
        }
        lcm.syncPendingChanges(wsHandle, compHandle, this.fSandbox, null);
        ILocalChange[] localChanges = lcm.getPendingChanges(wsHandle, compHandle, this.fSandbox);
        if (localChanges.length == 0) {
            return;
        }
        checkinOperation.requestCheckin(localChanges, null, "", null);
        try {
            checkinOperation.run(null);
        }
        catch (TeamRepositoryException ex) {
            checkinEx = StatusHelper.wrap((String)Messages.RPPCliCommand_SHARING_ERROR, (TeamRepositoryException)ex, (IndentingPrintStream)this.fIndentStdErr);
        }
        catch (Throwable t) {
            checkinEx = StatusHelper.failure((String)Messages.RPPCliCommand_SHARING_ERROR, (Throwable)t);
        }
        if (checkinEx != null) {
            throw checkinEx;
        }
    }

    private void checkin() throws TeamRepositoryException {
        if (this.fSandbox == null) {
            return;
        }
        HashSet<String> createdChangeset = new HashSet<String>();
        this.fSdtOut.write(Messages.RPPUploadSandoxCommand_CHECKIN_ALL_START);
        CLIFileSystemClientException checkinEx = null;
        ILocalChangeManager lcm = FileSystemCore.getSharingManager().getLocalChangeManager();
        if (this.fIsRefreshSandbox) {
            this.fSdtOut.write(Messages.RPPUploadSandoxCommand_REFRESH_ALL_START);
            lcm.refreshChanges(new ISandbox[]{this.fSandbox}, ILocalChangeManager.RefreshType.TRAVERSE_ALL_WITH_RECOMPUTE_OF_KNOWN, null);
            this.fSdtOut.write(Messages.RPPUploadSandoxCommand_REFRESH_ALL_END);
        }
        IContextHandle wsHandle = this.fWorkspaceConnection.getContextHandle();
        List componentHandles = this.fWorkspaceConnection.getComponents();
        NullProgressMonitor progressMonitor = new NullProgressMonitor();
        for (IComponentHandle componentHandle : componentHandles) {
            ILocalChange[] localChanges;
            String componentName;
            block18: {
                ILocalChange localChange;
                int n;
                int n2;
                ILocalChange[] iLocalChangeArray;
                IComponent comp = (IComponent)this.fRepo.itemManager().fetchCompleteItem((IItemHandle)componentHandle, 0, (IProgressMonitor)progressMonitor);
                componentName = comp.getName();
                lcm.syncPendingChanges(wsHandle, componentHandle, this.fSandbox, null);
                localChanges = lcm.getPendingChanges(wsHandle, componentHandle, this.fSandbox);
                if (localChanges.length == 0) continue;
                if (this.fVerbose) {
                    iLocalChangeArray = localChanges;
                    n2 = localChanges.length;
                    n = 0;
                    while (n < n2) {
                        localChange = iLocalChangeArray[n];
                        this.fSdtOut.write(localChange.toString());
                        ++n;
                    }
                }
                if (!this.fIsGlobalStrategy) {
                    this.fSdtOut.write(String.valueOf(Messages.RPPUploadSandoxCommand_CS_BY_AFFINITY_CREATE) + " " + componentName);
                    iLocalChangeArray = localChanges;
                    n2 = localChanges.length;
                    n = 0;
                    while (n < n2) {
                        localChange = iLocalChangeArray[n];
                        IChangeSetResolver.ChangeSetHolder changeSetHolder = this.fChangeSetResolver.getChangeSetForCheckinOperation(this.fWorkspaceConnection, localChange, (IProgressMonitor)progressMonitor);
                        IChangeSetHandle csh = changeSetHolder.handle;
                        if (csh != null) {
                            LocalChangesHolder lch = this.fChangeSet2LocalChanges.get(csh);
                            if (lch == null) {
                                lch = new LocalChangesHolder();
                                lch.localChanges = new ArrayList<ILocalChange>();
                                this.fChangeSet2LocalChanges.put(csh, lch);
                            }
                            lch.localChanges.add(localChange);
                            lch.toBeRunAlone = lch.toBeRunAlone || changeSetHolder.toBeRunAlone;
                        }
                        ++n;
                    }
                    IRepositoryResolver repositoryResolver = new IRepositoryResolver(){

                        public ITeamRepository getRepoFor(String uri, UUID id) throws TeamRepositoryException {
                            return RPPUploadSandoxCommand.this.fRepo;
                        }
                    };
                    try {
                        this.createCheckinRequests((IProgressMonitor)progressMonitor, this.fChangeSet2LocalChanges, repositoryResolver);
                    }
                    catch (TeamRepositoryException ex) {
                        checkinEx = StatusHelper.wrap((String)Messages.RPPUploadSandoxCommand_CHECKIN_ERROR_COMPONENT, (TeamRepositoryException)ex, (IndentingPrintStream)this.fIndentStdErr);
                    }
                    catch (Throwable t) {
                        checkinEx = StatusHelper.failure((String)Messages.RPPUploadSandoxCommand_CHECKIN_ERROR_COMPONENT, (Throwable)t);
                    }
                    if (checkinEx == null) continue;
                    this.fStdErr.println(String.valueOf(Messages.RPPUploadSandoxCommand_CHECKIN_ERROR_COMPONENT) + componentName, (Exception)checkinEx);
                    checkinEx = null;
                    continue;
                }
                if (!createdChangeset.contains(componentName)) {
                    createdChangeset.add(componentName);
                    try {
                        this.fSdtOut.write(String.valueOf(Messages.RPPUploadSandoxCommand_CS_CREATE) + componentName);
                        String csUUID = this.createChangeSet(componentName);
                        if (csUUID == null) break block18;
                        this.fCsUUIDs.add(csUUID);
                    }
                    catch (TeamRepositoryException tre) {
                        this.fStdErr.println(String.valueOf(Messages.RPPUploadSandoxCommand_CS_CREATE_FAILED) + componentName, (Exception)((Object)tre));
                        continue;
                    }
                }
            }
            this.fSdtOut.write(String.valueOf(Messages.RPPUploadSandoxCommand_CHECKIN_COMPONENT) + componentName);
            ICheckinOperation checkinOperation = IOperationFactory.instance.getCheckinOperation(null, new IRepositoryResolver(){

                public ITeamRepository getRepoFor(String arg0, UUID arg1) {
                    return RPPUploadSandoxCommand.this.fRepo;
                }
            });
            checkinOperation.requestCheckin(localChanges, null, "", null);
            try {
                checkinOperation.run(null);
            }
            catch (TeamRepositoryException ex) {
                checkinEx = StatusHelper.wrap((String)Messages.RPPUploadSandoxCommand_CHECKIN_ERROR_COMPONENT, (TeamRepositoryException)ex, (IndentingPrintStream)this.fIndentStdErr);
            }
            catch (Throwable t) {
                checkinEx = StatusHelper.failure((String)Messages.RPPUploadSandoxCommand_CHECKIN_ERROR_COMPONENT, (Throwable)t);
            }
            if (checkinEx == null) continue;
            this.fStdErr.println(String.valueOf(Messages.RPPUploadSandoxCommand_CHECKIN_ERROR_COMPONENT) + componentName, (Exception)checkinEx);
            checkinEx = null;
        }
        this.fSdtOut.write(Messages.RPPUploadSandoxCommand_CHECKIN_ALL_END);
    }

    private boolean deliver() throws TeamRepositoryException {
        this.fSdtOut.write(Messages.RPPUploadSandoxCommand_DELIVER_START);
        boolean result = true;
        List componentHandles = this.fWorkspaceConnection.getComponents();
        NullProgressMonitor progressMonitor = new NullProgressMonitor();
        for (IComponentHandle componentHandle : componentHandles) {
            try {
                this.fStreamConnection.addComponent(componentHandle, true, (IProgressMonitor)progressMonitor);
            }
            catch (Exception exception) {}
            List activeChangeSets = this.fWorkspaceConnection.activeChangeSets(componentHandle);
            if (activeChangeSets.size() == 0) continue;
            ArrayList<IChangeSet> changeSetToDelivers = new ArrayList<IChangeSet>();
            for (IChangeSetHandle changeSetHandle : activeChangeSets) {
                if (!(changeSetHandle instanceof IChangeSet)) continue;
                changeSetToDelivers.add((IChangeSet)changeSetHandle);
            }
            IComponent comp = (IComponent)this.fRepo.itemManager().fetchCompleteItem((IItemHandle)componentHandle, 0, (IProgressMonitor)progressMonitor);
            try {
                IChangeHistorySyncReport sync = this.fWorkspaceConnection.compareTo((IFlowNodeConnection)this.fStreamConnection, 0, Collections.EMPTY_LIST, null);
                List list = sync.outgoingChangeSets(componentHandle);
                if (list.size() == 0) continue;
                this.fSdtOut.write(String.valueOf(Messages.RPPUploadSandoxCommand_DELIVER_COMPONENT) + comp.getName());
                this.fWorkspaceConnection.deliver(this.fStreamConnection, sync, this.fWorkspaceConnection.getBaselineSets(null), changeSetToDelivers, null);
            }
            catch (TeamRepositoryException tre) {
                this.fStdErr.println(String.valueOf(Messages.RPPUploadSandoxCommand_DELIVER_ERROR) + comp.getName(), (Exception)((Object)tre));
                result = false;
            }
        }
        this.fSdtOut.write(Messages.RPPUploadSandoxCommand_DELIVER_END);
        return result;
    }

    private void createCheckinRequests(IProgressMonitor monitor, HashMap<IChangeSetHandle, LocalChangesHolder> changeSet2LocalChanges, IRepositoryResolver repositoryResolver) throws FileSystemException, TeamRepositoryException {
        if (this.log != null) {
            this.log.info("Checkin start");
        }
        CommitDilemmaHandler handler = new CommitDilemmaHandler(){};
        ICheckinOperation checkInOperation = null;
        for (Map.Entry<IChangeSetHandle, LocalChangesHolder> entry : changeSet2LocalChanges.entrySet()) {
            ILocalChange[] lcs;
            LocalChangesHolder localChangesHolder = entry.getValue();
            if (this.log != null && this.log.isDebugEnabled()) {
                this.log.debug("changeSet contains " + localChangesHolder.localChanges.size() + " localChanges for: ");
                for (ILocalChange localChange : localChangesHolder.localChanges) {
                    this.log.debug(localChange.getPath().toString());
                }
            }
            if ((lcs = localChangesHolder.localChanges.toArray(new ILocalChange[localChangesHolder.localChanges.size()])).length == 0) continue;
            if (checkInOperation == null) {
                checkInOperation = IOperationFactory.instance.getCheckinOperation(handler, repositoryResolver);
            }
            localChangesHolder.localChanges.clear();
            checkInOperation.requestCheckin(lcs, entry.getKey(), "should not happen", monitor);
            if (!localChangesHolder.toBeRunAlone) continue;
            if (this.log != null) {
                this.log.info("Run a Checkin Operation");
            }
            checkInOperation.run(monitor);
            checkInOperation = null;
        }
        if (checkInOperation != null) {
            if (this.log != null) {
                this.log.info("Run last Checkin Operation");
            }
            checkInOperation.run(monitor);
        }
        if (this.log != null) {
            this.log.info("Checkin end");
        }
    }

    private IWorkspaceConnection findConnectionByName(ITeamRepository teamRepository, String name, int kind, IProgressMonitor monitor) throws TeamRepositoryException {
        List workspaces;
        IWorkspaceManager wm = SCMPlatform.getWorkspaceManager((ITeamRepository)teamRepository);
        IWorkspaceSearchCriteria criteria = IWorkspaceSearchCriteria.FACTORY.newInstance().setKind(kind);
        if (name != null) {
            criteria.setExactName(name);
        }
        if ((workspaces = wm.findWorkspaces(criteria, Integer.MAX_VALUE, monitor)) == null || workspaces.isEmpty() || workspaces.size() > 1) {
            return null;
        }
        return wm.getWorkspaceConnection((IWorkspaceHandle)workspaces.get(0), monitor);
    }

    private HashMap<String, IComponentHandle> getComponentMap(ITeamRepository teamRepository, IProgressMonitor monitor) throws TeamRepositoryException {
        if (this.componentMap != null) {
            return this.componentMap;
        }
        IWorkspaceManager wm = SCMPlatform.getWorkspaceManager((ITeamRepository)teamRepository);
        this.componentMap = new HashMap();
        Set components = wm.findAllComponentNames(monitor);
        for (String compName : components) {
            IComponentSearchCriteria criteria = IComponentSearchCriteria.FACTORY.newInstance();
            criteria.setExactName(compName);
            List found = wm.findComponents(criteria, Integer.MAX_VALUE, monitor);
            for (IComponentHandle iComponentHandle : found) {
                this.componentMap.put(compName, iComponentHandle);
            }
        }
        return this.componentMap;
    }

    private class LocalChangesHolder {
        boolean toBeRunAlone = false;
        List<ILocalChange> localChanges = null;

        private LocalChangesHolder() {
        }
    }
}

