/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teampdp.cli.internal.subcommand.uploadsandbox;

import com.ibm.team.filesystem.cli.core.subcommands.IScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.rtc.cli.infrastructure.internal.core.CLIClientException;
import com.ibm.team.rtc.cli.infrastructure.internal.core.IClientConfiguration;
import com.ibm.team.rtc.cli.infrastructure.internal.core.ISubcommand;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLine;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.util.IndentingPrintStream;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.dto.IWorkspaceSearchCriteria;
import com.ibm.teampdp.cli.internal.nls.Messages;
import com.ibm.teampdp.cli.internal.subcommand.DefaultRPPzDSLangDefWriter;
import com.ibm.teampdp.cli.internal.subcommand.IRPPzDSLangDefWriter;
import com.ibm.teampdp.cli.internal.subcommand.uploadsandbox.RPPUploadSandoxCommandOpts;
import com.ibm.teampdp.cli.internal.subcommand.uploadsandbox.resolver.IChangeSetResolver;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;

public class RPPDisplayConfigCommand
implements ISubcommand {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2020.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private IScmClientConfiguration fConfig;
    private IRPPzDSLangDefWriter fStdErr;
    private ISandbox fSandbox;
    private IRPPzDSLangDefWriter fSdtOut;
    private IFilesystemRestClient fClient;
    private ITeamRepository fRepo;
    private IWorkspace fWorkspace;
    private IWorkspaceConnection fWorkspaceConnection;
    private String fSandBoxPath;
    private String fLocationName;
    private IProjectArea fProjectArea;
    private IWorkspaceConnection fStreamConnection;
    boolean fIsDryRun = true;
    private boolean fReShareAll = false;
    private String fCsComment;
    private String fStatusFile;
    private boolean fVerbose;
    private String fWorkspaceName;
    private boolean fIsRefreshSandbox;
    private IndentingPrintStream fIndentStdErr;
    private String fConfigDir;
    private boolean fIsGlobalStrategy = true;
    IChangeSetResolver fChangeSetResolver = null;
    private boolean fIsSepareCobolComp = false;

    private void validateCommandLine(ICommandLine cmdLine) throws FileSystemException {
        if (!cmdLine.hasOption((IOptionKey)RPPUploadSandoxCommandOpts.OPT_WORKSPACE)) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.RPPCliCommand_MISSING_REQUIRED_ARGUMENT, (Object)RPPUploadSandoxCommandOpts.OPT_WORKSPACE.getName()));
        }
        if (!cmdLine.hasOption((IOptionKey)RPPUploadSandoxCommandOpts.OPT_SANDBOX)) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.RPPCliCommand_MISSING_REQUIRED_ARGUMENT, (Object)RPPUploadSandoxCommandOpts.OPT_SANDBOX.getName()));
        }
        if (!cmdLine.hasOption((IOptionKey)RPPUploadSandoxCommandOpts.OPT_LOCATION)) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.RPPCliCommand_MISSING_REQUIRED_ARGUMENT, (Object)RPPUploadSandoxCommandOpts.OPT_LOCATION.getName()));
        }
        if (!cmdLine.hasOption((IOptionKey)RPPUploadSandoxCommandOpts.OPT_PROJECT_AREA)) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.RPPCliCommand_MISSING_REQUIRED_ARGUMENT, (Object)RPPUploadSandoxCommandOpts.OPT_PROJECT_AREA.getName()));
        }
        if (!cmdLine.hasOption((IOptionKey)RPPUploadSandoxCommandOpts.OPT_STREAM)) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.RPPCliCommand_MISSING_REQUIRED_ARGUMENT, (Object)RPPUploadSandoxCommandOpts.OPT_STREAM.getName()));
        }
        if (!cmdLine.hasOption((IOptionKey)RPPUploadSandoxCommandOpts.OPT_COMMENT)) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.RPPCliCommand_MISSING_REQUIRED_ARGUMENT, (Object)RPPUploadSandoxCommandOpts.OPT_COMMENT.getName()));
        }
        if (cmdLine.hasOption((IOptionKey)RPPUploadSandoxCommandOpts.OPT_STRATEGY)) {
            String strategy = cmdLine.getOption((IOptionKey)RPPUploadSandoxCommandOpts.OPT_STRATEGY, null);
            if (!"global".equals(strategy) && !"affinity".equals(strategy)) {
                throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.RPPCliCommand_MISSING_REQUIRED_ARGUMENT, (Object)RPPUploadSandoxCommandOpts.OPT_STRATEGY.getName()));
            }
            this.fIsGlobalStrategy = "global".equals(strategy);
        }
        if (cmdLine.hasOption((IOptionKey)RPPUploadSandoxCommandOpts.OPT_SEPARATE_COB_COMP)) {
            this.fIsSepareCobolComp = true;
        }
        if (cmdLine.hasOption((IOptionKey)RPPUploadSandoxCommandOpts.OPT_WORKITEM)) {
            String workItem = cmdLine.getOption((IOptionKey)RPPUploadSandoxCommandOpts.OPT_WORKITEM, null);
            try {
                Integer.parseInt(workItem);
            }
            catch (Exception exception) {
                throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.RPPCliCommand_MISSING_REQUIRED_ARGUMENT, (Object)RPPUploadSandoxCommandOpts.OPT_WORKITEM.getName()));
            }
        }
    }

    public int run(IClientConfiguration config) throws CLIClientException {
        int result = this.runCommand(config);
        if (result != 0) {
            return -1;
        }
        return 0;
    }

    /*
     * Exception decompiling
     */
    public int runCommand(IClientConfiguration config) throws CLIClientException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static IWorkspaceConnection findNamedWorkspaceConnection(String nameOrUUID, ITeamRepository repo, IScmClientConfiguration config) throws FileSystemException, RepoUtil.UnmatchedSelectorException, RepoUtil.AmbiguousSelectorException {
        IWorkspace wsHandle = RPPDisplayConfigCommand.findNamedWorkspace(nameOrUUID, repo, config);
        IWorkspaceManager manager = SCMPlatform.getWorkspaceManager((ITeamRepository)repo);
        try {
            return manager.getWorkspaceConnection((IWorkspaceHandle)wsHandle, null);
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap((String)NLS.bind((String)Messages.RepoUtil_11, (Object)nameOrUUID), (TeamRepositoryException)e, (IndentingPrintStream)new IndentingPrintStream((OutputStream)config.getContext().stderr()), (String)repo.getRepositoryURI());
        }
    }

    private static IWorkspace findNamedWorkspace(String selector, ITeamRepository repo, IScmClientConfiguration config) throws FileSystemException, RepoUtil.UnmatchedSelectorException, RepoUtil.AmbiguousSelectorException {
        ArrayList workspaceHandles = new ArrayList();
        IWorkspaceSearchCriteria criteria = IWorkspaceSearchCriteria.FACTORY.newInstance().setExactName(selector);
        criteria.setKind(2);
        try {
            List foundWorkspaceHandles = SCMPlatform.getWorkspaceManager((ITeamRepository)repo).findWorkspaces(criteria, Integer.MAX_VALUE, null);
            workspaceHandles.addAll(foundWorkspaceHandles);
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap((String)Messages.RepoUtil_9, (TeamRepositoryException)e, (IndentingPrintStream)new IndentingPrintStream((OutputStream)config.getContext().stderr()), (String)repo.getRepositoryURI());
        }
        ArrayList<IWorkspace> workspaces = new ArrayList<IWorkspace>();
        if (workspaceHandles.size() > 0) {
            try {
                List fetchedWorkspaces = repo.itemManager().fetchCompleteItems(workspaceHandles, 0, null);
                for (IItem item : fetchedWorkspaces) {
                    if (item == null || !(item instanceof IWorkspace)) continue;
                    IWorkspace workspace = (IWorkspace)item;
                    workspaces.add(workspace);
                }
            }
            catch (TeamRepositoryException e) {
                throw StatusHelper.wrap((String)Messages.RepoUtil_10, (TeamRepositoryException)e, (IndentingPrintStream)new IndentingPrintStream((OutputStream)config.getContext().stderr()), (String)repo.getRepositoryURI());
            }
        }
        if (workspaces.size() == 0) {
            throw new RepoUtil.UnmatchedSelectorException(RepoUtil.ItemType.WORKSPACE, selector, Collections.EMPTY_LIST, Collections.EMPTY_LIST);
        }
        if (workspaces.size() > 1) {
            throw new RepoUtil.AmbiguousSelectorException(RepoUtil.ItemType.WORKSPACE, selector, workspaces, workspaces, repo);
        }
        return (IWorkspace)workspaces.get(0);
    }

    protected int doRun() throws CLIClientException {
        int result = 0;
        return result;
    }

    protected IRPPzDSLangDefWriter getWriter(PrintStream out, boolean verbose, boolean quiet, boolean isError) {
        DefaultRPPzDSLangDefWriter writer = new DefaultRPPzDSLangDefWriter(out);
        writer.setVerbose(verbose);
        writer.setQuiet(quiet);
        writer.setErrorWrite(isError);
        return writer;
    }

    private void updateSandbox() throws FileSystemException {
        if (this.fSandbox == null) {
            ILocation source = SubcommandUtil.makeAbsolutePath((IScmClientConfiguration)this.fConfig, (String)this.fSandBoxPath);
            this.fSandbox = SubcommandUtil.findSandboxContaining((ILocation)source);
        }
    }

    private IWorkspaceConnection findConnectionByName(ITeamRepository teamRepository, String name, int kind, IProgressMonitor monitor) throws TeamRepositoryException {
        List workspaces;
        IWorkspaceManager wm = SCMPlatform.getWorkspaceManager((ITeamRepository)teamRepository);
        IWorkspaceSearchCriteria criteria = IWorkspaceSearchCriteria.FACTORY.newInstance().setKind(kind);
        if (name != null) {
            criteria.setExactName(name);
        }
        if ((workspaces = wm.findWorkspaces(criteria, Integer.MAX_VALUE, monitor)) == null || workspaces.isEmpty() || workspaces.size() > 1) {
            return null;
        }
        return wm.getWorkspaceConnection((IWorkspaceHandle)workspaces.get(0), monitor);
    }
}

