/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teampdp.cli.internal.subcommand.showstatus;

import com.ibm.team.filesystem.cli.core.Constants;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.repository.common.json.JSONArray;
import com.ibm.team.repository.common.json.JSONObject;
import com.ibm.team.rtc.cli.infrastructure.internal.core.CLIClientException;
import com.ibm.team.rtc.cli.infrastructure.internal.core.IClientConfiguration;
import com.ibm.team.rtc.cli.infrastructure.internal.core.ISubcommand;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLine;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionKey;
import com.ibm.teampdp.cli.internal.nls.Messages;
import com.ibm.teampdp.cli.internal.subcommand.DefaultRPPzDSLangDefWriter;
import com.ibm.teampdp.cli.internal.subcommand.IRPPzDSLangDefWriter;
import com.ibm.teampdp.cli.internal.subcommand.showstatus.RPPShowStatusCommandOpts;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Reader;
import java.util.HashSet;
import java.util.ListIterator;
import java.util.Set;
import org.eclipse.osgi.util.NLS;

public class RPPShowStatusCommand
implements ISubcommand {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2015.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private IScmClientConfiguration fConfig;
    private static boolean fVerbose;
    private static IRPPzDSLangDefWriter fStdErr;
    private static IRPPzDSLangDefWriter fSdtOut;

    private void validateCommandLine(ICommandLine cmdLine) throws FileSystemException {
        if (!cmdLine.hasOption((IOptionKey)RPPShowStatusCommandOpts.OPT_STATUS_FILE)) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.RPPCliCommand_MISSING_REQUIRED_ARGUMENT, (Object)RPPShowStatusCommandOpts.OPT_STATUS_FILE.getName()));
        }
    }

    public int run(IClientConfiguration config) throws CLIClientException {
        int result = this.runCommand(config);
        if (result != 0) {
            throw StatusHelper.toCLIClientException((Exception)new FileSystemException("ERROR: See log files"));
        }
        return Constants.STATUS_OK;
    }

    public int runCommand(IClientConfiguration config) throws CLIClientException {
        try {
            this.fConfig = (IScmClientConfiguration)config;
            ICommandLine cmdLine = this.fConfig.getSubcommandCommandLine();
            this.validateCommandLine(cmdLine);
            fStdErr = this.getWriter(this.fConfig.getContext().stderr(), true, false, true);
            fSdtOut = this.getWriter(this.fConfig.getContext().stdout(), cmdLine.hasOption((IOptionKey)CommonOptions.OPT_VERBOSE), cmdLine.hasOption((IOptionKey)CommonOptions.OPT_QUIET), false);
            fVerbose = cmdLine.hasOption((IOptionKey)CommonOptions.OPT_VERBOSE);
            String fStatusFile = cmdLine.getOption((IOptionKey)RPPShowStatusCommandOpts.OPT_STATUS_FILE, null);
            HashSet<String> foldersToCheking = new HashSet<String>();
            HashSet<String> foldersToDeliver = new HashSet<String>();
            fSdtOut.println("Current Sandbox Status");
            RPPShowStatusCommand.checkStatus(foldersToCheking, foldersToDeliver, fStatusFile, fVerbose);
        }
        catch (FileSystemException e) {
            throw new CLIClientException((Throwable)e);
        }
        return 0;
    }

    protected IRPPzDSLangDefWriter getWriter(PrintStream out, boolean verbose, boolean quiet, boolean isError) {
        DefaultRPPzDSLangDefWriter writer = new DefaultRPPzDSLangDefWriter(out);
        writer.setVerbose(verbose);
        writer.setQuiet(quiet);
        writer.setErrorWrite(isError);
        return writer;
    }

    public static void checkStatus(Set<String> foldersToCheking, Set<String> foldersToDeliver, String fStatusFile, boolean verbose) {
        if (fStatusFile == null) {
            return;
        }
        try {
            JSONObject array = JSONObject.parse((Reader)new FileReader(fStatusFile));
            JSONArray workspaces = (JSONArray)array.get((Object)"workspaces");
            if (!workspaces.isEmpty()) {
                JSONObject components = (JSONObject)workspaces.get(0);
                JSONArray componentsList = (JSONArray)components.get((Object)"components");
                if (!components.isEmpty()) {
                    ListIterator compIterator = componentsList.listIterator();
                    while (compIterator.hasNext()) {
                        JSONArray incomingChanges;
                        JSONArray outgoingChanges;
                        JSONObject component = (JSONObject)compIterator.next();
                        JSONArray unresolveds = (JSONArray)component.get((Object)"unresolved");
                        if (unresolveds != null && !unresolveds.isEmpty()) {
                            if (verbose) {
                                fSdtOut.println(String.valueOf(component.get((Object)"name").toString()) + " -> unresolved");
                            }
                            ListIterator iterator = unresolveds.listIterator();
                            while (iterator.hasNext()) {
                                int idx;
                                JSONObject current = (JSONObject)iterator.next();
                                Object path = current.get((Object)"path");
                                if (path == null) continue;
                                JSONObject state = (JSONObject)current.get((Object)"state");
                                String pathName = path.toString();
                                if (verbose) {
                                    fSdtOut.println("  " + pathName + "\t\t\t" + RPPShowStatusCommand.getState(state));
                                }
                                if ((idx = pathName.indexOf(47, 1)) > 0) {
                                    pathName = pathName.substring(1, idx);
                                }
                                foldersToCheking.add(pathName);
                            }
                        }
                        if ((outgoingChanges = (JSONArray)component.get((Object)"outgoing-changes")) != null && !outgoingChanges.isEmpty()) {
                            if (verbose) {
                                fSdtOut.println(String.valueOf(component.get((Object)"name").toString()) + " -> outgoing-changes");
                            }
                            ListIterator iterator = outgoingChanges.listIterator();
                            while (iterator.hasNext()) {
                                JSONObject current = (JSONObject)iterator.next();
                                JSONArray changes = (JSONArray)current.get((Object)"changes");
                                ListIterator changesIterator = changes.listIterator();
                                while (changesIterator.hasNext()) {
                                    int idx;
                                    JSONObject change = (JSONObject)changesIterator.next();
                                    Object path = change.get((Object)"path");
                                    if (path == null) continue;
                                    JSONObject state = (JSONObject)change.get((Object)"state");
                                    String pathName = path.toString();
                                    if (verbose) {
                                        fSdtOut.println("  " + pathName + "\t\t\t" + RPPShowStatusCommand.getState(state));
                                    }
                                    if ((idx = pathName.indexOf(47, 1)) < 0) {
                                        idx = pathName.indexOf(92, 1);
                                    }
                                    if (idx > 0) {
                                        pathName = pathName.substring(1, idx);
                                    }
                                    foldersToDeliver.add(pathName);
                                }
                            }
                        }
                        if ((incomingChanges = (JSONArray)component.get((Object)"incoming-changes")) == null || incomingChanges.isEmpty()) continue;
                        if (verbose) {
                            fSdtOut.println(String.valueOf(component.get((Object)"name").toString()) + " -> incoming-changes");
                        }
                        ListIterator iterator = incomingChanges.listIterator();
                        while (iterator.hasNext()) {
                            JSONObject current = (JSONObject)iterator.next();
                            JSONArray changes = (JSONArray)current.get((Object)"changes");
                            ListIterator changesIterator = changes.listIterator();
                            while (changesIterator.hasNext()) {
                                int idx;
                                JSONObject change = (JSONObject)changesIterator.next();
                                Object path = change.get((Object)"path");
                                if (path == null) continue;
                                JSONObject state = (JSONObject)change.get((Object)"state");
                                String pathName = path.toString();
                                if (verbose) {
                                    fSdtOut.println("  " + pathName + "\t\t\t" + RPPShowStatusCommand.getState(state));
                                }
                                if ((idx = pathName.indexOf(47, 1)) < 0) {
                                    idx = pathName.indexOf(92, 1);
                                }
                                if (idx > 0) {
                                    pathName = pathName.substring(1, idx);
                                }
                                foldersToDeliver.add(pathName);
                            }
                        }
                    }
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            fStdErr.println(String.valueOf(Messages.RPPUploadSandoxCommand_STATUS_READ_ERROR) + fStatusFile);
        }
        catch (IOException iOException) {
            fStdErr.println(String.valueOf(Messages.RPPUploadSandoxCommand_STATUS_READ_ERROR) + fStatusFile);
        }
    }

    private static String getState(JSONObject state) {
        String sState = "error";
        if ("true".equals(state.get((Object)"add").toString())) {
            sState = "add";
        } else if ("true".equals(state.get((Object)"content_change").toString())) {
            sState = "content_change";
        } else if ("true".equals(state.get((Object)"delete").toString())) {
            sState = "delete";
        } else if ("true".equals(state.get((Object)"move").toString())) {
            sState = "move";
        } else if ("true".equals(state.get((Object)"property_change").toString())) {
            sState = "property_change";
        } else if ("true".equals(state.get((Object)"conflict").toString())) {
            sState = "conflict";
        } else if ("true".equals(state.get((Object)"potential_conflict").toString())) {
            sState = "potential_conflict";
        }
        return sState;
    }
}

