/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.widgets.ui.swt.control.internal;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.window.ToolTip;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class PDPComboToolTip
extends CCombo {
    private static final String FIELD_LIST = "list";
    private static final String FIELD_POPUP = "popup";
    private final List<String> tooltips = new ArrayList<String>();
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2012.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public PDPComboToolTip(Composite parent, int style) {
        super(parent, style);
        try {
            Field listField = CCombo.class.getDeclaredField(FIELD_LIST);
            listField.setAccessible(true);
            org.eclipse.swt.widgets.List list = (org.eclipse.swt.widgets.List)listField.get((Object)this);
            Field popupField = CCombo.class.getDeclaredField(FIELD_POPUP);
            popupField.setAccessible(true);
            Shell popup = (Shell)popupField.get((Object)this);
            ActivationListener activationListener = new ActivationListener(list, this.tooltips);
            popup.addListener(9, (Listener)activationListener);
            popup.addListener(21, (Listener)activationListener);
            popup.addListener(27, (Listener)activationListener);
            this.addListener(16, activationListener);
        }
        catch (Exception e) {
            throw new UnsupportedOperationException("Reflections of this JVM can't be used to access private fields. Thus this class won't work with your JVM.", e);
        }
    }

    public void add(String string) {
        super.add(string);
        this.tooltips.add(null);
    }

    public void add(String string, int index) {
        super.add(string, index);
        this.tooltips.add(index, null);
    }

    public void add(String element, String tooltip) {
        if (tooltip.length() > 0) {
            super.add(element);
            this.tooltips.add(tooltip);
        }
    }

    public void add(String string, int index, String tooltip) {
        if (tooltip.length() > 0) {
            super.add(string, index);
            this.tooltips.add(index, tooltip);
        }
    }

    public void setToolTip(int index, String tooltip) {
        if (tooltip.length() > 0) {
            if (index >= 0 && index < this.getItemCount()) {
                throw new IndexOutOfBoundsException("The index must be  in range 0 <= index && index < getItemCount()");
            }
            this.tooltips.set(index, tooltip);
        }
    }

    public void setToolTip(String element, String tooltip) {
        int idx;
        if (tooltip.length() > 0 && element.length() > 0 && (idx = this.indexOf(element)) != -1) {
            this.tooltips.set(idx, tooltip);
        }
    }

    public String getToolTip(String element) {
        int idx = this.indexOf(element);
        if (idx != -1) {
            return this.tooltips.get(idx);
        }
        return null;
    }

    public String getToolTip(int index) {
        return this.tooltips.get(index);
    }

    public void remove(int start, int end) {
        int count = this.getItemCount();
        if (start < 0 || start > end || end >= count) {
            SWT.error((int)6);
        }
        int i = start;
        while (i <= end) {
            this.tooltips.remove(this.getItem(i));
            ++i;
        }
        super.remove(start, end);
    }

    public void remove(String string) {
        this.tooltips.remove(string);
        super.remove(string);
    }

    public void remove(int index) {
        this.tooltips.remove(this.getItem(index));
        super.remove(index);
    }

    public void removeAll() {
        this.tooltips.clear();
        super.removeAll();
    }

    protected void checkSubclass() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ActivationListener
    implements Listener {
        private org.eclipse.swt.widgets.List list;
        private List<String> textLookup;
        private TooltipHandler handler;

        public ActivationListener(org.eclipse.swt.widgets.List list, List<String> textLookup) {
            this.list = list;
            this.textLookup = textLookup;
        }

        public void handleEvent(Event event) {
            switch (event.type) {
                case 9: {
                    this.handler = new TooltipHandler(this.list, this.textLookup);
                    break;
                }
                case 7: 
                case 16: 
                case 21: 
                case 27: {
                    if (this.handler == null) break;
                    this.handler.dispose();
                    this.handler = null;
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TooltipHandler
    implements MouseMoveListener,
    SelectionListener,
    MouseTrackListener {
        private int previousSelectionIdx = -1;
        private WrapTooltip tooltip = null;
        private org.eclipse.swt.widgets.List list;
        private List<String> textLookup;

        public TooltipHandler(org.eclipse.swt.widgets.List list, List<String> textLookup) {
            this.list = list;
            this.list.addMouseMoveListener((MouseMoveListener)this);
            this.list.addSelectionListener((SelectionListener)this);
            this.list.addMouseTrackListener((MouseTrackListener)this);
            this.textLookup = textLookup;
            this.tooltip = new WrapTooltip((Control)this.list);
            this.tooltip.setRespectDisplayBounds(true);
            this.tooltip.setRespectMonitorBounds(true);
            if (this.list.getSelectionIndex() != -1) {
                this.updateTooltip(this.list.getSelectionIndex());
            }
        }

        public void mouseEnter(MouseEvent arg0) {
        }

        public void mouseExit(MouseEvent arg0) {
            this.tooltip.hide();
            this.previousSelectionIdx = -1;
        }

        public void mouseHover(MouseEvent arg0) {
        }

        public void widgetDefaultSelected(SelectionEvent arg0) {
        }

        public void widgetSelected(SelectionEvent arg0) {
            this.updateTooltip(this.list.getSelectionIndex());
        }

        public void mouseMove(MouseEvent e) {
            int itemHeight = this.list.getItemHeight();
            int hoverItem = e.y / itemHeight;
            int itemIdx = this.list.getTopIndex() + hoverItem;
            if (this.previousSelectionIdx != itemIdx) {
                this.updateTooltip(itemIdx);
                this.previousSelectionIdx = itemIdx;
            }
        }

        private void updateTooltip(int index) {
            String text = null;
            if (index >= 0 && index < this.list.getItemCount() && (text = this.textLookup.get(index)) != null) {
                this.tooltip.setText(text);
                Point size = this.list.getSize();
                this.tooltip.show(new Point(size.x - 2, 0));
                this.previousSelectionIdx = index;
            } else {
                this.tooltip.hide();
            }
        }

        public void dispose() {
            this.list.removeMouseMoveListener((MouseMoveListener)this);
            this.list.removeSelectionListener((SelectionListener)this);
            this.list.removeMouseTrackListener((MouseTrackListener)this);
            this.tooltip.hide();
        }
    }

    private class WrapTooltip
    extends ToolTip {
        private Label label;
        private String text;

        public WrapTooltip(Control control) {
            super(control, 0, true);
        }

        protected Composite createToolTipContentArea(Event event, Composite parent) {
            Composite composite = new Composite(parent, 0);
            FillLayout layout = new FillLayout();
            layout.marginWidth = 5;
            layout.marginHeight = 5;
            composite.setLayout((Layout)layout);
            composite.setForeground(parent.getDisplay().getSystemColor(28));
            composite.setBackground(parent.getDisplay().getSystemColor(29));
            this.label = new Label(composite, 64);
            this.label.setForeground(parent.getDisplay().getSystemColor(28));
            this.label.setBackground(parent.getDisplay().getSystemColor(29));
            this.label.setText(this.text);
            return composite;
        }

        public void setText(String text) {
            this.text = text;
        }

        public String getText() {
            return this.text;
        }
    }
}

