/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.widgets.ui.formatter;

import com.ibm.pdp.widgets.ui.formatter.IPDPFormatter;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;

public class PDPDoubleFormatter
implements IPDPFormatter {
    public static final String copyright = "IBM Confidential\r\nOCO Source Materials\r\n5724-T07\r\n(C) Copyright IBM Corp. 2011\r\nThe source code for this program is not published or \r\notherwise divested of its trade secrets, irrespective of \r\nwhat has been deposited with the U.S. Copyright Office.";
    String decimalSeparator;
    String thousandSeparator;
    int decimalLength;

    public PDPDoubleFormatter() {
    }

    public PDPDoubleFormatter(String thousandSeparator, String decimalSeparator, int decimalLength) {
        this.decimalSeparator = decimalSeparator;
        this.thousandSeparator = thousandSeparator;
        this.decimalLength = decimalLength;
    }

    public static String formatToString(Double value) {
        DecimalFormat format = (DecimalFormat)DecimalFormat.getInstance();
        format.setParseIntegerOnly(false);
        format.setGroupingUsed(false);
        format.setDecimalSeparatorAlwaysShown(false);
        return format.format(value).replace(',', '.');
    }

    public String format(Object value) {
        DecimalFormat format = (DecimalFormat)DecimalFormat.getInstance();
        if (this.decimalLength > 0) {
            format.setDecimalSeparatorAlwaysShown(true);
            format.setMaximumFractionDigits(this.decimalLength);
            format.setMinimumFractionDigits(this.decimalLength);
        } else {
            format.setDecimalSeparatorAlwaysShown(false);
        }
        DecimalFormatSymbols symbol = new DecimalFormatSymbols();
        if (this.thousandSeparator == null || this.thousandSeparator.equals("")) {
            format.setGroupingUsed(false);
        } else {
            symbol.setGroupingSeparator(this.thousandSeparator.charAt(0));
        }
        symbol.setDecimalSeparator(this.decimalSeparator.charAt(0));
        format.setDecimalFormatSymbols(symbol);
        try {
            return format.format(new Double((String)value));
        }
        catch (ClassCastException classCastException) {
            return format.format((Double)value);
        }
    }

    public String getDecimalSeparator() {
        return this.decimalSeparator;
    }

    public void setDecimalSeparator(String decimalSeparator) {
        this.decimalSeparator = decimalSeparator;
    }

    public int getDecimalLength() {
        return this.decimalLength;
    }

    public void setDecimalLength(int decimalLength) {
        this.decimalLength = decimalLength;
    }

    public String getThousandSeparator() {
        return this.thousandSeparator;
    }

    public void setThousandSeparator(String thousandSeparator) {
        this.thousandSeparator = thousandSeparator;
    }
}

