/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.widgets.ui.control;

import com.ibm.pdp.widgets.ui.control.PDPAbstractControl;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class PDPText
extends PDPAbstractControl {
    ModifyListener modifyListener;
    protected boolean isMouseClicked = false;
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2016.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public PDPText(Composite parent, int style) {
        super(parent, style);
        ModifyListener modifyListener = this.getModifyListener();
        if (modifyListener != null) {
            this.getText().addModifyListener(this.getModifyListener());
            this.getText().addKeyListener(new KeyListener(){

                public void keyReleased(KeyEvent event) {
                    if (event.keyCode == 0x1000001 || event.keyCode == 0x1000002) {
                        event.doit = false;
                    }
                }

                public void keyPressed(KeyEvent event) {
                    if (event.keyCode == 0x1000001 || event.keyCode == 0x1000002) {
                        event.doit = false;
                    }
                }
            });
        }
        this.defaultErrorMessage = " is not a valid value";
    }

    public void setDisplayText(Object valueToDisplay) {
        Object formatedValue;
        Object object = formatedValue = valueToDisplay instanceof String ? valueToDisplay : this.format(valueToDisplay);
        if (formatedValue != null) {
            this.getText().setText(formatedValue.toString());
        } else {
            this.getText().setText("");
        }
    }

    protected Object getDisplayText() {
        return this.getText().getText();
    }

    protected void initialize(int style) {
        this.swtControl = new Text((Composite)this, style);
        this.setLayout((Layout)new FillLayout());
    }

    public void setEditable(boolean editable, boolean swteditable) {
        this.editable = editable;
        this.setEnabled(editable);
        this.getText().setEditable(swteditable);
        if (!swteditable) {
            this.setBackground(this.getReadOnlyColor());
        } else {
            this.setBackground(this.getDefaultColor());
        }
    }

    public Text getText() {
        return (Text)this.getInternalSwtControl();
    }

    protected ModifyListener getModifyListener() {
        if (this.modifyListener == null) {
            this.modifyListener = new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    Object newValue = PDPText.this.getDisplayText();
                    if (PDPText.this.isValidationRequired() && PDPText.this.isValid(newValue) == null) {
                        PDPText.this.updateValue(newValue);
                        PDPText.this.notifyChanges(false);
                    }
                }
            };
        }
        return this.modifyListener;
    }

    protected void setModifyListener(ModifyListener modifyListener) {
        this.modifyListener = modifyListener;
    }

    public boolean setFocus() {
        this.getText().selectAll();
        return super.setFocus();
    }

    protected void computePattern() {
    }

    protected void handleFocusGained() {
        if (!this.isEditable() && !this.isMouseClicked) {
            this.getInternalSwtControl().traverse(16);
        } else {
            super.handleFocusGained();
            this.getText().selectAll();
        }
    }

    protected void handleFocusLost() {
        if (!this.isEditable() && !this.isMouseClicked || this.isContentAssistOpen()) {
            return;
        }
        super.handleFocusLost();
        this.isMouseClicked = false;
    }

    public boolean canMoveWithArrowLeft() {
        return this.getText().getCaretPosition() <= 0 || this.getText().getSelectionCount() == this.getText().getText().length();
    }

    public boolean canMoveWithArrowRight() {
        return this.getText().getText().length() <= this.getText().getCaretPosition();
    }
}

