/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.widgets.ui.control;

import com.ibm.pdp.widgets.ui.control.PDPAbstractControl;
import com.ibm.pdp.widgets.ui.control.PDPAbstractPicker;
import com.ibm.pdp.widgets.ui.control.PDPBoolean;
import com.ibm.pdp.widgets.ui.control.PDPCombo;
import com.ibm.pdp.widgets.ui.control.PDPDouble;
import com.ibm.pdp.widgets.ui.control.PDPExtendedCombo;
import com.ibm.pdp.widgets.ui.control.PDPInteger;
import com.ibm.pdp.widgets.ui.control.PDPText;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.forms.FormColors;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;

public class PDPFormToolkit
extends FormToolkit {
    BorderPainter pdpBorderPainter;
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2010, 2011.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public PDPFormToolkit(Display display) {
        super(display);
    }

    public PDPFormToolkit(FormColors colors) {
        super(colors);
    }

    public void paintBordersFor(Composite parent) {
        if (this.pdpBorderPainter == null) {
            this.pdpBorderPainter = new BorderPainter();
        }
        parent.addPaintListener((PaintListener)this.pdpBorderPainter);
    }

    public PDPInteger createPDPInteger(Composite parent, int style) {
        PDPInteger result = new PDPInteger(parent, style);
        this.adapt(result);
        return result;
    }

    public PDPText createPDPText(Composite parent, int style) {
        PDPText result = new PDPText(parent, style);
        this.adapt(result);
        return result;
    }

    public PDPBoolean createPDPBoolean(Composite parent, int style) {
        PDPBoolean result = new PDPBoolean(parent, style);
        this.adapt(result);
        return result;
    }

    public PDPBoolean createPDPBoolean(Composite parent, int style, String label) {
        PDPBoolean result = new PDPBoolean(parent, style, label);
        this.adapt(result);
        return result;
    }

    public PDPExtendedCombo createPDPExtendedCombo(Composite parent, int style) {
        PDPExtendedCombo result = new PDPExtendedCombo(parent, style);
        this.adapt(result);
        return result;
    }

    public PDPCombo createPDPCombo(Composite parent, int style) {
        PDPCombo result = new PDPCombo(parent, style);
        this.adapt(result);
        return result;
    }

    public PDPDouble createPDPDouble(Composite parent, int style) {
        PDPDouble result = new PDPDouble(parent, style);
        this.adapt(result);
        return result;
    }

    public void adapt(Control control, boolean trackFocus, boolean trackKeyboard) {
        if (control instanceof PDPAbstractPicker) {
            PDPAbstractPicker pdpControl = (PDPAbstractPicker)control;
            super.adapt((Control)pdpControl, trackFocus, trackKeyboard);
            super.adapt((Control)pdpControl.getSwtControl(), trackFocus, trackKeyboard);
            super.adapt((Control)((Button)pdpControl.getSwtButton()), trackFocus, trackKeyboard);
        } else if (control instanceof PDPAbstractControl) {
            PDPAbstractControl pdpControl = (PDPAbstractControl)control;
            super.adapt((Control)pdpControl, trackFocus, trackKeyboard);
            super.adapt((Control)pdpControl.getSwtControl(), trackFocus, trackFocus);
        } else {
            super.adapt(control, trackFocus, trackKeyboard);
        }
    }

    public void adapt(Composite composite) {
        if (composite instanceof PDPAbstractPicker) {
            PDPAbstractPicker pdpControl = (PDPAbstractPicker)composite;
            super.adapt((Composite)pdpControl);
            super.adapt((Control)pdpControl.getSwtControl(), true, true);
            super.adapt((Control)((Button)pdpControl.getSwtButton()), true, true);
        } else if (composite instanceof PDPAbstractControl) {
            PDPAbstractControl pdpControl = (PDPAbstractControl)composite;
            super.adapt((Composite)pdpControl);
            super.adapt((Control)pdpControl.getSwtControl(), true, true);
        } else {
            super.adapt(composite);
        }
    }

    private void paintFinalControl(Control c, GC gc, Rectangle b) {
        boolean inactiveBorder = false;
        boolean textBorder = false;
        if (!c.isVisible()) {
            return;
        }
        if (!c.getEnabled() && !(c instanceof CCombo)) {
            return;
        }
        if (c instanceof Hyperlink) {
            return;
        }
        Object flag = c.getData("FormWidgetFactory.drawBorder");
        if (flag != null) {
            if (flag.equals(Boolean.FALSE)) {
                return;
            }
            if (flag.equals("treeBorder")) {
                inactiveBorder = true;
            } else if (flag.equals("textBorder")) {
                textBorder = true;
            }
        }
        if (this.getBorderStyle() == 2048) {
            if (!inactiveBorder && !textBorder) {
                return;
            }
            if (c instanceof Text || c instanceof Table || c instanceof Tree) {
                return;
            }
        }
        if (!inactiveBorder && (c instanceof Text || c instanceof CCombo || textBorder)) {
            gc.setForeground(c.getBackground());
            gc.drawRectangle(b.x - 1, b.y - 1, b.width + 1, b.height + 1);
            gc.setForeground(this.getColors().getBorderColor());
            gc.drawRectangle(b.x - 1, b.y - 1, b.width + 1, b.height + 1);
        } else if (inactiveBorder || c instanceof Table || c instanceof Tree) {
            gc.drawRectangle(b.x - 1, b.y - 1, b.width + 1, b.height + 1);
        }
    }

    private class BorderPainter
    implements PaintListener {
        private BorderPainter() {
        }

        public void paintControl(PaintEvent event) {
            Composite composite = (Composite)event.widget;
            Control[] children = composite.getChildren();
            int i = 0;
            while (i < children.length) {
                Control c = children[i];
                if (c instanceof PDPAbstractControl) {
                    Control[] pdpChildren;
                    boolean isPDPAbstractPicker = false;
                    if (c instanceof PDPAbstractPicker) {
                        isPDPAbstractPicker = true;
                        pdpChildren = ((PDPAbstractPicker)c).getPDPControl().getChildren();
                    } else {
                        pdpChildren = ((Composite)c).getChildren();
                    }
                    int j = 0;
                    while (j < pdpChildren.length) {
                        Rectangle b = isPDPAbstractPicker ? pdpChildren[j].getParent().getParent().getBounds() : pdpChildren[j].getParent().getBounds();
                        PDPFormToolkit.this.paintFinalControl(pdpChildren[j], event.gc, b);
                        ++j;
                    }
                } else {
                    PDPFormToolkit.this.paintFinalControl(c, event.gc, c.getBounds());
                }
                ++i;
            }
        }
    }
}

