/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.widgets.ui.control;

import com.ibm.pdp.widgets.ui.control.PDPCombo;
import com.ibm.pdp.widgets.ui.control.PDPLabelProvider;
import java.util.List;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.widgets.Composite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PDPExtendedCombo
extends PDPCombo {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2018.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected PDPLabelProvider labelProvider;
    protected List<Object> items;
    protected List<Object> tooltips;

    public PDPExtendedCombo(Composite parent, int style) {
        super(parent, style);
    }

    public void setItems(List<Object> list) {
        String[] result;
        this.items = list;
        if (list != null && list.size() > 0) {
            result = new String[list.size()];
            int i = 0;
            for (Object object : list) {
                result[i] = this.labelProvider.getText(object);
                ++i;
            }
        } else {
            result = new String[]{""};
        }
        super.setItems(result);
    }

    public void setItems(List<Object> list, List<Object> lsttooltip) {
        String[] resultt;
        String[] result;
        this.items = list;
        this.tooltips = lsttooltip;
        if (list != null && list.size() > 0) {
            result = new String[list.size()];
            int i = 0;
            for (Object object : list) {
                result[i] = this.labelProvider.getText(object);
                ++i;
            }
        } else {
            result = new String[]{""};
        }
        if (lsttooltip != null && lsttooltip.size() > 0) {
            resultt = new String[list.size()];
            int i = 0;
            for (Object object : lsttooltip) {
                resultt[i] = this.labelProvider.getToolTipText(object);
                ++i;
            }
        } else {
            resultt = new String[]{""};
        }
        super.setItems(result, resultt);
    }

    public ILabelProvider getLabelProvider() {
        return this.labelProvider;
    }

    public void setLabelProvider(PDPLabelProvider labelProvider) {
        this.labelProvider = labelProvider;
    }

    @Override
    public Object getValue() {
        String current = ((CCombo)this.swtControl).getText();
        String[] itemsString = ((CCombo)this.swtControl).getItems();
        int i = 0;
        while (i < itemsString.length) {
            if (itemsString[i].equals(current)) {
                return this.items.get(i);
            }
            ++i;
        }
        return this.value;
    }

    @Override
    public void setValue(Object newValue) {
        this.updateValue(newValue);
        super.setValue(this.value);
    }

    @Override
    protected void updateValue(Object newValue) {
        if (newValue instanceof String) {
            boolean isValidImput = false;
            int i = 0;
            while (i < this.items.size()) {
                if (this.labelProvider.getText(this.items.get(i)).equals(newValue)) {
                    this.value = this.items.get(i);
                    isValidImput = true;
                    break;
                }
                ++i;
            }
            if (!isValidImput) {
                this.isInError = true;
                this.setDisplayText(newValue);
                this.value = newValue;
            }
        } else {
            this.value = newValue;
        }
    }

    @Override
    public void setDisplayText(Object value) {
        String[] itemsString = ((CCombo)this.swtControl).getItems();
        int i = 0;
        while (i < this.items.size()) {
            if (this.items.get(i) == value) {
                super.setDisplayText(itemsString[i]);
                return;
            }
            ++i;
        }
        super.setDisplayText(value);
    }

    protected boolean isNewValueDiffer() {
        if (this.value == null) {
            return false;
        }
        return !this.value.toString().equals(this.getValue().toString());
    }

    @Override
    public boolean isValidString(String newValue) {
        return !this.isInError;
    }
}

